/*
 * Decompiled with CFR 0.152.
 */
package org.wysko.gervill;

import java.util.ArrayList;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.Sequence;
import javax.sound.midi.Track;

public final class MidiUtils {
    public static final int DEFAULT_TEMPO_MPQ = 500000;
    public static final int META_END_OF_TRACK_TYPE = 47;
    public static final int META_TEMPO_TYPE = 81;

    private MidiUtils() {
    }

    public static boolean isMetaEndOfTrack(MidiMessage midiMsg) {
        if (midiMsg.getLength() != 3 || midiMsg.getStatus() != 255) {
            return false;
        }
        byte[] msg = midiMsg.getMessage();
        return (msg[1] & 0xFF) == 47 && msg[2] == 0;
    }

    public static boolean isMetaTempo(MidiMessage midiMsg) {
        if (midiMsg.getLength() != 6 || midiMsg.getStatus() != 255) {
            return false;
        }
        byte[] msg = midiMsg.getMessage();
        return (msg[1] & 0xFF) == 81 && msg[2] == 3;
    }

    public static int getTempoMPQ(MidiMessage midiMsg) {
        if (midiMsg.getLength() != 6 || midiMsg.getStatus() != 255) {
            return -1;
        }
        byte[] msg = midiMsg.getMessage();
        if ((msg[1] & 0xFF) != 81 || msg[2] != 3) {
            return -1;
        }
        int tempo = msg[5] & 0xFF | (msg[4] & 0xFF) << 8 | (msg[3] & 0xFF) << 16;
        return tempo;
    }

    public static double convertTempo(double tempo) {
        if (tempo <= 0.0) {
            tempo = 1.0;
        }
        return 6.0E7 / tempo;
    }

    public static long ticks2microsec(long tick2, double tempoMPQ, int resolution) {
        return (long)((double)tick2 * tempoMPQ / (double)resolution);
    }

    public static long microsec2ticks(long us, double tempoMPQ, int resolution) {
        return (long)((double)us * (double)resolution / tempoMPQ);
    }

    public static long tick2microsecond(Sequence seq, long tick2, TempoCache cache2) {
        if (seq.getDivisionType() != 0.0f) {
            double seconds = (double)tick2 / (double)(seq.getDivisionType() * (float)seq.getResolution());
            return (long)(1000000.0 * seconds);
        }
        if (cache2 == null) {
            cache2 = new TempoCache(seq);
        }
        int resolution = seq.getResolution();
        long[] ticks = cache2.ticks;
        int[] tempos = cache2.tempos;
        int cacheCount = tempos.length;
        int snapshotIndex = cache2.snapshotIndex;
        int snapshotMicro = cache2.snapshotMicro;
        long us = 0L;
        if (snapshotIndex <= 0 || snapshotIndex >= cacheCount || ticks[snapshotIndex] > tick2) {
            snapshotMicro = 0;
            snapshotIndex = 0;
        }
        if (cacheCount > 0) {
            int i = snapshotIndex + 1;
            while (i < cacheCount && ticks[i] <= tick2) {
                snapshotMicro = (int)((long)snapshotMicro + MidiUtils.ticks2microsec(ticks[i] - ticks[i - 1], tempos[i - 1], resolution));
                snapshotIndex = i++;
            }
            us = (long)snapshotMicro + MidiUtils.ticks2microsec(tick2 - ticks[snapshotIndex], tempos[snapshotIndex], resolution);
        }
        cache2.snapshotIndex = snapshotIndex;
        cache2.snapshotMicro = snapshotMicro;
        return us;
    }

    public static long microsecond2tick(Sequence seq, long micros, TempoCache cache2) {
        int i;
        if (seq.getDivisionType() != 0.0f) {
            double dTick = (double)micros * (double)seq.getDivisionType() * (double)seq.getResolution() / 1000000.0;
            long tick2 = (long)dTick;
            if (cache2 != null) {
                cache2.currTempo = (int)cache2.getTempoMPQAt(tick2);
            }
            return tick2;
        }
        if (cache2 == null) {
            cache2 = new TempoCache(seq);
        }
        long[] ticks = cache2.ticks;
        int[] tempos = cache2.tempos;
        int cacheCount = tempos.length;
        int resolution = seq.getResolution();
        long us = 0L;
        long tick3 = 0L;
        boolean newReadPos = false;
        if (micros > 0L && cacheCount > 0) {
            long nextTime;
            for (i = 1; i < cacheCount && (nextTime = us + MidiUtils.ticks2microsec(ticks[i] - ticks[i - 1], tempos[i - 1], resolution)) <= micros; ++i) {
                us = nextTime;
            }
            tick3 = ticks[i - 1] + MidiUtils.microsec2ticks(micros - us, tempos[i - 1], resolution);
        }
        cache2.currTempo = tempos[i - 1];
        return tick3;
    }

    public static int tick2index(Track track, long tick2) {
        int ret = 0;
        if (tick2 > 0L) {
            long t;
            int low = 0;
            int high = track.size() - 1;
            while (low < high && (t = track.get(ret = low + high >> 1).getTick()) != tick2) {
                if (t < tick2) {
                    if (low == high - 1) {
                        ++ret;
                        break;
                    }
                    low = ret;
                    continue;
                }
                high = ret;
            }
        }
        return ret;
    }

    public static final class TempoCache {
        long[] ticks = new long[1];
        int[] tempos = new int[1];
        int snapshotIndex = 0;
        int snapshotMicro = 0;
        int currTempo;
        private boolean firstTempoIsFake = false;

        public TempoCache() {
            this.tempos[0] = 500000;
            this.snapshotIndex = 0;
            this.snapshotMicro = 0;
        }

        public TempoCache(Sequence seq) {
            this();
            this.refresh(seq);
        }

        public synchronized void refresh(Sequence seq) {
            Track[] tracks;
            ArrayList<MidiEvent> list2 = new ArrayList<MidiEvent>();
            for (Track track : tracks = seq.getTracks()) {
                int c = track.size();
                for (int i = 0; i < c; ++i) {
                    MidiEvent ev = track.get(i);
                    MidiMessage msg = ev.getMessage();
                    if (!MidiUtils.isMetaTempo(msg)) continue;
                    list2.add(ev);
                }
            }
            list2.sort((o1, o2) -> {
                long l2;
                long l1 = o1.getTick();
                if (l1 < (l2 = o2.getTick())) {
                    return -1;
                }
                if (l1 > l2) {
                    return 1;
                }
                return 0;
            });
            int size2 = list2.size() + 1;
            this.firstTempoIsFake = true;
            if (size2 > 1 && ((MidiEvent)list2.get(0)).getTick() == 0L) {
                --size2;
                this.firstTempoIsFake = false;
            }
            this.ticks = new long[size2];
            this.tempos = new int[size2];
            int e = 0;
            if (this.firstTempoIsFake) {
                this.ticks[0] = 0L;
                this.tempos[0] = 500000;
                ++e;
            }
            int i = 0;
            while (i < list2.size()) {
                MidiEvent evt = (MidiEvent)list2.get(i);
                this.ticks[e] = evt.getTick();
                this.tempos[e] = MidiUtils.getTempoMPQ(evt.getMessage());
                ++i;
                ++e;
            }
            this.snapshotIndex = 0;
            this.snapshotMicro = 0;
        }

        public int getCurrTempoMPQ() {
            return this.currTempo;
        }

        float getTempoMPQAt(long tick2) {
            return this.getTempoMPQAt(tick2, -1.0f);
        }

        float getTempoMPQAt(long tick2, float startTempoMPQ) {
            for (int i = 0; i < this.ticks.length; ++i) {
                if (this.ticks[i] <= tick2) continue;
                if (i > 0) {
                    --i;
                }
                if (startTempoMPQ > 0.0f && i == 0 && this.firstTempoIsFake) {
                    return startTempoMPQ;
                }
                return this.tempos[i];
            }
            return this.tempos[this.tempos.length - 1];
        }
    }
}

