/*
 * Decompiled with CFR 0.152.
 */
package org.wysko.gervill;

import javax.sound.midi.MidiDevice;
import org.wysko.gervill.AbstractMidiDeviceProvider;
import org.wysko.gervill.MidiOutDevice;
import org.wysko.gervill.Platform;

public final class MidiOutDeviceProvider
extends AbstractMidiDeviceProvider {
    private static AbstractMidiDeviceProvider.Info[] infos = null;
    private static MidiDevice[] devices = null;
    private static final boolean enabled;

    @Override
    AbstractMidiDeviceProvider.Info createInfo(int index2) {
        if (!enabled) {
            return null;
        }
        return new MidiOutDeviceInfo(index2, MidiOutDeviceProvider.class);
    }

    @Override
    MidiDevice createDevice(AbstractMidiDeviceProvider.Info info2) {
        if (enabled && info2 instanceof MidiOutDeviceInfo) {
            return new MidiOutDevice(info2);
        }
        return null;
    }

    @Override
    int getNumDevices() {
        if (!enabled) {
            return 0;
        }
        return MidiOutDeviceProvider.nGetNumDevices();
    }

    @Override
    MidiDevice[] getDeviceCache() {
        return devices;
    }

    @Override
    void setDeviceCache(MidiDevice[] devices) {
        MidiOutDeviceProvider.devices = devices;
    }

    @Override
    AbstractMidiDeviceProvider.Info[] getInfoCache() {
        return infos;
    }

    @Override
    void setInfoCache(AbstractMidiDeviceProvider.Info[] infos) {
        MidiOutDeviceProvider.infos = infos;
    }

    private static native int nGetNumDevices();

    private static native String nGetName(int var0);

    private static native String nGetVendor(int var0);

    private static native String nGetDescription(int var0);

    private static native String nGetVersion(int var0);

    static {
        Platform.initialize();
        enabled = Platform.isMidiIOEnabled();
    }

    static final class MidiOutDeviceInfo
    extends AbstractMidiDeviceProvider.Info {
        private final Class providerClass;

        private MidiOutDeviceInfo(int index2, Class providerClass) {
            super(MidiOutDeviceProvider.nGetName(index2), MidiOutDeviceProvider.nGetVendor(index2), MidiOutDeviceProvider.nGetDescription(index2), MidiOutDeviceProvider.nGetVersion(index2), index2);
            this.providerClass = providerClass;
        }
    }
}

