/*
 * Decompiled with CFR 0.152.
 */
package org.wysko.gervill;

import javax.sound.midi.MidiDevice;
import org.wysko.gervill.AbstractMidiDeviceProvider;
import org.wysko.gervill.MidiInDevice;
import org.wysko.gervill.Platform;

public final class MidiInDeviceProvider
extends AbstractMidiDeviceProvider {
    private static AbstractMidiDeviceProvider.Info[] infos = null;
    private static MidiDevice[] devices = null;
    private static final boolean enabled;

    @Override
    AbstractMidiDeviceProvider.Info createInfo(int index2) {
        if (!enabled) {
            return null;
        }
        return new MidiInDeviceInfo(index2, MidiInDeviceProvider.class);
    }

    @Override
    MidiDevice createDevice(AbstractMidiDeviceProvider.Info info2) {
        if (enabled && info2 instanceof MidiInDeviceInfo) {
            return new MidiInDevice(info2);
        }
        return null;
    }

    @Override
    int getNumDevices() {
        if (!enabled) {
            return 0;
        }
        int numDevices = MidiInDeviceProvider.nGetNumDevices();
        return numDevices;
    }

    @Override
    MidiDevice[] getDeviceCache() {
        return devices;
    }

    @Override
    void setDeviceCache(MidiDevice[] devices) {
        MidiInDeviceProvider.devices = devices;
    }

    @Override
    AbstractMidiDeviceProvider.Info[] getInfoCache() {
        return infos;
    }

    @Override
    void setInfoCache(AbstractMidiDeviceProvider.Info[] infos) {
        MidiInDeviceProvider.infos = infos;
    }

    private static native int nGetNumDevices();

    private static native String nGetName(int var0);

    private static native String nGetVendor(int var0);

    private static native String nGetDescription(int var0);

    private static native String nGetVersion(int var0);

    static {
        Platform.initialize();
        enabled = Platform.isMidiIOEnabled();
    }

    static final class MidiInDeviceInfo
    extends AbstractMidiDeviceProvider.Info {
        private final Class providerClass;

        private MidiInDeviceInfo(int index2, Class providerClass) {
            super(MidiInDeviceProvider.nGetName(index2), MidiInDeviceProvider.nGetVendor(index2), MidiInDeviceProvider.nGetDescription(index2), MidiInDeviceProvider.nGetVersion(index2), index2);
            this.providerClass = providerClass;
        }
    }
}

