/*
 * Decompiled with CFR 0.152.
 */
package org.wysko.gervill;

import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Transmitter;
import org.wysko.gervill.AbstractMidiDevice;
import org.wysko.gervill.AbstractMidiDeviceProvider;
import org.wysko.gervill.JSSecurityManager;
import org.wysko.gervill.MidiInDeviceProvider;

final class MidiInDevice
extends AbstractMidiDevice
implements Runnable {
    private Thread midiInThread = null;

    MidiInDevice(AbstractMidiDeviceProvider.Info info2) {
        super(info2);
    }

    @Override
    protected synchronized void implOpen() throws MidiUnavailableException {
        int index2 = ((MidiInDeviceProvider.MidiInDeviceInfo)this.getDeviceInfo()).getIndex();
        this.id = this.nOpen(index2);
        if (this.id == 0L) {
            throw new MidiUnavailableException("Unable to open native device");
        }
        if (this.midiInThread == null) {
            this.midiInThread = JSSecurityManager.createThread(this, "Java Sound MidiInDevice Thread", false, -1, true);
        }
        this.nStart(this.id);
    }

    @Override
    protected synchronized void implClose() {
        long oldId = this.id;
        this.id = 0L;
        super.implClose();
        this.nStop(oldId);
        if (this.midiInThread != null) {
            try {
                this.midiInThread.join(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.nClose(oldId);
    }

    @Override
    public long getMicrosecondPosition() {
        long timestamp = -1L;
        if (this.isOpen()) {
            timestamp = this.nGetTimeStamp(this.id);
        }
        return timestamp;
    }

    @Override
    protected boolean hasTransmitters() {
        return true;
    }

    @Override
    protected Transmitter createTransmitter() {
        return new MidiInTransmitter();
    }

    @Override
    public void run() {
        while (this.id != 0L) {
            this.nGetMessages(this.id);
            if (this.id == 0L) continue;
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.midiInThread = null;
    }

    void callbackShortMessage(int packedMsg, long timeStamp) {
        if (packedMsg == 0 || this.id == 0L) {
            return;
        }
        this.getTransmitterList().sendMessage(packedMsg, timeStamp);
    }

    void callbackLongMessage(byte[] data2, long timeStamp) {
        if (this.id == 0L || data2 == null) {
            return;
        }
        this.getTransmitterList().sendMessage(data2, timeStamp);
    }

    private native long nOpen(int var1) throws MidiUnavailableException;

    private native void nClose(long var1);

    private native void nStart(long var1) throws MidiUnavailableException;

    private native void nStop(long var1);

    private native long nGetTimeStamp(long var1);

    private native void nGetMessages(long var1);

    private final class MidiInTransmitter
    extends AbstractMidiDevice.BasicTransmitter {
        private MidiInTransmitter() {
        }
    }
}

