/*
 * Decompiled with CFR 0.152.
 */
package org.wysko.gervill;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.ServiceLoader;
import javax.sound.sampled.AudioPermission;

final class JSSecurityManager {
    private JSSecurityManager() {
    }

    private static boolean hasSecurityManager() {
        return System.getSecurityManager() != null;
    }

    static void checkRecordPermission() throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new AudioPermission("record"));
        }
    }

    static void loadProperties(final Properties properties2, final String filename) {
        if (JSSecurityManager.hasSecurityManager()) {
            try {
                PrivilegedAction<Void> action = new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        JSSecurityManager.loadPropertiesImpl(properties2, filename);
                        return null;
                    }
                };
                AccessController.doPrivileged(action);
            }
            catch (Exception e) {
                JSSecurityManager.loadPropertiesImpl(properties2, filename);
            }
        } else {
            JSSecurityManager.loadPropertiesImpl(properties2, filename);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadPropertiesImpl(Properties properties2, String filename) {
        String fname = System.getProperty("java.home");
        try {
            if (fname == null) {
                throw new Error("Can't find java.home ??");
            }
            File f = new File(fname, "lib");
            f = new File(f, filename);
            fname = f.getCanonicalPath();
            FileInputStream in = new FileInputStream(fname);
            BufferedInputStream bin = new BufferedInputStream(in);
            try {
                properties2.load(bin);
            }
            finally {
                if (in != null) {
                    ((InputStream)in).close();
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static Thread createThread(Runnable runnable, String threadName, boolean isDaemon, int priority, boolean doStart) {
        Thread thread2 = new Thread(runnable);
        if (threadName != null) {
            thread2.setName(threadName);
        }
        thread2.setDaemon(isDaemon);
        if (priority >= 0) {
            thread2.setPriority(priority);
        }
        if (doStart) {
            thread2.start();
        }
        return thread2;
    }

    static synchronized <T> List<T> getProviders(final Class<T> providerClass) {
        ArrayList p = new ArrayList(7);
        PrivilegedAction psAction = new PrivilegedAction<Iterator<T>>(){

            @Override
            public Iterator<T> run() {
                return ServiceLoader.load(providerClass).iterator();
            }
        };
        final Iterator ps = (Iterator)AccessController.doPrivileged(psAction);
        PrivilegedAction<Boolean> hasNextAction = new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return ps.hasNext();
            }
        };
        while (AccessController.doPrivileged(hasNextAction).booleanValue()) {
            try {
                Object provider = ps.next();
                if (!providerClass.isInstance(provider)) continue;
                p.add(0, provider);
            }
            catch (Throwable throwable) {}
        }
        return p;
    }
}

