/*
 * Decompiled with CFR 0.152.
 */
package org.wysko.gervill;

import java.util.List;
import java.util.Map;
import javax.sound.midi.MidiEvent;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B'\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0011\u001a\u00020\u0007J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u0007R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0014"}, d2={"Lorg/wysko/gervill/EventCollector;", "", "events", "", "Ljavax/sound/midi/MidiEvent;", "timeTable", "", "", "(Ljava/util/List;Ljava/util/Map;)V", "currentIndex", "", "triggerCondition", "Lkotlin/Function2;", "", "getTriggerCondition", "()Lkotlin/jvm/functions/Function2;", "advanceCollectAll", "time", "seek", "", "Gervill"})
@SourceDebugExtension(value={"SMAP\nEventCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EventCollector.kt\norg/wysko/gervill/EventCollector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,40:1\n350#2,7:41\n*S KotlinDebug\n*F\n+ 1 EventCollector.kt\norg/wysko/gervill/EventCollector\n*L\n36#1:41,7\n*E\n"})
public final class EventCollector {
    @NotNull
    private final List<MidiEvent> events;
    @NotNull
    private final Map<MidiEvent, Double> timeTable;
    @NotNull
    private final Function2<MidiEvent, Double, Boolean> triggerCondition;
    private int currentIndex;

    public EventCollector(@NotNull List<? extends MidiEvent> events, @NotNull Map<MidiEvent, Double> timeTable) {
        Intrinsics.checkNotNullParameter(events, "events");
        Intrinsics.checkNotNullParameter(timeTable, "timeTable");
        this.events = events;
        this.timeTable = timeTable;
        this.triggerCondition = new Function2<MidiEvent, Double, Boolean>(this){
            final /* synthetic */ EventCollector this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            @NotNull
            public final Boolean invoke(@NotNull MidiEvent event, double time) {
                Intrinsics.checkNotNullParameter(event, "event");
                V v = EventCollector.access$getTimeTable$p(this.this$0).get(event);
                Intrinsics.checkNotNull(v);
                return ((Number)v).doubleValue() <= time;
            }
        };
    }

    @NotNull
    public final Function2<MidiEvent, Double, Boolean> getTriggerCondition() {
        return this.triggerCondition;
    }

    @NotNull
    public final List<MidiEvent> advanceCollectAll(double time) {
        int startingIndex = this.currentIndex;
        while (this.currentIndex < this.events.size() && this.triggerCondition.invoke(this.events.get(this.currentIndex), time).booleanValue()) {
            int n = this.currentIndex;
            this.currentIndex = n + 1;
        }
        return this.events.subList(startingIndex, this.currentIndex);
    }

    /*
     * WARNING - void declaration
     */
    public final void seek(double time) {
        int n;
        int n2;
        block3: {
            void $this$indexOfFirst$iv;
            List<MidiEvent> list2 = this.events;
            EventCollector eventCollector = this;
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            for (Object item$iv : $this$indexOfFirst$iv) {
                MidiEvent it = (MidiEvent)item$iv;
                boolean bl = false;
                Double d = this.timeTable.get(it);
                Intrinsics.checkNotNull(d);
                if (((Number)d).doubleValue() >= time) {
                    n2 = index$iv;
                    break block3;
                }
                ++index$iv;
            }
            n2 = -1;
        }
        eventCollector.currentIndex = n = n2;
        if (this.currentIndex == -1) {
            this.currentIndex = this.events.size();
        }
    }

    public static final /* synthetic */ Map access$getTimeTable$p(EventCollector $this) {
        return $this.timeTable;
    }
}

