/*
 * Decompiled with CFR 0.152.
 */
package org.wysko.gervill;

import javax.sound.sampled.Mixer;
import javax.sound.sampled.spi.MixerProvider;
import org.wysko.gervill.DirectAudioDevice;
import org.wysko.gervill.Platform;

public final class DirectAudioDeviceProvider
extends MixerProvider {
    private static DirectAudioDeviceInfo[] infos;
    private static DirectAudioDevice[] devices;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DirectAudioDeviceProvider() {
        Class<DirectAudioDeviceProvider> clazz = DirectAudioDeviceProvider.class;
        synchronized (DirectAudioDeviceProvider.class) {
            if (Platform.isDirectAudioEnabled()) {
                DirectAudioDeviceProvider.init();
            } else {
                infos = new DirectAudioDeviceInfo[0];
                devices = new DirectAudioDevice[0];
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private static void init() {
        int numDevices = DirectAudioDeviceProvider.nGetNumDevices();
        if (infos == null || infos.length != numDevices) {
            infos = new DirectAudioDeviceInfo[numDevices];
            devices = new DirectAudioDevice[numDevices];
            for (int i = 0; i < infos.length; ++i) {
                DirectAudioDeviceProvider.infos[i] = DirectAudioDeviceProvider.nNewDirectAudioDeviceInfo(i);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Mixer.Info[] getMixerInfo() {
        Class<DirectAudioDeviceProvider> clazz = DirectAudioDeviceProvider.class;
        synchronized (DirectAudioDeviceProvider.class) {
            Mixer.Info[] localArray = new Mixer.Info[infos.length];
            System.arraycopy(infos, 0, localArray, 0, infos.length);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return localArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Mixer getMixer(Mixer.Info info2) {
        Class<DirectAudioDeviceProvider> clazz = DirectAudioDeviceProvider.class;
        synchronized (DirectAudioDeviceProvider.class) {
            int i;
            if (info2 == null) {
                for (i = 0; i < infos.length; ++i) {
                    Mixer mixer = DirectAudioDeviceProvider.getDevice(infos[i]);
                    if (mixer.getSourceLineInfo().length <= 0) continue;
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return mixer;
                }
            }
            for (i = 0; i < infos.length; ++i) {
                if (!infos[i].equals(info2)) continue;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return DirectAudioDeviceProvider.getDevice(infos[i]);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            throw new IllegalArgumentException("Mixer " + info2.toString() + " not supported by this provider.");
        }
    }

    private static Mixer getDevice(DirectAudioDeviceInfo info2) {
        int index2 = info2.getIndex();
        if (devices[index2] == null) {
            DirectAudioDeviceProvider.devices[index2] = new DirectAudioDevice(info2);
        }
        return devices[index2];
    }

    private static native int nGetNumDevices();

    private static native DirectAudioDeviceInfo nNewDirectAudioDeviceInfo(int var0);

    static {
        Platform.initialize();
    }

    static final class DirectAudioDeviceInfo
    extends Mixer.Info {
        private final int index;
        private final int maxSimulLines;
        private final int deviceID;

        private DirectAudioDeviceInfo(int index2, int deviceID, int maxSimulLines, String name, String vendor, String description2, String version) {
            super(name, vendor, "Direct Audio Device: " + description2, version);
            this.index = index2;
            this.maxSimulLines = maxSimulLines;
            this.deviceID = deviceID;
        }

        int getIndex() {
            return this.index;
        }

        int getMaxSimulLines() {
            return this.maxSimulLines;
        }

        int getDeviceID() {
            return this.deviceID;
        }
    }
}

