/*
 * Decompiled with CFR 0.152.
 */
package org.wysko.gervill;

import java.io.InputStream;
import java.util.Arrays;
import javax.sound.midi.Soundbank;
import javax.sound.midi.SoundbankResource;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import org.wysko.gervill.DLSInfo;
import org.wysko.gervill.DLSSampleOptions;
import org.wysko.gervill.ModelByteBuffer;

public final class DLSSample
extends SoundbankResource {
    byte[] guid = null;
    DLSInfo info = new DLSInfo();
    DLSSampleOptions sampleoptions;
    ModelByteBuffer data;
    AudioFormat format;

    public DLSSample(Soundbank soundBank) {
        super(soundBank, null, AudioInputStream.class);
    }

    public DLSSample() {
        super(null, null, AudioInputStream.class);
    }

    public DLSInfo getInfo() {
        return this.info;
    }

    @Override
    public Object getData() {
        AudioFormat format2 = this.getFormat();
        InputStream is = this.data.getInputStream();
        if (is == null) {
            return null;
        }
        return new AudioInputStream(is, format2, this.data.capacity());
    }

    public ModelByteBuffer getDataBuffer() {
        return this.data;
    }

    public AudioFormat getFormat() {
        return this.format;
    }

    public void setFormat(AudioFormat format2) {
        this.format = format2;
    }

    public void setData(ModelByteBuffer data2) {
        this.data = data2;
    }

    public void setData(byte[] data2) {
        this.data = new ModelByteBuffer(data2);
    }

    public void setData(byte[] data2, int offset2, int length) {
        this.data = new ModelByteBuffer(data2, offset2, length);
    }

    @Override
    public String getName() {
        return this.info.name;
    }

    public void setName(String name) {
        this.info.name = name;
    }

    public DLSSampleOptions getSampleoptions() {
        return this.sampleoptions;
    }

    public void setSampleoptions(DLSSampleOptions sampleOptions) {
        this.sampleoptions = sampleOptions;
    }

    public String toString() {
        return "Sample: " + this.info.name;
    }

    public byte[] getGuid() {
        return this.guid == null ? null : Arrays.copyOf(this.guid, this.guid.length);
    }

    public void setGuid(byte[] guid) {
        this.guid = guid == null ? null : Arrays.copyOf(guid, guid.length);
    }
}

