/*
 * Decompiled with CFR 0.152.
 */
package org.wysko.gervill;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.Soundbank;
import javax.sound.midi.spi.SoundbankReader;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.wysko.gervill.ModelByteBuffer;
import org.wysko.gervill.ModelByteBufferWavetable;
import org.wysko.gervill.ModelPerformer;
import org.wysko.gervill.SimpleInstrument;
import org.wysko.gervill.SimpleSoundbank;

public final class AudioFileSoundbankReader
extends SoundbankReader {
    @Override
    public Soundbank getSoundbank(URL url) throws InvalidMidiDataException, IOException {
        try {
            AudioInputStream ais = AudioSystem.getAudioInputStream(url);
            Soundbank sbk = this.getSoundbank(ais);
            ais.close();
            return sbk;
        }
        catch (UnsupportedAudioFileException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public Soundbank getSoundbank(InputStream stream) throws InvalidMidiDataException, IOException {
        stream.mark(512);
        try {
            AudioInputStream ais = AudioSystem.getAudioInputStream(stream);
            Soundbank sbk = this.getSoundbank(ais);
            if (sbk != null) {
                return sbk;
            }
        }
        catch (UnsupportedAudioFileException unsupportedAudioFileException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        stream.reset();
        return null;
    }

    public Soundbank getSoundbank(AudioInputStream ais) throws InvalidMidiDataException, IOException {
        try {
            byte[] buffer;
            if (ais.getFrameLength() == -1L) {
                int ret;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] buff = new byte[1024 - 1024 % ais.getFormat().getFrameSize()];
                while ((ret = ais.read(buff)) != -1) {
                    baos.write(buff, 0, ret);
                }
                ais.close();
                buffer = baos.toByteArray();
            } else {
                buffer = new byte[(int)(ais.getFrameLength() * (long)ais.getFormat().getFrameSize())];
                new DataInputStream(ais).readFully(buffer);
            }
            ModelByteBufferWavetable osc = new ModelByteBufferWavetable(new ModelByteBuffer(buffer), ais.getFormat(), -4800.0f);
            ModelPerformer performer = new ModelPerformer();
            performer.getOscillators().add(osc);
            SimpleSoundbank sbk = new SimpleSoundbank();
            SimpleInstrument ins = new SimpleInstrument();
            ins.add(performer);
            sbk.addInstrument(ins);
            return sbk;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public Soundbank getSoundbank(File file) throws InvalidMidiDataException, IOException {
        try {
            AudioInputStream ais = AudioSystem.getAudioInputStream(file);
            ais.close();
            ModelByteBufferWavetable osc = new ModelByteBufferWavetable(new ModelByteBuffer(file, 0L, file.length()), -4800.0f);
            ModelPerformer performer = new ModelPerformer();
            performer.getOscillators().add(osc);
            SimpleSoundbank sbk = new SimpleSoundbank();
            SimpleInstrument ins = new SimpleInstrument();
            ins.add(performer);
            sbk.addInstrument(ins);
            return sbk;
        }
        catch (UnsupportedAudioFileException e1) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }
}

