/*
 * Decompiled with CFR 0.152.
 */
package org.wysko.gervill;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.SequenceInputStream;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import org.wysko.gervill.AuFileFormat;
import org.wysko.gervill.SunFileWriter;

public final class AuFileWriter
extends SunFileWriter {
    public static final int UNKNOWN_SIZE = -1;

    public AuFileWriter() {
        super(new AudioFileFormat.Type[]{AudioFileFormat.Type.AU});
    }

    @Override
    public AudioFileFormat.Type[] getAudioFileTypes(AudioInputStream stream) {
        AudioFileFormat.Type[] filetypes = new AudioFileFormat.Type[this.types.length];
        System.arraycopy(this.types, 0, filetypes, 0, this.types.length);
        AudioFormat format2 = stream.getFormat();
        AudioFormat.Encoding encoding = format2.getEncoding();
        if (AudioFormat.Encoding.ALAW.equals(encoding) || AudioFormat.Encoding.ULAW.equals(encoding) || AudioFormat.Encoding.PCM_SIGNED.equals(encoding) || AudioFormat.Encoding.PCM_UNSIGNED.equals(encoding)) {
            return filetypes;
        }
        return new AudioFileFormat.Type[0];
    }

    @Override
    public int write(AudioInputStream stream, AudioFileFormat.Type fileType, OutputStream out) throws IOException {
        AuFileFormat auFileFormat = (AuFileFormat)this.getAudioFileFormat(fileType, stream);
        int bytesWritten = this.writeAuFile(stream, auFileFormat, out);
        return bytesWritten;
    }

    @Override
    public int write(AudioInputStream stream, AudioFileFormat.Type fileType, File out) throws IOException {
        AuFileFormat auFileFormat = (AuFileFormat)this.getAudioFileFormat(fileType, stream);
        FileOutputStream fos = new FileOutputStream(out);
        BufferedOutputStream bos = new BufferedOutputStream(fos, 4096);
        int bytesWritten = this.writeAuFile(stream, auFileFormat, bos);
        bos.close();
        if (auFileFormat.getByteLength() == -1) {
            RandomAccessFile raf = new RandomAccessFile(out, "rw");
            if (raf.length() <= Integer.MAX_VALUE) {
                raf.skipBytes(8);
                raf.writeInt(bytesWritten - 24);
            }
            raf.close();
        }
        return bytesWritten;
    }

    private AudioFileFormat getAudioFileFormat(AudioFileFormat.Type type2, AudioInputStream stream) {
        int sampleSizeInBits;
        AudioFormat format2 = null;
        AuFileFormat fileFormat = null;
        AudioFormat.Encoding encoding = AudioFormat.Encoding.PCM_SIGNED;
        AudioFormat streamFormat = stream.getFormat();
        AudioFormat.Encoding streamEncoding = streamFormat.getEncoding();
        if (!this.types[0].equals(type2)) {
            throw new IllegalArgumentException("File type " + type2 + " not supported.");
        }
        if (AudioFormat.Encoding.ALAW.equals(streamEncoding) || AudioFormat.Encoding.ULAW.equals(streamEncoding)) {
            encoding = streamEncoding;
            sampleSizeInBits = streamFormat.getSampleSizeInBits();
        } else if (streamFormat.getSampleSizeInBits() == 8) {
            encoding = AudioFormat.Encoding.PCM_SIGNED;
            sampleSizeInBits = 8;
        } else {
            encoding = AudioFormat.Encoding.PCM_SIGNED;
            sampleSizeInBits = streamFormat.getSampleSizeInBits();
        }
        format2 = new AudioFormat(encoding, streamFormat.getSampleRate(), sampleSizeInBits, streamFormat.getChannels(), streamFormat.getFrameSize(), streamFormat.getFrameRate(), true);
        int fileSize = stream.getFrameLength() != -1L ? (int)stream.getFrameLength() * streamFormat.getFrameSize() + 24 : -1;
        fileFormat = new AuFileFormat(AudioFileFormat.Type.AU, fileSize, format2, (int)stream.getFrameLength());
        return fileFormat;
    }

    private InputStream getFileStream(AuFileFormat auFileFormat, InputStream audioStream) throws IOException {
        long dataSizeInBytes;
        AudioFormat format2 = auFileFormat.getFormat();
        int magic = 779316836;
        int headerSize = 24;
        long dataSize = auFileFormat.getFrameLength();
        long l = dataSizeInBytes = dataSize == -1L ? -1L : dataSize * (long)format2.getFrameSize();
        if (dataSizeInBytes > Integer.MAX_VALUE) {
            dataSizeInBytes = -1L;
        }
        int encoding_local = auFileFormat.getAuType();
        int sampleRate = (int)format2.getSampleRate();
        int channels = format2.getChannels();
        boolean bigendian = true;
        byte[] header = null;
        ByteArrayInputStream headerStream = null;
        ByteArrayOutputStream baos = null;
        DataOutputStream dos = null;
        SequenceInputStream auStream = null;
        AudioFormat audioStreamFormat = null;
        AudioFormat.Encoding encoding = null;
        InputStream codedAudioStream = audioStream;
        codedAudioStream = audioStream;
        if (audioStream instanceof AudioInputStream && (AudioFormat.Encoding.PCM_UNSIGNED.equals(encoding = (audioStreamFormat = ((AudioInputStream)audioStream).getFormat()).getEncoding()) || AudioFormat.Encoding.PCM_SIGNED.equals(encoding) && bigendian != audioStreamFormat.isBigEndian())) {
            codedAudioStream = AudioSystem.getAudioInputStream(new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, audioStreamFormat.getSampleRate(), audioStreamFormat.getSampleSizeInBits(), audioStreamFormat.getChannels(), audioStreamFormat.getFrameSize(), audioStreamFormat.getFrameRate(), bigendian), (AudioInputStream)audioStream);
        }
        baos = new ByteArrayOutputStream();
        dos = new DataOutputStream(baos);
        if (bigendian) {
            dos.writeInt(779316836);
            dos.writeInt(headerSize);
            dos.writeInt((int)dataSizeInBytes);
            dos.writeInt(encoding_local);
            dos.writeInt(sampleRate);
            dos.writeInt(channels);
        } else {
            dos.writeInt(1684960046);
            dos.writeInt(this.big2little(headerSize));
            dos.writeInt(this.big2little((int)dataSizeInBytes));
            dos.writeInt(this.big2little(encoding_local));
            dos.writeInt(this.big2little(sampleRate));
            dos.writeInt(this.big2little(channels));
        }
        dos.close();
        header = baos.toByteArray();
        headerStream = new ByteArrayInputStream(header);
        auStream = new SequenceInputStream(headerStream, new SunFileWriter.NoCloseInputStream(this, codedAudioStream));
        return auStream;
    }

    private int writeAuFile(InputStream in, AuFileFormat auFileFormat, OutputStream out) throws IOException {
        int bytesRead = 0;
        int bytesWritten = 0;
        InputStream fileStream = this.getFileStream(auFileFormat, in);
        byte[] buffer = new byte[4096];
        int maxLength = auFileFormat.getByteLength();
        while ((bytesRead = fileStream.read(buffer)) >= 0) {
            if (maxLength > 0) {
                if (bytesRead < maxLength) {
                    out.write(buffer, 0, bytesRead);
                    bytesWritten += bytesRead;
                    maxLength -= bytesRead;
                    continue;
                }
                out.write(buffer, 0, maxLength);
                bytesWritten += maxLength;
                maxLength = 0;
                break;
            }
            out.write(buffer, 0, bytesRead);
            bytesWritten += bytesRead;
        }
        return bytesWritten;
    }
}

