/*
 * Decompiled with CFR 0.152.
 */
package org.wysko.gervill;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.wysko.gervill.AuFileFormat;
import org.wysko.gervill.SunFileReader;

public final class AuFileReader
extends SunFileReader {
    @Override
    public AudioFileFormat getAudioFileFormat(InputStream stream) throws UnsupportedAudioFileException, IOException {
        int sampleSizeInBits;
        AudioFormat format2 = null;
        AuFileFormat fileFormat = null;
        int maxReadLength = 28;
        boolean bigendian = false;
        int magic = -1;
        int headerSize = -1;
        int dataSize = -1;
        int encoding_local = -1;
        int sampleRate = -1;
        int frameRate = -1;
        int frameSize = -1;
        int channels = -1;
        int length = 0;
        int nread = 0;
        AudioFormat.Encoding encoding = null;
        DataInputStream dis = new DataInputStream(stream);
        dis.mark(maxReadLength);
        magic = dis.readInt();
        if (magic != 779316836 || magic == 779314176 || magic == 1684960046 || magic == 6583086) {
            dis.reset();
            throw new UnsupportedAudioFileException("not an AU file");
        }
        if (magic == 779316836 || magic == 779314176) {
            bigendian = true;
        }
        headerSize = bigendian ? dis.readInt() : this.rllong(dis);
        nread += 4;
        dataSize = bigendian ? dis.readInt() : this.rllong(dis);
        nread += 4;
        encoding_local = bigendian ? dis.readInt() : this.rllong(dis);
        nread += 4;
        sampleRate = bigendian ? dis.readInt() : this.rllong(dis);
        nread += 4;
        channels = bigendian ? dis.readInt() : this.rllong(dis);
        nread += 4;
        if (channels <= 0) {
            dis.reset();
            throw new UnsupportedAudioFileException("Invalid number of channels");
        }
        frameRate = sampleRate;
        switch (encoding_local) {
            case 1: {
                encoding = AudioFormat.Encoding.ULAW;
                sampleSizeInBits = 8;
                break;
            }
            case 27: {
                encoding = AudioFormat.Encoding.ALAW;
                sampleSizeInBits = 8;
                break;
            }
            case 2: {
                encoding = AudioFormat.Encoding.PCM_SIGNED;
                sampleSizeInBits = 8;
                break;
            }
            case 3: {
                encoding = AudioFormat.Encoding.PCM_SIGNED;
                sampleSizeInBits = 16;
                break;
            }
            case 4: {
                encoding = AudioFormat.Encoding.PCM_SIGNED;
                sampleSizeInBits = 24;
                break;
            }
            case 5: {
                encoding = AudioFormat.Encoding.PCM_SIGNED;
                sampleSizeInBits = 32;
                break;
            }
            default: {
                dis.reset();
                throw new UnsupportedAudioFileException("not a valid AU file");
            }
        }
        frameSize = AuFileReader.calculatePCMFrameSize(sampleSizeInBits, channels);
        length = dataSize < 0 ? -1 : dataSize / frameSize;
        format2 = new AudioFormat(encoding, sampleRate, sampleSizeInBits, channels, frameSize, frameRate, bigendian);
        fileFormat = new AuFileFormat(AudioFileFormat.Type.AU, dataSize + headerSize, format2, length);
        dis.reset();
        return fileFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AudioFileFormat getAudioFileFormat(URL url) throws UnsupportedAudioFileException, IOException {
        InputStream urlStream = null;
        BufferedInputStream bis = null;
        AudioFileFormat fileFormat = null;
        Object format2 = null;
        urlStream = url.openStream();
        try {
            bis = new BufferedInputStream(urlStream, 4096);
            fileFormat = this.getAudioFileFormat(bis);
        }
        finally {
            urlStream.close();
        }
        return fileFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AudioFileFormat getAudioFileFormat(File file) throws UnsupportedAudioFileException, IOException {
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        AudioFileFormat fileFormat = null;
        Object format2 = null;
        fis = new FileInputStream(file);
        try {
            bis = new BufferedInputStream(fis, 4096);
            fileFormat = this.getAudioFileFormat(bis);
        }
        finally {
            fis.close();
        }
        return fileFormat;
    }

    @Override
    public AudioInputStream getAudioInputStream(InputStream stream) throws UnsupportedAudioFileException, IOException {
        DataInputStream dis = null;
        AudioFileFormat fileFormat = null;
        AudioFormat format2 = null;
        fileFormat = this.getAudioFileFormat(stream);
        format2 = fileFormat.getFormat();
        dis = new DataInputStream(stream);
        dis.readInt();
        int headerSize = format2.isBigEndian() ? dis.readInt() : this.rllong(dis);
        dis.skipBytes(headerSize - 8);
        return new AudioInputStream(dis, format2, fileFormat.getFrameLength());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AudioInputStream getAudioInputStream(URL url) throws UnsupportedAudioFileException, IOException {
        InputStream urlStream = null;
        BufferedInputStream bis = null;
        Object fileFormat = null;
        urlStream = url.openStream();
        AudioInputStream result2 = null;
        try {
            bis = new BufferedInputStream(urlStream, 4096);
            result2 = this.getAudioInputStream(bis);
        }
        finally {
            if (result2 == null) {
                urlStream.close();
            }
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AudioInputStream getAudioInputStream(File file) throws UnsupportedAudioFileException, IOException {
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        Object fileFormat = null;
        fis = new FileInputStream(file);
        AudioInputStream result2 = null;
        try {
            bis = new BufferedInputStream(fis, 4096);
            result2 = this.getAudioInputStream(bis);
        }
        finally {
            if (result2 == null) {
                fis.close();
            }
        }
        return result2;
    }
}

