/*
 * Decompiled with CFR 0.152.
 */
package org.wysko.gervill;

import javax.sound.midi.MidiDevice;
import javax.sound.midi.spi.MidiDeviceProvider;
import org.wysko.gervill.Platform;

public abstract class AbstractMidiDeviceProvider
extends MidiDeviceProvider {
    private static final boolean enabled;

    final synchronized void readDeviceInfos() {
        int newNumDevices;
        Info[] infos = this.getInfoCache();
        MidiDevice[] devices = this.getDeviceCache();
        if (!enabled) {
            if (infos == null || infos.length != 0) {
                this.setInfoCache(new Info[0]);
            }
            if (devices == null || devices.length != 0) {
                this.setDeviceCache(new MidiDevice[0]);
            }
            return;
        }
        int oldNumDevices = infos == null ? -1 : infos.length;
        if (oldNumDevices != (newNumDevices = this.getNumDevices())) {
            int i;
            Info[] newInfos = new Info[newNumDevices];
            MidiDevice[] newDevices = new MidiDevice[newNumDevices];
            for (i = 0; i < newNumDevices; ++i) {
                Info newInfo = this.createInfo(i);
                if (infos != null) {
                    for (int ii = 0; ii < infos.length; ++ii) {
                        Info info2 = infos[ii];
                        if (info2 == null || !info2.equalStrings(newInfo)) continue;
                        newInfos[i] = info2;
                        info2.setIndex(i);
                        infos[ii] = null;
                        newDevices[i] = devices[ii];
                        devices[ii] = null;
                        break;
                    }
                }
                if (newInfos[i] != null) continue;
                newInfos[i] = newInfo;
            }
            if (infos != null) {
                for (i = 0; i < infos.length; ++i) {
                    if (infos[i] == null) continue;
                    infos[i].setIndex(-1);
                }
            }
            this.setInfoCache(newInfos);
            this.setDeviceCache(newDevices);
        }
    }

    @Override
    public final MidiDevice.Info[] getDeviceInfo() {
        this.readDeviceInfos();
        Info[] infos = this.getInfoCache();
        MidiDevice.Info[] localArray = new MidiDevice.Info[infos.length];
        System.arraycopy(infos, 0, localArray, 0, infos.length);
        return localArray;
    }

    @Override
    public final MidiDevice getDevice(MidiDevice.Info info2) {
        if (info2 instanceof Info) {
            this.readDeviceInfos();
            MidiDevice[] devices = this.getDeviceCache();
            Info[] infos = this.getInfoCache();
            Info thisInfo = (Info)info2;
            int index2 = thisInfo.getIndex();
            if (index2 >= 0 && index2 < devices.length && infos[index2] == info2) {
                if (devices[index2] == null) {
                    devices[index2] = this.createDevice(thisInfo);
                }
                if (devices[index2] != null) {
                    return devices[index2];
                }
            }
        }
        throw new IllegalArgumentException("MidiDevice " + info2.toString() + " not supported by this provider.");
    }

    abstract int getNumDevices();

    abstract MidiDevice[] getDeviceCache();

    abstract void setDeviceCache(MidiDevice[] var1);

    abstract Info[] getInfoCache();

    abstract void setInfoCache(Info[] var1);

    abstract Info createInfo(int var1);

    abstract MidiDevice createDevice(Info var1);

    static {
        Platform.initialize();
        enabled = Platform.isMidiIOEnabled();
    }

    static class Info
    extends MidiDevice.Info {
        private int index;

        Info(String name, String vendor, String description2, String version, int index2) {
            super(name, vendor, description2, version);
            this.index = index2;
        }

        final boolean equalStrings(Info info2) {
            return info2 != null && this.getName().equals(info2.getName()) && this.getVendor().equals(info2.getVendor()) && this.getDescription().equals(info2.getDescription()) && this.getVersion().equals(info2.getVersion());
        }

        final int getIndex() {
            return this.index;
        }

        final void setIndex(int index2) {
            this.index = index2;
        }
    }
}

