/*
 * Decompiled with CFR 0.152.
 */
package org.wysko.gervill;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiDeviceReceiver;
import javax.sound.midi.MidiDeviceTransmitter;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Transmitter;
import org.wysko.gervill.FastShortMessage;
import org.wysko.gervill.FastSysexMessage;
import org.wysko.gervill.MidiOutDevice;
import org.wysko.gervill.ReferenceCountingDevice;

public abstract class AbstractMidiDevice
implements MidiDevice,
ReferenceCountingDevice {
    private static final boolean TRACE_TRANSMITTER = false;
    private ArrayList<Receiver> receiverList;
    private TransmitterList transmitterList;
    private final Object traRecLock = new Object();
    private final MidiDevice.Info info;
    private boolean open = false;
    private int openRefCount;
    private List openKeepingObjects;
    protected long id = 0L;

    protected AbstractMidiDevice(MidiDevice.Info info2) {
        this.info = info2;
        this.openRefCount = 0;
    }

    @Override
    public final MidiDevice.Info getDeviceInfo() {
        return this.info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void open() throws MidiUnavailableException {
        AbstractMidiDevice abstractMidiDevice = this;
        synchronized (abstractMidiDevice) {
            this.openRefCount = -1;
            this.doOpen();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openInternal(Object object) throws MidiUnavailableException {
        AbstractMidiDevice abstractMidiDevice = this;
        synchronized (abstractMidiDevice) {
            if (this.openRefCount != -1) {
                ++this.openRefCount;
                this.getOpenKeepingObjects().add(object);
            }
            this.doOpen();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doOpen() throws MidiUnavailableException {
        AbstractMidiDevice abstractMidiDevice = this;
        synchronized (abstractMidiDevice) {
            if (!this.isOpen()) {
                this.implOpen();
                this.open = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() {
        AbstractMidiDevice abstractMidiDevice = this;
        synchronized (abstractMidiDevice) {
            this.doClose();
            this.openRefCount = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void closeInternal(Object object) {
        AbstractMidiDevice abstractMidiDevice = this;
        synchronized (abstractMidiDevice) {
            if (this.getOpenKeepingObjects().remove(object) && this.openRefCount > 0) {
                --this.openRefCount;
                if (this.openRefCount == 0) {
                    this.doClose();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void doClose() {
        AbstractMidiDevice abstractMidiDevice = this;
        synchronized (abstractMidiDevice) {
            if (this.isOpen()) {
                this.implClose();
                this.open = false;
            }
        }
    }

    @Override
    public final boolean isOpen() {
        return this.open;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void implClose() {
        Object object = this.traRecLock;
        synchronized (object) {
            if (this.receiverList != null) {
                for (int i = 0; i < this.receiverList.size(); ++i) {
                    this.receiverList.get(i).close();
                }
                this.receiverList.clear();
            }
            if (this.transmitterList != null) {
                this.transmitterList.close();
            }
        }
    }

    @Override
    public long getMicrosecondPosition() {
        return -1L;
    }

    @Override
    public final int getMaxReceivers() {
        if (this.hasReceivers()) {
            return -1;
        }
        return 0;
    }

    @Override
    public final int getMaxTransmitters() {
        if (this.hasTransmitters()) {
            return -1;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Receiver getReceiver() throws MidiUnavailableException {
        Receiver receiver;
        Object object = this.traRecLock;
        synchronized (object) {
            receiver = this.createReceiver();
            this.getReceiverList().add(receiver);
        }
        return receiver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final List<Receiver> getReceivers() {
        List<Object> recs;
        Object object = this.traRecLock;
        synchronized (object) {
            recs = this.receiverList == null ? Collections.unmodifiableList(new ArrayList(0)) : Collections.unmodifiableList((List)this.receiverList.clone());
        }
        return recs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Transmitter getTransmitter() throws MidiUnavailableException {
        Transmitter transmitter;
        Object object = this.traRecLock;
        synchronized (object) {
            transmitter = this.createTransmitter();
            this.getTransmitterList().add(transmitter);
        }
        return transmitter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final List<Transmitter> getTransmitters() {
        List<Transmitter> tras;
        Object object = this.traRecLock;
        synchronized (object) {
            tras = this.transmitterList == null || this.transmitterList.transmitters.size() == 0 ? Collections.unmodifiableList(new ArrayList(0)) : Collections.unmodifiableList((List)this.transmitterList.transmitters.clone());
        }
        return tras;
    }

    final long getId() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Receiver getReceiverReferenceCounting() throws MidiUnavailableException {
        Receiver receiver;
        Object object = this.traRecLock;
        synchronized (object) {
            receiver = this.getReceiver();
            this.openInternal(receiver);
        }
        return receiver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Transmitter getTransmitterReferenceCounting() throws MidiUnavailableException {
        Transmitter transmitter;
        Object object = this.traRecLock;
        synchronized (object) {
            transmitter = this.getTransmitter();
            this.openInternal(transmitter);
        }
        return transmitter;
    }

    private synchronized List getOpenKeepingObjects() {
        if (this.openKeepingObjects == null) {
            this.openKeepingObjects = new ArrayList();
        }
        return this.openKeepingObjects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Receiver> getReceiverList() {
        Object object = this.traRecLock;
        synchronized (object) {
            if (this.receiverList == null) {
                this.receiverList = new ArrayList();
            }
        }
        return this.receiverList;
    }

    protected boolean hasReceivers() {
        return false;
    }

    protected Receiver createReceiver() throws MidiUnavailableException {
        throw new MidiUnavailableException("MIDI IN receiver not available");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final TransmitterList getTransmitterList() {
        Object object = this.traRecLock;
        synchronized (object) {
            if (this.transmitterList == null) {
                this.transmitterList = new TransmitterList();
            }
        }
        return this.transmitterList;
    }

    protected boolean hasTransmitters() {
        return false;
    }

    protected Transmitter createTransmitter() throws MidiUnavailableException {
        throw new MidiUnavailableException("MIDI OUT transmitter not available");
    }

    protected abstract void implOpen() throws MidiUnavailableException;

    protected final void finalize() {
        this.close();
    }

    final class TransmitterList {
        private final ArrayList<Transmitter> transmitters = new ArrayList();
        private MidiOutDevice.MidiOutReceiver midiOutReceiver;
        private int optimizedReceiverCount = 0;

        TransmitterList() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void add(Transmitter t) {
            ArrayList<Transmitter> arrayList = this.transmitters;
            synchronized (arrayList) {
                this.transmitters.add(t);
            }
            if (t instanceof BasicTransmitter) {
                ((BasicTransmitter)t).setTransmitterList(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void remove(Transmitter t) {
            ArrayList<Transmitter> arrayList = this.transmitters;
            synchronized (arrayList) {
                int index2 = this.transmitters.indexOf(t);
                if (index2 >= 0) {
                    this.transmitters.remove(index2);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void receiverChanged(BasicTransmitter t, Receiver oldR, Receiver newR) {
            ArrayList<Transmitter> arrayList = this.transmitters;
            synchronized (arrayList) {
                if (this.midiOutReceiver == oldR) {
                    this.midiOutReceiver = null;
                }
                if (newR != null && newR instanceof MidiOutDevice.MidiOutReceiver && this.midiOutReceiver == null) {
                    this.midiOutReceiver = (MidiOutDevice.MidiOutReceiver)newR;
                }
                this.optimizedReceiverCount = this.midiOutReceiver != null ? 1 : 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void close() {
            ArrayList<Transmitter> arrayList = this.transmitters;
            synchronized (arrayList) {
                for (int i = 0; i < this.transmitters.size(); ++i) {
                    this.transmitters.get(i).close();
                }
                this.transmitters.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void sendMessage(int packedMessage, long timeStamp) {
            try {
                ArrayList<Transmitter> arrayList = this.transmitters;
                synchronized (arrayList) {
                    int size2 = this.transmitters.size();
                    if (this.optimizedReceiverCount == size2) {
                        if (this.midiOutReceiver != null) {
                            this.midiOutReceiver.sendPackedMidiMessage(packedMessage, timeStamp);
                        }
                    } else {
                        for (int i = 0; i < size2; ++i) {
                            Receiver receiver = this.transmitters.get(i).getReceiver();
                            if (receiver == null) continue;
                            if (this.optimizedReceiverCount > 0) {
                                if (receiver instanceof MidiOutDevice.MidiOutReceiver) {
                                    ((MidiOutDevice.MidiOutReceiver)receiver).sendPackedMidiMessage(packedMessage, timeStamp);
                                    continue;
                                }
                                receiver.send(new FastShortMessage(packedMessage), timeStamp);
                                continue;
                            }
                            receiver.send(new FastShortMessage(packedMessage), timeStamp);
                        }
                    }
                }
            }
            catch (InvalidMidiDataException invalidMidiDataException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void sendMessage(byte[] data2, long timeStamp) {
            try {
                ArrayList<Transmitter> arrayList = this.transmitters;
                synchronized (arrayList) {
                    int size2 = this.transmitters.size();
                    for (int i = 0; i < size2; ++i) {
                        Receiver receiver = this.transmitters.get(i).getReceiver();
                        if (receiver == null) continue;
                        receiver.send(new FastSysexMessage(data2), timeStamp);
                    }
                }
            }
            catch (InvalidMidiDataException e) {
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void sendMessage(MidiMessage message, long timeStamp) {
            if (message instanceof FastShortMessage) {
                this.sendMessage(((FastShortMessage)message).getPackedMsg(), timeStamp);
                return;
            }
            ArrayList<Transmitter> arrayList = this.transmitters;
            synchronized (arrayList) {
                int size2 = this.transmitters.size();
                if (this.optimizedReceiverCount == size2) {
                    if (this.midiOutReceiver != null) {
                        this.midiOutReceiver.send(message, timeStamp);
                    }
                } else {
                    for (int i = 0; i < size2; ++i) {
                        Receiver receiver = this.transmitters.get(i).getReceiver();
                        if (receiver == null) continue;
                        receiver.send(message, timeStamp);
                    }
                }
            }
        }
    }

    public class BasicTransmitter
    implements MidiDeviceTransmitter {
        private Receiver receiver = null;
        TransmitterList tlist = null;

        protected BasicTransmitter() {
        }

        private void setTransmitterList(TransmitterList tlist) {
            this.tlist = tlist;
        }

        @Override
        public final void setReceiver(Receiver receiver) {
            if (this.tlist != null && this.receiver != receiver) {
                this.tlist.receiverChanged(this, this.receiver, receiver);
                this.receiver = receiver;
            }
        }

        @Override
        public final Receiver getReceiver() {
            return this.receiver;
        }

        @Override
        public final void close() {
            AbstractMidiDevice.this.closeInternal(this);
            if (this.tlist != null) {
                this.tlist.receiverChanged(this, this.receiver, null);
                this.tlist.remove(this);
                this.tlist = null;
            }
        }

        @Override
        public final MidiDevice getMidiDevice() {
            return AbstractMidiDevice.this;
        }
    }

    abstract class AbstractReceiver
    implements MidiDeviceReceiver {
        private boolean open = true;

        AbstractReceiver() {
        }

        @Override
        public final synchronized void send(MidiMessage message, long timeStamp) {
            if (!this.open) {
                throw new IllegalStateException("Receiver is not open");
            }
            this.implSend(message, timeStamp);
        }

        abstract void implSend(MidiMessage var1, long var2);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void close() {
            this.open = false;
            Object object = AbstractMidiDevice.this.traRecLock;
            synchronized (object) {
                AbstractMidiDevice.this.getReceiverList().remove(this);
            }
            AbstractMidiDevice.this.closeInternal(this);
        }

        @Override
        public final MidiDevice getMidiDevice() {
            return AbstractMidiDevice.this;
        }

        final boolean isOpen() {
            return this.open;
        }
    }
}

