/*
 * Decompiled with CFR 0.152.
 */
package org.wysko.gervill;

import java.util.Map;
import java.util.Vector;
import java.util.WeakHashMap;
import javax.sound.sampled.Control;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.LineUnavailableException;
import org.wysko.gervill.AbstractMixer;
import org.wysko.gervill.EventDispatcher;

abstract class AbstractLine
implements Line {
    protected final Line.Info info;
    protected Control[] controls;
    AbstractMixer mixer;
    private boolean open = false;
    private final Vector listeners = new Vector();
    private static final Map<ThreadGroup, EventDispatcher> dispatchers = new WeakHashMap<ThreadGroup, EventDispatcher>();

    protected AbstractLine(Line.Info info2, AbstractMixer mixer, Control[] controls) {
        if (controls == null) {
            controls = new Control[]{};
        }
        this.info = info2;
        this.mixer = mixer;
        this.controls = controls;
    }

    @Override
    public final Line.Info getLineInfo() {
        return this.info;
    }

    @Override
    public final boolean isOpen() {
        return this.open;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void addLineListener(LineListener listener) {
        Vector vector2 = this.listeners;
        synchronized (vector2) {
            if (!this.listeners.contains(listener)) {
                this.listeners.addElement(listener);
            }
        }
    }

    @Override
    public final void removeLineListener(LineListener listener) {
        this.listeners.removeElement(listener);
    }

    @Override
    public final Control[] getControls() {
        Control[] returnedArray = new Control[this.controls.length];
        for (int i = 0; i < this.controls.length; ++i) {
            returnedArray[i] = this.controls[i];
        }
        return returnedArray;
    }

    @Override
    public final boolean isControlSupported(Control.Type controlType) {
        if (controlType == null) {
            return false;
        }
        for (int i = 0; i < this.controls.length; ++i) {
            if (controlType != this.controls[i].getType()) continue;
            return true;
        }
        return false;
    }

    @Override
    public final Control getControl(Control.Type controlType) {
        if (controlType != null) {
            for (int i = 0; i < this.controls.length; ++i) {
                if (controlType != this.controls[i].getType()) continue;
                return this.controls[i];
            }
        }
        throw new IllegalArgumentException("Unsupported control type: " + controlType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void setOpen(boolean open) {
        boolean sendEvents = false;
        long position = this.getLongFramePosition();
        AbstractLine abstractLine = this;
        synchronized (abstractLine) {
            if (this.open != open) {
                this.open = open;
                sendEvents = true;
            }
        }
        if (sendEvents) {
            if (open) {
                this.sendEvents(new LineEvent(this, LineEvent.Type.OPEN, position));
            } else {
                this.sendEvents(new LineEvent(this, LineEvent.Type.CLOSE, position));
            }
        }
    }

    final void sendEvents(LineEvent event) {
        this.getEventDispatcher().sendAudioEvents(event, this.listeners);
    }

    public final int getFramePosition() {
        return (int)this.getLongFramePosition();
    }

    public long getLongFramePosition() {
        return -1L;
    }

    final AbstractMixer getMixer() {
        return this.mixer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final EventDispatcher getEventDispatcher() {
        ThreadGroup tg = Thread.currentThread().getThreadGroup();
        Map<ThreadGroup, EventDispatcher> map2 = dispatchers;
        synchronized (map2) {
            EventDispatcher eventDispatcher = dispatchers.get(tg);
            if (eventDispatcher == null) {
                eventDispatcher = new EventDispatcher();
                dispatchers.put(tg, eventDispatcher);
                eventDispatcher.start();
            }
            return eventDispatcher;
        }
    }

    @Override
    public abstract void open() throws LineUnavailableException;

    @Override
    public abstract void close();
}

