/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.noise.module.source;

import org.spongepowered.noise.Noise;
import org.spongepowered.noise.Utils;
import org.spongepowered.noise.module.NoiseModule;

public class Voronoi
extends NoiseModule {
    private static final double SQRT_3 = 1.7320508075688772;
    public static final double DEFAULT_VORONOI_DISPLACEMENT = 1.0;
    public static final double DEFAULT_VORONOI_FREQUENCY = 1.0;
    public static final int DEFAULT_VORONOI_SEED = 0;
    private double displacement = 1.0;
    private boolean enableDistance = false;
    private double frequency = 1.0;
    private int seed = 0;

    public Voronoi() {
        super(0);
    }

    public double displacement() {
        return this.displacement;
    }

    public void setDisplacement(double displacement) {
        this.displacement = displacement;
    }

    public boolean enableDistance() {
        return this.enableDistance;
    }

    public void setEnableDistance(boolean enableDistance) {
        this.enableDistance = enableDistance;
    }

    public double frequency() {
        return this.frequency;
    }

    public void setFrequency(double frequency) {
        this.frequency = frequency;
    }

    public int seed() {
        return this.seed;
    }

    public void setSeed(int seed) {
        this.seed = seed;
    }

    @Override
    public double get(double x2, double y2, double z) {
        double value;
        double x1 = x2;
        double y1 = y2;
        double z1 = z;
        int xInt = x1 > 0.0 ? (int)x1 : (int)(x1 *= this.frequency) - 1;
        int yInt = y1 > 0.0 ? (int)y1 : (int)(y1 *= this.frequency) - 1;
        int zInt = z1 > 0.0 ? (int)z1 : (int)(z1 *= this.frequency) - 1;
        double minDist = 2.147483647E9;
        double xCandidate = 0.0;
        double yCandidate = 0.0;
        double zCandidate = 0.0;
        for (int zCur = zInt - 2; zCur <= zInt + 2; ++zCur) {
            for (int yCur = yInt - 2; yCur <= yInt + 2; ++yCur) {
                for (int xCur = xInt - 2; xCur <= xInt + 2; ++xCur) {
                    double zPos;
                    double zDist;
                    double yPos;
                    double yDist;
                    double xPos = (double)xCur + Noise.valueNoise3D(xCur, yCur, zCur, this.seed);
                    double xDist = xPos - x1;
                    double dist = xDist * xDist + (yDist = (yPos = (double)yCur + Noise.valueNoise3D(xCur, yCur, zCur, this.seed + 1)) - y1) * yDist + (zDist = (zPos = (double)zCur + Noise.valueNoise3D(xCur, yCur, zCur, this.seed + 2)) - z1) * zDist;
                    if (!(dist < minDist)) continue;
                    minDist = dist;
                    xCandidate = xPos;
                    yCandidate = yPos;
                    zCandidate = zPos;
                }
            }
        }
        if (this.enableDistance) {
            double xDist = xCandidate - x1;
            double yDist = yCandidate - y1;
            double zDist = zCandidate - z1;
            value = Math.sqrt(xDist * xDist + yDist * yDist + zDist * zDist) / 1.7320508075688772;
        } else {
            value = 0.0;
        }
        return value + this.displacement * Noise.valueNoise3D(Utils.floor(xCandidate), Utils.floor(yCandidate), Utils.floor(zCandidate), this.seed);
    }
}

