/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.noise.module.source;

import org.spongepowered.noise.Noise;
import org.spongepowered.noise.NoiseQuality;
import org.spongepowered.noise.Utils;
import org.spongepowered.noise.module.NoiseModule;

public class RidgedMulti
extends NoiseModule {
    public static final double DEFAULT_RIDGED_FREQUENCY = 1.0;
    public static final double DEFAULT_RIDGED_LACUNARITY = 2.0;
    public static final int DEFAULT_RIDGED_OCTAVE_COUNT = 6;
    public static final NoiseQuality DEFAULT_RIDGED_QUALITY = NoiseQuality.STANDARD;
    public static final int DEFAULT_RIDGED_SEED = 0;
    public static final int RIDGED_MAX_OCTAVE = 30;
    private double frequency = 1.0;
    private double lacunarity = 2.0;
    private NoiseQuality noiseQuality = DEFAULT_RIDGED_QUALITY;
    private int octaveCount = 6;
    private double[] spectralWeights;
    private int seed = 0;

    public RidgedMulti() {
        super(0);
        this.calcSpectralWeights();
    }

    public double frequency() {
        return this.frequency;
    }

    public void setFrequency(double frequency) {
        this.frequency = frequency;
    }

    public double lacunarity() {
        return this.lacunarity;
    }

    public void setLacunarity(double lacunarity) {
        this.lacunarity = lacunarity;
    }

    public NoiseQuality noiseQuality() {
        return this.noiseQuality;
    }

    public void setNoiseQuality(NoiseQuality noiseQuality) {
        this.noiseQuality = noiseQuality;
    }

    public int octaveCount() {
        return this.octaveCount;
    }

    public void setOctaveCount(int octaveCount) {
        if (octaveCount < 1 || octaveCount > 30) {
            throw new IllegalArgumentException("octaveCount must be between 1 and MAX OCTAVE: 30");
        }
        this.octaveCount = octaveCount;
    }

    public int seed() {
        return this.seed;
    }

    public void setSeed(int seed) {
        this.seed = seed;
    }

    private void calcSpectralWeights() {
        double h = 1.0;
        double frequency = 1.0;
        this.spectralWeights = new double[30];
        for (int i = 0; i < 30; ++i) {
            this.spectralWeights[i] = Math.pow(frequency, -1.0);
            frequency *= this.lacunarity;
        }
    }

    public double maxValue() {
        return (this.lacunarity() - Math.pow(this.lacunarity(), 1 - this.octaveCount())) / (this.lacunarity() - 1.0) / 1.6;
    }

    @Override
    public double get(double x2, double y2, double z) {
        double x1 = x2;
        double y1 = y2;
        double z1 = z;
        x1 *= this.frequency;
        y1 *= this.frequency;
        z1 *= this.frequency;
        double value = 0.0;
        double weight = 1.0;
        double offset2 = 1.0;
        double gain = 2.0;
        for (int curOctave = 0; curOctave < this.octaveCount; ++curOctave) {
            double nx = Utils.makeInt32Range(x1);
            double ny = Utils.makeInt32Range(y1);
            double nz = Utils.makeInt32Range(z1);
            int seed = this.seed + curOctave & Integer.MAX_VALUE;
            double signal = Noise.gradientCoherentNoise3D(nx, ny, nz, seed, this.noiseQuality) * 2.0 - 1.0;
            signal = Math.abs(signal);
            signal = 1.0 - signal;
            signal *= signal;
            if ((weight = (signal *= weight) * 2.0) > 1.0) {
                weight = 1.0;
            }
            if (weight < 0.0) {
                weight = 0.0;
            }
            value += signal * this.spectralWeights[curOctave];
            x1 *= this.lacunarity;
            y1 *= this.lacunarity;
            z1 *= this.lacunarity;
        }
        return value / 1.6;
    }
}

