/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.noise.module.modifier;

import java.util.ArrayList;
import java.util.List;
import org.spongepowered.noise.Utils;
import org.spongepowered.noise.exception.NoModuleException;
import org.spongepowered.noise.exception.NoiseException;
import org.spongepowered.noise.module.NoiseModule;

public class Curve
extends NoiseModule {
    private final List<ControlPoint> controlPoints = new ArrayList<ControlPoint>();

    public Curve() {
        super(1);
    }

    public Curve(NoiseModule source) {
        this();
        this.setSourceModule(0, source);
    }

    public void addControlPoint(double inputValue, double outputValue) {
        int index2 = this.findInsertionPos(inputValue);
        this.insertAtPos(index2, inputValue, outputValue);
    }

    public ControlPoint[] controlPoints() {
        return this.controlPoints.toArray(new ControlPoint[0]);
    }

    public void clearControlPoints() {
        this.controlPoints.clear();
    }

    private int findInsertionPos(double inputValue) {
        int insertionPos;
        for (insertionPos = 0; insertionPos < this.controlPoints.size() && !(inputValue < this.controlPoints.get((int)insertionPos).inputValue); ++insertionPos) {
            if (inputValue != this.controlPoints.get((int)insertionPos).inputValue) continue;
            throw new IllegalArgumentException("inputValue must be unique");
        }
        return insertionPos;
    }

    private void insertAtPos(int insertionPos, double inputValue, double outputValue) {
        ControlPoint newPoint = new ControlPoint(inputValue, outputValue);
        this.controlPoints.add(insertionPos, newPoint);
    }

    @Override
    public double get(double x2, double y2, double z) {
        int indexPos;
        if (this.sourceModule[0] == null) {
            throw new NoModuleException(0);
        }
        int size2 = this.controlPoints.size();
        if (size2 < 4) {
            throw new NoiseException("Curve module must have at least 4 control points");
        }
        double sourceModuleValue = this.sourceModule[0].get(x2, y2, z);
        for (indexPos = 0; indexPos < size2 && !(sourceModuleValue < this.controlPoints.get((int)indexPos).inputValue); ++indexPos) {
        }
        int lastIndex = size2 - 1;
        int index0 = Utils.clamp(indexPos - 2, 0, lastIndex);
        int index1 = Utils.clamp(indexPos - 1, 0, lastIndex);
        int index2 = Utils.clamp(indexPos, 0, lastIndex);
        int index3 = Utils.clamp(indexPos + 1, 0, lastIndex);
        if (index1 == index2) {
            return this.controlPoints.get((int)index1).outputValue;
        }
        double input0 = this.controlPoints.get((int)index1).inputValue;
        double input1 = this.controlPoints.get((int)index2).inputValue;
        double alpha2 = (sourceModuleValue - input0) / (input1 - input0);
        return Utils.cubicInterp(this.controlPoints.get((int)index0).outputValue, this.controlPoints.get((int)index1).outputValue, this.controlPoints.get((int)index2).outputValue, this.controlPoints.get((int)index3).outputValue, alpha2);
    }

    public static final class ControlPoint {
        final double inputValue;
        final double outputValue;

        public ControlPoint(double inputValue, double outputValue) {
            this.inputValue = inputValue;
            this.outputValue = outputValue;
        }

        public double inputValue() {
            return this.inputValue;
        }

        public double outputValue() {
            return this.outputValue;
        }
    }
}

