/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.noise.module.combiner;

import org.spongepowered.noise.Utils;
import org.spongepowered.noise.exception.NoModuleException;
import org.spongepowered.noise.module.NoiseModule;

public class Blend
extends NoiseModule {
    public Blend() {
        super(3);
    }

    public Blend(NoiseModule left, NoiseModule right, NoiseModule control) {
        this();
        this.setSourceModule(0, left);
        this.setSourceModule(1, right);
        this.setSourceModule(2, control);
    }

    public NoiseModule controlModule() {
        if (this.sourceModule[2] == null) {
            throw new NoModuleException(2);
        }
        return this.sourceModule[2];
    }

    public void setControlModule(NoiseModule module) {
        if (module == null) {
            throw new IllegalArgumentException("Control Module cannot be null");
        }
        this.sourceModule[2] = module;
    }

    @Override
    public double get(double x2, double y2, double z) {
        if (this.sourceModule[0] == null) {
            throw new NoModuleException(0);
        }
        if (this.sourceModule[1] == null) {
            throw new NoModuleException(1);
        }
        if (this.sourceModule[2] == null) {
            throw new NoModuleException(2);
        }
        double v0 = this.sourceModule[0].get(x2, y2, z);
        double v1 = this.sourceModule[1].get(x2, y2, z);
        double alpha2 = this.sourceModule[2].get(x2, y2, z);
        return Utils.linearInterp(v0, v1, alpha2);
    }
}

