/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.noise.model;

import java.util.Objects;
import org.spongepowered.noise.Utils;
import org.spongepowered.noise.exception.NoModuleException;
import org.spongepowered.noise.module.NoiseModule;

public class Sphere {
    private NoiseModule module;

    public Sphere(NoiseModule module) {
        if (module == null) {
            throw new IllegalArgumentException("module cannot be null");
        }
        this.module = module;
    }

    public NoiseModule module() {
        return this.module;
    }

    public void setModule(NoiseModule module) {
        this.module = Objects.requireNonNull(module, "Module cannot be null");
    }

    public double get(double lat, double lon) {
        if (this.module == null) {
            throw new NoModuleException(0);
        }
        double[] vec = Utils.latLonToXYZ(lat, lon);
        return this.module.get(vec[0], vec[1], vec[2]);
    }
}

