/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.noise.model;

import java.util.Objects;
import org.spongepowered.noise.exception.NoModuleException;
import org.spongepowered.noise.module.NoiseModule;

public class Line {
    private boolean attenuate = false;
    private NoiseModule module;
    private double x0 = 0.0;
    private double x1 = 1.0;
    private double y0 = 0.0;
    private double y1 = 1.0;
    private double z0 = 0.0;
    private double z1 = 1.0;

    public Line(NoiseModule module) {
        if (module == null) {
            throw new IllegalArgumentException("module cannot be null");
        }
        this.module = module;
    }

    public boolean attenuate() {
        return this.attenuate;
    }

    public void setAttenuate(boolean att) {
        this.attenuate = att;
    }

    public void setStartPoint(double x2, double y2, double z) {
        this.x0 = x2;
        this.y0 = y2;
        this.z0 = z;
    }

    public void setEndPoint(double x2, double y2, double z) {
        this.x1 = x2;
        this.y1 = y2;
        this.z1 = z;
    }

    public NoiseModule module() {
        return this.module;
    }

    public void setModule(NoiseModule module) {
        this.module = Objects.requireNonNull(module, "Module cannot be null");
    }

    public double get(double p) {
        if (this.module == null) {
            throw new NoModuleException(0);
        }
        double x2 = (this.x1 - this.x0) * p + this.x0;
        double y2 = (this.y1 - this.y0) * p + this.y0;
        double z = (this.z1 - this.z0) * p + this.z0;
        double value = this.module.get(x2, y2, z);
        if (this.attenuate) {
            return p * (1.0 - p) * 4.0 * value;
        }
        return value;
    }
}

