/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.macosx;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct objc_method_description")
public class ObjCMethodDescription
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int NAME;
    public static final int TYPES;

    public ObjCMethodDescription(ByteBuffer container2) {
        super(MemoryUtil.memAddress(container2), ObjCMethodDescription.__checkContainer(container2, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="SEL")
    public long name() {
        return ObjCMethodDescription.nname(this.address());
    }

    @NativeType(value="char *")
    public ByteBuffer types() {
        return ObjCMethodDescription.ntypes(this.address());
    }

    @NativeType(value="char *")
    public String typesString() {
        return ObjCMethodDescription.ntypesString(this.address());
    }

    public static ObjCMethodDescription malloc() {
        return ObjCMethodDescription.wrap(ObjCMethodDescription.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static ObjCMethodDescription calloc() {
        return ObjCMethodDescription.wrap(ObjCMethodDescription.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static ObjCMethodDescription create() {
        ByteBuffer container2 = BufferUtils.createByteBuffer(SIZEOF);
        return ObjCMethodDescription.wrap(ObjCMethodDescription.class, MemoryUtil.memAddress(container2), container2);
    }

    public static ObjCMethodDescription create(long address) {
        return ObjCMethodDescription.wrap(ObjCMethodDescription.class, address);
    }

    @Nullable
    public static ObjCMethodDescription createSafe(long address) {
        return address == 0L ? null : ObjCMethodDescription.wrap(ObjCMethodDescription.class, address);
    }

    public static Buffer malloc(int capacity) {
        return ObjCMethodDescription.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(ObjCMethodDescription.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return ObjCMethodDescription.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container2 = ObjCMethodDescription.__create(capacity, SIZEOF);
        return ObjCMethodDescription.wrap(Buffer.class, MemoryUtil.memAddress(container2), capacity, container2);
    }

    public static Buffer create(long address, int capacity) {
        return ObjCMethodDescription.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : ObjCMethodDescription.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static ObjCMethodDescription mallocStack() {
        return ObjCMethodDescription.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static ObjCMethodDescription callocStack() {
        return ObjCMethodDescription.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static ObjCMethodDescription mallocStack(MemoryStack stack) {
        return ObjCMethodDescription.malloc(stack);
    }

    @Deprecated
    public static ObjCMethodDescription callocStack(MemoryStack stack) {
        return ObjCMethodDescription.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return ObjCMethodDescription.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return ObjCMethodDescription.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return ObjCMethodDescription.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return ObjCMethodDescription.calloc(capacity, stack);
    }

    public static ObjCMethodDescription malloc(MemoryStack stack) {
        return ObjCMethodDescription.wrap(ObjCMethodDescription.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static ObjCMethodDescription calloc(MemoryStack stack) {
        return ObjCMethodDescription.wrap(ObjCMethodDescription.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return ObjCMethodDescription.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return ObjCMethodDescription.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nname(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NAME);
    }

    public static ByteBuffer ntypes(long struct) {
        return MemoryUtil.memByteBufferNT1(MemoryUtil.memGetAddress(struct + (long)TYPES));
    }

    public static String ntypesString(long struct) {
        return MemoryUtil.memUTF8(MemoryUtil.memGetAddress(struct + (long)TYPES));
    }

    static {
        Struct.Layout layout2 = ObjCMethodDescription.__struct(ObjCMethodDescription.__member(POINTER_SIZE), ObjCMethodDescription.__member(POINTER_SIZE));
        SIZEOF = layout2.getSize();
        ALIGNOF = layout2.getAlignment();
        NAME = layout2.offsetof(0);
        TYPES = layout2.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<ObjCMethodDescription, Buffer>
    implements NativeResource {
        private static final ObjCMethodDescription ELEMENT_FACTORY = ObjCMethodDescription.create(-1L);

        public Buffer(ByteBuffer container2) {
            super(container2, container2.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container2, int mark, int pos, int lim, int cap) {
            super(address, container2, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected ObjCMethodDescription getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="SEL")
        public long name() {
            return ObjCMethodDescription.nname(this.address());
        }

        @NativeType(value="char *")
        public ByteBuffer types() {
            return ObjCMethodDescription.ntypes(this.address());
        }

        @NativeType(value="char *")
        public String typesString() {
            return ObjCMethodDescription.ntypesString(this.address());
        }
    }
}

