/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux.liburing;

import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.system.linux.KernelTimespec;

@NativeType(value="struct io_uring_sync_cancel_reg")
public class IOURingSyncCancelReg
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ADDR;
    public static final int FD;
    public static final int FLAGS;
    public static final int TIMEOUT;
    public static final int PAD;

    public IOURingSyncCancelReg(ByteBuffer container2) {
        super(MemoryUtil.memAddress(container2), IOURingSyncCancelReg.__checkContainer(container2, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="__u64")
    public long addr() {
        return IOURingSyncCancelReg.naddr(this.address());
    }

    @NativeType(value="__s32")
    public int fd() {
        return IOURingSyncCancelReg.nfd(this.address());
    }

    @NativeType(value="__u32")
    public int flags() {
        return IOURingSyncCancelReg.nflags(this.address());
    }

    @NativeType(value="struct __kernel_timespec")
    public KernelTimespec timeout() {
        return IOURingSyncCancelReg.ntimeout(this.address());
    }

    public IOURingSyncCancelReg addr(@NativeType(value="__u64") long value) {
        IOURingSyncCancelReg.naddr(this.address(), value);
        return this;
    }

    public IOURingSyncCancelReg fd(@NativeType(value="__s32") int value) {
        IOURingSyncCancelReg.nfd(this.address(), value);
        return this;
    }

    public IOURingSyncCancelReg flags(@NativeType(value="__u32") int value) {
        IOURingSyncCancelReg.nflags(this.address(), value);
        return this;
    }

    public IOURingSyncCancelReg timeout(@NativeType(value="struct __kernel_timespec") KernelTimespec value) {
        IOURingSyncCancelReg.ntimeout(this.address(), value);
        return this;
    }

    public IOURingSyncCancelReg timeout(Consumer<KernelTimespec> consumer2) {
        consumer2.accept(this.timeout());
        return this;
    }

    public IOURingSyncCancelReg set(long addr, int fd, int flags, KernelTimespec timeout) {
        this.addr(addr);
        this.fd(fd);
        this.flags(flags);
        this.timeout(timeout);
        return this;
    }

    public IOURingSyncCancelReg set(IOURingSyncCancelReg src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static IOURingSyncCancelReg malloc() {
        return IOURingSyncCancelReg.wrap(IOURingSyncCancelReg.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static IOURingSyncCancelReg calloc() {
        return IOURingSyncCancelReg.wrap(IOURingSyncCancelReg.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static IOURingSyncCancelReg create() {
        ByteBuffer container2 = BufferUtils.createByteBuffer(SIZEOF);
        return IOURingSyncCancelReg.wrap(IOURingSyncCancelReg.class, MemoryUtil.memAddress(container2), container2);
    }

    public static IOURingSyncCancelReg create(long address) {
        return IOURingSyncCancelReg.wrap(IOURingSyncCancelReg.class, address);
    }

    @Nullable
    public static IOURingSyncCancelReg createSafe(long address) {
        return address == 0L ? null : IOURingSyncCancelReg.wrap(IOURingSyncCancelReg.class, address);
    }

    public static Buffer malloc(int capacity) {
        return IOURingSyncCancelReg.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(IOURingSyncCancelReg.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return IOURingSyncCancelReg.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container2 = IOURingSyncCancelReg.__create(capacity, SIZEOF);
        return IOURingSyncCancelReg.wrap(Buffer.class, MemoryUtil.memAddress(container2), capacity, container2);
    }

    public static Buffer create(long address, int capacity) {
        return IOURingSyncCancelReg.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : IOURingSyncCancelReg.wrap(Buffer.class, address, capacity);
    }

    public static IOURingSyncCancelReg malloc(MemoryStack stack) {
        return IOURingSyncCancelReg.wrap(IOURingSyncCancelReg.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static IOURingSyncCancelReg calloc(MemoryStack stack) {
        return IOURingSyncCancelReg.wrap(IOURingSyncCancelReg.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return IOURingSyncCancelReg.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return IOURingSyncCancelReg.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long naddr(long struct) {
        return UNSAFE.getLong(null, struct + (long)ADDR);
    }

    public static int nfd(long struct) {
        return UNSAFE.getInt(null, struct + (long)FD);
    }

    public static int nflags(long struct) {
        return UNSAFE.getInt(null, struct + (long)FLAGS);
    }

    public static KernelTimespec ntimeout(long struct) {
        return KernelTimespec.create(struct + (long)TIMEOUT);
    }

    public static LongBuffer npad(long struct) {
        return MemoryUtil.memLongBuffer(struct + (long)PAD, 4);
    }

    public static long npad(long struct, int index2) {
        return UNSAFE.getLong(null, struct + (long)PAD + Checks.check(index2, 4) * 8L);
    }

    public static void naddr(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)ADDR, value);
    }

    public static void nfd(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FD, value);
    }

    public static void nflags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FLAGS, value);
    }

    public static void ntimeout(long struct, KernelTimespec value) {
        MemoryUtil.memCopy(value.address(), struct + (long)TIMEOUT, KernelTimespec.SIZEOF);
    }

    public static void npad(long struct, LongBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 4);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)PAD, value.remaining() * 8);
    }

    public static void npad(long struct, int index2, long value) {
        UNSAFE.putLong(null, struct + (long)PAD + Checks.check(index2, 4) * 8L, value);
    }

    static {
        Struct.Layout layout2 = IOURingSyncCancelReg.__struct(IOURingSyncCancelReg.__member(8), IOURingSyncCancelReg.__member(4), IOURingSyncCancelReg.__member(4), IOURingSyncCancelReg.__member(KernelTimespec.SIZEOF, KernelTimespec.ALIGNOF), IOURingSyncCancelReg.__array(8, 4));
        SIZEOF = layout2.getSize();
        ALIGNOF = layout2.getAlignment();
        ADDR = layout2.offsetof(0);
        FD = layout2.offsetof(1);
        FLAGS = layout2.offsetof(2);
        TIMEOUT = layout2.offsetof(3);
        PAD = layout2.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<IOURingSyncCancelReg, Buffer>
    implements NativeResource {
        private static final IOURingSyncCancelReg ELEMENT_FACTORY = IOURingSyncCancelReg.create(-1L);

        public Buffer(ByteBuffer container2) {
            super(container2, container2.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container2, int mark, int pos, int lim, int cap) {
            super(address, container2, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected IOURingSyncCancelReg getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="__u64")
        public long addr() {
            return IOURingSyncCancelReg.naddr(this.address());
        }

        @NativeType(value="__s32")
        public int fd() {
            return IOURingSyncCancelReg.nfd(this.address());
        }

        @NativeType(value="__u32")
        public int flags() {
            return IOURingSyncCancelReg.nflags(this.address());
        }

        @NativeType(value="struct __kernel_timespec")
        public KernelTimespec timeout() {
            return IOURingSyncCancelReg.ntimeout(this.address());
        }

        public Buffer addr(@NativeType(value="__u64") long value) {
            IOURingSyncCancelReg.naddr(this.address(), value);
            return this;
        }

        public Buffer fd(@NativeType(value="__s32") int value) {
            IOURingSyncCancelReg.nfd(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="__u32") int value) {
            IOURingSyncCancelReg.nflags(this.address(), value);
            return this;
        }

        public Buffer timeout(@NativeType(value="struct __kernel_timespec") KernelTimespec value) {
            IOURingSyncCancelReg.ntimeout(this.address(), value);
            return this;
        }

        public Buffer timeout(Consumer<KernelTimespec> consumer2) {
            consumer2.accept(this.timeout());
            return this;
        }
    }
}

