/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux.liburing;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct io_uring_restriction")
public class IOURingRestriction
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int OPCODE;
    public static final int REGISTER_OP;
    public static final int SQE_OP;
    public static final int SQE_FLAGS;
    public static final int RESV;
    public static final int RESV2;

    public IOURingRestriction(ByteBuffer container2) {
        super(MemoryUtil.memAddress(container2), IOURingRestriction.__checkContainer(container2, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="__u16")
    public short opcode() {
        return IOURingRestriction.nopcode(this.address());
    }

    @NativeType(value="__u8")
    public byte register_op() {
        return IOURingRestriction.nregister_op(this.address());
    }

    @NativeType(value="__u8")
    public byte sqe_op() {
        return IOURingRestriction.nsqe_op(this.address());
    }

    @NativeType(value="__u8")
    public byte sqe_flags() {
        return IOURingRestriction.nsqe_flags(this.address());
    }

    public IOURingRestriction opcode(@NativeType(value="__u16") short value) {
        IOURingRestriction.nopcode(this.address(), value);
        return this;
    }

    public IOURingRestriction register_op(@NativeType(value="__u8") byte value) {
        IOURingRestriction.nregister_op(this.address(), value);
        return this;
    }

    public IOURingRestriction sqe_op(@NativeType(value="__u8") byte value) {
        IOURingRestriction.nsqe_op(this.address(), value);
        return this;
    }

    public IOURingRestriction sqe_flags(@NativeType(value="__u8") byte value) {
        IOURingRestriction.nsqe_flags(this.address(), value);
        return this;
    }

    public IOURingRestriction set(IOURingRestriction src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static IOURingRestriction malloc() {
        return IOURingRestriction.wrap(IOURingRestriction.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static IOURingRestriction calloc() {
        return IOURingRestriction.wrap(IOURingRestriction.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static IOURingRestriction create() {
        ByteBuffer container2 = BufferUtils.createByteBuffer(SIZEOF);
        return IOURingRestriction.wrap(IOURingRestriction.class, MemoryUtil.memAddress(container2), container2);
    }

    public static IOURingRestriction create(long address) {
        return IOURingRestriction.wrap(IOURingRestriction.class, address);
    }

    @Nullable
    public static IOURingRestriction createSafe(long address) {
        return address == 0L ? null : IOURingRestriction.wrap(IOURingRestriction.class, address);
    }

    public static Buffer malloc(int capacity) {
        return IOURingRestriction.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(IOURingRestriction.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return IOURingRestriction.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container2 = IOURingRestriction.__create(capacity, SIZEOF);
        return IOURingRestriction.wrap(Buffer.class, MemoryUtil.memAddress(container2), capacity, container2);
    }

    public static Buffer create(long address, int capacity) {
        return IOURingRestriction.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : IOURingRestriction.wrap(Buffer.class, address, capacity);
    }

    public static IOURingRestriction malloc(MemoryStack stack) {
        return IOURingRestriction.wrap(IOURingRestriction.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static IOURingRestriction calloc(MemoryStack stack) {
        return IOURingRestriction.wrap(IOURingRestriction.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return IOURingRestriction.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return IOURingRestriction.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static short nopcode(long struct) {
        return UNSAFE.getShort(null, struct + (long)OPCODE);
    }

    public static byte nregister_op(long struct) {
        return UNSAFE.getByte(null, struct + (long)REGISTER_OP);
    }

    public static byte nsqe_op(long struct) {
        return UNSAFE.getByte(null, struct + (long)SQE_OP);
    }

    public static byte nsqe_flags(long struct) {
        return UNSAFE.getByte(null, struct + (long)SQE_FLAGS);
    }

    public static byte nresv(long struct) {
        return UNSAFE.getByte(null, struct + (long)RESV);
    }

    public static IntBuffer nresv2(long struct) {
        return MemoryUtil.memIntBuffer(struct + (long)RESV2, 3);
    }

    public static int nresv2(long struct, int index2) {
        return UNSAFE.getInt(null, struct + (long)RESV2 + Checks.check(index2, 3) * 4L);
    }

    public static void nopcode(long struct, short value) {
        UNSAFE.putShort(null, struct + (long)OPCODE, value);
    }

    public static void nregister_op(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)REGISTER_OP, value);
    }

    public static void nsqe_op(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)SQE_OP, value);
    }

    public static void nsqe_flags(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)SQE_FLAGS, value);
    }

    public static void nresv(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)RESV, value);
    }

    public static void nresv2(long struct, IntBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 3);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)RESV2, value.remaining() * 4);
    }

    public static void nresv2(long struct, int index2, int value) {
        UNSAFE.putInt(null, struct + (long)RESV2 + Checks.check(index2, 3) * 4L, value);
    }

    static {
        Struct.Layout layout2 = IOURingRestriction.__struct(IOURingRestriction.__member(2), IOURingRestriction.__union(IOURingRestriction.__member(1), IOURingRestriction.__member(1), IOURingRestriction.__member(1)), IOURingRestriction.__member(1), IOURingRestriction.__array(4, 3));
        SIZEOF = layout2.getSize();
        ALIGNOF = layout2.getAlignment();
        OPCODE = layout2.offsetof(0);
        REGISTER_OP = layout2.offsetof(2);
        SQE_OP = layout2.offsetof(3);
        SQE_FLAGS = layout2.offsetof(4);
        RESV = layout2.offsetof(5);
        RESV2 = layout2.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<IOURingRestriction, Buffer>
    implements NativeResource {
        private static final IOURingRestriction ELEMENT_FACTORY = IOURingRestriction.create(-1L);

        public Buffer(ByteBuffer container2) {
            super(container2, container2.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container2, int mark, int pos, int lim, int cap) {
            super(address, container2, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected IOURingRestriction getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="__u16")
        public short opcode() {
            return IOURingRestriction.nopcode(this.address());
        }

        @NativeType(value="__u8")
        public byte register_op() {
            return IOURingRestriction.nregister_op(this.address());
        }

        @NativeType(value="__u8")
        public byte sqe_op() {
            return IOURingRestriction.nsqe_op(this.address());
        }

        @NativeType(value="__u8")
        public byte sqe_flags() {
            return IOURingRestriction.nsqe_flags(this.address());
        }

        public Buffer opcode(@NativeType(value="__u16") short value) {
            IOURingRestriction.nopcode(this.address(), value);
            return this;
        }

        public Buffer register_op(@NativeType(value="__u8") byte value) {
            IOURingRestriction.nregister_op(this.address(), value);
            return this;
        }

        public Buffer sqe_op(@NativeType(value="__u8") byte value) {
            IOURingRestriction.nsqe_op(this.address(), value);
            return this;
        }

        public Buffer sqe_flags(@NativeType(value="__u8") byte value) {
            IOURingRestriction.nsqe_flags(this.address(), value);
            return this;
        }
    }
}

