/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux.liburing;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.system.linux.liburing.IOURingProbeOp;

@NativeType(value="struct io_uring_probe")
public class IOURingProbe
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int LAST_OP;
    public static final int OPS_LEN;
    public static final int RESV;
    public static final int RESV2;
    public static final int OPS;

    public IOURingProbe(ByteBuffer container2) {
        super(MemoryUtil.memAddress(container2), IOURingProbe.__checkContainer(container2, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="__u8")
    public byte last_op() {
        return IOURingProbe.nlast_op(this.address());
    }

    @NativeType(value="__u8")
    public byte ops_len() {
        return IOURingProbe.nops_len(this.address());
    }

    @NativeType(value="__u16")
    public short resv() {
        return IOURingProbe.nresv(this.address());
    }

    @NativeType(value="struct io_uring_probe_op[0]")
    public IOURingProbeOp.Buffer ops() {
        return IOURingProbe.nops(this.address());
    }

    @NativeType(value="struct io_uring_probe_op")
    public IOURingProbeOp ops(int index2) {
        return IOURingProbe.nops(this.address(), index2);
    }

    public IOURingProbe last_op(@NativeType(value="__u8") byte value) {
        IOURingProbe.nlast_op(this.address(), value);
        return this;
    }

    public IOURingProbe ops_len(@NativeType(value="__u8") byte value) {
        IOURingProbe.nops_len(this.address(), value);
        return this;
    }

    public IOURingProbe resv(@NativeType(value="__u16") short value) {
        IOURingProbe.nresv(this.address(), value);
        return this;
    }

    public IOURingProbe ops(@NativeType(value="struct io_uring_probe_op[0]") IOURingProbeOp.Buffer value) {
        IOURingProbe.nops(this.address(), value);
        return this;
    }

    public IOURingProbe ops(int index2, @NativeType(value="struct io_uring_probe_op") IOURingProbeOp value) {
        IOURingProbe.nops(this.address(), index2, value);
        return this;
    }

    public IOURingProbe ops(Consumer<IOURingProbeOp.Buffer> consumer2) {
        consumer2.accept(this.ops());
        return this;
    }

    public IOURingProbe ops(int index2, Consumer<IOURingProbeOp> consumer2) {
        consumer2.accept(this.ops(index2));
        return this;
    }

    public IOURingProbe set(byte last_op, byte ops_len, short resv, IOURingProbeOp.Buffer ops) {
        this.last_op(last_op);
        this.ops_len(ops_len);
        this.resv(resv);
        this.ops(ops);
        return this;
    }

    public IOURingProbe set(IOURingProbe src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static IOURingProbe malloc() {
        return IOURingProbe.wrap(IOURingProbe.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static IOURingProbe calloc() {
        return IOURingProbe.wrap(IOURingProbe.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static IOURingProbe create() {
        ByteBuffer container2 = BufferUtils.createByteBuffer(SIZEOF);
        return IOURingProbe.wrap(IOURingProbe.class, MemoryUtil.memAddress(container2), container2);
    }

    public static IOURingProbe create(long address) {
        return IOURingProbe.wrap(IOURingProbe.class, address);
    }

    @Nullable
    public static IOURingProbe createSafe(long address) {
        return address == 0L ? null : IOURingProbe.wrap(IOURingProbe.class, address);
    }

    public static Buffer malloc(int capacity) {
        return IOURingProbe.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(IOURingProbe.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return IOURingProbe.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container2 = IOURingProbe.__create(capacity, SIZEOF);
        return IOURingProbe.wrap(Buffer.class, MemoryUtil.memAddress(container2), capacity, container2);
    }

    public static Buffer create(long address, int capacity) {
        return IOURingProbe.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : IOURingProbe.wrap(Buffer.class, address, capacity);
    }

    public static IOURingProbe malloc(MemoryStack stack) {
        return IOURingProbe.wrap(IOURingProbe.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static IOURingProbe calloc(MemoryStack stack) {
        return IOURingProbe.wrap(IOURingProbe.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return IOURingProbe.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return IOURingProbe.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static byte nlast_op(long struct) {
        return UNSAFE.getByte(null, struct + (long)LAST_OP);
    }

    public static byte nops_len(long struct) {
        return UNSAFE.getByte(null, struct + (long)OPS_LEN);
    }

    public static short nresv(long struct) {
        return UNSAFE.getShort(null, struct + (long)RESV);
    }

    public static IntBuffer nresv2(long struct) {
        return MemoryUtil.memIntBuffer(struct + (long)RESV2, 3);
    }

    public static int nresv2(long struct, int index2) {
        return UNSAFE.getInt(null, struct + (long)RESV2 + Checks.check(index2, 3) * 4L);
    }

    public static IOURingProbeOp.Buffer nops(long struct) {
        return IOURingProbeOp.create(struct + (long)OPS, 0);
    }

    public static IOURingProbeOp nops(long struct, int index2) {
        return IOURingProbeOp.create(struct + (long)OPS + Checks.check(index2, 0) * (long)IOURingProbeOp.SIZEOF);
    }

    public static void nlast_op(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)LAST_OP, value);
    }

    public static void nops_len(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)OPS_LEN, value);
    }

    public static void nresv(long struct, short value) {
        UNSAFE.putShort(null, struct + (long)RESV, value);
    }

    public static void nresv2(long struct, IntBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 3);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)RESV2, value.remaining() * 4);
    }

    public static void nresv2(long struct, int index2, int value) {
        UNSAFE.putInt(null, struct + (long)RESV2 + Checks.check(index2, 3) * 4L, value);
    }

    public static void nops(long struct, IOURingProbeOp.Buffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 0);
        }
        MemoryUtil.memCopy(value.address(), struct + (long)OPS, value.remaining() * IOURingProbeOp.SIZEOF);
    }

    public static void nops(long struct, int index2, IOURingProbeOp value) {
        MemoryUtil.memCopy(value.address(), struct + (long)OPS + Checks.check(index2, 0) * (long)IOURingProbeOp.SIZEOF, IOURingProbeOp.SIZEOF);
    }

    static {
        Struct.Layout layout2 = IOURingProbe.__struct(IOURingProbe.__member(1), IOURingProbe.__member(1), IOURingProbe.__member(2), IOURingProbe.__array(4, 3), IOURingProbe.__array(IOURingProbeOp.SIZEOF, IOURingProbeOp.ALIGNOF, 0));
        SIZEOF = layout2.getSize();
        ALIGNOF = layout2.getAlignment();
        LAST_OP = layout2.offsetof(0);
        OPS_LEN = layout2.offsetof(1);
        RESV = layout2.offsetof(2);
        RESV2 = layout2.offsetof(3);
        OPS = layout2.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<IOURingProbe, Buffer>
    implements NativeResource {
        private static final IOURingProbe ELEMENT_FACTORY = IOURingProbe.create(-1L);

        public Buffer(ByteBuffer container2) {
            super(container2, container2.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container2, int mark, int pos, int lim, int cap) {
            super(address, container2, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected IOURingProbe getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="__u8")
        public byte last_op() {
            return IOURingProbe.nlast_op(this.address());
        }

        @NativeType(value="__u8")
        public byte ops_len() {
            return IOURingProbe.nops_len(this.address());
        }

        @NativeType(value="__u16")
        public short resv() {
            return IOURingProbe.nresv(this.address());
        }

        @NativeType(value="struct io_uring_probe_op[0]")
        public IOURingProbeOp.Buffer ops() {
            return IOURingProbe.nops(this.address());
        }

        @NativeType(value="struct io_uring_probe_op")
        public IOURingProbeOp ops(int index2) {
            return IOURingProbe.nops(this.address(), index2);
        }

        public Buffer last_op(@NativeType(value="__u8") byte value) {
            IOURingProbe.nlast_op(this.address(), value);
            return this;
        }

        public Buffer ops_len(@NativeType(value="__u8") byte value) {
            IOURingProbe.nops_len(this.address(), value);
            return this;
        }

        public Buffer resv(@NativeType(value="__u16") short value) {
            IOURingProbe.nresv(this.address(), value);
            return this;
        }

        public Buffer ops(@NativeType(value="struct io_uring_probe_op[0]") IOURingProbeOp.Buffer value) {
            IOURingProbe.nops(this.address(), value);
            return this;
        }

        public Buffer ops(int index2, @NativeType(value="struct io_uring_probe_op") IOURingProbeOp value) {
            IOURingProbe.nops(this.address(), index2, value);
            return this;
        }

        public Buffer ops(Consumer<IOURingProbeOp.Buffer> consumer2) {
            consumer2.accept(this.ops());
            return this;
        }

        public Buffer ops(int index2, Consumer<IOURingProbeOp> consumer2) {
            consumer2.accept(this.ops(index2));
            return this;
        }
    }
}

