/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux.liburing;

import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct io_uring_cqe")
public class IOURingCQE
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int USER_DATA;
    public static final int RES;
    public static final int FLAGS;
    public static final int BIG_CQE;

    public IOURingCQE(ByteBuffer container2) {
        super(MemoryUtil.memAddress(container2), IOURingCQE.__checkContainer(container2, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="__u64")
    public long user_data() {
        return IOURingCQE.nuser_data(this.address());
    }

    @NativeType(value="__s32")
    public int res() {
        return IOURingCQE.nres(this.address());
    }

    @NativeType(value="__u32")
    public int flags() {
        return IOURingCQE.nflags(this.address());
    }

    @NativeType(value="__u64[0]")
    public LongBuffer big_cqe() {
        return IOURingCQE.nbig_cqe(this.address());
    }

    @NativeType(value="__u64")
    public long big_cqe(int index2) {
        return IOURingCQE.nbig_cqe(this.address(), index2);
    }

    public IOURingCQE user_data(@NativeType(value="__u64") long value) {
        IOURingCQE.nuser_data(this.address(), value);
        return this;
    }

    public IOURingCQE res(@NativeType(value="__s32") int value) {
        IOURingCQE.nres(this.address(), value);
        return this;
    }

    public IOURingCQE flags(@NativeType(value="__u32") int value) {
        IOURingCQE.nflags(this.address(), value);
        return this;
    }

    public IOURingCQE big_cqe(@NativeType(value="__u64[0]") LongBuffer value) {
        IOURingCQE.nbig_cqe(this.address(), value);
        return this;
    }

    public IOURingCQE big_cqe(int index2, @NativeType(value="__u64") long value) {
        IOURingCQE.nbig_cqe(this.address(), index2, value);
        return this;
    }

    public IOURingCQE set(long user_data, int res, int flags, LongBuffer big_cqe) {
        this.user_data(user_data);
        this.res(res);
        this.flags(flags);
        this.big_cqe(big_cqe);
        return this;
    }

    public IOURingCQE set(IOURingCQE src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static IOURingCQE malloc() {
        return IOURingCQE.wrap(IOURingCQE.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static IOURingCQE calloc() {
        return IOURingCQE.wrap(IOURingCQE.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static IOURingCQE create() {
        ByteBuffer container2 = BufferUtils.createByteBuffer(SIZEOF);
        return IOURingCQE.wrap(IOURingCQE.class, MemoryUtil.memAddress(container2), container2);
    }

    public static IOURingCQE create(long address) {
        return IOURingCQE.wrap(IOURingCQE.class, address);
    }

    @Nullable
    public static IOURingCQE createSafe(long address) {
        return address == 0L ? null : IOURingCQE.wrap(IOURingCQE.class, address);
    }

    public static Buffer malloc(int capacity) {
        return IOURingCQE.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(IOURingCQE.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return IOURingCQE.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container2 = IOURingCQE.__create(capacity, SIZEOF);
        return IOURingCQE.wrap(Buffer.class, MemoryUtil.memAddress(container2), capacity, container2);
    }

    public static Buffer create(long address, int capacity) {
        return IOURingCQE.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : IOURingCQE.wrap(Buffer.class, address, capacity);
    }

    public static IOURingCQE malloc(MemoryStack stack) {
        return IOURingCQE.wrap(IOURingCQE.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static IOURingCQE calloc(MemoryStack stack) {
        return IOURingCQE.wrap(IOURingCQE.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return IOURingCQE.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return IOURingCQE.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nuser_data(long struct) {
        return UNSAFE.getLong(null, struct + (long)USER_DATA);
    }

    public static int nres(long struct) {
        return UNSAFE.getInt(null, struct + (long)RES);
    }

    public static int nflags(long struct) {
        return UNSAFE.getInt(null, struct + (long)FLAGS);
    }

    public static LongBuffer nbig_cqe(long struct) {
        return MemoryUtil.memLongBuffer(struct + (long)BIG_CQE, 0);
    }

    public static long nbig_cqe(long struct, int index2) {
        return UNSAFE.getLong(null, struct + (long)BIG_CQE + Checks.check(index2, 0) * 8L);
    }

    public static void nuser_data(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)USER_DATA, value);
    }

    public static void nres(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)RES, value);
    }

    public static void nflags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FLAGS, value);
    }

    public static void nbig_cqe(long struct, LongBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 0);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)BIG_CQE, value.remaining() * 8);
    }

    public static void nbig_cqe(long struct, int index2, long value) {
        UNSAFE.putLong(null, struct + (long)BIG_CQE + Checks.check(index2, 0) * 8L, value);
    }

    static {
        Struct.Layout layout2 = IOURingCQE.__struct(IOURingCQE.__member(8), IOURingCQE.__member(4), IOURingCQE.__member(4), IOURingCQE.__array(8, 0));
        SIZEOF = layout2.getSize();
        ALIGNOF = layout2.getAlignment();
        USER_DATA = layout2.offsetof(0);
        RES = layout2.offsetof(1);
        FLAGS = layout2.offsetof(2);
        BIG_CQE = layout2.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<IOURingCQE, Buffer>
    implements NativeResource {
        private static final IOURingCQE ELEMENT_FACTORY = IOURingCQE.create(-1L);

        public Buffer(ByteBuffer container2) {
            super(container2, container2.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container2, int mark, int pos, int lim, int cap) {
            super(address, container2, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected IOURingCQE getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="__u64")
        public long user_data() {
            return IOURingCQE.nuser_data(this.address());
        }

        @NativeType(value="__s32")
        public int res() {
            return IOURingCQE.nres(this.address());
        }

        @NativeType(value="__u32")
        public int flags() {
            return IOURingCQE.nflags(this.address());
        }

        @NativeType(value="__u64[0]")
        public LongBuffer big_cqe() {
            return IOURingCQE.nbig_cqe(this.address());
        }

        @NativeType(value="__u64")
        public long big_cqe(int index2) {
            return IOURingCQE.nbig_cqe(this.address(), index2);
        }

        public Buffer user_data(@NativeType(value="__u64") long value) {
            IOURingCQE.nuser_data(this.address(), value);
            return this;
        }

        public Buffer res(@NativeType(value="__s32") int value) {
            IOURingCQE.nres(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="__u32") int value) {
            IOURingCQE.nflags(this.address(), value);
            return this;
        }

        public Buffer big_cqe(@NativeType(value="__u64[0]") LongBuffer value) {
            IOURingCQE.nbig_cqe(this.address(), value);
            return this;
        }

        public Buffer big_cqe(int index2, @NativeType(value="__u64") long value) {
            IOURingCQE.nbig_cqe(this.address(), index2, value);
            return this;
        }
    }
}

