/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux.liburing;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.system.linux.liburing.IOURingBuf;

@NativeType(value="struct io_uring_buf_ring")
public class IOURingBufRing
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int RESV1;
    public static final int RESV2;
    public static final int RESV3;
    public static final int TAIL;
    public static final int BUFS;

    public IOURingBufRing(ByteBuffer container2) {
        super(MemoryUtil.memAddress(container2), IOURingBufRing.__checkContainer(container2, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="__u64")
    public long resv1() {
        return IOURingBufRing.nresv1(this.address());
    }

    @NativeType(value="__u32")
    public int resv2() {
        return IOURingBufRing.nresv2(this.address());
    }

    @NativeType(value="__u16")
    public short resv3() {
        return IOURingBufRing.nresv3(this.address());
    }

    @NativeType(value="__u16")
    public short tail() {
        return IOURingBufRing.ntail(this.address());
    }

    @NativeType(value="struct io_uring_buf[0]")
    public IOURingBuf.Buffer bufs() {
        return IOURingBufRing.nbufs(this.address());
    }

    @NativeType(value="struct io_uring_buf")
    public IOURingBuf bufs(int index2) {
        return IOURingBufRing.nbufs(this.address(), index2);
    }

    public IOURingBufRing resv1(@NativeType(value="__u64") long value) {
        IOURingBufRing.nresv1(this.address(), value);
        return this;
    }

    public IOURingBufRing resv2(@NativeType(value="__u32") int value) {
        IOURingBufRing.nresv2(this.address(), value);
        return this;
    }

    public IOURingBufRing resv3(@NativeType(value="__u16") short value) {
        IOURingBufRing.nresv3(this.address(), value);
        return this;
    }

    public IOURingBufRing tail(@NativeType(value="__u16") short value) {
        IOURingBufRing.ntail(this.address(), value);
        return this;
    }

    public IOURingBufRing bufs(@NativeType(value="struct io_uring_buf[0]") IOURingBuf.Buffer value) {
        IOURingBufRing.nbufs(this.address(), value);
        return this;
    }

    public IOURingBufRing bufs(int index2, @NativeType(value="struct io_uring_buf") IOURingBuf value) {
        IOURingBufRing.nbufs(this.address(), index2, value);
        return this;
    }

    public IOURingBufRing bufs(Consumer<IOURingBuf.Buffer> consumer2) {
        consumer2.accept(this.bufs());
        return this;
    }

    public IOURingBufRing bufs(int index2, Consumer<IOURingBuf> consumer2) {
        consumer2.accept(this.bufs(index2));
        return this;
    }

    public IOURingBufRing set(IOURingBufRing src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static IOURingBufRing malloc() {
        return IOURingBufRing.wrap(IOURingBufRing.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static IOURingBufRing calloc() {
        return IOURingBufRing.wrap(IOURingBufRing.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static IOURingBufRing create() {
        ByteBuffer container2 = BufferUtils.createByteBuffer(SIZEOF);
        return IOURingBufRing.wrap(IOURingBufRing.class, MemoryUtil.memAddress(container2), container2);
    }

    public static IOURingBufRing create(long address) {
        return IOURingBufRing.wrap(IOURingBufRing.class, address);
    }

    @Nullable
    public static IOURingBufRing createSafe(long address) {
        return address == 0L ? null : IOURingBufRing.wrap(IOURingBufRing.class, address);
    }

    public static Buffer malloc(int capacity) {
        return IOURingBufRing.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(IOURingBufRing.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return IOURingBufRing.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container2 = IOURingBufRing.__create(capacity, SIZEOF);
        return IOURingBufRing.wrap(Buffer.class, MemoryUtil.memAddress(container2), capacity, container2);
    }

    public static Buffer create(long address, int capacity) {
        return IOURingBufRing.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : IOURingBufRing.wrap(Buffer.class, address, capacity);
    }

    public static IOURingBufRing malloc(MemoryStack stack) {
        return IOURingBufRing.wrap(IOURingBufRing.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static IOURingBufRing calloc(MemoryStack stack) {
        return IOURingBufRing.wrap(IOURingBufRing.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return IOURingBufRing.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return IOURingBufRing.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nresv1(long struct) {
        return UNSAFE.getLong(null, struct + (long)RESV1);
    }

    public static int nresv2(long struct) {
        return UNSAFE.getInt(null, struct + (long)RESV2);
    }

    public static short nresv3(long struct) {
        return UNSAFE.getShort(null, struct + (long)RESV3);
    }

    public static short ntail(long struct) {
        return UNSAFE.getShort(null, struct + (long)TAIL);
    }

    public static IOURingBuf.Buffer nbufs(long struct) {
        return IOURingBuf.create(struct + (long)BUFS, 0);
    }

    public static IOURingBuf nbufs(long struct, int index2) {
        return IOURingBuf.create(struct + (long)BUFS + Checks.check(index2, 0) * (long)IOURingBuf.SIZEOF);
    }

    public static void nresv1(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)RESV1, value);
    }

    public static void nresv2(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)RESV2, value);
    }

    public static void nresv3(long struct, short value) {
        UNSAFE.putShort(null, struct + (long)RESV3, value);
    }

    public static void ntail(long struct, short value) {
        UNSAFE.putShort(null, struct + (long)TAIL, value);
    }

    public static void nbufs(long struct, IOURingBuf.Buffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 0);
        }
        MemoryUtil.memCopy(value.address(), struct + (long)BUFS, value.remaining() * IOURingBuf.SIZEOF);
    }

    public static void nbufs(long struct, int index2, IOURingBuf value) {
        MemoryUtil.memCopy(value.address(), struct + (long)BUFS + Checks.check(index2, 0) * (long)IOURingBuf.SIZEOF, IOURingBuf.SIZEOF);
    }

    static {
        Struct.Layout layout2 = IOURingBufRing.__struct(IOURingBufRing.__union(IOURingBufRing.__struct(IOURingBufRing.__member(8), IOURingBufRing.__member(4), IOURingBufRing.__member(2), IOURingBufRing.__member(2)), IOURingBufRing.__array(IOURingBuf.SIZEOF, IOURingBuf.ALIGNOF, 0)));
        SIZEOF = layout2.getSize();
        ALIGNOF = layout2.getAlignment();
        RESV1 = layout2.offsetof(2);
        RESV2 = layout2.offsetof(3);
        RESV3 = layout2.offsetof(4);
        TAIL = layout2.offsetof(5);
        BUFS = layout2.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<IOURingBufRing, Buffer>
    implements NativeResource {
        private static final IOURingBufRing ELEMENT_FACTORY = IOURingBufRing.create(-1L);

        public Buffer(ByteBuffer container2) {
            super(container2, container2.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container2, int mark, int pos, int lim, int cap) {
            super(address, container2, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected IOURingBufRing getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="__u64")
        public long resv1() {
            return IOURingBufRing.nresv1(this.address());
        }

        @NativeType(value="__u32")
        public int resv2() {
            return IOURingBufRing.nresv2(this.address());
        }

        @NativeType(value="__u16")
        public short resv3() {
            return IOURingBufRing.nresv3(this.address());
        }

        @NativeType(value="__u16")
        public short tail() {
            return IOURingBufRing.ntail(this.address());
        }

        @NativeType(value="struct io_uring_buf[0]")
        public IOURingBuf.Buffer bufs() {
            return IOURingBufRing.nbufs(this.address());
        }

        @NativeType(value="struct io_uring_buf")
        public IOURingBuf bufs(int index2) {
            return IOURingBufRing.nbufs(this.address(), index2);
        }

        public Buffer resv1(@NativeType(value="__u64") long value) {
            IOURingBufRing.nresv1(this.address(), value);
            return this;
        }

        public Buffer resv2(@NativeType(value="__u32") int value) {
            IOURingBufRing.nresv2(this.address(), value);
            return this;
        }

        public Buffer resv3(@NativeType(value="__u16") short value) {
            IOURingBufRing.nresv3(this.address(), value);
            return this;
        }

        public Buffer tail(@NativeType(value="__u16") short value) {
            IOURingBufRing.ntail(this.address(), value);
            return this;
        }

        public Buffer bufs(@NativeType(value="struct io_uring_buf[0]") IOURingBuf.Buffer value) {
            IOURingBufRing.nbufs(this.address(), value);
            return this;
        }

        public Buffer bufs(int index2, @NativeType(value="struct io_uring_buf") IOURingBuf value) {
            IOURingBufRing.nbufs(this.address(), index2, value);
            return this;
        }

        public Buffer bufs(Consumer<IOURingBuf.Buffer> consumer2) {
            consumer2.accept(this.bufs());
            return this;
        }

        public Buffer bufs(int index2, Consumer<IOURingBuf> consumer2) {
            consumer2.accept(this.bufs(index2));
            return this;
        }
    }
}

