/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux.liburing;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct io_uring_buf")
public class IOURingBuf
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ADDR;
    public static final int LEN;
    public static final int BID;
    public static final int RESV;

    public IOURingBuf(ByteBuffer container2) {
        super(MemoryUtil.memAddress(container2), IOURingBuf.__checkContainer(container2, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="__u64")
    public long addr() {
        return IOURingBuf.naddr(this.address());
    }

    @NativeType(value="__u32")
    public int len() {
        return IOURingBuf.nlen(this.address());
    }

    @NativeType(value="__u16")
    public short bid() {
        return IOURingBuf.nbid(this.address());
    }

    @NativeType(value="__u16")
    public short resv() {
        return IOURingBuf.nresv(this.address());
    }

    public IOURingBuf addr(@NativeType(value="__u64") long value) {
        IOURingBuf.naddr(this.address(), value);
        return this;
    }

    public IOURingBuf len(@NativeType(value="__u32") int value) {
        IOURingBuf.nlen(this.address(), value);
        return this;
    }

    public IOURingBuf bid(@NativeType(value="__u16") short value) {
        IOURingBuf.nbid(this.address(), value);
        return this;
    }

    public IOURingBuf resv(@NativeType(value="__u16") short value) {
        IOURingBuf.nresv(this.address(), value);
        return this;
    }

    public IOURingBuf set(long addr, int len, short bid, short resv) {
        this.addr(addr);
        this.len(len);
        this.bid(bid);
        this.resv(resv);
        return this;
    }

    public IOURingBuf set(IOURingBuf src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static IOURingBuf malloc() {
        return IOURingBuf.wrap(IOURingBuf.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static IOURingBuf calloc() {
        return IOURingBuf.wrap(IOURingBuf.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static IOURingBuf create() {
        ByteBuffer container2 = BufferUtils.createByteBuffer(SIZEOF);
        return IOURingBuf.wrap(IOURingBuf.class, MemoryUtil.memAddress(container2), container2);
    }

    public static IOURingBuf create(long address) {
        return IOURingBuf.wrap(IOURingBuf.class, address);
    }

    @Nullable
    public static IOURingBuf createSafe(long address) {
        return address == 0L ? null : IOURingBuf.wrap(IOURingBuf.class, address);
    }

    public static Buffer malloc(int capacity) {
        return IOURingBuf.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(IOURingBuf.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return IOURingBuf.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container2 = IOURingBuf.__create(capacity, SIZEOF);
        return IOURingBuf.wrap(Buffer.class, MemoryUtil.memAddress(container2), capacity, container2);
    }

    public static Buffer create(long address, int capacity) {
        return IOURingBuf.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : IOURingBuf.wrap(Buffer.class, address, capacity);
    }

    public static IOURingBuf malloc(MemoryStack stack) {
        return IOURingBuf.wrap(IOURingBuf.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static IOURingBuf calloc(MemoryStack stack) {
        return IOURingBuf.wrap(IOURingBuf.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return IOURingBuf.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return IOURingBuf.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long naddr(long struct) {
        return UNSAFE.getLong(null, struct + (long)ADDR);
    }

    public static int nlen(long struct) {
        return UNSAFE.getInt(null, struct + (long)LEN);
    }

    public static short nbid(long struct) {
        return UNSAFE.getShort(null, struct + (long)BID);
    }

    public static short nresv(long struct) {
        return UNSAFE.getShort(null, struct + (long)RESV);
    }

    public static void naddr(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)ADDR, value);
    }

    public static void nlen(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)LEN, value);
    }

    public static void nbid(long struct, short value) {
        UNSAFE.putShort(null, struct + (long)BID, value);
    }

    public static void nresv(long struct, short value) {
        UNSAFE.putShort(null, struct + (long)RESV, value);
    }

    static {
        Struct.Layout layout2 = IOURingBuf.__struct(IOURingBuf.__member(8), IOURingBuf.__member(4), IOURingBuf.__member(2), IOURingBuf.__member(2));
        SIZEOF = layout2.getSize();
        ALIGNOF = layout2.getAlignment();
        ADDR = layout2.offsetof(0);
        LEN = layout2.offsetof(1);
        BID = layout2.offsetof(2);
        RESV = layout2.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<IOURingBuf, Buffer>
    implements NativeResource {
        private static final IOURingBuf ELEMENT_FACTORY = IOURingBuf.create(-1L);

        public Buffer(ByteBuffer container2) {
            super(container2, container2.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container2, int mark, int pos, int lim, int cap) {
            super(address, container2, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected IOURingBuf getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="__u64")
        public long addr() {
            return IOURingBuf.naddr(this.address());
        }

        @NativeType(value="__u32")
        public int len() {
            return IOURingBuf.nlen(this.address());
        }

        @NativeType(value="__u16")
        public short bid() {
            return IOURingBuf.nbid(this.address());
        }

        @NativeType(value="__u16")
        public short resv() {
            return IOURingBuf.nresv(this.address());
        }

        public Buffer addr(@NativeType(value="__u64") long value) {
            IOURingBuf.naddr(this.address(), value);
            return this;
        }

        public Buffer len(@NativeType(value="__u32") int value) {
            IOURingBuf.nlen(this.address(), value);
            return this;
        }

        public Buffer bid(@NativeType(value="__u16") short value) {
            IOURingBuf.nbid(this.address(), value);
            return this;
        }

        public Buffer resv(@NativeType(value="__u16") short value) {
            IOURingBuf.nresv(this.address(), value);
            return this;
        }
    }
}

