/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux.liburing;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct io_cqring_offsets")
public class IOCQRingOffsets
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int HEAD;
    public static final int TAIL;
    public static final int RING_MASK;
    public static final int RING_ENTRIES;
    public static final int OVERFLOW;
    public static final int CQES;
    public static final int FLAGS;
    public static final int RESV1;
    public static final int RESV2;

    public IOCQRingOffsets(ByteBuffer container2) {
        super(MemoryUtil.memAddress(container2), IOCQRingOffsets.__checkContainer(container2, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="__u32")
    public int head() {
        return IOCQRingOffsets.nhead(this.address());
    }

    @NativeType(value="__u32")
    public int tail() {
        return IOCQRingOffsets.ntail(this.address());
    }

    @NativeType(value="__u32")
    public int ring_mask() {
        return IOCQRingOffsets.nring_mask(this.address());
    }

    @NativeType(value="__u32")
    public int ring_entries() {
        return IOCQRingOffsets.nring_entries(this.address());
    }

    @NativeType(value="__u32")
    public int overflow() {
        return IOCQRingOffsets.noverflow(this.address());
    }

    @NativeType(value="__u32")
    public int cqes() {
        return IOCQRingOffsets.ncqes(this.address());
    }

    @NativeType(value="__u32")
    public int flags() {
        return IOCQRingOffsets.nflags(this.address());
    }

    public IOCQRingOffsets head(@NativeType(value="__u32") int value) {
        IOCQRingOffsets.nhead(this.address(), value);
        return this;
    }

    public IOCQRingOffsets tail(@NativeType(value="__u32") int value) {
        IOCQRingOffsets.ntail(this.address(), value);
        return this;
    }

    public IOCQRingOffsets ring_mask(@NativeType(value="__u32") int value) {
        IOCQRingOffsets.nring_mask(this.address(), value);
        return this;
    }

    public IOCQRingOffsets ring_entries(@NativeType(value="__u32") int value) {
        IOCQRingOffsets.nring_entries(this.address(), value);
        return this;
    }

    public IOCQRingOffsets overflow(@NativeType(value="__u32") int value) {
        IOCQRingOffsets.noverflow(this.address(), value);
        return this;
    }

    public IOCQRingOffsets cqes(@NativeType(value="__u32") int value) {
        IOCQRingOffsets.ncqes(this.address(), value);
        return this;
    }

    public IOCQRingOffsets flags(@NativeType(value="__u32") int value) {
        IOCQRingOffsets.nflags(this.address(), value);
        return this;
    }

    public IOCQRingOffsets set(int head, int tail, int ring_mask, int ring_entries, int overflow, int cqes, int flags) {
        this.head(head);
        this.tail(tail);
        this.ring_mask(ring_mask);
        this.ring_entries(ring_entries);
        this.overflow(overflow);
        this.cqes(cqes);
        this.flags(flags);
        return this;
    }

    public IOCQRingOffsets set(IOCQRingOffsets src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static IOCQRingOffsets malloc() {
        return IOCQRingOffsets.wrap(IOCQRingOffsets.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static IOCQRingOffsets calloc() {
        return IOCQRingOffsets.wrap(IOCQRingOffsets.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static IOCQRingOffsets create() {
        ByteBuffer container2 = BufferUtils.createByteBuffer(SIZEOF);
        return IOCQRingOffsets.wrap(IOCQRingOffsets.class, MemoryUtil.memAddress(container2), container2);
    }

    public static IOCQRingOffsets create(long address) {
        return IOCQRingOffsets.wrap(IOCQRingOffsets.class, address);
    }

    @Nullable
    public static IOCQRingOffsets createSafe(long address) {
        return address == 0L ? null : IOCQRingOffsets.wrap(IOCQRingOffsets.class, address);
    }

    public static Buffer malloc(int capacity) {
        return IOCQRingOffsets.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(IOCQRingOffsets.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return IOCQRingOffsets.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container2 = IOCQRingOffsets.__create(capacity, SIZEOF);
        return IOCQRingOffsets.wrap(Buffer.class, MemoryUtil.memAddress(container2), capacity, container2);
    }

    public static Buffer create(long address, int capacity) {
        return IOCQRingOffsets.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : IOCQRingOffsets.wrap(Buffer.class, address, capacity);
    }

    public static IOCQRingOffsets malloc(MemoryStack stack) {
        return IOCQRingOffsets.wrap(IOCQRingOffsets.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static IOCQRingOffsets calloc(MemoryStack stack) {
        return IOCQRingOffsets.wrap(IOCQRingOffsets.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return IOCQRingOffsets.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return IOCQRingOffsets.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nhead(long struct) {
        return UNSAFE.getInt(null, struct + (long)HEAD);
    }

    public static int ntail(long struct) {
        return UNSAFE.getInt(null, struct + (long)TAIL);
    }

    public static int nring_mask(long struct) {
        return UNSAFE.getInt(null, struct + (long)RING_MASK);
    }

    public static int nring_entries(long struct) {
        return UNSAFE.getInt(null, struct + (long)RING_ENTRIES);
    }

    public static int noverflow(long struct) {
        return UNSAFE.getInt(null, struct + (long)OVERFLOW);
    }

    public static int ncqes(long struct) {
        return UNSAFE.getInt(null, struct + (long)CQES);
    }

    public static int nflags(long struct) {
        return UNSAFE.getInt(null, struct + (long)FLAGS);
    }

    public static int nresv1(long struct) {
        return UNSAFE.getInt(null, struct + (long)RESV1);
    }

    public static long nresv2(long struct) {
        return UNSAFE.getLong(null, struct + (long)RESV2);
    }

    public static void nhead(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)HEAD, value);
    }

    public static void ntail(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TAIL, value);
    }

    public static void nring_mask(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)RING_MASK, value);
    }

    public static void nring_entries(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)RING_ENTRIES, value);
    }

    public static void noverflow(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)OVERFLOW, value);
    }

    public static void ncqes(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)CQES, value);
    }

    public static void nflags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FLAGS, value);
    }

    public static void nresv1(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)RESV1, value);
    }

    public static void nresv2(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)RESV2, value);
    }

    static {
        Struct.Layout layout2 = IOCQRingOffsets.__struct(IOCQRingOffsets.__member(4), IOCQRingOffsets.__member(4), IOCQRingOffsets.__member(4), IOCQRingOffsets.__member(4), IOCQRingOffsets.__member(4), IOCQRingOffsets.__member(4), IOCQRingOffsets.__member(4), IOCQRingOffsets.__member(4), IOCQRingOffsets.__member(8));
        SIZEOF = layout2.getSize();
        ALIGNOF = layout2.getAlignment();
        HEAD = layout2.offsetof(0);
        TAIL = layout2.offsetof(1);
        RING_MASK = layout2.offsetof(2);
        RING_ENTRIES = layout2.offsetof(3);
        OVERFLOW = layout2.offsetof(4);
        CQES = layout2.offsetof(5);
        FLAGS = layout2.offsetof(6);
        RESV1 = layout2.offsetof(7);
        RESV2 = layout2.offsetof(8);
    }

    public static class Buffer
    extends StructBuffer<IOCQRingOffsets, Buffer>
    implements NativeResource {
        private static final IOCQRingOffsets ELEMENT_FACTORY = IOCQRingOffsets.create(-1L);

        public Buffer(ByteBuffer container2) {
            super(container2, container2.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container2, int mark, int pos, int lim, int cap) {
            super(address, container2, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected IOCQRingOffsets getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="__u32")
        public int head() {
            return IOCQRingOffsets.nhead(this.address());
        }

        @NativeType(value="__u32")
        public int tail() {
            return IOCQRingOffsets.ntail(this.address());
        }

        @NativeType(value="__u32")
        public int ring_mask() {
            return IOCQRingOffsets.nring_mask(this.address());
        }

        @NativeType(value="__u32")
        public int ring_entries() {
            return IOCQRingOffsets.nring_entries(this.address());
        }

        @NativeType(value="__u32")
        public int overflow() {
            return IOCQRingOffsets.noverflow(this.address());
        }

        @NativeType(value="__u32")
        public int cqes() {
            return IOCQRingOffsets.ncqes(this.address());
        }

        @NativeType(value="__u32")
        public int flags() {
            return IOCQRingOffsets.nflags(this.address());
        }

        public Buffer head(@NativeType(value="__u32") int value) {
            IOCQRingOffsets.nhead(this.address(), value);
            return this;
        }

        public Buffer tail(@NativeType(value="__u32") int value) {
            IOCQRingOffsets.ntail(this.address(), value);
            return this;
        }

        public Buffer ring_mask(@NativeType(value="__u32") int value) {
            IOCQRingOffsets.nring_mask(this.address(), value);
            return this;
        }

        public Buffer ring_entries(@NativeType(value="__u32") int value) {
            IOCQRingOffsets.nring_entries(this.address(), value);
            return this;
        }

        public Buffer overflow(@NativeType(value="__u32") int value) {
            IOCQRingOffsets.noverflow(this.address(), value);
            return this;
        }

        public Buffer cqes(@NativeType(value="__u32") int value) {
            IOCQRingOffsets.ncqes(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="__u32") int value) {
            IOCQRingOffsets.nflags(this.address(), value);
            return this;
        }
    }
}

