/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct open_how")
public class OpenHow
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FLAGS;
    public static final int MODE;
    public static final int RESOLVE;

    public OpenHow(ByteBuffer container2) {
        super(MemoryUtil.memAddress(container2), OpenHow.__checkContainer(container2, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="__u64")
    public long flags() {
        return OpenHow.nflags(this.address());
    }

    @NativeType(value="__u64")
    public long mode() {
        return OpenHow.nmode(this.address());
    }

    @NativeType(value="__u64")
    public long resolve() {
        return OpenHow.nresolve(this.address());
    }

    public OpenHow flags(@NativeType(value="__u64") long value) {
        OpenHow.nflags(this.address(), value);
        return this;
    }

    public OpenHow mode(@NativeType(value="__u64") long value) {
        OpenHow.nmode(this.address(), value);
        return this;
    }

    public OpenHow resolve(@NativeType(value="__u64") long value) {
        OpenHow.nresolve(this.address(), value);
        return this;
    }

    public OpenHow set(long flags, long mode, long resolve2) {
        this.flags(flags);
        this.mode(mode);
        this.resolve(resolve2);
        return this;
    }

    public OpenHow set(OpenHow src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static OpenHow malloc() {
        return OpenHow.wrap(OpenHow.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static OpenHow calloc() {
        return OpenHow.wrap(OpenHow.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static OpenHow create() {
        ByteBuffer container2 = BufferUtils.createByteBuffer(SIZEOF);
        return OpenHow.wrap(OpenHow.class, MemoryUtil.memAddress(container2), container2);
    }

    public static OpenHow create(long address) {
        return OpenHow.wrap(OpenHow.class, address);
    }

    @Nullable
    public static OpenHow createSafe(long address) {
        return address == 0L ? null : OpenHow.wrap(OpenHow.class, address);
    }

    public static Buffer malloc(int capacity) {
        return OpenHow.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(OpenHow.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return OpenHow.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container2 = OpenHow.__create(capacity, SIZEOF);
        return OpenHow.wrap(Buffer.class, MemoryUtil.memAddress(container2), capacity, container2);
    }

    public static Buffer create(long address, int capacity) {
        return OpenHow.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : OpenHow.wrap(Buffer.class, address, capacity);
    }

    public static OpenHow malloc(MemoryStack stack) {
        return OpenHow.wrap(OpenHow.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static OpenHow calloc(MemoryStack stack) {
        return OpenHow.wrap(OpenHow.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return OpenHow.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return OpenHow.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nflags(long struct) {
        return UNSAFE.getLong(null, struct + (long)FLAGS);
    }

    public static long nmode(long struct) {
        return UNSAFE.getLong(null, struct + (long)MODE);
    }

    public static long nresolve(long struct) {
        return UNSAFE.getLong(null, struct + (long)RESOLVE);
    }

    public static void nflags(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)FLAGS, value);
    }

    public static void nmode(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)MODE, value);
    }

    public static void nresolve(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)RESOLVE, value);
    }

    static {
        Struct.Layout layout2 = OpenHow.__struct(OpenHow.__member(8), OpenHow.__member(8), OpenHow.__member(8));
        SIZEOF = layout2.getSize();
        ALIGNOF = layout2.getAlignment();
        FLAGS = layout2.offsetof(0);
        MODE = layout2.offsetof(1);
        RESOLVE = layout2.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<OpenHow, Buffer>
    implements NativeResource {
        private static final OpenHow ELEMENT_FACTORY = OpenHow.create(-1L);

        public Buffer(ByteBuffer container2) {
            super(container2, container2.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container2, int mark, int pos, int lim, int cap) {
            super(address, container2, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected OpenHow getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="__u64")
        public long flags() {
            return OpenHow.nflags(this.address());
        }

        @NativeType(value="__u64")
        public long mode() {
            return OpenHow.nmode(this.address());
        }

        @NativeType(value="__u64")
        public long resolve() {
            return OpenHow.nresolve(this.address());
        }

        public Buffer flags(@NativeType(value="__u64") long value) {
            OpenHow.nflags(this.address(), value);
            return this;
        }

        public Buffer mode(@NativeType(value="__u64") long value) {
            OpenHow.nmode(this.address(), value);
            return this;
        }

        public Buffer resolve(@NativeType(value="__u64") long value) {
            OpenHow.nresolve(this.address(), value);
            return this;
        }
    }
}

