/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct __kernel_timespec")
public class KernelTimespec
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TV_SEC;
    public static final int TV_NSEC;

    public KernelTimespec(ByteBuffer container2) {
        super(MemoryUtil.memAddress(container2), KernelTimespec.__checkContainer(container2, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="int64_t")
    public long tv_sec() {
        return KernelTimespec.ntv_sec(this.address());
    }

    @NativeType(value="long long")
    public long tv_nsec() {
        return KernelTimespec.ntv_nsec(this.address());
    }

    public KernelTimespec tv_sec(@NativeType(value="int64_t") long value) {
        KernelTimespec.ntv_sec(this.address(), value);
        return this;
    }

    public KernelTimespec tv_nsec(@NativeType(value="long long") long value) {
        KernelTimespec.ntv_nsec(this.address(), value);
        return this;
    }

    public KernelTimespec set(long tv_sec, long tv_nsec) {
        this.tv_sec(tv_sec);
        this.tv_nsec(tv_nsec);
        return this;
    }

    public KernelTimespec set(KernelTimespec src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static KernelTimespec malloc() {
        return KernelTimespec.wrap(KernelTimespec.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static KernelTimespec calloc() {
        return KernelTimespec.wrap(KernelTimespec.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static KernelTimespec create() {
        ByteBuffer container2 = BufferUtils.createByteBuffer(SIZEOF);
        return KernelTimespec.wrap(KernelTimespec.class, MemoryUtil.memAddress(container2), container2);
    }

    public static KernelTimespec create(long address) {
        return KernelTimespec.wrap(KernelTimespec.class, address);
    }

    @Nullable
    public static KernelTimespec createSafe(long address) {
        return address == 0L ? null : KernelTimespec.wrap(KernelTimespec.class, address);
    }

    public static Buffer malloc(int capacity) {
        return KernelTimespec.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(KernelTimespec.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return KernelTimespec.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container2 = KernelTimespec.__create(capacity, SIZEOF);
        return KernelTimespec.wrap(Buffer.class, MemoryUtil.memAddress(container2), capacity, container2);
    }

    public static Buffer create(long address, int capacity) {
        return KernelTimespec.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : KernelTimespec.wrap(Buffer.class, address, capacity);
    }

    public static KernelTimespec malloc(MemoryStack stack) {
        return KernelTimespec.wrap(KernelTimespec.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static KernelTimespec calloc(MemoryStack stack) {
        return KernelTimespec.wrap(KernelTimespec.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return KernelTimespec.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return KernelTimespec.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long ntv_sec(long struct) {
        return UNSAFE.getLong(null, struct + (long)TV_SEC);
    }

    public static long ntv_nsec(long struct) {
        return UNSAFE.getLong(null, struct + (long)TV_NSEC);
    }

    public static void ntv_sec(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)TV_SEC, value);
    }

    public static void ntv_nsec(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)TV_NSEC, value);
    }

    static {
        Struct.Layout layout2 = KernelTimespec.__struct(KernelTimespec.__member(8), KernelTimespec.__member(8));
        SIZEOF = layout2.getSize();
        ALIGNOF = layout2.getAlignment();
        TV_SEC = layout2.offsetof(0);
        TV_NSEC = layout2.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<KernelTimespec, Buffer>
    implements NativeResource {
        private static final KernelTimespec ELEMENT_FACTORY = KernelTimespec.create(-1L);

        public Buffer(ByteBuffer container2) {
            super(container2, container2.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container2, int mark, int pos, int lim, int cap) {
            super(address, container2, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected KernelTimespec getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="int64_t")
        public long tv_sec() {
            return KernelTimespec.ntv_sec(this.address());
        }

        @NativeType(value="long long")
        public long tv_nsec() {
            return KernelTimespec.ntv_nsec(this.address());
        }

        public Buffer tv_sec(@NativeType(value="int64_t") long value) {
            KernelTimespec.ntv_sec(this.address(), value);
            return this;
        }

        public Buffer tv_nsec(@NativeType(value="long long") long value) {
            KernelTimespec.ntv_nsec(this.address(), value);
            return this;
        }
    }
}

