/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.zip.CRC32;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.lwjgl.Version;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Configuration;
import org.lwjgl.system.Platform;

final class SharedLibraryLoader {
    private static final Lock EXTRACT_PATH_LOCK = new ReentrantLock();
    @Nullable
    @GuardedBy(value="EXTRACT_PATH_LOCK")
    private static Path extractPath;
    private static HashSet<Path> extractPaths;
    private static boolean checkedJDK8195129;

    private SharedLibraryLoader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static FileChannel load(String name, String filename, URL resource2, @Nullable Consumer<String> load2) {
        try {
            Path extractedFile;
            EXTRACT_PATH_LOCK.lock();
            try {
                if (extractPath != null) {
                    extractedFile = extractPath.resolve(filename);
                } else {
                    extractedFile = SharedLibraryLoader.getExtractPath(filename, resource2, load2);
                    Path parent2 = extractedFile.getParent();
                    if (Platform.get() != Platform.WINDOWS || checkedJDK8195129) {
                        extractPath = parent2;
                    }
                    SharedLibraryLoader.initExtractPath(parent2);
                }
            }
            finally {
                EXTRACT_PATH_LOCK.unlock();
            }
            return SharedLibraryLoader.extract(extractedFile, resource2);
        }
        catch (Exception e) {
            throw new RuntimeException("\tFailed to extract " + name + " library", e);
        }
    }

    private static void initExtractPath(Path extractPath) {
        if (extractPaths.contains(extractPath)) {
            return;
        }
        extractPaths.add(extractPath);
        String newLibPath = extractPath.toAbsolutePath().toString();
        String libPath = Configuration.LIBRARY_PATH.get();
        if (libPath != null && !libPath.isEmpty()) {
            newLibPath = newLibPath + File.pathSeparator + libPath;
        }
        System.setProperty(Configuration.LIBRARY_PATH.getProperty(), newLibPath);
        Configuration.LIBRARY_PATH.set(newLibPath);
    }

    private static Path getExtractPath(String filename, URL resource2, @Nullable Consumer<String> load2) {
        Path file;
        Path root2;
        String override = Configuration.SHARED_LIBRARY_EXTRACT_PATH.get();
        if (override != null) {
            root2 = Paths.get(override, new String[0]);
            if (SharedLibraryLoader.canWrite(root2, file = root2.resolve(filename), resource2, load2)) {
                return file;
            }
            APIUtil.apiLogMore("The path " + override + " is not accessible. Trying other paths.");
        }
        String version = Version.getVersion().replace(' ', '-');
        String arch = Platform.getArchitecture().name().toLowerCase();
        root2 = Paths.get(System.getProperty("java.io.tmpdir"), new String[0]);
        if (SharedLibraryLoader.canWrite(root2, file = root2.resolve(Paths.get(Configuration.SHARED_LIBRARY_EXTRACT_DIRECTORY.get("lwjgl_" + System.getProperty("user.name").trim()), version, arch, filename)), resource2, load2)) {
            return file;
        }
        Path lwjgl_version_filename = Paths.get("." + Configuration.SHARED_LIBRARY_EXTRACT_DIRECTORY.get("lwjgl"), version, arch, filename);
        root2 = Paths.get("", new String[0]).toAbsolutePath();
        if (SharedLibraryLoader.canWrite(root2, file = root2.resolve(lwjgl_version_filename), resource2, load2)) {
            return file;
        }
        root2 = Paths.get(System.getProperty("user.home"), new String[0]);
        if (SharedLibraryLoader.canWrite(root2, file = root2.resolve(lwjgl_version_filename), resource2, load2)) {
            return file;
        }
        if (Platform.get() == Platform.WINDOWS) {
            String env = System.getenv("SystemRoot");
            if (env != null && SharedLibraryLoader.canWrite(root2 = Paths.get(env, "Temp"), file = root2.resolve(lwjgl_version_filename), resource2, load2)) {
                return file;
            }
            env = System.getenv("SystemDrive");
            if (env != null && SharedLibraryLoader.canWrite(root2 = Paths.get(env + "/", new String[0]), file = root2.resolve(Paths.get("Temp", new String[0]).resolve(lwjgl_version_filename)), resource2, load2)) {
                return file;
            }
        }
        try {
            file = Files.createTempDirectory("lwjgl", new FileAttribute[0]);
            root2 = file.getParent();
            file = file.resolve(filename);
            if (SharedLibraryLoader.canWrite(root2, file, resource2, load2)) {
                return file;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        throw new RuntimeException("Failed to find an appropriate directory to extract the native library");
    }

    private static FileChannel extract(Path file, URL resource2) throws IOException {
        Throwable throwable;
        InputStream source;
        if (Files.exists(file, new LinkOption[0])) {
            source = resource2.openStream();
            throwable = null;
            try (InputStream target = Files.newInputStream(file, new OpenOption[0]);){
                if (SharedLibraryLoader.crc(source) == SharedLibraryLoader.crc(target)) {
                    if (Configuration.DEBUG_LOADER.get(false).booleanValue()) {
                        APIUtil.apiLogMore("Found at: " + file);
                    }
                    FileChannel fileChannel = SharedLibraryLoader.lock(file);
                    return fileChannel;
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (source != null) {
                    if (throwable != null) {
                        try {
                            source.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        source.close();
                    }
                }
            }
        }
        APIUtil.apiLogMore("Extracting: " + resource2.getPath());
        if (extractPath == null) {
            APIUtil.apiLogMore("        to: " + file);
        }
        Files.createDirectories(file.getParent(), new FileAttribute[0]);
        source = resource2.openStream();
        throwable = null;
        try {
            Files.copy(source, file, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            if (source != null) {
                if (throwable != null) {
                    try {
                        source.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                } else {
                    source.close();
                }
            }
        }
        return SharedLibraryLoader.lock(file);
    }

    private static FileChannel lock(Path file) {
        try {
            FileChannel fc = FileChannel.open(file, new OpenOption[0]);
            if (fc.tryLock(0L, Long.MAX_VALUE, true) == null) {
                if (Configuration.DEBUG_LOADER.get(false).booleanValue()) {
                    APIUtil.apiLogMore("File is locked by another process, waiting...");
                }
                fc.lock(0L, Long.MAX_VALUE, true);
            }
            return fc;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to lock file.", e);
        }
    }

    private static long crc(InputStream input) throws IOException {
        int n;
        CRC32 crc = new CRC32();
        byte[] buffer = new byte[8192];
        while ((n = input.read(buffer)) != -1) {
            crc.update(buffer, 0, n);
        }
        return crc.getValue();
    }

    private static boolean canWrite(Path root2, Path file, URL resource2, @Nullable Consumer<String> load2) {
        Path testFile;
        if (Files.exists(file, new LinkOption[0])) {
            if (!Files.isWritable(file)) {
                return false;
            }
            testFile = file.getParent().resolve(".lwjgl.test");
        } else {
            try {
                Files.createDirectories(file.getParent(), new FileAttribute[0]);
            }
            catch (IOException ignored) {
                return false;
            }
            testFile = file;
        }
        try {
            Files.write(testFile, new byte[0], new OpenOption[0]);
            Files.delete(testFile);
            if (load2 != null && Platform.get() == Platform.WINDOWS) {
                SharedLibraryLoader.workaroundJDK8195129(file, resource2, load2);
            }
            return true;
        }
        catch (Throwable ignored) {
            if (file == testFile) {
                SharedLibraryLoader.canWriteCleanup(root2, file);
            }
            return false;
        }
    }

    private static void canWriteCleanup(Path root2, Path file) {
        try {
            Files.deleteIfExists(file);
            Path parent2 = file.getParent();
            while (!Files.isSameFile(parent2, root2)) {
                block17: {
                    try (Stream<Path> dir = Files.list(parent2);){
                        if (!dir.findAny().isPresent()) break block17;
                        break;
                    }
                }
                Files.delete(parent2);
                parent2 = parent2.getParent();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void workaroundJDK8195129(Path file, URL resource2, @Nonnull Consumer<String> load2) throws Throwable {
        String filepath = file.toAbsolutePath().toString();
        if (filepath.endsWith(".dll")) {
            boolean mustCheck = false;
            for (int i = 0; i < filepath.length(); ++i) {
                if ('\u0080' > filepath.charAt(i)) continue;
                mustCheck = true;
            }
            if (mustCheck) {
                try (FileChannel ignored = SharedLibraryLoader.extract(file, resource2);){
                    load2.accept(file.toAbsolutePath().toString());
                }
            }
            checkedJDK8195129 = true;
        }
    }

    static {
        extractPaths = new HashSet(4);
    }
}

