/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.Arrays;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.CLongBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.Configuration;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.StackWalkUtil;

public class MemoryStack
extends Pointer.Default
implements AutoCloseable {
    private static final int DEFAULT_STACK_SIZE = Configuration.STACK_SIZE.get(64) * 1024;
    private static final int DEFAULT_STACK_FRAMES = 8;
    private static final ThreadLocal<MemoryStack> TLS = ThreadLocal.withInitial(MemoryStack::create);
    @Nullable
    private final ByteBuffer container;
    private final int size;
    private int pointer;
    private int[] frames;
    protected int frameIndex;

    protected MemoryStack(@Nullable ByteBuffer container2, long address, int size2) {
        super(address);
        this.container = container2;
        this.size = size2;
        this.pointer = size2;
        this.frames = new int[8];
    }

    public static MemoryStack create() {
        return MemoryStack.create(DEFAULT_STACK_SIZE);
    }

    public static MemoryStack create(int capacity) {
        return MemoryStack.create(BufferUtils.createByteBuffer(capacity));
    }

    public static MemoryStack create(ByteBuffer buffer) {
        long address = MemoryUtil.memAddress(buffer);
        int size2 = buffer.remaining();
        return Configuration.DEBUG_STACK.get(false) != false ? new DebugMemoryStack(buffer, address, size2) : new MemoryStack(buffer, address, size2);
    }

    public static MemoryStack ncreate(long address, int size2) {
        return Configuration.DEBUG_STACK.get(false) != false ? new DebugMemoryStack(null, address, size2) : new MemoryStack(null, address, size2);
    }

    public MemoryStack push() {
        if (this.frameIndex == this.frames.length) {
            this.frameOverflow();
        }
        this.frames[this.frameIndex++] = this.pointer;
        return this;
    }

    private void frameOverflow() {
        if (Checks.DEBUG) {
            APIUtil.apiLog("[WARNING] Out of frame stack space (" + this.frames.length + ") in thread: " + Thread.currentThread());
        }
        this.frames = Arrays.copyOf(this.frames, this.frames.length * 3 / 2);
    }

    public MemoryStack pop() {
        this.pointer = this.frames[--this.frameIndex];
        return this;
    }

    @Override
    public void close() {
        this.pop();
    }

    public long getAddress() {
        return this.address;
    }

    public int getSize() {
        return this.size;
    }

    public int getFrameIndex() {
        return this.frameIndex;
    }

    public long getPointerAddress() {
        return this.address + ((long)this.pointer & 0xFFFFFFFFL);
    }

    public int getPointer() {
        return this.pointer;
    }

    public void setPointer(int pointer) {
        if (Checks.CHECKS) {
            this.checkPointer(pointer);
        }
        this.pointer = pointer;
    }

    private void checkPointer(int pointer) {
        if (pointer < 0 || this.size < pointer) {
            throw new IndexOutOfBoundsException("Invalid stack pointer");
        }
    }

    private static void checkAlignment(int alignment) {
        if (Integer.bitCount(alignment) != 1) {
            throw new IllegalArgumentException("Alignment must be a power-of-two value.");
        }
    }

    public long nmalloc(int size2) {
        return this.nmalloc(POINTER_SIZE, size2);
    }

    public long nmalloc(int alignment, int size2) {
        long address = this.address + (long)this.pointer - (long)size2 & (Integer.toUnsignedLong(alignment - 1) ^ 0xFFFFFFFFFFFFFFFFL);
        this.pointer = (int)(address - this.address);
        if (Checks.CHECKS && this.pointer < 0) {
            throw new OutOfMemoryError("Out of stack space.");
        }
        return address;
    }

    public long ncalloc(int alignment, int num, int size2) {
        int bytes = num * size2;
        long address = this.nmalloc(alignment, bytes);
        MemoryUtil.memSet(address, 0, bytes);
        return address;
    }

    public ByteBuffer malloc(int alignment, int size2) {
        if (Checks.DEBUG) {
            MemoryStack.checkAlignment(alignment);
        }
        return MemoryUtil.wrap(MemoryUtil.BUFFER_BYTE, this.nmalloc(alignment, size2), size2).order(MemoryUtil.NATIVE_ORDER);
    }

    public ByteBuffer calloc(int alignment, int size2) {
        if (Checks.DEBUG) {
            MemoryStack.checkAlignment(alignment);
        }
        return MemoryUtil.wrap(MemoryUtil.BUFFER_BYTE, this.ncalloc(alignment, size2, 1), size2).order(MemoryUtil.NATIVE_ORDER);
    }

    public ByteBuffer malloc(int size2) {
        return MemoryUtil.wrap(MemoryUtil.BUFFER_BYTE, this.nmalloc(POINTER_SIZE, size2), size2).order(MemoryUtil.NATIVE_ORDER);
    }

    public ByteBuffer calloc(int size2) {
        return MemoryUtil.wrap(MemoryUtil.BUFFER_BYTE, this.ncalloc(POINTER_SIZE, size2, 1), size2).order(MemoryUtil.NATIVE_ORDER);
    }

    public long nbyte(byte value) {
        long a = this.nmalloc(1, 1);
        MemoryUtil.memPutByte(a, value);
        return a;
    }

    public ByteBuffer bytes(byte x2) {
        return this.malloc(1, 1).put(0, x2);
    }

    public ByteBuffer bytes(byte x2, byte y2) {
        return this.malloc(1, 2).put(0, x2).put(1, y2);
    }

    public ByteBuffer bytes(byte x2, byte y2, byte z) {
        return this.malloc(1, 3).put(0, x2).put(1, y2).put(2, z);
    }

    public ByteBuffer bytes(byte x2, byte y2, byte z, byte w) {
        return this.malloc(1, 4).put(0, x2).put(1, y2).put(2, z).put(3, w);
    }

    public ByteBuffer bytes(byte ... values2) {
        ByteBuffer buffer = this.malloc(1, values2.length).put(values2);
        buffer.flip();
        return buffer;
    }

    public ShortBuffer mallocShort(int size2) {
        return MemoryUtil.wrap(MemoryUtil.BUFFER_SHORT, this.nmalloc(2, size2 << 1), size2);
    }

    public ShortBuffer callocShort(int size2) {
        int bytes = size2 * 2;
        long address = this.nmalloc(2, bytes);
        MemoryUtil.memSet(address, 0, bytes);
        return MemoryUtil.wrap(MemoryUtil.BUFFER_SHORT, address, size2);
    }

    public long nshort(short value) {
        long a = this.nmalloc(2, 2);
        MemoryUtil.memPutShort(a, value);
        return a;
    }

    public ShortBuffer shorts(short x2) {
        return this.mallocShort(1).put(0, x2);
    }

    public ShortBuffer shorts(short x2, short y2) {
        return this.mallocShort(2).put(0, x2).put(1, y2);
    }

    public ShortBuffer shorts(short x2, short y2, short z) {
        return this.mallocShort(3).put(0, x2).put(1, y2).put(2, z);
    }

    public ShortBuffer shorts(short x2, short y2, short z, short w) {
        return this.mallocShort(4).put(0, x2).put(1, y2).put(2, z).put(3, w);
    }

    public ShortBuffer shorts(short ... values2) {
        ShortBuffer buffer = this.mallocShort(values2.length).put(values2);
        buffer.flip();
        return buffer;
    }

    public IntBuffer mallocInt(int size2) {
        return MemoryUtil.wrap(MemoryUtil.BUFFER_INT, this.nmalloc(4, size2 << 2), size2);
    }

    public IntBuffer callocInt(int size2) {
        int bytes = size2 * 4;
        long address = this.nmalloc(4, bytes);
        MemoryUtil.memSet(address, 0, bytes);
        return MemoryUtil.wrap(MemoryUtil.BUFFER_INT, address, size2);
    }

    public long nint(int value) {
        long a = this.nmalloc(4, 4);
        MemoryUtil.memPutInt(a, value);
        return a;
    }

    public IntBuffer ints(int x2) {
        return this.mallocInt(1).put(0, x2);
    }

    public IntBuffer ints(int x2, int y2) {
        return this.mallocInt(2).put(0, x2).put(1, y2);
    }

    public IntBuffer ints(int x2, int y2, int z) {
        return this.mallocInt(3).put(0, x2).put(1, y2).put(2, z);
    }

    public IntBuffer ints(int x2, int y2, int z, int w) {
        return this.mallocInt(4).put(0, x2).put(1, y2).put(2, z).put(3, w);
    }

    public IntBuffer ints(int ... values2) {
        IntBuffer buffer = this.mallocInt(values2.length).put(values2);
        buffer.flip();
        return buffer;
    }

    public LongBuffer mallocLong(int size2) {
        return MemoryUtil.wrap(MemoryUtil.BUFFER_LONG, this.nmalloc(8, size2 << 3), size2);
    }

    public LongBuffer callocLong(int size2) {
        int bytes = size2 * 8;
        long address = this.nmalloc(8, bytes);
        MemoryUtil.memSet(address, 0, bytes);
        return MemoryUtil.wrap(MemoryUtil.BUFFER_LONG, address, size2);
    }

    public long nlong(long value) {
        long a = this.nmalloc(8, 8);
        MemoryUtil.memPutLong(a, value);
        return a;
    }

    public LongBuffer longs(long x2) {
        return this.mallocLong(1).put(0, x2);
    }

    public LongBuffer longs(long x2, long y2) {
        return this.mallocLong(2).put(0, x2).put(1, y2);
    }

    public LongBuffer longs(long x2, long y2, long z) {
        return this.mallocLong(3).put(0, x2).put(1, y2).put(2, z);
    }

    public LongBuffer longs(long x2, long y2, long z, long w) {
        return this.mallocLong(4).put(0, x2).put(1, y2).put(2, z).put(3, w);
    }

    public LongBuffer longs(long ... more) {
        LongBuffer buffer = this.mallocLong(more.length).put(more);
        buffer.flip();
        return buffer;
    }

    public CLongBuffer mallocCLong(int size2) {
        return MemoryStack.wrap(CLongBuffer.class, this.nmalloc(CLONG_SIZE, size2 << CLONG_SHIFT), size2);
    }

    public CLongBuffer callocCLong(int size2) {
        int bytes = size2 * CLONG_SIZE;
        long address = this.nmalloc(CLONG_SIZE, bytes);
        MemoryUtil.memSet(address, 0, bytes);
        return MemoryStack.wrap(CLongBuffer.class, address, size2);
    }

    public long nclong(long value) {
        long a = this.nmalloc(CLONG_SIZE, CLONG_SIZE);
        MemoryUtil.memPutCLong(a, value);
        return a;
    }

    public CLongBuffer clongs(long x2) {
        return this.mallocCLong(1).put(0, x2);
    }

    public CLongBuffer clongs(long x2, long y2) {
        return this.mallocCLong(2).put(0, x2).put(1, y2);
    }

    public CLongBuffer clongs(long x2, long y2, long z) {
        return this.mallocCLong(3).put(0, x2).put(1, y2).put(2, z);
    }

    public CLongBuffer clongs(long x2, long y2, long z, long w) {
        return this.mallocCLong(4).put(0, x2).put(1, y2).put(2, z).put(3, w);
    }

    public CLongBuffer clongs(long ... values2) {
        CLongBuffer buffer = this.mallocCLong(values2.length).put(values2);
        buffer.flip();
        return buffer;
    }

    public FloatBuffer mallocFloat(int size2) {
        return MemoryUtil.wrap(MemoryUtil.BUFFER_FLOAT, this.nmalloc(4, size2 << 2), size2);
    }

    public FloatBuffer callocFloat(int size2) {
        int bytes = size2 * 4;
        long address = this.nmalloc(4, bytes);
        MemoryUtil.memSet(address, 0, bytes);
        return MemoryUtil.wrap(MemoryUtil.BUFFER_FLOAT, address, size2);
    }

    public long nfloat(float value) {
        long a = this.nmalloc(4, 4);
        MemoryUtil.memPutFloat(a, value);
        return a;
    }

    public FloatBuffer floats(float x2) {
        return this.mallocFloat(1).put(0, x2);
    }

    public FloatBuffer floats(float x2, float y2) {
        return this.mallocFloat(2).put(0, x2).put(1, y2);
    }

    public FloatBuffer floats(float x2, float y2, float z) {
        return this.mallocFloat(3).put(0, x2).put(1, y2).put(2, z);
    }

    public FloatBuffer floats(float x2, float y2, float z, float w) {
        return this.mallocFloat(4).put(0, x2).put(1, y2).put(2, z).put(3, w);
    }

    public FloatBuffer floats(float ... values2) {
        FloatBuffer buffer = this.mallocFloat(values2.length).put(values2);
        buffer.flip();
        return buffer;
    }

    public DoubleBuffer mallocDouble(int size2) {
        return MemoryUtil.wrap(MemoryUtil.BUFFER_DOUBLE, this.nmalloc(8, size2 << 3), size2);
    }

    public DoubleBuffer callocDouble(int size2) {
        int bytes = size2 * 8;
        long address = this.nmalloc(8, bytes);
        MemoryUtil.memSet(address, 0, bytes);
        return MemoryUtil.wrap(MemoryUtil.BUFFER_DOUBLE, address, size2);
    }

    public long ndouble(double value) {
        long a = this.nmalloc(8, 8);
        MemoryUtil.memPutDouble(a, value);
        return a;
    }

    public DoubleBuffer doubles(double x2) {
        return this.mallocDouble(1).put(0, x2);
    }

    public DoubleBuffer doubles(double x2, double y2) {
        return this.mallocDouble(2).put(0, x2).put(1, y2);
    }

    public DoubleBuffer doubles(double x2, double y2, double z) {
        return this.mallocDouble(3).put(0, x2).put(1, y2).put(2, z);
    }

    public DoubleBuffer doubles(double x2, double y2, double z, double w) {
        return this.mallocDouble(4).put(0, x2).put(1, y2).put(2, z).put(3, w);
    }

    public DoubleBuffer doubles(double ... values2) {
        DoubleBuffer buffer = this.mallocDouble(values2.length).put(values2);
        buffer.flip();
        return buffer;
    }

    public PointerBuffer mallocPointer(int size2) {
        return MemoryStack.wrap(PointerBuffer.class, this.nmalloc(POINTER_SIZE, size2 << POINTER_SHIFT), size2);
    }

    public PointerBuffer callocPointer(int size2) {
        int bytes = size2 * POINTER_SIZE;
        long address = this.nmalloc(POINTER_SIZE, bytes);
        MemoryUtil.memSet(address, 0, bytes);
        return MemoryStack.wrap(PointerBuffer.class, address, size2);
    }

    public long npointer(long value) {
        long a = this.nmalloc(POINTER_SIZE, POINTER_SIZE);
        MemoryUtil.memPutAddress(a, value);
        return a;
    }

    public PointerBuffer pointers(long x2) {
        return this.mallocPointer(1).put(0, x2);
    }

    public PointerBuffer pointers(long x2, long y2) {
        return this.mallocPointer(2).put(0, x2).put(1, y2);
    }

    public PointerBuffer pointers(long x2, long y2, long z) {
        return this.mallocPointer(3).put(0, x2).put(1, y2).put(2, z);
    }

    public PointerBuffer pointers(long x2, long y2, long z, long w) {
        return this.mallocPointer(4).put(0, x2).put(1, y2).put(2, z).put(3, w);
    }

    public PointerBuffer pointers(long ... values2) {
        PointerBuffer buffer = this.mallocPointer(values2.length).put(values2);
        buffer.flip();
        return buffer;
    }

    public long npointer(Pointer value) {
        long a = this.nmalloc(POINTER_SIZE, POINTER_SIZE);
        MemoryUtil.memPutAddress(a, value.address());
        return a;
    }

    public PointerBuffer pointers(Pointer x2) {
        return this.mallocPointer(1).put(0, x2);
    }

    public PointerBuffer pointers(Pointer x2, Pointer y2) {
        return this.mallocPointer(2).put(0, x2).put(1, y2);
    }

    public PointerBuffer pointers(Pointer x2, Pointer y2, Pointer z) {
        return this.mallocPointer(3).put(0, x2).put(1, y2).put(2, z);
    }

    public PointerBuffer pointers(Pointer x2, Pointer y2, Pointer z, Pointer w) {
        return this.mallocPointer(4).put(0, x2).put(1, y2).put(2, z).put(3, w);
    }

    public PointerBuffer pointers(Pointer ... values2) {
        PointerBuffer buffer = this.mallocPointer(values2.length);
        for (int i = 0; i < values2.length; ++i) {
            buffer.put(i, values2[i]);
        }
        return buffer;
    }

    public long npointer(Buffer value) {
        long a = this.nmalloc(POINTER_SIZE, POINTER_SIZE);
        MemoryUtil.memPutAddress(a, MemoryUtil.memAddress(value));
        return a;
    }

    public PointerBuffer pointers(Buffer x2) {
        return this.mallocPointer(1).put(0, MemoryUtil.memAddress(x2));
    }

    public PointerBuffer pointers(Buffer x2, Buffer y2) {
        return this.mallocPointer(2).put(0, MemoryUtil.memAddress(x2)).put(1, MemoryUtil.memAddress(y2));
    }

    public PointerBuffer pointers(Buffer x2, Buffer y2, Buffer z) {
        return this.mallocPointer(3).put(0, MemoryUtil.memAddress(x2)).put(1, MemoryUtil.memAddress(y2)).put(2, MemoryUtil.memAddress(z));
    }

    public PointerBuffer pointers(Buffer x2, Buffer y2, Buffer z, Buffer w) {
        return this.mallocPointer(4).put(0, MemoryUtil.memAddress(x2)).put(1, MemoryUtil.memAddress(y2)).put(2, MemoryUtil.memAddress(z)).put(3, MemoryUtil.memAddress(w));
    }

    public PointerBuffer pointers(Buffer ... values2) {
        PointerBuffer buffer = this.mallocPointer(values2.length);
        for (int i = 0; i < values2.length; ++i) {
            buffer.put(i, MemoryUtil.memAddress(values2[i]));
        }
        return buffer;
    }

    public PointerBuffer pointersOfElements(CustomBuffer<?> buffer) {
        int remaining = buffer.remaining();
        long addr = buffer.address();
        long sizeof = buffer.sizeof();
        PointerBuffer pointerBuffer = this.mallocPointer(remaining);
        for (int i = 0; i < remaining; ++i) {
            pointerBuffer.put(i, addr + sizeof * (long)i);
        }
        return pointerBuffer;
    }

    public ByteBuffer ASCII(CharSequence text2) {
        return this.ASCII(text2, true);
    }

    public ByteBuffer ASCII(CharSequence text2, boolean nullTerminated) {
        int length = MemoryUtil.memLengthASCII(text2, nullTerminated);
        long target = this.nmalloc(POINTER_SIZE, length);
        MemoryUtil.encodeASCIIUnsafe(text2, nullTerminated, target);
        return MemoryUtil.wrap(MemoryUtil.BUFFER_BYTE, target, length).order(MemoryUtil.NATIVE_ORDER);
    }

    public int nASCII(CharSequence text2, boolean nullTerminated) {
        long target = this.nmalloc(POINTER_SIZE, MemoryUtil.memLengthASCII(text2, nullTerminated));
        return MemoryUtil.encodeASCIIUnsafe(text2, nullTerminated, target);
    }

    @Nullable
    public ByteBuffer ASCIISafe(@Nullable CharSequence text2) {
        return this.ASCIISafe(text2, true);
    }

    @Nullable
    public ByteBuffer ASCIISafe(@Nullable CharSequence text2, boolean nullTerminated) {
        return text2 == null ? null : this.ASCII(text2, nullTerminated);
    }

    public int nASCIISafe(@Nullable CharSequence text2, boolean nullTerminated) {
        return text2 == null ? 0 : this.nASCII(text2, nullTerminated);
    }

    public ByteBuffer UTF8(CharSequence text2) {
        return this.UTF8(text2, true);
    }

    public ByteBuffer UTF8(CharSequence text2, boolean nullTerminated) {
        int length = MemoryUtil.memLengthUTF8(text2, nullTerminated);
        long target = this.nmalloc(POINTER_SIZE, length);
        MemoryUtil.encodeUTF8Unsafe(text2, nullTerminated, target);
        return MemoryUtil.wrap(MemoryUtil.BUFFER_BYTE, target, length).order(MemoryUtil.NATIVE_ORDER);
    }

    public int nUTF8(CharSequence text2, boolean nullTerminated) {
        long target = this.nmalloc(POINTER_SIZE, MemoryUtil.memLengthUTF8(text2, nullTerminated));
        return MemoryUtil.encodeUTF8Unsafe(text2, nullTerminated, target);
    }

    @Nullable
    public ByteBuffer UTF8Safe(@Nullable CharSequence text2) {
        return this.UTF8Safe(text2, true);
    }

    @Nullable
    public ByteBuffer UTF8Safe(@Nullable CharSequence text2, boolean nullTerminated) {
        return text2 == null ? null : this.UTF8(text2, nullTerminated);
    }

    public int nUTF8Safe(@Nullable CharSequence text2, boolean nullTerminated) {
        return text2 == null ? 0 : this.nUTF8(text2, nullTerminated);
    }

    public ByteBuffer UTF16(CharSequence text2) {
        return this.UTF16(text2, true);
    }

    public ByteBuffer UTF16(CharSequence text2, boolean nullTerminated) {
        int length = MemoryUtil.memLengthUTF16(text2, nullTerminated);
        long target = this.nmalloc(POINTER_SIZE, length);
        MemoryUtil.encodeUTF16Unsafe(text2, nullTerminated, target);
        return MemoryUtil.wrap(MemoryUtil.BUFFER_BYTE, target, length).order(MemoryUtil.NATIVE_ORDER);
    }

    public int nUTF16(CharSequence text2, boolean nullTerminated) {
        long target = this.nmalloc(POINTER_SIZE, MemoryUtil.memLengthUTF16(text2, nullTerminated));
        return MemoryUtil.encodeUTF16Unsafe(text2, nullTerminated, target);
    }

    @Nullable
    public ByteBuffer UTF16Safe(@Nullable CharSequence text2) {
        return this.UTF16Safe(text2, true);
    }

    @Nullable
    public ByteBuffer UTF16Safe(@Nullable CharSequence text2, boolean nullTerminated) {
        return text2 == null ? null : this.UTF16(text2, nullTerminated);
    }

    public int nUTF16Safe(@Nullable CharSequence text2, boolean nullTerminated) {
        return text2 == null ? 0 : this.nUTF16(text2, nullTerminated);
    }

    public static MemoryStack stackGet() {
        return TLS.get();
    }

    public static MemoryStack stackPush() {
        return MemoryStack.stackGet().push();
    }

    public static MemoryStack stackPop() {
        return MemoryStack.stackGet().pop();
    }

    public static long nstackMalloc(int size2) {
        return MemoryStack.stackGet().nmalloc(size2);
    }

    public static long nstackMalloc(int alignment, int size2) {
        return MemoryStack.stackGet().nmalloc(alignment, size2);
    }

    public static long nstackCalloc(int alignment, int num, int size2) {
        return MemoryStack.stackGet().ncalloc(alignment, num, size2);
    }

    public static ByteBuffer stackMalloc(int size2) {
        return MemoryStack.stackGet().malloc(size2);
    }

    public static ByteBuffer stackCalloc(int size2) {
        return MemoryStack.stackGet().calloc(size2);
    }

    public static ByteBuffer stackBytes(byte x2) {
        return MemoryStack.stackGet().bytes(x2);
    }

    public static ByteBuffer stackBytes(byte x2, byte y2) {
        return MemoryStack.stackGet().bytes(x2, y2);
    }

    public static ByteBuffer stackBytes(byte x2, byte y2, byte z) {
        return MemoryStack.stackGet().bytes(x2, y2, z);
    }

    public static ByteBuffer stackBytes(byte x2, byte y2, byte z, byte w) {
        return MemoryStack.stackGet().bytes(x2, y2, z, w);
    }

    public static ByteBuffer stackBytes(byte ... values2) {
        return MemoryStack.stackGet().bytes(values2);
    }

    public static ShortBuffer stackMallocShort(int size2) {
        return MemoryStack.stackGet().mallocShort(size2);
    }

    public static ShortBuffer stackCallocShort(int size2) {
        return MemoryStack.stackGet().callocShort(size2);
    }

    public static ShortBuffer stackShorts(short x2) {
        return MemoryStack.stackGet().shorts(x2);
    }

    public static ShortBuffer stackShorts(short x2, short y2) {
        return MemoryStack.stackGet().shorts(x2, y2);
    }

    public static ShortBuffer stackShorts(short x2, short y2, short z) {
        return MemoryStack.stackGet().shorts(x2, y2, z);
    }

    public static ShortBuffer stackShorts(short x2, short y2, short z, short w) {
        return MemoryStack.stackGet().shorts(x2, y2, z, w);
    }

    public static ShortBuffer stackShorts(short ... values2) {
        return MemoryStack.stackGet().shorts(values2);
    }

    public static IntBuffer stackMallocInt(int size2) {
        return MemoryStack.stackGet().mallocInt(size2);
    }

    public static IntBuffer stackCallocInt(int size2) {
        return MemoryStack.stackGet().callocInt(size2);
    }

    public static IntBuffer stackInts(int x2) {
        return MemoryStack.stackGet().ints(x2);
    }

    public static IntBuffer stackInts(int x2, int y2) {
        return MemoryStack.stackGet().ints(x2, y2);
    }

    public static IntBuffer stackInts(int x2, int y2, int z) {
        return MemoryStack.stackGet().ints(x2, y2, z);
    }

    public static IntBuffer stackInts(int x2, int y2, int z, int w) {
        return MemoryStack.stackGet().ints(x2, y2, z, w);
    }

    public static IntBuffer stackInts(int ... values2) {
        return MemoryStack.stackGet().ints(values2);
    }

    public static LongBuffer stackMallocLong(int size2) {
        return MemoryStack.stackGet().mallocLong(size2);
    }

    public static LongBuffer stackCallocLong(int size2) {
        return MemoryStack.stackGet().callocLong(size2);
    }

    public static LongBuffer stackLongs(long x2) {
        return MemoryStack.stackGet().longs(x2);
    }

    public static LongBuffer stackLongs(long x2, long y2) {
        return MemoryStack.stackGet().longs(x2, y2);
    }

    public static LongBuffer stackLongs(long x2, long y2, long z) {
        return MemoryStack.stackGet().longs(x2, y2, z);
    }

    public static LongBuffer stackLongs(long x2, long y2, long z, long w) {
        return MemoryStack.stackGet().longs(x2, y2, z, w);
    }

    public static LongBuffer stackLongs(long ... values2) {
        return MemoryStack.stackGet().longs(values2);
    }

    public static CLongBuffer stackMallocCLong(int size2) {
        return MemoryStack.stackGet().mallocCLong(size2);
    }

    public static CLongBuffer stackCallocCLong(int size2) {
        return MemoryStack.stackGet().callocCLong(size2);
    }

    public static CLongBuffer stackCLongs(long x2) {
        return MemoryStack.stackGet().clongs(x2);
    }

    public static CLongBuffer stackCLongs(long x2, long y2) {
        return MemoryStack.stackGet().clongs(x2, y2);
    }

    public static CLongBuffer stackCLongs(long x2, long y2, long z) {
        return MemoryStack.stackGet().clongs(x2, y2, z);
    }

    public static CLongBuffer stackCLongs(long x2, long y2, long z, long w) {
        return MemoryStack.stackGet().clongs(x2, y2, z, w);
    }

    public static CLongBuffer stackCLongs(long ... values2) {
        return MemoryStack.stackGet().clongs(values2);
    }

    public static FloatBuffer stackMallocFloat(int size2) {
        return MemoryStack.stackGet().mallocFloat(size2);
    }

    public static FloatBuffer stackCallocFloat(int size2) {
        return MemoryStack.stackGet().callocFloat(size2);
    }

    public static FloatBuffer stackFloats(float x2) {
        return MemoryStack.stackGet().floats(x2);
    }

    public static FloatBuffer stackFloats(float x2, float y2) {
        return MemoryStack.stackGet().floats(x2, y2);
    }

    public static FloatBuffer stackFloats(float x2, float y2, float z) {
        return MemoryStack.stackGet().floats(x2, y2, z);
    }

    public static FloatBuffer stackFloats(float x2, float y2, float z, float w) {
        return MemoryStack.stackGet().floats(x2, y2, z, w);
    }

    public static FloatBuffer stackFloats(float ... values2) {
        return MemoryStack.stackGet().floats(values2);
    }

    public static DoubleBuffer stackMallocDouble(int size2) {
        return MemoryStack.stackGet().mallocDouble(size2);
    }

    public static DoubleBuffer stackCallocDouble(int size2) {
        return MemoryStack.stackGet().callocDouble(size2);
    }

    public static DoubleBuffer stackDoubles(double x2) {
        return MemoryStack.stackGet().doubles(x2);
    }

    public static DoubleBuffer stackDoubles(double x2, double y2) {
        return MemoryStack.stackGet().doubles(x2, y2);
    }

    public static DoubleBuffer stackDoubles(double x2, double y2, double z) {
        return MemoryStack.stackGet().doubles(x2, y2, z);
    }

    public static DoubleBuffer stackDoubles(double x2, double y2, double z, double w) {
        return MemoryStack.stackGet().doubles(x2, y2, z, w);
    }

    public static DoubleBuffer stackDoubles(double ... values2) {
        return MemoryStack.stackGet().doubles(values2);
    }

    public static PointerBuffer stackMallocPointer(int size2) {
        return MemoryStack.stackGet().mallocPointer(size2);
    }

    public static PointerBuffer stackCallocPointer(int size2) {
        return MemoryStack.stackGet().callocPointer(size2);
    }

    public static PointerBuffer stackPointers(long x2) {
        return MemoryStack.stackGet().pointers(x2);
    }

    public static PointerBuffer stackPointers(long x2, long y2) {
        return MemoryStack.stackGet().pointers(x2, y2);
    }

    public static PointerBuffer stackPointers(long x2, long y2, long z) {
        return MemoryStack.stackGet().pointers(x2, y2, z);
    }

    public static PointerBuffer stackPointers(long x2, long y2, long z, long w) {
        return MemoryStack.stackGet().pointers(x2, y2, z, w);
    }

    public static PointerBuffer stackPointers(long ... values2) {
        return MemoryStack.stackGet().pointers(values2);
    }

    public static PointerBuffer stackPointers(Pointer x2) {
        return MemoryStack.stackGet().pointers(x2);
    }

    public static PointerBuffer stackPointers(Pointer x2, Pointer y2) {
        return MemoryStack.stackGet().pointers(x2, y2);
    }

    public static PointerBuffer stackPointers(Pointer x2, Pointer y2, Pointer z) {
        return MemoryStack.stackGet().pointers(x2, y2, z);
    }

    public static PointerBuffer stackPointers(Pointer x2, Pointer y2, Pointer z, Pointer w) {
        return MemoryStack.stackGet().pointers(x2, y2, z, w);
    }

    public static PointerBuffer stackPointers(Pointer ... values2) {
        return MemoryStack.stackGet().pointers(values2);
    }

    public static ByteBuffer stackASCII(CharSequence text2) {
        return MemoryStack.stackGet().ASCII(text2);
    }

    public static ByteBuffer stackASCII(CharSequence text2, boolean nullTerminated) {
        return MemoryStack.stackGet().ASCII(text2, nullTerminated);
    }

    public static ByteBuffer stackUTF8(CharSequence text2) {
        return MemoryStack.stackGet().UTF8(text2);
    }

    public static ByteBuffer stackUTF8(CharSequence text2, boolean nullTerminated) {
        return MemoryStack.stackGet().UTF8(text2, nullTerminated);
    }

    public static ByteBuffer stackUTF16(CharSequence text2) {
        return MemoryStack.stackGet().UTF16(text2);
    }

    public static ByteBuffer stackUTF16(CharSequence text2, boolean nullTerminated) {
        return MemoryStack.stackGet().UTF16(text2, nullTerminated);
    }

    @Nullable
    public static ByteBuffer stackASCIISafe(@Nullable CharSequence text2) {
        return MemoryStack.stackGet().ASCIISafe(text2);
    }

    @Nullable
    public static ByteBuffer stackASCIISafe(@Nullable CharSequence text2, boolean nullTerminated) {
        return MemoryStack.stackGet().ASCIISafe(text2, nullTerminated);
    }

    @Nullable
    public static ByteBuffer stackUTF8Safe(@Nullable CharSequence text2) {
        return MemoryStack.stackGet().UTF8Safe(text2);
    }

    @Nullable
    public static ByteBuffer stackUTF8Safe(@Nullable CharSequence text2, boolean nullTerminated) {
        return MemoryStack.stackGet().UTF8Safe(text2, nullTerminated);
    }

    @Nullable
    public static ByteBuffer stackUTF16Safe(@Nullable CharSequence text2) {
        return MemoryStack.stackGet().UTF16Safe(text2);
    }

    @Nullable
    public static ByteBuffer stackUTF16Safe(@Nullable CharSequence text2, boolean nullTerminated) {
        return MemoryStack.stackGet().UTF16Safe(text2, nullTerminated);
    }

    static {
        if (DEFAULT_STACK_SIZE < 0) {
            throw new IllegalStateException("Invalid stack size.");
        }
    }

    private static class DebugMemoryStack
    extends MemoryStack {
        private Object[] debugFrames = new Object[8];

        DebugMemoryStack(@Nullable ByteBuffer buffer, long address, int size2) {
            super(buffer, address, size2);
        }

        @Override
        public MemoryStack push() {
            if (this.frameIndex == this.debugFrames.length) {
                this.frameOverflow();
            }
            this.debugFrames[this.frameIndex] = StackWalkUtil.stackWalkGetMethod(MemoryStack.class);
            return super.push();
        }

        @Override
        private void frameOverflow() {
            this.debugFrames = Arrays.copyOf(this.debugFrames, this.debugFrames.length * 3 / 2);
        }

        @Override
        public MemoryStack pop() {
            Object pushed = this.debugFrames[this.frameIndex - 1];
            Object popped = StackWalkUtil.stackWalkCheckPop(MemoryStack.class, pushed);
            if (popped != null) {
                DebugMemoryStack.reportAsymmetricPop(pushed, popped);
            }
            this.debugFrames[this.frameIndex - 1] = null;
            return super.pop();
        }

        @Override
        public void close() {
            this.debugFrames[this.frameIndex - 1] = null;
            super.pop();
        }

        private static void reportAsymmetricPop(Object pushed, Object popped) {
            APIUtil.DEBUG_STREAM.format("[LWJGL] Asymmetric pop detected:\n\tPUSHED: %s\n\tPOPPED: %s\n\tTHREAD: %s\n", pushed, popped, Thread.currentThread());
        }
    }
}

