/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opencl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import javax.annotation.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opencl.CL;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;

public class KHRSemaphore {
    public static final int CL_PLATFORM_SEMAPHORE_TYPES_KHR = 8246;
    public static final int CL_DEVICE_SEMAPHORE_TYPES_KHR = 8268;
    public static final int CL_SEMAPHORE_TYPE_BINARY_KHR = 1;
    public static final int CL_SEMAPHORE_CONTEXT_KHR = 8249;
    public static final int CL_SEMAPHORE_REFERENCE_COUNT_KHR = 8250;
    public static final int CL_SEMAPHORE_PROPERTIES_KHR = 8251;
    public static final int CL_SEMAPHORE_PAYLOAD_KHR = 8252;
    public static final int CL_SEMAPHORE_TYPE_KHR = 8253;
    public static final int CL_DEVICE_HANDLE_LIST_KHR = 8273;
    public static final int CL_DEVICE_HANDLE_LIST_END_KHR = 0;
    public static final int CL_COMMAND_SEMAPHORE_WAIT_KHR = 8258;
    public static final int CL_COMMAND_SEMAPHORE_SIGNAL_KHR = 8259;
    public static final int CL_INVALID_SEMAPHORE_KHR = -1142;

    protected KHRSemaphore() {
        throw new UnsupportedOperationException();
    }

    public static long nclCreateSemaphoreWithPropertiesKHR(long context2, long sema_props, long errcode_ret) {
        long __functionAddress = CL.getICD().clCreateSemaphoreWithPropertiesKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(context2);
        }
        return JNI.callPPPP(context2, sema_props, errcode_ret, __functionAddress);
    }

    @NativeType(value="cl_semaphore_khr")
    public static long clCreateSemaphoreWithPropertiesKHR(@NativeType(value="cl_context") long context2, @NativeType(value="cl_semaphore_properties_khr const *") LongBuffer sema_props, @Nullable @NativeType(value="cl_int *") IntBuffer errcode_ret) {
        if (Checks.CHECKS) {
            Checks.checkNT(sema_props);
            Checks.checkSafe((Buffer)errcode_ret, 1);
        }
        return KHRSemaphore.nclCreateSemaphoreWithPropertiesKHR(context2, MemoryUtil.memAddress(sema_props), MemoryUtil.memAddressSafe(errcode_ret));
    }

    public static int nclEnqueueWaitSemaphoresKHR(long command_queue, int num_sema_objects, long sema_objects, long sema_payload_list, int num_events_in_wait_list, long event_wait_list, long event) {
        long __functionAddress = CL.getICD().clEnqueueWaitSemaphoresKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(command_queue);
        }
        return JNI.callPPPPPI(command_queue, num_sema_objects, sema_objects, sema_payload_list, num_events_in_wait_list, event_wait_list, event, __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clEnqueueWaitSemaphoresKHR(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_semaphore_khr const *") PointerBuffer sema_objects, @Nullable @NativeType(value="cl_semaphore_payload_khr const *") LongBuffer sema_payload_list, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.checkSafe(event, 1);
        }
        return KHRSemaphore.nclEnqueueWaitSemaphoresKHR(command_queue, sema_objects.remaining(), MemoryUtil.memAddress(sema_objects), MemoryUtil.memAddressSafe(sema_payload_list), Checks.remainingSafe(event_wait_list), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static int nclEnqueueSignalSemaphoresKHR(long command_queue, int num_sema_objects, long sema_objects, long sema_payload_list, int num_events_in_wait_list, long event_wait_list, long event) {
        long __functionAddress = CL.getICD().clEnqueueSignalSemaphoresKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(command_queue);
        }
        return JNI.callPPPPPI(command_queue, num_sema_objects, sema_objects, sema_payload_list, num_events_in_wait_list, event_wait_list, event, __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clEnqueueSignalSemaphoresKHR(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_semaphore_khr const *") PointerBuffer sema_objects, @NativeType(value="cl_semaphore_payload_khr const *") LongBuffer sema_payload_list, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.checkSafe(event, 1);
        }
        return KHRSemaphore.nclEnqueueSignalSemaphoresKHR(command_queue, sema_objects.remaining(), MemoryUtil.memAddress(sema_objects), MemoryUtil.memAddress(sema_payload_list), Checks.remainingSafe(event_wait_list), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static int nclGetSemaphoreInfoKHR(long sema_object, int param_name, long param_value_size, long param_value, long param_value_size_ret) {
        long __functionAddress = CL.getICD().clGetSemaphoreInfoKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(sema_object);
        }
        return JNI.callPPPPI(sema_object, param_name, param_value_size, param_value, param_value_size_ret, __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clGetSemaphoreInfoKHR(@NativeType(value="cl_semaphore_khr") long sema_object, @NativeType(value="cl_semaphore_info_khr") int param_name, @Nullable @NativeType(value="void *") ByteBuffer param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe(param_value_size_ret, 1);
        }
        return KHRSemaphore.nclGetSemaphoreInfoKHR(sema_object, param_name, Checks.remainingSafe(param_value), MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    @NativeType(value="cl_int")
    public static int clGetSemaphoreInfoKHR(@NativeType(value="cl_semaphore_khr") long sema_object, @NativeType(value="cl_semaphore_info_khr") int param_name, @Nullable @NativeType(value="void *") IntBuffer param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe(param_value_size_ret, 1);
        }
        return KHRSemaphore.nclGetSemaphoreInfoKHR(sema_object, param_name, Integer.toUnsignedLong(Checks.remainingSafe(param_value)) << 2, MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    @NativeType(value="cl_int")
    public static int clGetSemaphoreInfoKHR(@NativeType(value="cl_semaphore_khr") long sema_object, @NativeType(value="cl_semaphore_info_khr") int param_name, @Nullable @NativeType(value="void *") PointerBuffer param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe(param_value_size_ret, 1);
        }
        return KHRSemaphore.nclGetSemaphoreInfoKHR(sema_object, param_name, Integer.toUnsignedLong(Checks.remainingSafe(param_value)) << Pointer.POINTER_SHIFT, MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    @NativeType(value="cl_int")
    public static int clReleaseSemaphoreKHR(@NativeType(value="cl_semaphore_khr") long sema_object) {
        long __functionAddress = CL.getICD().clReleaseSemaphoreKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(sema_object);
        }
        return JNI.callPI(sema_object, __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clRetainSemaphoreKHR(@NativeType(value="cl_semaphore_khr") long sema_object) {
        long __functionAddress = CL.getICD().clRetainSemaphoreKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(sema_object);
        }
        return JNI.callPI(sema_object, __functionAddress);
    }

    @NativeType(value="cl_semaphore_khr")
    public static long clCreateSemaphoreWithPropertiesKHR(@NativeType(value="cl_context") long context2, @NativeType(value="cl_semaphore_properties_khr const *") long[] sema_props, @Nullable @NativeType(value="cl_int *") int[] errcode_ret) {
        long __functionAddress = CL.getICD().clCreateSemaphoreWithPropertiesKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(context2);
            Checks.checkNT(sema_props);
            Checks.checkSafe(errcode_ret, 1);
        }
        return JNI.callPPPP(context2, sema_props, errcode_ret, __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clEnqueueWaitSemaphoresKHR(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_semaphore_khr const *") PointerBuffer sema_objects, @Nullable @NativeType(value="cl_semaphore_payload_khr const *") long[] sema_payload_list, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        long __functionAddress = CL.getICD().clEnqueueWaitSemaphoresKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(command_queue);
            Checks.checkSafe(event, 1);
        }
        return JNI.callPPPPPI(command_queue, sema_objects.remaining(), MemoryUtil.memAddress(sema_objects), sema_payload_list, Checks.remainingSafe(event_wait_list), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event), __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clEnqueueSignalSemaphoresKHR(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_semaphore_khr const *") PointerBuffer sema_objects, @NativeType(value="cl_semaphore_payload_khr const *") long[] sema_payload_list, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        long __functionAddress = CL.getICD().clEnqueueSignalSemaphoresKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(command_queue);
            Checks.checkSafe(event, 1);
        }
        return JNI.callPPPPPI(command_queue, sema_objects.remaining(), MemoryUtil.memAddress(sema_objects), sema_payload_list, Checks.remainingSafe(event_wait_list), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event), __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clGetSemaphoreInfoKHR(@NativeType(value="cl_semaphore_khr") long sema_object, @NativeType(value="cl_semaphore_info_khr") int param_name, @Nullable @NativeType(value="void *") int[] param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        long __functionAddress = CL.getICD().clGetSemaphoreInfoKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(sema_object);
            Checks.checkSafe(param_value_size_ret, 1);
        }
        return JNI.callPPPPI(sema_object, param_name, Integer.toUnsignedLong(Checks.lengthSafe(param_value)) << 2, param_value, MemoryUtil.memAddressSafe(param_value_size_ret), __functionAddress);
    }
}

