/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opencl;

import java.nio.Buffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opencl.CL;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class KHREGLImage {
    public static final int CL_EGL_RESOURCE_NOT_ACQUIRED_KHR = -1092;
    public static final int CL_INVALID_EGL_OBJECT_KHR = -1093;
    public static final int CL_COMMAND_ACQUIRE_EGL_OBJECTS_KHR = 8237;
    public static final int CL_COMMAND_RELEASE_EGL_OBJECTS_KHR = 8238;

    protected KHREGLImage() {
        throw new UnsupportedOperationException();
    }

    public static long nclCreateFromEGLImageKHR(long context2, long display, long image, long flags, long properties2, long errcode_ret) {
        long __functionAddress = CL.getICD().clCreateFromEGLImageKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(context2);
            Checks.check(display);
            Checks.check(image);
        }
        return JNI.callPPPJPPP(context2, display, image, flags, properties2, errcode_ret, __functionAddress);
    }

    @NativeType(value="cl_mem")
    public static long clCreateFromEGLImageKHR(@NativeType(value="cl_context") long context2, @NativeType(value="CLeglDisplayKHR") long display, @NativeType(value="CLeglImageKHR") long image, @NativeType(value="cl_mem_flags") long flags, @Nullable @NativeType(value="cl_egl_image_properties_khr const *") PointerBuffer properties2, @Nullable @NativeType(value="cl_int *") IntBuffer errcode_ret) {
        if (Checks.CHECKS) {
            Checks.checkNTSafe(properties2);
            Checks.checkSafe((Buffer)errcode_ret, 1);
        }
        return KHREGLImage.nclCreateFromEGLImageKHR(context2, display, image, flags, MemoryUtil.memAddressSafe(properties2), MemoryUtil.memAddressSafe(errcode_ret));
    }

    public static int nclEnqueueAcquireEGLObjectsKHR(long command_queue, int num_objects, long mem_objects, int num_events_in_wait_list, long event_wait_list, long event) {
        long __functionAddress = CL.getICD().clEnqueueAcquireEGLObjectsKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(command_queue);
        }
        return JNI.callPPPPI(command_queue, num_objects, mem_objects, num_events_in_wait_list, event_wait_list, event, __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clEnqueueAcquireEGLObjectsKHR(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem const *") PointerBuffer mem_objects, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.checkSafe(event, 1);
        }
        return KHREGLImage.nclEnqueueAcquireEGLObjectsKHR(command_queue, mem_objects.remaining(), MemoryUtil.memAddress(mem_objects), Checks.remainingSafe(event_wait_list), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static int nclEnqueueReleaseEGLObjectsKHR(long command_queue, int num_objects, long mem_objects, int num_events_in_wait_list, long event_wait_list, long event) {
        long __functionAddress = CL.getICD().clEnqueueReleaseEGLObjectsKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(command_queue);
        }
        return JNI.callPPPPI(command_queue, num_objects, mem_objects, num_events_in_wait_list, event_wait_list, event, __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clEnqueueReleaseEGLObjectsKHR(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem const *") PointerBuffer mem_objects, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.checkSafe(event, 1);
        }
        return KHREGLImage.nclEnqueueReleaseEGLObjectsKHR(command_queue, mem_objects.remaining(), MemoryUtil.memAddress(mem_objects), Checks.remainingSafe(event_wait_list), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="cl_int")
    public static int clEnqueueReleaseEGLObjectsKHR(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem const *") long mem_object, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.checkSafe(event, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            PointerBuffer mem_objects = stack.pointers(mem_object);
            int n = KHREGLImage.nclEnqueueReleaseEGLObjectsKHR(command_queue, 1, MemoryUtil.memAddress(mem_objects), Checks.remainingSafe(event_wait_list), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="cl_mem")
    public static long clCreateFromEGLImageKHR(@NativeType(value="cl_context") long context2, @NativeType(value="CLeglDisplayKHR") long display, @NativeType(value="CLeglImageKHR") long image, @NativeType(value="cl_mem_flags") long flags, @Nullable @NativeType(value="cl_egl_image_properties_khr const *") PointerBuffer properties2, @Nullable @NativeType(value="cl_int *") int[] errcode_ret) {
        long __functionAddress = CL.getICD().clCreateFromEGLImageKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(context2);
            Checks.check(display);
            Checks.check(image);
            Checks.checkNTSafe(properties2);
            Checks.checkSafe(errcode_ret, 1);
        }
        return JNI.callPPPJPPP(context2, display, image, flags, MemoryUtil.memAddressSafe(properties2), errcode_ret, __functionAddress);
    }
}

