/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opencl;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct cl_mem_ext_host_ptr")
public class CLMemEXTHostPtr
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ALLOCATION_TYPE;
    public static final int HOST_CACHE_POLICY;

    public CLMemEXTHostPtr(ByteBuffer container2) {
        super(MemoryUtil.memAddress(container2), CLMemEXTHostPtr.__checkContainer(container2, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="cl_uint")
    public int allocation_type() {
        return CLMemEXTHostPtr.nallocation_type(this.address());
    }

    @NativeType(value="cl_uint")
    public int host_cache_policy() {
        return CLMemEXTHostPtr.nhost_cache_policy(this.address());
    }

    public CLMemEXTHostPtr allocation_type(@NativeType(value="cl_uint") int value) {
        CLMemEXTHostPtr.nallocation_type(this.address(), value);
        return this;
    }

    public CLMemEXTHostPtr host_cache_policy(@NativeType(value="cl_uint") int value) {
        CLMemEXTHostPtr.nhost_cache_policy(this.address(), value);
        return this;
    }

    public CLMemEXTHostPtr set(int allocation_type, int host_cache_policy) {
        this.allocation_type(allocation_type);
        this.host_cache_policy(host_cache_policy);
        return this;
    }

    public CLMemEXTHostPtr set(CLMemEXTHostPtr src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static CLMemEXTHostPtr malloc() {
        return CLMemEXTHostPtr.wrap(CLMemEXTHostPtr.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static CLMemEXTHostPtr calloc() {
        return CLMemEXTHostPtr.wrap(CLMemEXTHostPtr.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static CLMemEXTHostPtr create() {
        ByteBuffer container2 = BufferUtils.createByteBuffer(SIZEOF);
        return CLMemEXTHostPtr.wrap(CLMemEXTHostPtr.class, MemoryUtil.memAddress(container2), container2);
    }

    public static CLMemEXTHostPtr create(long address) {
        return CLMemEXTHostPtr.wrap(CLMemEXTHostPtr.class, address);
    }

    @Nullable
    public static CLMemEXTHostPtr createSafe(long address) {
        return address == 0L ? null : CLMemEXTHostPtr.wrap(CLMemEXTHostPtr.class, address);
    }

    public static Buffer malloc(int capacity) {
        return CLMemEXTHostPtr.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(CLMemEXTHostPtr.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return CLMemEXTHostPtr.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container2 = CLMemEXTHostPtr.__create(capacity, SIZEOF);
        return CLMemEXTHostPtr.wrap(Buffer.class, MemoryUtil.memAddress(container2), capacity, container2);
    }

    public static Buffer create(long address, int capacity) {
        return CLMemEXTHostPtr.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : CLMemEXTHostPtr.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static CLMemEXTHostPtr mallocStack() {
        return CLMemEXTHostPtr.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CLMemEXTHostPtr callocStack() {
        return CLMemEXTHostPtr.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CLMemEXTHostPtr mallocStack(MemoryStack stack) {
        return CLMemEXTHostPtr.malloc(stack);
    }

    @Deprecated
    public static CLMemEXTHostPtr callocStack(MemoryStack stack) {
        return CLMemEXTHostPtr.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return CLMemEXTHostPtr.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return CLMemEXTHostPtr.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return CLMemEXTHostPtr.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return CLMemEXTHostPtr.calloc(capacity, stack);
    }

    public static CLMemEXTHostPtr malloc(MemoryStack stack) {
        return CLMemEXTHostPtr.wrap(CLMemEXTHostPtr.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static CLMemEXTHostPtr calloc(MemoryStack stack) {
        return CLMemEXTHostPtr.wrap(CLMemEXTHostPtr.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return CLMemEXTHostPtr.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return CLMemEXTHostPtr.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nallocation_type(long struct) {
        return UNSAFE.getInt(null, struct + (long)ALLOCATION_TYPE);
    }

    public static int nhost_cache_policy(long struct) {
        return UNSAFE.getInt(null, struct + (long)HOST_CACHE_POLICY);
    }

    public static void nallocation_type(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)ALLOCATION_TYPE, value);
    }

    public static void nhost_cache_policy(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)HOST_CACHE_POLICY, value);
    }

    static {
        Struct.Layout layout2 = CLMemEXTHostPtr.__struct(CLMemEXTHostPtr.__member(4), CLMemEXTHostPtr.__member(4));
        SIZEOF = layout2.getSize();
        ALIGNOF = layout2.getAlignment();
        ALLOCATION_TYPE = layout2.offsetof(0);
        HOST_CACHE_POLICY = layout2.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<CLMemEXTHostPtr, Buffer>
    implements NativeResource {
        private static final CLMemEXTHostPtr ELEMENT_FACTORY = CLMemEXTHostPtr.create(-1L);

        public Buffer(ByteBuffer container2) {
            super(container2, container2.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container2, int mark, int pos, int lim, int cap) {
            super(address, container2, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected CLMemEXTHostPtr getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="cl_uint")
        public int allocation_type() {
            return CLMemEXTHostPtr.nallocation_type(this.address());
        }

        @NativeType(value="cl_uint")
        public int host_cache_policy() {
            return CLMemEXTHostPtr.nhost_cache_policy(this.address());
        }

        public Buffer allocation_type(@NativeType(value="cl_uint") int value) {
            CLMemEXTHostPtr.nallocation_type(this.address(), value);
            return this;
        }

        public Buffer host_cache_policy(@NativeType(value="cl_uint") int value) {
            CLMemEXTHostPtr.nhost_cache_policy(this.address(), value);
            return this;
        }
    }
}

