/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opencl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import javax.annotation.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opencl.CL;
import org.lwjgl.opencl.CLContextCallbackI;
import org.lwjgl.opencl.CLImageFormat;
import org.lwjgl.opencl.CLNativeKernelI;
import org.lwjgl.opencl.CLProgramCallbackI;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class CL10 {
    public static final int CL_SUCCESS = 0;
    public static final int CL_DEVICE_NOT_FOUND = -1;
    public static final int CL_DEVICE_NOT_AVAILABLE = -2;
    public static final int CL_COMPILER_NOT_AVAILABLE = -3;
    public static final int CL_MEM_OBJECT_ALLOCATION_FAILURE = -4;
    public static final int CL_OUT_OF_RESOURCES = -5;
    public static final int CL_OUT_OF_HOST_MEMORY = -6;
    public static final int CL_PROFILING_INFO_NOT_AVAILABLE = -7;
    public static final int CL_MEM_COPY_OVERLAP = -8;
    public static final int CL_IMAGE_FORMAT_MISMATCH = -9;
    public static final int CL_IMAGE_FORMAT_NOT_SUPPORTED = -10;
    public static final int CL_BUILD_PROGRAM_FAILURE = -11;
    public static final int CL_MAP_FAILURE = -12;
    public static final int CL_INVALID_VALUE = -30;
    public static final int CL_INVALID_DEVICE_TYPE = -31;
    public static final int CL_INVALID_PLATFORM = -32;
    public static final int CL_INVALID_DEVICE = -33;
    public static final int CL_INVALID_CONTEXT = -34;
    public static final int CL_INVALID_QUEUE_PROPERTIES = -35;
    public static final int CL_INVALID_COMMAND_QUEUE = -36;
    public static final int CL_INVALID_HOST_PTR = -37;
    public static final int CL_INVALID_MEM_OBJECT = -38;
    public static final int CL_INVALID_IMAGE_FORMAT_DESCRIPTOR = -39;
    public static final int CL_INVALID_IMAGE_SIZE = -40;
    public static final int CL_INVALID_SAMPLER = -41;
    public static final int CL_INVALID_BINARY = -42;
    public static final int CL_INVALID_BUILD_OPTIONS = -43;
    public static final int CL_INVALID_PROGRAM = -44;
    public static final int CL_INVALID_PROGRAM_EXECUTABLE = -45;
    public static final int CL_INVALID_KERNEL_NAME = -46;
    public static final int CL_INVALID_KERNEL_DEFINITION = -47;
    public static final int CL_INVALID_KERNEL = -48;
    public static final int CL_INVALID_ARG_INDEX = -49;
    public static final int CL_INVALID_ARG_VALUE = -50;
    public static final int CL_INVALID_ARG_SIZE = -51;
    public static final int CL_INVALID_KERNEL_ARGS = -52;
    public static final int CL_INVALID_WORK_DIMENSION = -53;
    public static final int CL_INVALID_WORK_GROUP_SIZE = -54;
    public static final int CL_INVALID_WORK_ITEM_SIZE = -55;
    public static final int CL_INVALID_GLOBAL_OFFSET = -56;
    public static final int CL_INVALID_EVENT_WAIT_LIST = -57;
    public static final int CL_INVALID_EVENT = -58;
    public static final int CL_INVALID_OPERATION = -59;
    public static final int CL_INVALID_BUFFER_SIZE = -61;
    public static final int CL_INVALID_GLOBAL_WORK_SIZE = -63;
    public static final int CL_VERSION_1_0 = 1;
    public static final int CL_FALSE = 0;
    public static final int CL_TRUE = 1;
    public static final int CL_PLATFORM_PROFILE = 2304;
    public static final int CL_PLATFORM_VERSION = 2305;
    public static final int CL_PLATFORM_NAME = 2306;
    public static final int CL_PLATFORM_VENDOR = 2307;
    public static final int CL_PLATFORM_EXTENSIONS = 2308;
    public static final int CL_DEVICE_TYPE_DEFAULT = 1;
    public static final int CL_DEVICE_TYPE_CPU = 2;
    public static final int CL_DEVICE_TYPE_GPU = 4;
    public static final int CL_DEVICE_TYPE_ACCELERATOR = 8;
    public static final int CL_DEVICE_TYPE_ALL = -1;
    public static final int CL_DEVICE_TYPE = 4096;
    public static final int CL_DEVICE_VENDOR_ID = 4097;
    public static final int CL_DEVICE_MAX_COMPUTE_UNITS = 4098;
    public static final int CL_DEVICE_MAX_WORK_ITEM_DIMENSIONS = 4099;
    public static final int CL_DEVICE_MAX_WORK_GROUP_SIZE = 4100;
    public static final int CL_DEVICE_MAX_WORK_ITEM_SIZES = 4101;
    public static final int CL_DEVICE_PREFERRED_VECTOR_WIDTH_CHAR = 4102;
    public static final int CL_DEVICE_PREFERRED_VECTOR_WIDTH_SHORT = 4103;
    public static final int CL_DEVICE_PREFERRED_VECTOR_WIDTH_INT = 4104;
    public static final int CL_DEVICE_PREFERRED_VECTOR_WIDTH_LONG = 4105;
    public static final int CL_DEVICE_PREFERRED_VECTOR_WIDTH_FLOAT = 4106;
    public static final int CL_DEVICE_PREFERRED_VECTOR_WIDTH_DOUBLE = 4107;
    public static final int CL_DEVICE_MAX_CLOCK_FREQUENCY = 4108;
    public static final int CL_DEVICE_ADDRESS_BITS = 4109;
    public static final int CL_DEVICE_MAX_READ_IMAGE_ARGS = 4110;
    public static final int CL_DEVICE_MAX_WRITE_IMAGE_ARGS = 4111;
    public static final int CL_DEVICE_MAX_MEM_ALLOC_SIZE = 4112;
    public static final int CL_DEVICE_IMAGE2D_MAX_WIDTH = 4113;
    public static final int CL_DEVICE_IMAGE2D_MAX_HEIGHT = 4114;
    public static final int CL_DEVICE_IMAGE3D_MAX_WIDTH = 4115;
    public static final int CL_DEVICE_IMAGE3D_MAX_HEIGHT = 4116;
    public static final int CL_DEVICE_IMAGE3D_MAX_DEPTH = 4117;
    public static final int CL_DEVICE_IMAGE_SUPPORT = 4118;
    public static final int CL_DEVICE_MAX_PARAMETER_SIZE = 4119;
    public static final int CL_DEVICE_MAX_SAMPLERS = 4120;
    public static final int CL_DEVICE_MEM_BASE_ADDR_ALIGN = 4121;
    public static final int CL_DEVICE_MIN_DATA_TYPE_ALIGN_SIZE = 4122;
    public static final int CL_DEVICE_SINGLE_FP_CONFIG = 4123;
    public static final int CL_DEVICE_GLOBAL_MEM_CACHE_TYPE = 4124;
    public static final int CL_DEVICE_GLOBAL_MEM_CACHELINE_SIZE = 4125;
    public static final int CL_DEVICE_GLOBAL_MEM_CACHE_SIZE = 4126;
    public static final int CL_DEVICE_GLOBAL_MEM_SIZE = 4127;
    public static final int CL_DEVICE_MAX_CONSTANT_BUFFER_SIZE = 4128;
    public static final int CL_DEVICE_MAX_CONSTANT_ARGS = 4129;
    public static final int CL_DEVICE_LOCAL_MEM_TYPE = 4130;
    public static final int CL_DEVICE_LOCAL_MEM_SIZE = 4131;
    public static final int CL_DEVICE_ERROR_CORRECTION_SUPPORT = 4132;
    public static final int CL_DEVICE_PROFILING_TIMER_RESOLUTION = 4133;
    public static final int CL_DEVICE_ENDIAN_LITTLE = 4134;
    public static final int CL_DEVICE_AVAILABLE = 4135;
    public static final int CL_DEVICE_COMPILER_AVAILABLE = 4136;
    public static final int CL_DEVICE_EXECUTION_CAPABILITIES = 4137;
    public static final int CL_DEVICE_QUEUE_PROPERTIES = 4138;
    public static final int CL_DEVICE_NAME = 4139;
    public static final int CL_DEVICE_VENDOR = 4140;
    public static final int CL_DRIVER_VERSION = 4141;
    public static final int CL_DEVICE_PROFILE = 4142;
    public static final int CL_DEVICE_VERSION = 4143;
    public static final int CL_DEVICE_EXTENSIONS = 4144;
    public static final int CL_DEVICE_PLATFORM = 4145;
    public static final int CL_FP_DENORM = 1;
    public static final int CL_FP_INF_NAN = 2;
    public static final int CL_FP_ROUND_TO_NEAREST = 4;
    public static final int CL_FP_ROUND_TO_ZERO = 8;
    public static final int CL_FP_ROUND_TO_INF = 16;
    public static final int CL_FP_FMA = 32;
    public static final int CL_NONE = 0;
    public static final int CL_READ_ONLY_CACHE = 1;
    public static final int CL_READ_WRITE_CACHE = 2;
    public static final int CL_LOCAL = 1;
    public static final int CL_GLOBAL = 2;
    public static final int CL_EXEC_KERNEL = 1;
    public static final int CL_EXEC_NATIVE_KERNEL = 2;
    public static final int CL_QUEUE_OUT_OF_ORDER_EXEC_MODE_ENABLE = 1;
    public static final int CL_QUEUE_PROFILING_ENABLE = 2;
    public static final int CL_CONTEXT_REFERENCE_COUNT = 4224;
    public static final int CL_CONTEXT_DEVICES = 4225;
    public static final int CL_CONTEXT_PROPERTIES = 4226;
    public static final int CL_CONTEXT_PLATFORM = 4228;
    public static final int CL_QUEUE_CONTEXT = 4240;
    public static final int CL_QUEUE_DEVICE = 4241;
    public static final int CL_QUEUE_REFERENCE_COUNT = 4242;
    public static final int CL_QUEUE_PROPERTIES = 4243;
    public static final int CL_MEM_READ_WRITE = 1;
    public static final int CL_MEM_WRITE_ONLY = 2;
    public static final int CL_MEM_READ_ONLY = 4;
    public static final int CL_MEM_USE_HOST_PTR = 8;
    public static final int CL_MEM_ALLOC_HOST_PTR = 16;
    public static final int CL_MEM_COPY_HOST_PTR = 32;
    public static final int CL_R = 4272;
    public static final int CL_A = 4273;
    public static final int CL_RG = 4274;
    public static final int CL_RA = 4275;
    public static final int CL_RGB = 4276;
    public static final int CL_RGBA = 4277;
    public static final int CL_BGRA = 4278;
    public static final int CL_ARGB = 4279;
    public static final int CL_INTENSITY = 4280;
    public static final int CL_LUMINANCE = 4281;
    public static final int CL_SNORM_INT8 = 4304;
    public static final int CL_SNORM_INT16 = 4305;
    public static final int CL_UNORM_INT8 = 4306;
    public static final int CL_UNORM_INT16 = 4307;
    public static final int CL_UNORM_SHORT_565 = 4308;
    public static final int CL_UNORM_SHORT_555 = 4309;
    public static final int CL_UNORM_INT_101010 = 4310;
    public static final int CL_SIGNED_INT8 = 4311;
    public static final int CL_SIGNED_INT16 = 4312;
    public static final int CL_SIGNED_INT32 = 4313;
    public static final int CL_UNSIGNED_INT8 = 4314;
    public static final int CL_UNSIGNED_INT16 = 4315;
    public static final int CL_UNSIGNED_INT32 = 4316;
    public static final int CL_HALF_FLOAT = 4317;
    public static final int CL_FLOAT = 4318;
    public static final int CL_MEM_OBJECT_BUFFER = 4336;
    public static final int CL_MEM_OBJECT_IMAGE2D = 4337;
    public static final int CL_MEM_OBJECT_IMAGE3D = 4338;
    public static final int CL_MEM_TYPE = 4352;
    public static final int CL_MEM_FLAGS = 4353;
    public static final int CL_MEM_SIZE = 4354;
    public static final int CL_MEM_HOST_PTR = 4355;
    public static final int CL_MEM_MAP_COUNT = 4356;
    public static final int CL_MEM_REFERENCE_COUNT = 4357;
    public static final int CL_MEM_CONTEXT = 4358;
    public static final int CL_IMAGE_FORMAT = 4368;
    public static final int CL_IMAGE_ELEMENT_SIZE = 4369;
    public static final int CL_IMAGE_ROW_PITCH = 4370;
    public static final int CL_IMAGE_SLICE_PITCH = 4371;
    public static final int CL_IMAGE_WIDTH = 4372;
    public static final int CL_IMAGE_HEIGHT = 4373;
    public static final int CL_IMAGE_DEPTH = 4374;
    public static final int CL_ADDRESS_NONE = 4400;
    public static final int CL_ADDRESS_CLAMP_TO_EDGE = 4401;
    public static final int CL_ADDRESS_CLAMP = 4402;
    public static final int CL_ADDRESS_REPEAT = 4403;
    public static final int CL_FILTER_NEAREST = 4416;
    public static final int CL_FILTER_LINEAR = 4417;
    public static final int CL_SAMPLER_REFERENCE_COUNT = 4432;
    public static final int CL_SAMPLER_CONTEXT = 4433;
    public static final int CL_SAMPLER_NORMALIZED_COORDS = 4434;
    public static final int CL_SAMPLER_ADDRESSING_MODE = 4435;
    public static final int CL_SAMPLER_FILTER_MODE = 4436;
    public static final int CL_MAP_READ = 1;
    public static final int CL_MAP_WRITE = 2;
    public static final int CL_PROGRAM_REFERENCE_COUNT = 4448;
    public static final int CL_PROGRAM_CONTEXT = 4449;
    public static final int CL_PROGRAM_NUM_DEVICES = 4450;
    public static final int CL_PROGRAM_DEVICES = 4451;
    public static final int CL_PROGRAM_SOURCE = 4452;
    public static final int CL_PROGRAM_BINARY_SIZES = 4453;
    public static final int CL_PROGRAM_BINARIES = 4454;
    public static final int CL_PROGRAM_BUILD_STATUS = 4481;
    public static final int CL_PROGRAM_BUILD_OPTIONS = 4482;
    public static final int CL_PROGRAM_BUILD_LOG = 4483;
    public static final int CL_BUILD_SUCCESS = 0;
    public static final int CL_BUILD_NONE = -1;
    public static final int CL_BUILD_ERROR = -2;
    public static final int CL_BUILD_IN_PROGRESS = -3;
    public static final int CL_KERNEL_FUNCTION_NAME = 4496;
    public static final int CL_KERNEL_NUM_ARGS = 4497;
    public static final int CL_KERNEL_REFERENCE_COUNT = 4498;
    public static final int CL_KERNEL_CONTEXT = 4499;
    public static final int CL_KERNEL_PROGRAM = 4500;
    public static final int CL_KERNEL_WORK_GROUP_SIZE = 4528;
    public static final int CL_KERNEL_COMPILE_WORK_GROUP_SIZE = 4529;
    public static final int CL_KERNEL_LOCAL_MEM_SIZE = 4530;
    public static final int CL_EVENT_COMMAND_QUEUE = 4560;
    public static final int CL_EVENT_COMMAND_TYPE = 4561;
    public static final int CL_EVENT_REFERENCE_COUNT = 4562;
    public static final int CL_EVENT_COMMAND_EXECUTION_STATUS = 4563;
    public static final int CL_COMMAND_NDRANGE_KERNEL = 4592;
    public static final int CL_COMMAND_TASK = 4593;
    public static final int CL_COMMAND_NATIVE_KERNEL = 4594;
    public static final int CL_COMMAND_READ_BUFFER = 4595;
    public static final int CL_COMMAND_WRITE_BUFFER = 4596;
    public static final int CL_COMMAND_COPY_BUFFER = 4597;
    public static final int CL_COMMAND_READ_IMAGE = 4598;
    public static final int CL_COMMAND_WRITE_IMAGE = 4599;
    public static final int CL_COMMAND_COPY_IMAGE = 4600;
    public static final int CL_COMMAND_COPY_IMAGE_TO_BUFFER = 4601;
    public static final int CL_COMMAND_COPY_BUFFER_TO_IMAGE = 4602;
    public static final int CL_COMMAND_MAP_BUFFER = 4603;
    public static final int CL_COMMAND_MAP_IMAGE = 4604;
    public static final int CL_COMMAND_UNMAP_MEM_OBJECT = 4605;
    public static final int CL_COMMAND_MARKER = 4606;
    public static final int CL_COMMAND_ACQUIRE_GL_OBJECTS = 4607;
    public static final int CL_COMMAND_RELEASE_GL_OBJECTS = 4608;
    public static final int CL_COMPLETE = 0;
    public static final int CL_RUNNING = 1;
    public static final int CL_SUBMITTED = 2;
    public static final int CL_QUEUED = 3;
    public static final int CL_PROFILING_COMMAND_QUEUED = 4736;
    public static final int CL_PROFILING_COMMAND_SUBMIT = 4737;
    public static final int CL_PROFILING_COMMAND_START = 4738;
    public static final int CL_PROFILING_COMMAND_END = 4739;

    protected CL10() {
        throw new UnsupportedOperationException();
    }

    public static int nclGetPlatformIDs(int num_entries, long platforms, long num_platforms) {
        long __functionAddress = CL.getICD().clGetPlatformIDs;
        return JNI.callPPI(num_entries, platforms, num_platforms, __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clGetPlatformIDs(@Nullable @NativeType(value="cl_platform_id *") PointerBuffer platforms, @Nullable @NativeType(value="cl_uint *") IntBuffer num_platforms) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)num_platforms, 1);
        }
        return CL10.nclGetPlatformIDs(Checks.remainingSafe(platforms), MemoryUtil.memAddressSafe(platforms), MemoryUtil.memAddressSafe(num_platforms));
    }

    public static int nclGetPlatformInfo(long platform, int param_name, long param_value_size, long param_value, long param_value_size_ret) {
        long __functionAddress = CL.getICD().clGetPlatformInfo;
        if (Checks.CHECKS) {
            Checks.check(platform);
        }
        return JNI.callPPPPI(platform, param_name, param_value_size, param_value, param_value_size_ret, __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clGetPlatformInfo(@NativeType(value="cl_platform_id") long platform, @NativeType(value="cl_platform_info") int param_name, @Nullable @NativeType(value="void *") ByteBuffer param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe(param_value_size_ret, 1);
        }
        return CL10.nclGetPlatformInfo(platform, param_name, Checks.remainingSafe(param_value), MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    @NativeType(value="cl_int")
    public static int clGetPlatformInfo(@NativeType(value="cl_platform_id") long platform, @NativeType(value="cl_platform_info") int param_name, @Nullable @NativeType(value="void *") LongBuffer param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe(param_value_size_ret, 1);
        }
        return CL10.nclGetPlatformInfo(platform, param_name, Integer.toUnsignedLong(Checks.remainingSafe(param_value)) << 3, MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    public static int nclGetDeviceIDs(long platform, long device_type, int num_entries, long devices, long num_devices) {
        long __functionAddress = CL.getICD().clGetDeviceIDs;
        return JNI.callPJPPI(platform, device_type, num_entries, devices, num_devices, __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clGetDeviceIDs(@NativeType(value="cl_platform_id") long platform, @NativeType(value="cl_device_type") long device_type, @Nullable @NativeType(value="cl_device_id *") PointerBuffer devices, @Nullable @NativeType(value="cl_uint *") IntBuffer num_devices) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)num_devices, 1);
        }
        return CL10.nclGetDeviceIDs(platform, device_type, Checks.remainingSafe(devices), MemoryUtil.memAddressSafe(devices), MemoryUtil.memAddressSafe(num_devices));
    }

    public static int nclGetDeviceInfo(long device2, int param_name, long param_value_size, long param_value, long param_value_size_ret) {
        long __functionAddress = CL.getICD().clGetDeviceInfo;
        if (Checks.CHECKS) {
            Checks.check(device2);
        }
        return JNI.callPPPPI(device2, param_name, param_value_size, param_value, param_value_size_ret, __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clGetDeviceInfo(@NativeType(value="cl_device_id") long device2, @NativeType(value="cl_device_info") int param_name, @Nullable @NativeType(value="void *") ByteBuffer param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe(param_value_size_ret, 1);
        }
        return CL10.nclGetDeviceInfo(device2, param_name, Checks.remainingSafe(param_value), MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    @NativeType(value="cl_int")
    public static int clGetDeviceInfo(@NativeType(value="cl_device_id") long device2, @NativeType(value="cl_device_info") int param_name, @Nullable @NativeType(value="void *") IntBuffer param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe(param_value_size_ret, 1);
        }
        return CL10.nclGetDeviceInfo(device2, param_name, Integer.toUnsignedLong(Checks.remainingSafe(param_value)) << 2, MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    @NativeType(value="cl_int")
    public static int clGetDeviceInfo(@NativeType(value="cl_device_id") long device2, @NativeType(value="cl_device_info") int param_name, @Nullable @NativeType(value="void *") LongBuffer param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe(param_value_size_ret, 1);
        }
        return CL10.nclGetDeviceInfo(device2, param_name, Integer.toUnsignedLong(Checks.remainingSafe(param_value)) << 3, MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    @NativeType(value="cl_int")
    public static int clGetDeviceInfo(@NativeType(value="cl_device_id") long device2, @NativeType(value="cl_device_info") int param_name, @Nullable @NativeType(value="void *") PointerBuffer param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe(param_value_size_ret, 1);
        }
        return CL10.nclGetDeviceInfo(device2, param_name, Integer.toUnsignedLong(Checks.remainingSafe(param_value)) << MemoryStack.POINTER_SHIFT, MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    public static long nclCreateContext(long properties2, int num_devices, long devices, long pfn_notify, long user_data, long errcode_ret) {
        long __functionAddress = CL.getICD().clCreateContext;
        return JNI.callPPPPPP(properties2, num_devices, devices, pfn_notify, user_data, errcode_ret, __functionAddress);
    }

    @NativeType(value="cl_context")
    public static long clCreateContext(@Nullable @NativeType(value="cl_context_properties const *") PointerBuffer properties2, @NativeType(value="cl_device_id const *") PointerBuffer devices, @Nullable @NativeType(value="void (*) (cl_char const *, void const *, size_t, void *)") CLContextCallbackI pfn_notify, @NativeType(value="void *") long user_data, @Nullable @NativeType(value="cl_int *") IntBuffer errcode_ret) {
        if (Checks.CHECKS) {
            Checks.checkNTSafe(properties2);
            Checks.checkSafe((Buffer)errcode_ret, 1);
        }
        return CL10.nclCreateContext(MemoryUtil.memAddressSafe(properties2), devices.remaining(), MemoryUtil.memAddress(devices), MemoryUtil.memAddressSafe(pfn_notify), user_data, MemoryUtil.memAddressSafe(errcode_ret));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="cl_context")
    public static long clCreateContext(@Nullable @NativeType(value="cl_context_properties const *") PointerBuffer properties2, @NativeType(value="cl_device_id const *") long device2, @Nullable @NativeType(value="void (*) (cl_char const *, void const *, size_t, void *)") CLContextCallbackI pfn_notify, @NativeType(value="void *") long user_data, @Nullable @NativeType(value="cl_int *") IntBuffer errcode_ret) {
        if (Checks.CHECKS) {
            Checks.checkNTSafe(properties2);
            Checks.checkSafe((Buffer)errcode_ret, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            PointerBuffer devices = stack.pointers(device2);
            long l = CL10.nclCreateContext(MemoryUtil.memAddressSafe(properties2), 1, MemoryUtil.memAddress(devices), MemoryUtil.memAddressSafe(pfn_notify), user_data, MemoryUtil.memAddressSafe(errcode_ret));
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nclCreateContextFromType(long properties2, long device_type, long pfn_notify, long user_data, long errcode_ret) {
        long __functionAddress = CL.getICD().clCreateContextFromType;
        return JNI.callPJPPPP(properties2, device_type, pfn_notify, user_data, errcode_ret, __functionAddress);
    }

    @NativeType(value="cl_context")
    public static long clCreateContextFromType(@Nullable @NativeType(value="cl_context_properties const *") PointerBuffer properties2, @NativeType(value="cl_device_type") long device_type, @Nullable @NativeType(value="void (*) (cl_char const *, void const *, size_t, void *)") CLContextCallbackI pfn_notify, @NativeType(value="void *") long user_data, @Nullable @NativeType(value="cl_int *") IntBuffer errcode_ret) {
        if (Checks.CHECKS) {
            Checks.checkNTSafe(properties2);
            Checks.checkSafe((Buffer)errcode_ret, 1);
        }
        return CL10.nclCreateContextFromType(MemoryUtil.memAddressSafe(properties2), device_type, MemoryUtil.memAddressSafe(pfn_notify), user_data, MemoryUtil.memAddressSafe(errcode_ret));
    }

    @NativeType(value="cl_int")
    public static int clRetainContext(@NativeType(value="cl_context") long context2) {
        long __functionAddress = CL.getICD().clRetainContext;
        if (Checks.CHECKS) {
            Checks.check(context2);
        }
        return JNI.callPI(context2, __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clReleaseContext(@NativeType(value="cl_context") long context2) {
        long __functionAddress = CL.getICD().clReleaseContext;
        if (Checks.CHECKS) {
            Checks.check(context2);
        }
        return JNI.callPI(context2, __functionAddress);
    }

    public static int nclGetContextInfo(long context2, int param_name, long param_value_size, long param_value, long param_value_size_ret) {
        long __functionAddress = CL.getICD().clGetContextInfo;
        if (Checks.CHECKS) {
            Checks.check(context2);
        }
        return JNI.callPPPPI(context2, param_name, param_value_size, param_value, param_value_size_ret, __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clGetContextInfo(@NativeType(value="cl_context") long context2, @NativeType(value="cl_context_info") int param_name, @Nullable @NativeType(value="void *") ByteBuffer param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe(param_value_size_ret, 1);
        }
        return CL10.nclGetContextInfo(context2, param_name, Checks.remainingSafe(param_value), MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    @NativeType(value="cl_int")
    public static int clGetContextInfo(@NativeType(value="cl_context") long context2, @NativeType(value="cl_context_info") int param_name, @Nullable @NativeType(value="void *") IntBuffer param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe(param_value_size_ret, 1);
        }
        return CL10.nclGetContextInfo(context2, param_name, Integer.toUnsignedLong(Checks.remainingSafe(param_value)) << 2, MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    @NativeType(value="cl_int")
    public static int clGetContextInfo(@NativeType(value="cl_context") long context2, @NativeType(value="cl_context_info") int param_name, @Nullable @NativeType(value="void *") PointerBuffer param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe(param_value_size_ret, 1);
        }
        return CL10.nclGetContextInfo(context2, param_name, Integer.toUnsignedLong(Checks.remainingSafe(param_value)) << MemoryStack.POINTER_SHIFT, MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    public static long nclCreateCommandQueue(long context2, long device2, long properties2, long errcode_ret) {
        long __functionAddress = CL.getICD().clCreateCommandQueue;
        if (Checks.CHECKS) {
            Checks.check(context2);
            Checks.check(device2);
        }
        return JNI.callPPJPP(context2, device2, properties2, errcode_ret, __functionAddress);
    }

    @NativeType(value="cl_command_queue")
    public static long clCreateCommandQueue(@NativeType(value="cl_context") long context2, @NativeType(value="cl_device_id") long device2, @NativeType(value="cl_command_queue_properties") long properties2, @Nullable @NativeType(value="cl_int *") IntBuffer errcode_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)errcode_ret, 1);
        }
        return CL10.nclCreateCommandQueue(context2, device2, properties2, MemoryUtil.memAddressSafe(errcode_ret));
    }

    @NativeType(value="cl_int")
    public static int clRetainCommandQueue(@NativeType(value="cl_command_queue") long command_queue) {
        long __functionAddress = CL.getICD().clRetainCommandQueue;
        if (Checks.CHECKS) {
            Checks.check(command_queue);
        }
        return JNI.callPI(command_queue, __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clReleaseCommandQueue(@NativeType(value="cl_command_queue") long command_queue) {
        long __functionAddress = CL.getICD().clReleaseCommandQueue;
        if (Checks.CHECKS) {
            Checks.check(command_queue);
        }
        return JNI.callPI(command_queue, __functionAddress);
    }

    public static int nclGetCommandQueueInfo(long command_queue, int param_name, long param_value_size, long param_value, long param_value_size_ret) {
        long __functionAddress = CL.getICD().clGetCommandQueueInfo;
        if (Checks.CHECKS) {
            Checks.check(command_queue);
        }
        return JNI.callPPPPI(command_queue, param_name, param_value_size, param_value, param_value_size_ret, __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clGetCommandQueueInfo(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_command_queue_info") int param_name, @Nullable @NativeType(value="void *") ByteBuffer param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe(param_value_size_ret, 1);
        }
        return CL10.nclGetCommandQueueInfo(command_queue, param_name, Checks.remainingSafe(param_value), MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    @NativeType(value="cl_int")
    public static int clGetCommandQueueInfo(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_command_queue_info") int param_name, @Nullable @NativeType(value="void *") IntBuffer param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe(param_value_size_ret, 1);
        }
        return CL10.nclGetCommandQueueInfo(command_queue, param_name, Integer.toUnsignedLong(Checks.remainingSafe(param_value)) << 2, MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    @NativeType(value="cl_int")
    public static int clGetCommandQueueInfo(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_command_queue_info") int param_name, @Nullable @NativeType(value="void *") LongBuffer param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe(param_value_size_ret, 1);
        }
        return CL10.nclGetCommandQueueInfo(command_queue, param_name, Integer.toUnsignedLong(Checks.remainingSafe(param_value)) << 3, MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    @NativeType(value="cl_int")
    public static int clGetCommandQueueInfo(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_command_queue_info") int param_name, @Nullable @NativeType(value="void *") PointerBuffer param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe(param_value_size_ret, 1);
        }
        return CL10.nclGetCommandQueueInfo(command_queue, param_name, Integer.toUnsignedLong(Checks.remainingSafe(param_value)) << MemoryStack.POINTER_SHIFT, MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    public static long nclCreateBuffer(long context2, long flags, long size2, long host_ptr, long errcode_ret) {
        long __functionAddress = CL.getICD().clCreateBuffer;
        if (Checks.CHECKS) {
            Checks.check(context2);
        }
        return JNI.callPJPPPP(context2, flags, size2, host_ptr, errcode_ret, __functionAddress);
    }

    @NativeType(value="cl_mem")
    public static long clCreateBuffer(@NativeType(value="cl_context") long context2, @NativeType(value="cl_mem_flags") long flags, @NativeType(value="size_t") long size2, @Nullable @NativeType(value="cl_int *") IntBuffer errcode_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)errcode_ret, 1);
        }
        return CL10.nclCreateBuffer(context2, flags, size2, 0L, MemoryUtil.memAddressSafe(errcode_ret));
    }

    @NativeType(value="cl_mem")
    public static long clCreateBuffer(@NativeType(value="cl_context") long context2, @NativeType(value="cl_mem_flags") long flags, @NativeType(value="void *") ByteBuffer host_ptr, @Nullable @NativeType(value="cl_int *") IntBuffer errcode_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)errcode_ret, 1);
        }
        return CL10.nclCreateBuffer(context2, flags, host_ptr.remaining(), MemoryUtil.memAddress(host_ptr), MemoryUtil.memAddressSafe(errcode_ret));
    }

    @NativeType(value="cl_mem")
    public static long clCreateBuffer(@NativeType(value="cl_context") long context2, @NativeType(value="cl_mem_flags") long flags, @NativeType(value="void *") ShortBuffer host_ptr, @Nullable @NativeType(value="cl_int *") IntBuffer errcode_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)errcode_ret, 1);
        }
        return CL10.nclCreateBuffer(context2, flags, Integer.toUnsignedLong(host_ptr.remaining()) << 1, MemoryUtil.memAddress(host_ptr), MemoryUtil.memAddressSafe(errcode_ret));
    }

    @NativeType(value="cl_mem")
    public static long clCreateBuffer(@NativeType(value="cl_context") long context2, @NativeType(value="cl_mem_flags") long flags, @NativeType(value="void *") IntBuffer host_ptr, @Nullable @NativeType(value="cl_int *") IntBuffer errcode_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)errcode_ret, 1);
        }
        return CL10.nclCreateBuffer(context2, flags, Integer.toUnsignedLong(host_ptr.remaining()) << 2, MemoryUtil.memAddress(host_ptr), MemoryUtil.memAddressSafe(errcode_ret));
    }

    @NativeType(value="cl_mem")
    public static long clCreateBuffer(@NativeType(value="cl_context") long context2, @NativeType(value="cl_mem_flags") long flags, @NativeType(value="void *") FloatBuffer host_ptr, @Nullable @NativeType(value="cl_int *") IntBuffer errcode_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)errcode_ret, 1);
        }
        return CL10.nclCreateBuffer(context2, flags, Integer.toUnsignedLong(host_ptr.remaining()) << 2, MemoryUtil.memAddress(host_ptr), MemoryUtil.memAddressSafe(errcode_ret));
    }

    @NativeType(value="cl_mem")
    public static long clCreateBuffer(@NativeType(value="cl_context") long context2, @NativeType(value="cl_mem_flags") long flags, @NativeType(value="void *") DoubleBuffer host_ptr, @Nullable @NativeType(value="cl_int *") IntBuffer errcode_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)errcode_ret, 1);
        }
        return CL10.nclCreateBuffer(context2, flags, Integer.toUnsignedLong(host_ptr.remaining()) << 3, MemoryUtil.memAddress(host_ptr), MemoryUtil.memAddressSafe(errcode_ret));
    }

    public static int nclEnqueueReadBuffer(long command_queue, long buffer, int blocking_read, long offset2, long size2, long ptr, int num_events_in_wait_list, long event_wait_list, long event) {
        long __functionAddress = CL.getICD().clEnqueueReadBuffer;
        if (Checks.CHECKS) {
            Checks.check(command_queue);
            Checks.check(buffer);
        }
        return JNI.callPPPPPPPI(command_queue, buffer, blocking_read, offset2, size2, ptr, num_events_in_wait_list, event_wait_list, event, __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clEnqueueReadBuffer(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long buffer, @NativeType(value="cl_bool") boolean blocking_read, @NativeType(value="size_t") long offset2, @NativeType(value="void *") ByteBuffer ptr, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.checkSafe(event, 1);
        }
        return CL10.nclEnqueueReadBuffer(command_queue, buffer, blocking_read ? 1 : 0, offset2, ptr.remaining(), MemoryUtil.memAddress(ptr), Checks.remainingSafe(event_wait_list), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    @NativeType(value="cl_int")
    public static int clEnqueueReadBuffer(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long buffer, @NativeType(value="cl_bool") boolean blocking_read, @NativeType(value="size_t") long offset2, @NativeType(value="void *") ShortBuffer ptr, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.checkSafe(event, 1);
        }
        return CL10.nclEnqueueReadBuffer(command_queue, buffer, blocking_read ? 1 : 0, offset2, Integer.toUnsignedLong(ptr.remaining()) << 1, MemoryUtil.memAddress(ptr), Checks.remainingSafe(event_wait_list), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    @NativeType(value="cl_int")
    public static int clEnqueueReadBuffer(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long buffer, @NativeType(value="cl_bool") boolean blocking_read, @NativeType(value="size_t") long offset2, @NativeType(value="void *") IntBuffer ptr, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.checkSafe(event, 1);
        }
        return CL10.nclEnqueueReadBuffer(command_queue, buffer, blocking_read ? 1 : 0, offset2, Integer.toUnsignedLong(ptr.remaining()) << 2, MemoryUtil.memAddress(ptr), Checks.remainingSafe(event_wait_list), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    @NativeType(value="cl_int")
    public static int clEnqueueReadBuffer(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long buffer, @NativeType(value="cl_bool") boolean blocking_read, @NativeType(value="size_t") long offset2, @NativeType(value="void *") FloatBuffer ptr, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.checkSafe(event, 1);
        }
        return CL10.nclEnqueueReadBuffer(command_queue, buffer, blocking_read ? 1 : 0, offset2, Integer.toUnsignedLong(ptr.remaining()) << 2, MemoryUtil.memAddress(ptr), Checks.remainingSafe(event_wait_list), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    @NativeType(value="cl_int")
    public static int clEnqueueReadBuffer(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long buffer, @NativeType(value="cl_bool") boolean blocking_read, @NativeType(value="size_t") long offset2, @NativeType(value="void *") DoubleBuffer ptr, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.checkSafe(event, 1);
        }
        return CL10.nclEnqueueReadBuffer(command_queue, buffer, blocking_read ? 1 : 0, offset2, Integer.toUnsignedLong(ptr.remaining()) << 3, MemoryUtil.memAddress(ptr), Checks.remainingSafe(event_wait_list), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static int nclEnqueueWriteBuffer(long command_queue, long buffer, int blocking_write, long offset2, long size2, long ptr, int num_events_in_wait_list, long event_wait_list, long event) {
        long __functionAddress = CL.getICD().clEnqueueWriteBuffer;
        if (Checks.CHECKS) {
            Checks.check(command_queue);
            Checks.check(buffer);
        }
        return JNI.callPPPPPPPI(command_queue, buffer, blocking_write, offset2, size2, ptr, num_events_in_wait_list, event_wait_list, event, __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clEnqueueWriteBuffer(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long buffer, @NativeType(value="cl_bool") boolean blocking_write, @NativeType(value="size_t") long offset2, @NativeType(value="void const *") ByteBuffer ptr, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.checkSafe(event, 1);
        }
        return CL10.nclEnqueueWriteBuffer(command_queue, buffer, blocking_write ? 1 : 0, offset2, ptr.remaining(), MemoryUtil.memAddress(ptr), Checks.remainingSafe(event_wait_list), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    @NativeType(value="cl_int")
    public static int clEnqueueWriteBuffer(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long buffer, @NativeType(value="cl_bool") boolean blocking_write, @NativeType(value="size_t") long offset2, @NativeType(value="void const *") ShortBuffer ptr, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.checkSafe(event, 1);
        }
        return CL10.nclEnqueueWriteBuffer(command_queue, buffer, blocking_write ? 1 : 0, offset2, Integer.toUnsignedLong(ptr.remaining()) << 1, MemoryUtil.memAddress(ptr), Checks.remainingSafe(event_wait_list), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    @NativeType(value="cl_int")
    public static int clEnqueueWriteBuffer(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long buffer, @NativeType(value="cl_bool") boolean blocking_write, @NativeType(value="size_t") long offset2, @NativeType(value="void const *") IntBuffer ptr, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.checkSafe(event, 1);
        }
        return CL10.nclEnqueueWriteBuffer(command_queue, buffer, blocking_write ? 1 : 0, offset2, Integer.toUnsignedLong(ptr.remaining()) << 2, MemoryUtil.memAddress(ptr), Checks.remainingSafe(event_wait_list), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    @NativeType(value="cl_int")
    public static int clEnqueueWriteBuffer(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long buffer, @NativeType(value="cl_bool") boolean blocking_write, @NativeType(value="size_t") long offset2, @NativeType(value="void const *") FloatBuffer ptr, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.checkSafe(event, 1);
        }
        return CL10.nclEnqueueWriteBuffer(command_queue, buffer, blocking_write ? 1 : 0, offset2, Integer.toUnsignedLong(ptr.remaining()) << 2, MemoryUtil.memAddress(ptr), Checks.remainingSafe(event_wait_list), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    @NativeType(value="cl_int")
    public static int clEnqueueWriteBuffer(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long buffer, @NativeType(value="cl_bool") boolean blocking_write, @NativeType(value="size_t") long offset2, @NativeType(value="void const *") DoubleBuffer ptr, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.checkSafe(event, 1);
        }
        return CL10.nclEnqueueWriteBuffer(command_queue, buffer, blocking_write ? 1 : 0, offset2, Integer.toUnsignedLong(ptr.remaining()) << 3, MemoryUtil.memAddress(ptr), Checks.remainingSafe(event_wait_list), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static int nclEnqueueCopyBuffer(long command_queue, long src_buffer, long dst_buffer, long src_offset, long dst_offset, long size2, int num_events_in_wait_list, long event_wait_list, long event) {
        long __functionAddress = CL.getICD().clEnqueueCopyBuffer;
        if (Checks.CHECKS) {
            Checks.check(command_queue);
            Checks.check(src_buffer);
            Checks.check(dst_buffer);
        }
        return JNI.callPPPPPPPPI(command_queue, src_buffer, dst_buffer, src_offset, dst_offset, size2, num_events_in_wait_list, event_wait_list, event, __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clEnqueueCopyBuffer(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long src_buffer, @NativeType(value="cl_mem") long dst_buffer, @NativeType(value="size_t") long src_offset, @NativeType(value="size_t") long dst_offset, @NativeType(value="size_t") long size2, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.checkSafe(event, 1);
        }
        return CL10.nclEnqueueCopyBuffer(command_queue, src_buffer, dst_buffer, src_offset, dst_offset, size2, Checks.remainingSafe(event_wait_list), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static long nclEnqueueMapBuffer(long command_queue, long buffer, int blocking_map, long map_flags, long offset2, long size2, int num_events_in_wait_list, long event_wait_list, long event, long errcode_ret) {
        long __functionAddress = CL.getICD().clEnqueueMapBuffer;
        if (Checks.CHECKS) {
            Checks.check(command_queue);
            Checks.check(buffer);
        }
        return JNI.callPPJPPPPPP(command_queue, buffer, blocking_map, map_flags, offset2, size2, num_events_in_wait_list, event_wait_list, event, errcode_ret, __functionAddress);
    }

    @Nullable
    @NativeType(value="void *")
    public static ByteBuffer clEnqueueMapBuffer(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long buffer, @NativeType(value="cl_bool") boolean blocking_map, @NativeType(value="cl_map_flags") long map_flags, @NativeType(value="size_t") long offset2, @NativeType(value="size_t") long size2, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event, @Nullable @NativeType(value="cl_int *") IntBuffer errcode_ret, @Nullable ByteBuffer old_buffer) {
        if (Checks.CHECKS) {
            Checks.checkSafe(event, 1);
            Checks.checkSafe((Buffer)errcode_ret, 1);
        }
        long __result = CL10.nclEnqueueMapBuffer(command_queue, buffer, blocking_map ? 1 : 0, map_flags, offset2, size2, Checks.remainingSafe(event_wait_list), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event), MemoryUtil.memAddressSafe(errcode_ret));
        return APIUtil.apiGetMappedBuffer(old_buffer, __result, (int)size2);
    }

    public static long nclCreateImage2D(long context2, long flags, long image_format, long image_width, long image_height, long image_row_pitch, long host_ptr, long errcode_ret) {
        long __functionAddress = CL.getICD().clCreateImage2D;
        if (Checks.CHECKS) {
            Checks.check(context2);
        }
        return JNI.callPJPPPPPPP(context2, flags, image_format, image_width, image_height, image_row_pitch, host_ptr, errcode_ret, __functionAddress);
    }

    @NativeType(value="cl_mem")
    public static long clCreateImage2D(@NativeType(value="cl_context") long context2, @NativeType(value="cl_mem_flags") long flags, @NativeType(value="cl_image_format const *") CLImageFormat image_format, @NativeType(value="size_t") long image_width, @NativeType(value="size_t") long image_height, @NativeType(value="size_t") long image_row_pitch, @Nullable @NativeType(value="void *") ByteBuffer host_ptr, @Nullable @NativeType(value="cl_int *") IntBuffer errcode_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)errcode_ret, 1);
        }
        return CL10.nclCreateImage2D(context2, flags, image_format.address(), image_width, image_height, image_row_pitch, MemoryUtil.memAddressSafe(host_ptr), MemoryUtil.memAddressSafe(errcode_ret));
    }

    @NativeType(value="cl_mem")
    public static long clCreateImage2D(@NativeType(value="cl_context") long context2, @NativeType(value="cl_mem_flags") long flags, @NativeType(value="cl_image_format const *") CLImageFormat image_format, @NativeType(value="size_t") long image_width, @NativeType(value="size_t") long image_height, @NativeType(value="size_t") long image_row_pitch, @Nullable @NativeType(value="void *") ShortBuffer host_ptr, @Nullable @NativeType(value="cl_int *") IntBuffer errcode_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)errcode_ret, 1);
        }
        return CL10.nclCreateImage2D(context2, flags, image_format.address(), image_width, image_height, image_row_pitch, MemoryUtil.memAddressSafe(host_ptr), MemoryUtil.memAddressSafe(errcode_ret));
    }

    @NativeType(value="cl_mem")
    public static long clCreateImage2D(@NativeType(value="cl_context") long context2, @NativeType(value="cl_mem_flags") long flags, @NativeType(value="cl_image_format const *") CLImageFormat image_format, @NativeType(value="size_t") long image_width, @NativeType(value="size_t") long image_height, @NativeType(value="size_t") long image_row_pitch, @Nullable @NativeType(value="void *") IntBuffer host_ptr, @Nullable @NativeType(value="cl_int *") IntBuffer errcode_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)errcode_ret, 1);
        }
        return CL10.nclCreateImage2D(context2, flags, image_format.address(), image_width, image_height, image_row_pitch, MemoryUtil.memAddressSafe(host_ptr), MemoryUtil.memAddressSafe(errcode_ret));
    }

    @NativeType(value="cl_mem")
    public static long clCreateImage2D(@NativeType(value="cl_context") long context2, @NativeType(value="cl_mem_flags") long flags, @NativeType(value="cl_image_format const *") CLImageFormat image_format, @NativeType(value="size_t") long image_width, @NativeType(value="size_t") long image_height, @NativeType(value="size_t") long image_row_pitch, @Nullable @NativeType(value="void *") FloatBuffer host_ptr, @Nullable @NativeType(value="cl_int *") IntBuffer errcode_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)errcode_ret, 1);
        }
        return CL10.nclCreateImage2D(context2, flags, image_format.address(), image_width, image_height, image_row_pitch, MemoryUtil.memAddressSafe(host_ptr), MemoryUtil.memAddressSafe(errcode_ret));
    }

    public static long nclCreateImage3D(long context2, long flags, long image_format, long image_width, long image_height, long image_depth, long image_row_pitch, long image_slice_pitch, long host_ptr, long errcode_ret) {
        long __functionAddress = CL.getICD().clCreateImage3D;
        if (Checks.CHECKS) {
            Checks.check(context2);
        }
        return JNI.callPJPPPPPPPPP(context2, flags, image_format, image_width, image_height, image_depth, image_row_pitch, image_slice_pitch, host_ptr, errcode_ret, __functionAddress);
    }

    @NativeType(value="cl_mem")
    public static long clCreateImage3D(@NativeType(value="cl_context") long context2, @NativeType(value="cl_mem_flags") long flags, @NativeType(value="cl_image_format const *") CLImageFormat image_format, @NativeType(value="size_t") long image_width, @NativeType(value="size_t") long image_height, @NativeType(value="size_t") long image_depth, @NativeType(value="size_t") long image_row_pitch, @NativeType(value="size_t") long image_slice_pitch, @Nullable @NativeType(value="void *") ByteBuffer host_ptr, @Nullable @NativeType(value="cl_int *") IntBuffer errcode_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)errcode_ret, 1);
        }
        return CL10.nclCreateImage3D(context2, flags, image_format.address(), image_width, image_height, image_depth, image_row_pitch, image_slice_pitch, MemoryUtil.memAddressSafe(host_ptr), MemoryUtil.memAddressSafe(errcode_ret));
    }

    @NativeType(value="cl_mem")
    public static long clCreateImage3D(@NativeType(value="cl_context") long context2, @NativeType(value="cl_mem_flags") long flags, @NativeType(value="cl_image_format const *") CLImageFormat image_format, @NativeType(value="size_t") long image_width, @NativeType(value="size_t") long image_height, @NativeType(value="size_t") long image_depth, @NativeType(value="size_t") long image_row_pitch, @NativeType(value="size_t") long image_slice_pitch, @Nullable @NativeType(value="void *") ShortBuffer host_ptr, @Nullable @NativeType(value="cl_int *") IntBuffer errcode_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)errcode_ret, 1);
        }
        return CL10.nclCreateImage3D(context2, flags, image_format.address(), image_width, image_height, image_depth, image_row_pitch, image_slice_pitch, MemoryUtil.memAddressSafe(host_ptr), MemoryUtil.memAddressSafe(errcode_ret));
    }

    @NativeType(value="cl_mem")
    public static long clCreateImage3D(@NativeType(value="cl_context") long context2, @NativeType(value="cl_mem_flags") long flags, @NativeType(value="cl_image_format const *") CLImageFormat image_format, @NativeType(value="size_t") long image_width, @NativeType(value="size_t") long image_height, @NativeType(value="size_t") long image_depth, @NativeType(value="size_t") long image_row_pitch, @NativeType(value="size_t") long image_slice_pitch, @Nullable @NativeType(value="void *") IntBuffer host_ptr, @Nullable @NativeType(value="cl_int *") IntBuffer errcode_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)errcode_ret, 1);
        }
        return CL10.nclCreateImage3D(context2, flags, image_format.address(), image_width, image_height, image_depth, image_row_pitch, image_slice_pitch, MemoryUtil.memAddressSafe(host_ptr), MemoryUtil.memAddressSafe(errcode_ret));
    }

    @NativeType(value="cl_mem")
    public static long clCreateImage3D(@NativeType(value="cl_context") long context2, @NativeType(value="cl_mem_flags") long flags, @NativeType(value="cl_image_format const *") CLImageFormat image_format, @NativeType(value="size_t") long image_width, @NativeType(value="size_t") long image_height, @NativeType(value="size_t") long image_depth, @NativeType(value="size_t") long image_row_pitch, @NativeType(value="size_t") long image_slice_pitch, @Nullable @NativeType(value="void *") FloatBuffer host_ptr, @Nullable @NativeType(value="cl_int *") IntBuffer errcode_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)errcode_ret, 1);
        }
        return CL10.nclCreateImage3D(context2, flags, image_format.address(), image_width, image_height, image_depth, image_row_pitch, image_slice_pitch, MemoryUtil.memAddressSafe(host_ptr), MemoryUtil.memAddressSafe(errcode_ret));
    }

    public static int nclGetSupportedImageFormats(long context2, long flags, int image_type, int num_entries, long image_formats, long num_image_formats) {
        long __functionAddress = CL.getICD().clGetSupportedImageFormats;
        if (Checks.CHECKS) {
            Checks.check(context2);
        }
        return JNI.callPJPPI(context2, flags, image_type, num_entries, image_formats, num_image_formats, __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clGetSupportedImageFormats(@NativeType(value="cl_context") long context2, @NativeType(value="cl_mem_flags") long flags, @NativeType(value="cl_mem_object_type") int image_type, @Nullable @NativeType(value="cl_image_format *") CLImageFormat.Buffer image_formats, @Nullable @NativeType(value="cl_uint *") IntBuffer num_image_formats) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)num_image_formats, 1);
        }
        return CL10.nclGetSupportedImageFormats(context2, flags, image_type, Checks.remainingSafe(image_formats), MemoryUtil.memAddressSafe(image_formats), MemoryUtil.memAddressSafe(num_image_formats));
    }

    public static int nclEnqueueReadImage(long command_queue, long image, int blocking_read, long origin2, long region, long row_pitch, long slice_pitch, long ptr, int num_events_in_wait_list, long event_wait_list, long event) {
        long __functionAddress = CL.getICD().clEnqueueReadImage;
        if (Checks.CHECKS) {
            Checks.check(command_queue);
            Checks.check(image);
        }
        return JNI.callPPPPPPPPPI(command_queue, image, blocking_read, origin2, region, row_pitch, slice_pitch, ptr, num_events_in_wait_list, event_wait_list, event, __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clEnqueueReadImage(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long image, @NativeType(value="cl_bool") boolean blocking_read, @NativeType(value="size_t const *") PointerBuffer origin2, @NativeType(value="size_t const *") PointerBuffer region, @NativeType(value="size_t") long row_pitch, @NativeType(value="size_t") long slice_pitch, @NativeType(value="void *") ByteBuffer ptr, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.check(origin2, 3);
            Checks.check(region, 3);
            Checks.checkSafe(event, 1);
        }
        return CL10.nclEnqueueReadImage(command_queue, image, blocking_read ? 1 : 0, MemoryUtil.memAddress(origin2), MemoryUtil.memAddress(region), row_pitch, slice_pitch, MemoryUtil.memAddress(ptr), Checks.remainingSafe(event_wait_list), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    @NativeType(value="cl_int")
    public static int clEnqueueReadImage(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long image, @NativeType(value="cl_bool") boolean blocking_read, @NativeType(value="size_t const *") PointerBuffer origin2, @NativeType(value="size_t const *") PointerBuffer region, @NativeType(value="size_t") long row_pitch, @NativeType(value="size_t") long slice_pitch, @NativeType(value="void *") ShortBuffer ptr, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.check(origin2, 3);
            Checks.check(region, 3);
            Checks.checkSafe(event, 1);
        }
        return CL10.nclEnqueueReadImage(command_queue, image, blocking_read ? 1 : 0, MemoryUtil.memAddress(origin2), MemoryUtil.memAddress(region), row_pitch, slice_pitch, MemoryUtil.memAddress(ptr), Checks.remainingSafe(event_wait_list), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    @NativeType(value="cl_int")
    public static int clEnqueueReadImage(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long image, @NativeType(value="cl_bool") boolean blocking_read, @NativeType(value="size_t const *") PointerBuffer origin2, @NativeType(value="size_t const *") PointerBuffer region, @NativeType(value="size_t") long row_pitch, @NativeType(value="size_t") long slice_pitch, @NativeType(value="void *") IntBuffer ptr, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.check(origin2, 3);
            Checks.check(region, 3);
            Checks.checkSafe(event, 1);
        }
        return CL10.nclEnqueueReadImage(command_queue, image, blocking_read ? 1 : 0, MemoryUtil.memAddress(origin2), MemoryUtil.memAddress(region), row_pitch, slice_pitch, MemoryUtil.memAddress(ptr), Checks.remainingSafe(event_wait_list), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    @NativeType(value="cl_int")
    public static int clEnqueueReadImage(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long image, @NativeType(value="cl_bool") boolean blocking_read, @NativeType(value="size_t const *") PointerBuffer origin2, @NativeType(value="size_t const *") PointerBuffer region, @NativeType(value="size_t") long row_pitch, @NativeType(value="size_t") long slice_pitch, @NativeType(value="void *") FloatBuffer ptr, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.check(origin2, 3);
            Checks.check(region, 3);
            Checks.checkSafe(event, 1);
        }
        return CL10.nclEnqueueReadImage(command_queue, image, blocking_read ? 1 : 0, MemoryUtil.memAddress(origin2), MemoryUtil.memAddress(region), row_pitch, slice_pitch, MemoryUtil.memAddress(ptr), Checks.remainingSafe(event_wait_list), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    @NativeType(value="cl_int")
    public static int clEnqueueReadImage(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long image, @NativeType(value="cl_bool") boolean blocking_read, @NativeType(value="size_t const *") PointerBuffer origin2, @NativeType(value="size_t const *") PointerBuffer region, @NativeType(value="size_t") long row_pitch, @NativeType(value="size_t") long slice_pitch, @NativeType(value="void *") DoubleBuffer ptr, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.check(origin2, 3);
            Checks.check(region, 3);
            Checks.checkSafe(event, 1);
        }
        return CL10.nclEnqueueReadImage(command_queue, image, blocking_read ? 1 : 0, MemoryUtil.memAddress(origin2), MemoryUtil.memAddress(region), row_pitch, slice_pitch, MemoryUtil.memAddress(ptr), Checks.remainingSafe(event_wait_list), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static int nclEnqueueWriteImage(long command_queue, long image, int blocking_write, long origin2, long region, long input_row_pitch, long input_slice_pitch, long ptr, int num_events_in_wait_list, long event_wait_list, long event) {
        long __functionAddress = CL.getICD().clEnqueueWriteImage;
        if (Checks.CHECKS) {
            Checks.check(command_queue);
            Checks.check(image);
        }
        return JNI.callPPPPPPPPPI(command_queue, image, blocking_write, origin2, region, input_row_pitch, input_slice_pitch, ptr, num_events_in_wait_list, event_wait_list, event, __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clEnqueueWriteImage(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long image, @NativeType(value="cl_bool") boolean blocking_write, @NativeType(value="size_t const *") PointerBuffer origin2, @NativeType(value="size_t const *") PointerBuffer region, @NativeType(value="size_t") long input_row_pitch, @NativeType(value="size_t") long input_slice_pitch, @NativeType(value="void const *") ByteBuffer ptr, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.check(origin2, 3);
            Checks.check(region, 3);
            Checks.checkSafe(event, 1);
        }
        return CL10.nclEnqueueWriteImage(command_queue, image, blocking_write ? 1 : 0, MemoryUtil.memAddress(origin2), MemoryUtil.memAddress(region), input_row_pitch, input_slice_pitch, MemoryUtil.memAddress(ptr), Checks.remainingSafe(event_wait_list), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    @NativeType(value="cl_int")
    public static int clEnqueueWriteImage(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long image, @NativeType(value="cl_bool") boolean blocking_write, @NativeType(value="size_t const *") PointerBuffer origin2, @NativeType(value="size_t const *") PointerBuffer region, @NativeType(value="size_t") long input_row_pitch, @NativeType(value="size_t") long input_slice_pitch, @NativeType(value="void const *") ShortBuffer ptr, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.check(origin2, 3);
            Checks.check(region, 3);
            Checks.checkSafe(event, 1);
        }
        return CL10.nclEnqueueWriteImage(command_queue, image, blocking_write ? 1 : 0, MemoryUtil.memAddress(origin2), MemoryUtil.memAddress(region), input_row_pitch, input_slice_pitch, MemoryUtil.memAddress(ptr), Checks.remainingSafe(event_wait_list), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    @NativeType(value="cl_int")
    public static int clEnqueueWriteImage(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long image, @NativeType(value="cl_bool") boolean blocking_write, @NativeType(value="size_t const *") PointerBuffer origin2, @NativeType(value="size_t const *") PointerBuffer region, @NativeType(value="size_t") long input_row_pitch, @NativeType(value="size_t") long input_slice_pitch, @NativeType(value="void const *") IntBuffer ptr, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.check(origin2, 3);
            Checks.check(region, 3);
            Checks.checkSafe(event, 1);
        }
        return CL10.nclEnqueueWriteImage(command_queue, image, blocking_write ? 1 : 0, MemoryUtil.memAddress(origin2), MemoryUtil.memAddress(region), input_row_pitch, input_slice_pitch, MemoryUtil.memAddress(ptr), Checks.remainingSafe(event_wait_list), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    @NativeType(value="cl_int")
    public static int clEnqueueWriteImage(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long image, @NativeType(value="cl_bool") boolean blocking_write, @NativeType(value="size_t const *") PointerBuffer origin2, @NativeType(value="size_t const *") PointerBuffer region, @NativeType(value="size_t") long input_row_pitch, @NativeType(value="size_t") long input_slice_pitch, @NativeType(value="void const *") FloatBuffer ptr, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.check(origin2, 3);
            Checks.check(region, 3);
            Checks.checkSafe(event, 1);
        }
        return CL10.nclEnqueueWriteImage(command_queue, image, blocking_write ? 1 : 0, MemoryUtil.memAddress(origin2), MemoryUtil.memAddress(region), input_row_pitch, input_slice_pitch, MemoryUtil.memAddress(ptr), Checks.remainingSafe(event_wait_list), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    @NativeType(value="cl_int")
    public static int clEnqueueWriteImage(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long image, @NativeType(value="cl_bool") boolean blocking_write, @NativeType(value="size_t const *") PointerBuffer origin2, @NativeType(value="size_t const *") PointerBuffer region, @NativeType(value="size_t") long input_row_pitch, @NativeType(value="size_t") long input_slice_pitch, @NativeType(value="void const *") DoubleBuffer ptr, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.check(origin2, 3);
            Checks.check(region, 3);
            Checks.checkSafe(event, 1);
        }
        return CL10.nclEnqueueWriteImage(command_queue, image, blocking_write ? 1 : 0, MemoryUtil.memAddress(origin2), MemoryUtil.memAddress(region), input_row_pitch, input_slice_pitch, MemoryUtil.memAddress(ptr), Checks.remainingSafe(event_wait_list), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static int nclEnqueueCopyImage(long command_queue, long src_image, long dst_image, long src_origin, long dst_origin, long region, int num_events_in_wait_list, long event_wait_list, long event) {
        long __functionAddress = CL.getICD().clEnqueueCopyImage;
        if (Checks.CHECKS) {
            Checks.check(command_queue);
            Checks.check(src_image);
            Checks.check(dst_image);
        }
        return JNI.callPPPPPPPPI(command_queue, src_image, dst_image, src_origin, dst_origin, region, num_events_in_wait_list, event_wait_list, event, __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clEnqueueCopyImage(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long src_image, @NativeType(value="cl_mem") long dst_image, @NativeType(value="size_t const *") PointerBuffer src_origin, @NativeType(value="size_t const *") PointerBuffer dst_origin, @NativeType(value="size_t const *") PointerBuffer region, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.check(src_origin, 3);
            Checks.check(dst_origin, 3);
            Checks.check(region, 3);
            Checks.checkSafe(event, 1);
        }
        return CL10.nclEnqueueCopyImage(command_queue, src_image, dst_image, MemoryUtil.memAddress(src_origin), MemoryUtil.memAddress(dst_origin), MemoryUtil.memAddress(region), Checks.remainingSafe(event_wait_list), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static int nclEnqueueCopyImageToBuffer(long command_queue, long src_image, long dst_buffer, long src_origin, long region, long dst_offset, int num_events_in_wait_list, long event_wait_list, long event) {
        long __functionAddress = CL.getICD().clEnqueueCopyImageToBuffer;
        if (Checks.CHECKS) {
            Checks.check(command_queue);
            Checks.check(src_image);
            Checks.check(dst_buffer);
        }
        return JNI.callPPPPPPPPI(command_queue, src_image, dst_buffer, src_origin, region, dst_offset, num_events_in_wait_list, event_wait_list, event, __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clEnqueueCopyImageToBuffer(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long src_image, @NativeType(value="cl_mem") long dst_buffer, @NativeType(value="size_t const *") PointerBuffer src_origin, @NativeType(value="size_t const *") PointerBuffer region, @NativeType(value="size_t") long dst_offset, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.check(src_origin, 3);
            Checks.check(region, 3);
            Checks.checkSafe(event, 1);
        }
        return CL10.nclEnqueueCopyImageToBuffer(command_queue, src_image, dst_buffer, MemoryUtil.memAddress(src_origin), MemoryUtil.memAddress(region), dst_offset, Checks.remainingSafe(event_wait_list), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static int nclEnqueueCopyBufferToImage(long command_queue, long src_buffer, long dst_image, long src_offset, long dst_origin, long region, int num_events_in_wait_list, long event_wait_list, long event) {
        long __functionAddress = CL.getICD().clEnqueueCopyBufferToImage;
        if (Checks.CHECKS) {
            Checks.check(command_queue);
            Checks.check(src_buffer);
            Checks.check(dst_image);
        }
        return JNI.callPPPPPPPPI(command_queue, src_buffer, dst_image, src_offset, dst_origin, region, num_events_in_wait_list, event_wait_list, event, __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clEnqueueCopyBufferToImage(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long src_buffer, @NativeType(value="cl_mem") long dst_image, @NativeType(value="size_t") long src_offset, @NativeType(value="size_t const *") PointerBuffer dst_origin, @NativeType(value="size_t const *") PointerBuffer region, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.check(dst_origin, 3);
            Checks.check(region, 3);
            Checks.checkSafe(event, 1);
        }
        return CL10.nclEnqueueCopyBufferToImage(command_queue, src_buffer, dst_image, src_offset, MemoryUtil.memAddress(dst_origin), MemoryUtil.memAddress(region), Checks.remainingSafe(event_wait_list), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static long nclEnqueueMapImage(long command_queue, long image, int blocking_map, long map_flags, long origin2, long region, long image_row_pitch, long image_slice_pitch, int num_events_in_wait_list, long event_wait_list, long event, long errcode_ret) {
        long __functionAddress = CL.getICD().clEnqueueMapImage;
        if (Checks.CHECKS) {
            Checks.check(command_queue);
            Checks.check(image);
        }
        return JNI.callPPJPPPPPPPP(command_queue, image, blocking_map, map_flags, origin2, region, image_row_pitch, image_slice_pitch, num_events_in_wait_list, event_wait_list, event, errcode_ret, __functionAddress);
    }

    @Nullable
    @NativeType(value="void *")
    public static ByteBuffer clEnqueueMapImage(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long image, @NativeType(value="cl_bool") boolean blocking_map, @NativeType(value="cl_map_flags") long map_flags, @NativeType(value="size_t const *") PointerBuffer origin2, @NativeType(value="size_t const *") PointerBuffer region, @NativeType(value="size_t *") PointerBuffer image_row_pitch, @Nullable @NativeType(value="size_t *") PointerBuffer image_slice_pitch, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event, @Nullable @NativeType(value="cl_int *") IntBuffer errcode_ret, @Nullable ByteBuffer old_buffer) {
        if (Checks.CHECKS) {
            Checks.check(origin2, 3);
            Checks.check(region, 3);
            Checks.check(image_row_pitch, 1);
            Checks.checkSafe(image_slice_pitch, 1);
            Checks.checkSafe(event, 1);
            Checks.checkSafe((Buffer)errcode_ret, 1);
        }
        long __result = CL10.nclEnqueueMapImage(command_queue, image, blocking_map ? 1 : 0, map_flags, MemoryUtil.memAddress(origin2), MemoryUtil.memAddress(region), MemoryUtil.memAddress(image_row_pitch), MemoryUtil.memAddressSafe(image_slice_pitch), Checks.remainingSafe(event_wait_list), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event), MemoryUtil.memAddressSafe(errcode_ret));
        int length = (int)CL10.getMemObjectInfoPointer(image, 4354);
        return APIUtil.apiGetMappedBuffer(old_buffer, __result, length);
    }

    @Nullable
    @NativeType(value="void *")
    public static ByteBuffer clEnqueueMapImage(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long image, @NativeType(value="cl_bool") boolean blocking_map, @NativeType(value="cl_map_flags") long map_flags, @NativeType(value="size_t const *") PointerBuffer origin2, @NativeType(value="size_t const *") PointerBuffer region, @NativeType(value="size_t *") PointerBuffer image_row_pitch, @Nullable @NativeType(value="size_t *") PointerBuffer image_slice_pitch, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event, @Nullable @NativeType(value="cl_int *") IntBuffer errcode_ret, long length, @Nullable ByteBuffer old_buffer) {
        if (Checks.CHECKS) {
            Checks.check(origin2, 3);
            Checks.check(region, 3);
            Checks.check(image_row_pitch, 1);
            Checks.checkSafe(image_slice_pitch, 1);
            Checks.checkSafe(event, 1);
            Checks.checkSafe((Buffer)errcode_ret, 1);
        }
        long __result = CL10.nclEnqueueMapImage(command_queue, image, blocking_map ? 1 : 0, map_flags, MemoryUtil.memAddress(origin2), MemoryUtil.memAddress(region), MemoryUtil.memAddress(image_row_pitch), MemoryUtil.memAddressSafe(image_slice_pitch), Checks.remainingSafe(event_wait_list), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event), MemoryUtil.memAddressSafe(errcode_ret));
        return APIUtil.apiGetMappedBuffer(old_buffer, __result, (int)length);
    }

    public static int nclGetImageInfo(long image, int param_name, long param_value_size, long param_value, long param_value_size_ret) {
        long __functionAddress = CL.getICD().clGetImageInfo;
        if (Checks.CHECKS) {
            Checks.check(image);
        }
        return JNI.callPPPPI(image, param_name, param_value_size, param_value, param_value_size_ret, __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clGetImageInfo(@NativeType(value="cl_mem") long image, @NativeType(value="cl_image_info") int param_name, @Nullable @NativeType(value="void *") ByteBuffer param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe(param_value_size_ret, 1);
        }
        return CL10.nclGetImageInfo(image, param_name, Checks.remainingSafe(param_value), MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    @NativeType(value="cl_int")
    public static int clGetImageInfo(@NativeType(value="cl_mem") long image, @NativeType(value="cl_image_info") int param_name, @Nullable @NativeType(value="void *") IntBuffer param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe(param_value_size_ret, 1);
        }
        return CL10.nclGetImageInfo(image, param_name, Integer.toUnsignedLong(Checks.remainingSafe(param_value)) << 2, MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    @NativeType(value="cl_int")
    public static int clGetImageInfo(@NativeType(value="cl_mem") long image, @NativeType(value="cl_image_info") int param_name, @Nullable @NativeType(value="void *") PointerBuffer param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe(param_value_size_ret, 1);
        }
        return CL10.nclGetImageInfo(image, param_name, Integer.toUnsignedLong(Checks.remainingSafe(param_value)) << MemoryStack.POINTER_SHIFT, MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    @NativeType(value="cl_int")
    public static int clRetainMemObject(@NativeType(value="cl_mem") long memobj) {
        long __functionAddress = CL.getICD().clRetainMemObject;
        if (Checks.CHECKS) {
            Checks.check(memobj);
        }
        return JNI.callPI(memobj, __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clReleaseMemObject(@NativeType(value="cl_mem") long memobj) {
        long __functionAddress = CL.getICD().clReleaseMemObject;
        if (Checks.CHECKS) {
            Checks.check(memobj);
        }
        return JNI.callPI(memobj, __functionAddress);
    }

    public static int nclEnqueueUnmapMemObject(long command_queue, long memobj, long mapped_ptr, int num_events_in_wait_list, long event_wait_list, long event) {
        long __functionAddress = CL.getICD().clEnqueueUnmapMemObject;
        if (Checks.CHECKS) {
            Checks.check(command_queue);
            Checks.check(memobj);
        }
        return JNI.callPPPPPI(command_queue, memobj, mapped_ptr, num_events_in_wait_list, event_wait_list, event, __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clEnqueueUnmapMemObject(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long memobj, @NativeType(value="void *") ByteBuffer mapped_ptr, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.checkSafe(event, 1);
        }
        return CL10.nclEnqueueUnmapMemObject(command_queue, memobj, MemoryUtil.memAddress(mapped_ptr), Checks.remainingSafe(event_wait_list), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static int nclGetMemObjectInfo(long memobj, int param_name, long param_value_size, long param_value, long param_value_size_ret) {
        long __functionAddress = CL.getICD().clGetMemObjectInfo;
        if (Checks.CHECKS) {
            Checks.check(memobj);
        }
        return JNI.callPPPPI(memobj, param_name, param_value_size, param_value, param_value_size_ret, __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clGetMemObjectInfo(@NativeType(value="cl_mem") long memobj, @NativeType(value="cl_mem_info") int param_name, @Nullable @NativeType(value="void *") ByteBuffer param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe(param_value_size_ret, 1);
        }
        return CL10.nclGetMemObjectInfo(memobj, param_name, Checks.remainingSafe(param_value), MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    @NativeType(value="cl_int")
    public static int clGetMemObjectInfo(@NativeType(value="cl_mem") long memobj, @NativeType(value="cl_mem_info") int param_name, @Nullable @NativeType(value="void *") IntBuffer param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe(param_value_size_ret, 1);
        }
        return CL10.nclGetMemObjectInfo(memobj, param_name, Integer.toUnsignedLong(Checks.remainingSafe(param_value)) << 2, MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    @NativeType(value="cl_int")
    public static int clGetMemObjectInfo(@NativeType(value="cl_mem") long memobj, @NativeType(value="cl_mem_info") int param_name, @Nullable @NativeType(value="void *") LongBuffer param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe(param_value_size_ret, 1);
        }
        return CL10.nclGetMemObjectInfo(memobj, param_name, Integer.toUnsignedLong(Checks.remainingSafe(param_value)) << 3, MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    @NativeType(value="cl_int")
    public static int clGetMemObjectInfo(@NativeType(value="cl_mem") long memobj, @NativeType(value="cl_mem_info") int param_name, @Nullable @NativeType(value="void *") PointerBuffer param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe(param_value_size_ret, 1);
        }
        return CL10.nclGetMemObjectInfo(memobj, param_name, Integer.toUnsignedLong(Checks.remainingSafe(param_value)) << MemoryStack.POINTER_SHIFT, MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    public static long nclCreateSampler(long context2, int normalized_coords, int addressing_mode, int filter_mode, long errcode_ret) {
        long __functionAddress = CL.getICD().clCreateSampler;
        if (Checks.CHECKS) {
            Checks.check(context2);
        }
        return JNI.callPPP(context2, normalized_coords, addressing_mode, filter_mode, errcode_ret, __functionAddress);
    }

    @NativeType(value="cl_sampler")
    public static long clCreateSampler(@NativeType(value="cl_context") long context2, @NativeType(value="cl_bool") boolean normalized_coords, @NativeType(value="cl_addressing_mode") int addressing_mode, @NativeType(value="cl_filter_mode") int filter_mode, @Nullable @NativeType(value="cl_int *") IntBuffer errcode_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)errcode_ret, 1);
        }
        return CL10.nclCreateSampler(context2, normalized_coords ? 1 : 0, addressing_mode, filter_mode, MemoryUtil.memAddressSafe(errcode_ret));
    }

    @NativeType(value="cl_int")
    public static int clRetainSampler(@NativeType(value="cl_sampler") long sampler) {
        long __functionAddress = CL.getICD().clRetainSampler;
        if (Checks.CHECKS) {
            Checks.check(sampler);
        }
        return JNI.callPI(sampler, __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clReleaseSampler(@NativeType(value="cl_sampler") long sampler) {
        long __functionAddress = CL.getICD().clReleaseSampler;
        if (Checks.CHECKS) {
            Checks.check(sampler);
        }
        return JNI.callPI(sampler, __functionAddress);
    }

    public static int nclGetSamplerInfo(long sampler, int param_name, long param_value_size, long param_value, long param_value_size_ret) {
        long __functionAddress = CL.getICD().clGetSamplerInfo;
        if (Checks.CHECKS) {
            Checks.check(sampler);
        }
        return JNI.callPPPPI(sampler, param_name, param_value_size, param_value, param_value_size_ret, __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clGetSamplerInfo(@NativeType(value="cl_sampler") long sampler, @NativeType(value="cl_sampler_info") int param_name, @Nullable @NativeType(value="void *") ByteBuffer param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe(param_value_size_ret, 1);
        }
        return CL10.nclGetSamplerInfo(sampler, param_name, Checks.remainingSafe(param_value), MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    @NativeType(value="cl_int")
    public static int clGetSamplerInfo(@NativeType(value="cl_sampler") long sampler, @NativeType(value="cl_sampler_info") int param_name, @Nullable @NativeType(value="void *") IntBuffer param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe(param_value_size_ret, 1);
        }
        return CL10.nclGetSamplerInfo(sampler, param_name, Integer.toUnsignedLong(Checks.remainingSafe(param_value)) << 2, MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    @NativeType(value="cl_int")
    public static int clGetSamplerInfo(@NativeType(value="cl_sampler") long sampler, @NativeType(value="cl_sampler_info") int param_name, @Nullable @NativeType(value="void *") PointerBuffer param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe(param_value_size_ret, 1);
        }
        return CL10.nclGetSamplerInfo(sampler, param_name, Integer.toUnsignedLong(Checks.remainingSafe(param_value)) << MemoryStack.POINTER_SHIFT, MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    public static long nclCreateProgramWithSource(long context2, int count2, long strings, long lengths, long errcode_ret) {
        long __functionAddress = CL.getICD().clCreateProgramWithSource;
        if (Checks.CHECKS) {
            Checks.check(context2);
        }
        return JNI.callPPPPP(context2, count2, strings, lengths, errcode_ret, __functionAddress);
    }

    @NativeType(value="cl_program")
    public static long clCreateProgramWithSource(@NativeType(value="cl_context") long context2, @NativeType(value="cl_char const **") PointerBuffer strings, @Nullable @NativeType(value="size_t const *") PointerBuffer lengths, @Nullable @NativeType(value="cl_int *") IntBuffer errcode_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe(lengths, strings.remaining());
            Checks.checkSafe((Buffer)errcode_ret, 1);
        }
        return CL10.nclCreateProgramWithSource(context2, strings.remaining(), MemoryUtil.memAddress(strings), MemoryUtil.memAddressSafe(lengths), MemoryUtil.memAddressSafe(errcode_ret));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="cl_program")
    public static long clCreateProgramWithSource(@NativeType(value="cl_context") long context2, @NativeType(value="cl_char const **") CharSequence[] strings, @Nullable @NativeType(value="cl_int *") IntBuffer errcode_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)errcode_ret, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            long stringsAddress = APIUtil.apiArrayp(stack, MemoryUtil::memUTF8, strings);
            long __result = CL10.nclCreateProgramWithSource(context2, strings.length, stringsAddress, stringsAddress - (long)(strings.length << MemoryStack.POINTER_SHIFT), MemoryUtil.memAddressSafe(errcode_ret));
            APIUtil.apiArrayFree(stringsAddress, strings.length);
            long l = __result;
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="cl_program")
    public static long clCreateProgramWithSource(@NativeType(value="cl_context") long context2, @NativeType(value="cl_char const **") CharSequence string, @Nullable @NativeType(value="cl_int *") IntBuffer errcode_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)errcode_ret, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            long stringsAddress = APIUtil.apiArrayp(stack, MemoryUtil::memUTF8, string);
            long __result = CL10.nclCreateProgramWithSource(context2, 1, stringsAddress, stringsAddress - (long)MemoryStack.POINTER_SIZE, MemoryUtil.memAddressSafe(errcode_ret));
            APIUtil.apiArrayFree(stringsAddress, 1);
            long l = __result;
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nclCreateProgramWithBinary(long context2, int num_devices, long device_list, long lengths, long binaries, long binary_status, long errcode_ret) {
        long __functionAddress = CL.getICD().clCreateProgramWithBinary;
        if (Checks.CHECKS) {
            Checks.check(context2);
        }
        return JNI.callPPPPPPP(context2, num_devices, device_list, lengths, binaries, binary_status, errcode_ret, __functionAddress);
    }

    @NativeType(value="cl_program")
    public static long clCreateProgramWithBinary(@NativeType(value="cl_context") long context2, @NativeType(value="cl_device_id const *") PointerBuffer device_list, @NativeType(value="size_t const *") PointerBuffer lengths, @NativeType(value="cl_uchar const **") PointerBuffer binaries, @Nullable @NativeType(value="cl_int *") IntBuffer binary_status, @Nullable @NativeType(value="cl_int *") IntBuffer errcode_ret) {
        if (Checks.CHECKS) {
            Checks.check(device_list, binaries.remaining());
            Checks.check(lengths, binaries.remaining());
            Checks.checkSafe((Buffer)binary_status, binaries.remaining());
            Checks.checkSafe((Buffer)errcode_ret, 1);
        }
        return CL10.nclCreateProgramWithBinary(context2, binaries.remaining(), MemoryUtil.memAddress(device_list), MemoryUtil.memAddress(lengths), MemoryUtil.memAddress(binaries), MemoryUtil.memAddressSafe(binary_status), MemoryUtil.memAddressSafe(errcode_ret));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="cl_program")
    public static long clCreateProgramWithBinary(@NativeType(value="cl_context") long context2, @NativeType(value="cl_device_id const *") PointerBuffer device_list, @NativeType(value="cl_uchar const **") ByteBuffer[] binaries, @Nullable @NativeType(value="cl_int *") IntBuffer binary_status, @Nullable @NativeType(value="cl_int *") IntBuffer errcode_ret) {
        if (Checks.CHECKS) {
            Checks.check(device_list, binaries.length);
            Checks.checkSafe((Buffer)binary_status, binaries.length);
            Checks.checkSafe((Buffer)errcode_ret, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            long binariesAddress = APIUtil.apiArrayp(stack, binaries);
            long l = CL10.nclCreateProgramWithBinary(context2, binaries.length, MemoryUtil.memAddress(device_list), binariesAddress - (long)(binaries.length << MemoryStack.POINTER_SHIFT), binariesAddress, MemoryUtil.memAddressSafe(binary_status), MemoryUtil.memAddressSafe(errcode_ret));
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="cl_program")
    public static long clCreateProgramWithBinary(@NativeType(value="cl_context") long context2, @NativeType(value="cl_device_id const *") PointerBuffer device_list, @NativeType(value="cl_uchar const **") ByteBuffer binary, @Nullable @NativeType(value="cl_int *") IntBuffer binary_status, @Nullable @NativeType(value="cl_int *") IntBuffer errcode_ret) {
        if (Checks.CHECKS) {
            Checks.check(device_list, 1);
            Checks.checkSafe((Buffer)binary_status, 1);
            Checks.checkSafe((Buffer)errcode_ret, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            long binariesAddress = APIUtil.apiArrayp(stack, binary);
            long l = CL10.nclCreateProgramWithBinary(context2, 1, MemoryUtil.memAddress(device_list), binariesAddress - (long)MemoryStack.POINTER_SIZE, binariesAddress, MemoryUtil.memAddressSafe(binary_status), MemoryUtil.memAddressSafe(errcode_ret));
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="cl_int")
    public static int clRetainProgram(@NativeType(value="cl_program") long program) {
        long __functionAddress = CL.getICD().clRetainProgram;
        if (Checks.CHECKS) {
            Checks.check(program);
        }
        return JNI.callPI(program, __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clReleaseProgram(@NativeType(value="cl_program") long program) {
        long __functionAddress = CL.getICD().clReleaseProgram;
        if (Checks.CHECKS) {
            Checks.check(program);
        }
        return JNI.callPI(program, __functionAddress);
    }

    public static int nclBuildProgram(long program, int num_devices, long device_list, long options, long pfn_notify, long user_data) {
        long __functionAddress = CL.getICD().clBuildProgram;
        if (Checks.CHECKS) {
            Checks.check(program);
        }
        return JNI.callPPPPPI(program, num_devices, device_list, options, pfn_notify, user_data, __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clBuildProgram(@NativeType(value="cl_program") long program, @Nullable @NativeType(value="cl_device_id const *") PointerBuffer device_list, @NativeType(value="cl_char const *") ByteBuffer options, @Nullable @NativeType(value="void (*) (cl_program, void *)") CLProgramCallbackI pfn_notify, @NativeType(value="void *") long user_data) {
        if (Checks.CHECKS) {
            Checks.checkNT1(options);
        }
        return CL10.nclBuildProgram(program, Checks.remainingSafe(device_list), MemoryUtil.memAddressSafe(device_list), MemoryUtil.memAddress(options), MemoryUtil.memAddressSafe(pfn_notify), user_data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="cl_int")
    public static int clBuildProgram(@NativeType(value="cl_program") long program, @Nullable @NativeType(value="cl_device_id const *") PointerBuffer device_list, @NativeType(value="cl_char const *") CharSequence options, @Nullable @NativeType(value="void (*) (cl_program, void *)") CLProgramCallbackI pfn_notify, @NativeType(value="void *") long user_data) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(options, true);
            long optionsEncoded = stack.getPointerAddress();
            int n = CL10.nclBuildProgram(program, Checks.remainingSafe(device_list), MemoryUtil.memAddressSafe(device_list), optionsEncoded, MemoryUtil.memAddressSafe(pfn_notify), user_data);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="cl_int")
    public static int clBuildProgram(@NativeType(value="cl_program") long program, @NativeType(value="cl_device_id const *") long device2, @NativeType(value="cl_char const *") CharSequence options, @Nullable @NativeType(value="void (*) (cl_program, void *)") CLProgramCallbackI pfn_notify, @NativeType(value="void *") long user_data) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(options, true);
            long optionsEncoded = stack.getPointerAddress();
            PointerBuffer device_list = stack.pointers(device2);
            int n = CL10.nclBuildProgram(program, 1, MemoryUtil.memAddress(device_list), optionsEncoded, MemoryUtil.memAddressSafe(pfn_notify), user_data);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="cl_int")
    public static int clUnloadCompiler() {
        long __functionAddress = CL.getICD().clUnloadCompiler;
        return JNI.callI(__functionAddress);
    }

    public static int nclGetProgramInfo(long program, int param_name, long param_value_size, long param_value, long param_value_size_ret) {
        long __functionAddress = CL.getICD().clGetProgramInfo;
        if (Checks.CHECKS) {
            Checks.check(program);
        }
        return JNI.callPPPPI(program, param_name, param_value_size, param_value, param_value_size_ret, __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clGetProgramInfo(@NativeType(value="cl_program") long program, @NativeType(value="cl_program_info") int param_name, @Nullable @NativeType(value="void *") ByteBuffer param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe(param_value_size_ret, 1);
        }
        return CL10.nclGetProgramInfo(program, param_name, Checks.remainingSafe(param_value), MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    @NativeType(value="cl_int")
    public static int clGetProgramInfo(@NativeType(value="cl_program") long program, @NativeType(value="cl_program_info") int param_name, @Nullable @NativeType(value="void *") IntBuffer param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe(param_value_size_ret, 1);
        }
        return CL10.nclGetProgramInfo(program, param_name, Integer.toUnsignedLong(Checks.remainingSafe(param_value)) << 2, MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    @NativeType(value="cl_int")
    public static int clGetProgramInfo(@NativeType(value="cl_program") long program, @NativeType(value="cl_program_info") int param_name, @Nullable @NativeType(value="void *") PointerBuffer param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe(param_value_size_ret, 1);
        }
        return CL10.nclGetProgramInfo(program, param_name, Integer.toUnsignedLong(Checks.remainingSafe(param_value)) << MemoryStack.POINTER_SHIFT, MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    public static int nclGetProgramBuildInfo(long program, long device2, int param_name, long param_value_size, long param_value, long param_value_size_ret) {
        long __functionAddress = CL.getICD().clGetProgramBuildInfo;
        if (Checks.CHECKS) {
            Checks.check(program);
            Checks.check(device2);
        }
        return JNI.callPPPPPI(program, device2, param_name, param_value_size, param_value, param_value_size_ret, __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clGetProgramBuildInfo(@NativeType(value="cl_program") long program, @NativeType(value="cl_device_id") long device2, @NativeType(value="cl_program_info") int param_name, @Nullable @NativeType(value="void *") ByteBuffer param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe(param_value_size_ret, 1);
        }
        return CL10.nclGetProgramBuildInfo(program, device2, param_name, Checks.remainingSafe(param_value), MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    @NativeType(value="cl_int")
    public static int clGetProgramBuildInfo(@NativeType(value="cl_program") long program, @NativeType(value="cl_device_id") long device2, @NativeType(value="cl_program_info") int param_name, @Nullable @NativeType(value="void *") IntBuffer param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe(param_value_size_ret, 1);
        }
        return CL10.nclGetProgramBuildInfo(program, device2, param_name, Integer.toUnsignedLong(Checks.remainingSafe(param_value)) << 2, MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    @NativeType(value="cl_int")
    public static int clGetProgramBuildInfo(@NativeType(value="cl_program") long program, @NativeType(value="cl_device_id") long device2, @NativeType(value="cl_program_info") int param_name, @Nullable @NativeType(value="void *") PointerBuffer param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe(param_value_size_ret, 1);
        }
        return CL10.nclGetProgramBuildInfo(program, device2, param_name, Integer.toUnsignedLong(Checks.remainingSafe(param_value)) << MemoryStack.POINTER_SHIFT, MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    public static long nclCreateKernel(long program, long kernel_name, long errcode_ret) {
        long __functionAddress = CL.getICD().clCreateKernel;
        if (Checks.CHECKS) {
            Checks.check(program);
        }
        return JNI.callPPPP(program, kernel_name, errcode_ret, __functionAddress);
    }

    @NativeType(value="cl_kernel")
    public static long clCreateKernel(@NativeType(value="cl_program") long program, @NativeType(value="cl_char const *") ByteBuffer kernel_name, @Nullable @NativeType(value="cl_int *") IntBuffer errcode_ret) {
        if (Checks.CHECKS) {
            Checks.checkNT1(kernel_name);
            Checks.checkSafe((Buffer)errcode_ret, 1);
        }
        return CL10.nclCreateKernel(program, MemoryUtil.memAddress(kernel_name), MemoryUtil.memAddressSafe(errcode_ret));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="cl_kernel")
    public static long clCreateKernel(@NativeType(value="cl_program") long program, @NativeType(value="cl_char const *") CharSequence kernel_name, @Nullable @NativeType(value="cl_int *") IntBuffer errcode_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)errcode_ret, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(kernel_name, true);
            long kernel_nameEncoded = stack.getPointerAddress();
            long l = CL10.nclCreateKernel(program, kernel_nameEncoded, MemoryUtil.memAddressSafe(errcode_ret));
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nclCreateKernelsInProgram(long program, int num_kernels, long kernels, long num_kernels_ret) {
        long __functionAddress = CL.getICD().clCreateKernelsInProgram;
        if (Checks.CHECKS) {
            Checks.check(program);
        }
        return JNI.callPPPI(program, num_kernels, kernels, num_kernels_ret, __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clCreateKernelsInProgram(@NativeType(value="cl_program") long program, @Nullable @NativeType(value="cl_kernel *") PointerBuffer kernels, @Nullable @NativeType(value="cl_uint *") IntBuffer num_kernels_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)num_kernels_ret, 1);
        }
        return CL10.nclCreateKernelsInProgram(program, Checks.remainingSafe(kernels), MemoryUtil.memAddressSafe(kernels), MemoryUtil.memAddressSafe(num_kernels_ret));
    }

    @NativeType(value="cl_int")
    public static int clRetainKernel(@NativeType(value="cl_kernel") long kernel) {
        long __functionAddress = CL.getICD().clRetainKernel;
        if (Checks.CHECKS) {
            Checks.check(kernel);
        }
        return JNI.callPI(kernel, __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clReleaseKernel(@NativeType(value="cl_kernel") long kernel) {
        long __functionAddress = CL.getICD().clReleaseKernel;
        if (Checks.CHECKS) {
            Checks.check(kernel);
        }
        return JNI.callPI(kernel, __functionAddress);
    }

    public static int nclSetKernelArg(long kernel, int arg_index, long arg_size, long arg_value) {
        long __functionAddress = CL.getICD().clSetKernelArg;
        if (Checks.CHECKS) {
            Checks.check(kernel);
        }
        return JNI.callPPPI(kernel, arg_index, arg_size, arg_value, __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clSetKernelArg(@NativeType(value="cl_kernel") long kernel, @NativeType(value="cl_uint") int arg_index, @NativeType(value="size_t") long arg_size) {
        return CL10.nclSetKernelArg(kernel, arg_index, arg_size, 0L);
    }

    @NativeType(value="cl_int")
    public static int clSetKernelArg(@NativeType(value="cl_kernel") long kernel, @NativeType(value="cl_uint") int arg_index, @NativeType(value="void const *") ByteBuffer arg_value) {
        return CL10.nclSetKernelArg(kernel, arg_index, arg_value.remaining(), MemoryUtil.memAddress(arg_value));
    }

    @NativeType(value="cl_int")
    public static int clSetKernelArg(@NativeType(value="cl_kernel") long kernel, @NativeType(value="cl_uint") int arg_index, @NativeType(value="void const *") ShortBuffer arg_value) {
        return CL10.nclSetKernelArg(kernel, arg_index, Integer.toUnsignedLong(arg_value.remaining()) << 1, MemoryUtil.memAddress(arg_value));
    }

    @NativeType(value="cl_int")
    public static int clSetKernelArg(@NativeType(value="cl_kernel") long kernel, @NativeType(value="cl_uint") int arg_index, @NativeType(value="void const *") IntBuffer arg_value) {
        return CL10.nclSetKernelArg(kernel, arg_index, Integer.toUnsignedLong(arg_value.remaining()) << 2, MemoryUtil.memAddress(arg_value));
    }

    @NativeType(value="cl_int")
    public static int clSetKernelArg(@NativeType(value="cl_kernel") long kernel, @NativeType(value="cl_uint") int arg_index, @NativeType(value="void const *") LongBuffer arg_value) {
        return CL10.nclSetKernelArg(kernel, arg_index, Integer.toUnsignedLong(arg_value.remaining()) << 3, MemoryUtil.memAddress(arg_value));
    }

    @NativeType(value="cl_int")
    public static int clSetKernelArg(@NativeType(value="cl_kernel") long kernel, @NativeType(value="cl_uint") int arg_index, @NativeType(value="void const *") FloatBuffer arg_value) {
        return CL10.nclSetKernelArg(kernel, arg_index, Integer.toUnsignedLong(arg_value.remaining()) << 2, MemoryUtil.memAddress(arg_value));
    }

    @NativeType(value="cl_int")
    public static int clSetKernelArg(@NativeType(value="cl_kernel") long kernel, @NativeType(value="cl_uint") int arg_index, @NativeType(value="void const *") DoubleBuffer arg_value) {
        return CL10.nclSetKernelArg(kernel, arg_index, Integer.toUnsignedLong(arg_value.remaining()) << 3, MemoryUtil.memAddress(arg_value));
    }

    @NativeType(value="cl_int")
    public static int clSetKernelArg(@NativeType(value="cl_kernel") long kernel, @NativeType(value="cl_uint") int arg_index, @NativeType(value="void const *") PointerBuffer arg_value) {
        return CL10.nclSetKernelArg(kernel, arg_index, Integer.toUnsignedLong(arg_value.remaining()) << MemoryStack.POINTER_SHIFT, MemoryUtil.memAddress(arg_value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="cl_int")
    public static int clSetKernelArg1b(@NativeType(value="cl_kernel") long kernel, @NativeType(value="cl_uint") int arg_index, @NativeType(value="void const *") byte arg0) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer arg_value = stack.bytes(arg0);
            int n = CL10.nclSetKernelArg(kernel, arg_index, 1L, MemoryUtil.memAddress(arg_value));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="cl_int")
    public static int clSetKernelArg2b(@NativeType(value="cl_kernel") long kernel, @NativeType(value="cl_uint") int arg_index, @NativeType(value="void const *") byte arg0, byte arg1) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer arg_value = stack.bytes(arg0, arg1);
            int n = CL10.nclSetKernelArg(kernel, arg_index, 2L, MemoryUtil.memAddress(arg_value));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="cl_int")
    public static int clSetKernelArg4b(@NativeType(value="cl_kernel") long kernel, @NativeType(value="cl_uint") int arg_index, @NativeType(value="void const *") byte arg0, byte arg1, byte arg2, byte arg3) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer arg_value = stack.bytes(arg0, arg1, arg2, arg3);
            int n = CL10.nclSetKernelArg(kernel, arg_index, 4L, MemoryUtil.memAddress(arg_value));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="cl_int")
    public static int clSetKernelArg1s(@NativeType(value="cl_kernel") long kernel, @NativeType(value="cl_uint") int arg_index, @NativeType(value="void const *") short arg0) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ShortBuffer arg_value = stack.shorts(arg0);
            int n = CL10.nclSetKernelArg(kernel, arg_index, 2L, MemoryUtil.memAddress(arg_value));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="cl_int")
    public static int clSetKernelArg2s(@NativeType(value="cl_kernel") long kernel, @NativeType(value="cl_uint") int arg_index, @NativeType(value="void const *") short arg0, short arg1) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ShortBuffer arg_value = stack.shorts(arg0, arg1);
            int n = CL10.nclSetKernelArg(kernel, arg_index, 4L, MemoryUtil.memAddress(arg_value));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="cl_int")
    public static int clSetKernelArg4s(@NativeType(value="cl_kernel") long kernel, @NativeType(value="cl_uint") int arg_index, @NativeType(value="void const *") short arg0, short arg1, short arg2, short arg3) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ShortBuffer arg_value = stack.shorts(arg0, arg1, arg2, arg3);
            int n = CL10.nclSetKernelArg(kernel, arg_index, 8L, MemoryUtil.memAddress(arg_value));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="cl_int")
    public static int clSetKernelArg1i(@NativeType(value="cl_kernel") long kernel, @NativeType(value="cl_uint") int arg_index, @NativeType(value="void const *") int arg0) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer arg_value = stack.ints(arg0);
            int n = CL10.nclSetKernelArg(kernel, arg_index, 4L, MemoryUtil.memAddress(arg_value));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="cl_int")
    public static int clSetKernelArg2i(@NativeType(value="cl_kernel") long kernel, @NativeType(value="cl_uint") int arg_index, @NativeType(value="void const *") int arg0, int arg1) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer arg_value = stack.ints(arg0, arg1);
            int n = CL10.nclSetKernelArg(kernel, arg_index, 8L, MemoryUtil.memAddress(arg_value));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="cl_int")
    public static int clSetKernelArg4i(@NativeType(value="cl_kernel") long kernel, @NativeType(value="cl_uint") int arg_index, @NativeType(value="void const *") int arg0, int arg1, int arg2, int arg3) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer arg_value = stack.ints(arg0, arg1, arg2, arg3);
            int n = CL10.nclSetKernelArg(kernel, arg_index, 16L, MemoryUtil.memAddress(arg_value));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="cl_int")
    public static int clSetKernelArg1l(@NativeType(value="cl_kernel") long kernel, @NativeType(value="cl_uint") int arg_index, @NativeType(value="void const *") long arg0) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            LongBuffer arg_value = stack.longs(arg0);
            int n = CL10.nclSetKernelArg(kernel, arg_index, 8L, MemoryUtil.memAddress(arg_value));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="cl_int")
    public static int clSetKernelArg2l(@NativeType(value="cl_kernel") long kernel, @NativeType(value="cl_uint") int arg_index, @NativeType(value="void const *") long arg0, long arg1) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            LongBuffer arg_value = stack.longs(arg0, arg1);
            int n = CL10.nclSetKernelArg(kernel, arg_index, 16L, MemoryUtil.memAddress(arg_value));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="cl_int")
    public static int clSetKernelArg4l(@NativeType(value="cl_kernel") long kernel, @NativeType(value="cl_uint") int arg_index, @NativeType(value="void const *") long arg0, long arg1, long arg2, long arg3) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            LongBuffer arg_value = stack.longs(arg0, arg1, arg2, arg3);
            int n = CL10.nclSetKernelArg(kernel, arg_index, 32L, MemoryUtil.memAddress(arg_value));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="cl_int")
    public static int clSetKernelArg1f(@NativeType(value="cl_kernel") long kernel, @NativeType(value="cl_uint") int arg_index, @NativeType(value="void const *") float arg0) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            FloatBuffer arg_value = stack.floats(arg0);
            int n = CL10.nclSetKernelArg(kernel, arg_index, 4L, MemoryUtil.memAddress(arg_value));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="cl_int")
    public static int clSetKernelArg2f(@NativeType(value="cl_kernel") long kernel, @NativeType(value="cl_uint") int arg_index, @NativeType(value="void const *") float arg0, float arg1) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            FloatBuffer arg_value = stack.floats(arg0, arg1);
            int n = CL10.nclSetKernelArg(kernel, arg_index, 8L, MemoryUtil.memAddress(arg_value));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="cl_int")
    public static int clSetKernelArg4f(@NativeType(value="cl_kernel") long kernel, @NativeType(value="cl_uint") int arg_index, @NativeType(value="void const *") float arg0, float arg1, float arg2, float arg3) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            FloatBuffer arg_value = stack.floats(arg0, arg1, arg2, arg3);
            int n = CL10.nclSetKernelArg(kernel, arg_index, 16L, MemoryUtil.memAddress(arg_value));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="cl_int")
    public static int clSetKernelArg1d(@NativeType(value="cl_kernel") long kernel, @NativeType(value="cl_uint") int arg_index, @NativeType(value="void const *") double arg0) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            DoubleBuffer arg_value = stack.doubles(arg0);
            int n = CL10.nclSetKernelArg(kernel, arg_index, 8L, MemoryUtil.memAddress(arg_value));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="cl_int")
    public static int clSetKernelArg2d(@NativeType(value="cl_kernel") long kernel, @NativeType(value="cl_uint") int arg_index, @NativeType(value="void const *") double arg0, double arg1) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            DoubleBuffer arg_value = stack.doubles(arg0, arg1);
            int n = CL10.nclSetKernelArg(kernel, arg_index, 16L, MemoryUtil.memAddress(arg_value));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="cl_int")
    public static int clSetKernelArg4d(@NativeType(value="cl_kernel") long kernel, @NativeType(value="cl_uint") int arg_index, @NativeType(value="void const *") double arg0, double arg1, double arg2, double arg3) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            DoubleBuffer arg_value = stack.doubles(arg0, arg1, arg2, arg3);
            int n = CL10.nclSetKernelArg(kernel, arg_index, 32L, MemoryUtil.memAddress(arg_value));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="cl_int")
    public static int clSetKernelArg1p(@NativeType(value="cl_kernel") long kernel, @NativeType(value="cl_uint") int arg_index, @NativeType(value="void const *") long arg0) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            PointerBuffer arg_value = stack.pointers(arg0);
            int n = CL10.nclSetKernelArg(kernel, arg_index, (1 << MemoryStack.POINTER_SHIFT) * 1, MemoryUtil.memAddress(arg_value));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="cl_int")
    public static int clSetKernelArg2p(@NativeType(value="cl_kernel") long kernel, @NativeType(value="cl_uint") int arg_index, @NativeType(value="void const *") long arg0, long arg1) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            PointerBuffer arg_value = stack.pointers(arg0, arg1);
            int n = CL10.nclSetKernelArg(kernel, arg_index, (1 << MemoryStack.POINTER_SHIFT) * 2, MemoryUtil.memAddress(arg_value));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="cl_int")
    public static int clSetKernelArg4p(@NativeType(value="cl_kernel") long kernel, @NativeType(value="cl_uint") int arg_index, @NativeType(value="void const *") long arg0, long arg1, long arg2, long arg3) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            PointerBuffer arg_value = stack.pointers(arg0, arg1, arg2, arg3);
            int n = CL10.nclSetKernelArg(kernel, arg_index, (1 << MemoryStack.POINTER_SHIFT) * 4, MemoryUtil.memAddress(arg_value));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nclGetKernelInfo(long kernel, int param_name, long param_value_size, long param_value, long param_value_size_ret) {
        long __functionAddress = CL.getICD().clGetKernelInfo;
        if (Checks.CHECKS) {
            Checks.check(kernel);
        }
        return JNI.callPPPPI(kernel, param_name, param_value_size, param_value, param_value_size_ret, __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clGetKernelInfo(@NativeType(value="cl_kernel") long kernel, @NativeType(value="cl_kernel_info") int param_name, @Nullable @NativeType(value="void *") ByteBuffer param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe(param_value_size_ret, 1);
        }
        return CL10.nclGetKernelInfo(kernel, param_name, Checks.remainingSafe(param_value), MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    @NativeType(value="cl_int")
    public static int clGetKernelInfo(@NativeType(value="cl_kernel") long kernel, @NativeType(value="cl_kernel_info") int param_name, @Nullable @NativeType(value="void *") IntBuffer param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe(param_value_size_ret, 1);
        }
        return CL10.nclGetKernelInfo(kernel, param_name, Integer.toUnsignedLong(Checks.remainingSafe(param_value)) << 2, MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    @NativeType(value="cl_int")
    public static int clGetKernelInfo(@NativeType(value="cl_kernel") long kernel, @NativeType(value="cl_kernel_info") int param_name, @Nullable @NativeType(value="void *") PointerBuffer param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe(param_value_size_ret, 1);
        }
        return CL10.nclGetKernelInfo(kernel, param_name, Integer.toUnsignedLong(Checks.remainingSafe(param_value)) << MemoryStack.POINTER_SHIFT, MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    public static int nclGetKernelWorkGroupInfo(long kernel, long device2, int param_name, long param_value_size, long param_value, long param_value_size_ret) {
        long __functionAddress = CL.getICD().clGetKernelWorkGroupInfo;
        if (Checks.CHECKS) {
            Checks.check(kernel);
            Checks.check(device2);
        }
        return JNI.callPPPPPI(kernel, device2, param_name, param_value_size, param_value, param_value_size_ret, __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clGetKernelWorkGroupInfo(@NativeType(value="cl_kernel") long kernel, @NativeType(value="cl_device_id") long device2, @NativeType(value="cl_kernel_work_group_info") int param_name, @Nullable @NativeType(value="void *") ByteBuffer param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe(param_value_size_ret, 1);
        }
        return CL10.nclGetKernelWorkGroupInfo(kernel, device2, param_name, Checks.remainingSafe(param_value), MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    @NativeType(value="cl_int")
    public static int clGetKernelWorkGroupInfo(@NativeType(value="cl_kernel") long kernel, @NativeType(value="cl_device_id") long device2, @NativeType(value="cl_kernel_work_group_info") int param_name, @Nullable @NativeType(value="void *") IntBuffer param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe(param_value_size_ret, 1);
        }
        return CL10.nclGetKernelWorkGroupInfo(kernel, device2, param_name, Integer.toUnsignedLong(Checks.remainingSafe(param_value)) << 2, MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    @NativeType(value="cl_int")
    public static int clGetKernelWorkGroupInfo(@NativeType(value="cl_kernel") long kernel, @NativeType(value="cl_device_id") long device2, @NativeType(value="cl_kernel_work_group_info") int param_name, @Nullable @NativeType(value="void *") LongBuffer param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe(param_value_size_ret, 1);
        }
        return CL10.nclGetKernelWorkGroupInfo(kernel, device2, param_name, Integer.toUnsignedLong(Checks.remainingSafe(param_value)) << 3, MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    @NativeType(value="cl_int")
    public static int clGetKernelWorkGroupInfo(@NativeType(value="cl_kernel") long kernel, @NativeType(value="cl_device_id") long device2, @NativeType(value="cl_kernel_work_group_info") int param_name, @Nullable @NativeType(value="void *") PointerBuffer param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe(param_value_size_ret, 1);
        }
        return CL10.nclGetKernelWorkGroupInfo(kernel, device2, param_name, Integer.toUnsignedLong(Checks.remainingSafe(param_value)) << MemoryStack.POINTER_SHIFT, MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    public static int nclEnqueueNDRangeKernel(long command_queue, long kernel, int work_dim, long global_work_offset, long global_work_size, long local_work_size, int num_events_in_wait_list, long event_wait_list, long event) {
        long __functionAddress = CL.getICD().clEnqueueNDRangeKernel;
        if (Checks.CHECKS) {
            Checks.check(command_queue);
            Checks.check(kernel);
        }
        return JNI.callPPPPPPPI(command_queue, kernel, work_dim, global_work_offset, global_work_size, local_work_size, num_events_in_wait_list, event_wait_list, event, __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clEnqueueNDRangeKernel(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_kernel") long kernel, @NativeType(value="cl_uint") int work_dim, @Nullable @NativeType(value="size_t const *") PointerBuffer global_work_offset, @Nullable @NativeType(value="size_t const *") PointerBuffer global_work_size, @Nullable @NativeType(value="size_t const *") PointerBuffer local_work_size, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.checkSafe(global_work_offset, work_dim);
            Checks.checkSafe(global_work_size, work_dim);
            Checks.checkSafe(local_work_size, work_dim);
            Checks.checkSafe(event, 1);
        }
        return CL10.nclEnqueueNDRangeKernel(command_queue, kernel, work_dim, MemoryUtil.memAddressSafe(global_work_offset), MemoryUtil.memAddressSafe(global_work_size), MemoryUtil.memAddressSafe(local_work_size), Checks.remainingSafe(event_wait_list), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static int nclEnqueueTask(long command_queue, long kernel, int num_events_in_wait_list, long event_wait_list, long event) {
        long __functionAddress = CL.getICD().clEnqueueTask;
        if (Checks.CHECKS) {
            Checks.check(command_queue);
            Checks.check(kernel);
        }
        return JNI.callPPPPI(command_queue, kernel, num_events_in_wait_list, event_wait_list, event, __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clEnqueueTask(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_kernel") long kernel, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.checkSafe(event, 1);
        }
        return CL10.nclEnqueueTask(command_queue, kernel, Checks.remainingSafe(event_wait_list), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static int nclEnqueueNativeKernel(long command_queue, long user_func, long args2, long cb_args, int num_mem_objects, long mem_list, long args_mem_loc, int num_events_in_wait_list, long event_wait_list, long event) {
        long __functionAddress = CL.getICD().clEnqueueNativeKernel;
        if (Checks.CHECKS) {
            Checks.check(command_queue);
        }
        return JNI.callPPPPPPPPI(command_queue, user_func, args2, cb_args, num_mem_objects, mem_list, args_mem_loc, num_events_in_wait_list, event_wait_list, event, __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clEnqueueNativeKernel(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="void (*) (void *)") CLNativeKernelI user_func, @Nullable @NativeType(value="void *") ByteBuffer args2, @Nullable @NativeType(value="cl_mem const *") PointerBuffer mem_list, @Nullable @NativeType(value="void const **") PointerBuffer args_mem_loc, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.checkSafe(args_mem_loc, Checks.remainingSafe(mem_list));
            Checks.checkSafe(event, 1);
        }
        return CL10.nclEnqueueNativeKernel(command_queue, user_func.address(), MemoryUtil.memAddressSafe(args2), Checks.remainingSafe(args2), Checks.remainingSafe(mem_list), MemoryUtil.memAddressSafe(mem_list), MemoryUtil.memAddressSafe(args_mem_loc), Checks.remainingSafe(event_wait_list), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="cl_int")
    public static int clEnqueueNativeKernel(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="void (*) (void *)") CLNativeKernelI user_func, @Nullable @NativeType(value="void *") ByteBuffer args2, @NativeType(value="cl_mem const *") long memobj, @NativeType(value="void const **") long memobj_loc, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.checkSafe(event, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            PointerBuffer mem_list = stack.pointers(memobj);
            PointerBuffer args_mem_loc = stack.pointers(memobj_loc);
            int n = CL10.nclEnqueueNativeKernel(command_queue, user_func.address(), MemoryUtil.memAddressSafe(args2), Checks.remainingSafe(args2), 1, MemoryUtil.memAddress(mem_list), MemoryUtil.memAddress(args_mem_loc), Checks.remainingSafe(event_wait_list), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nclWaitForEvents(int num_events, long event_list) {
        long __functionAddress = CL.getICD().clWaitForEvents;
        return JNI.callPI(num_events, event_list, __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clWaitForEvents(@NativeType(value="cl_event const *") PointerBuffer event_list) {
        return CL10.nclWaitForEvents(event_list.remaining(), MemoryUtil.memAddress(event_list));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="cl_int")
    public static int clWaitForEvents(@NativeType(value="cl_event const *") long event) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            PointerBuffer event_list = stack.pointers(event);
            int n = CL10.nclWaitForEvents(1, MemoryUtil.memAddress(event_list));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nclGetEventInfo(long event, int param_name, long param_value_size, long param_value, long param_value_size_ret) {
        long __functionAddress = CL.getICD().clGetEventInfo;
        if (Checks.CHECKS) {
            Checks.check(event);
        }
        return JNI.callPPPPI(event, param_name, param_value_size, param_value, param_value_size_ret, __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clGetEventInfo(@NativeType(value="cl_event") long event, @NativeType(value="cl_event_info") int param_name, @Nullable @NativeType(value="void *") ByteBuffer param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe(param_value_size_ret, 1);
        }
        return CL10.nclGetEventInfo(event, param_name, Checks.remainingSafe(param_value), MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    @NativeType(value="cl_int")
    public static int clGetEventInfo(@NativeType(value="cl_event") long event, @NativeType(value="cl_event_info") int param_name, @Nullable @NativeType(value="void *") IntBuffer param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe(param_value_size_ret, 1);
        }
        return CL10.nclGetEventInfo(event, param_name, Integer.toUnsignedLong(Checks.remainingSafe(param_value)) << 2, MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    @NativeType(value="cl_int")
    public static int clGetEventInfo(@NativeType(value="cl_event") long event, @NativeType(value="cl_event_info") int param_name, @Nullable @NativeType(value="void *") PointerBuffer param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe(param_value_size_ret, 1);
        }
        return CL10.nclGetEventInfo(event, param_name, Integer.toUnsignedLong(Checks.remainingSafe(param_value)) << MemoryStack.POINTER_SHIFT, MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    @NativeType(value="cl_int")
    public static int clRetainEvent(@NativeType(value="cl_event") long event) {
        long __functionAddress = CL.getICD().clRetainEvent;
        if (Checks.CHECKS) {
            Checks.check(event);
        }
        return JNI.callPI(event, __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clReleaseEvent(@NativeType(value="cl_event") long event) {
        long __functionAddress = CL.getICD().clReleaseEvent;
        if (Checks.CHECKS) {
            Checks.check(event);
        }
        return JNI.callPI(event, __functionAddress);
    }

    public static int nclEnqueueMarker(long command_queue, long event) {
        long __functionAddress = CL.getICD().clEnqueueMarker;
        if (Checks.CHECKS) {
            Checks.check(command_queue);
        }
        return JNI.callPPI(command_queue, event, __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clEnqueueMarker(@NativeType(value="cl_command_queue") long command_queue, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.checkSafe(event, 1);
        }
        return CL10.nclEnqueueMarker(command_queue, MemoryUtil.memAddressSafe(event));
    }

    @NativeType(value="cl_int")
    public static int clEnqueueBarrier(@NativeType(value="cl_command_queue") long command_queue) {
        long __functionAddress = CL.getICD().clEnqueueBarrier;
        if (Checks.CHECKS) {
            Checks.check(command_queue);
        }
        return JNI.callPI(command_queue, __functionAddress);
    }

    public static int nclEnqueueWaitForEvents(long command_queue, int num_events, long event_list) {
        long __functionAddress = CL.getICD().clEnqueueWaitForEvents;
        if (Checks.CHECKS) {
            Checks.check(command_queue);
        }
        return JNI.callPPI(command_queue, num_events, event_list, __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clEnqueueWaitForEvents(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_event const *") PointerBuffer event_list) {
        return CL10.nclEnqueueWaitForEvents(command_queue, event_list.remaining(), MemoryUtil.memAddress(event_list));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="cl_int")
    public static int clEnqueueWaitForEvents(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_event const *") long event) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            PointerBuffer event_list = stack.pointers(event);
            int n = CL10.nclEnqueueWaitForEvents(command_queue, 1, MemoryUtil.memAddress(event_list));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nclGetEventProfilingInfo(long event, int param_name, long param_value_size, long param_value, long param_value_size_ret) {
        long __functionAddress = CL.getICD().clGetEventProfilingInfo;
        if (Checks.CHECKS) {
            Checks.check(event);
        }
        return JNI.callPPPPI(event, param_name, param_value_size, param_value, param_value_size_ret, __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clGetEventProfilingInfo(@NativeType(value="cl_event") long event, @NativeType(value="cl_profiling_info") int param_name, @Nullable @NativeType(value="void *") ByteBuffer param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe(param_value_size_ret, 1);
        }
        return CL10.nclGetEventProfilingInfo(event, param_name, Checks.remainingSafe(param_value), MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    @NativeType(value="cl_int")
    public static int clGetEventProfilingInfo(@NativeType(value="cl_event") long event, @NativeType(value="cl_profiling_info") int param_name, @Nullable @NativeType(value="void *") LongBuffer param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe(param_value_size_ret, 1);
        }
        return CL10.nclGetEventProfilingInfo(event, param_name, Integer.toUnsignedLong(Checks.remainingSafe(param_value)) << 3, MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    @NativeType(value="cl_int")
    public static int clFlush(@NativeType(value="cl_command_queue") long command_queue) {
        long __functionAddress = CL.getICD().clFlush;
        if (Checks.CHECKS) {
            Checks.check(command_queue);
        }
        return JNI.callPI(command_queue, __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clFinish(@NativeType(value="cl_command_queue") long command_queue) {
        long __functionAddress = CL.getICD().clFinish;
        if (Checks.CHECKS) {
            Checks.check(command_queue);
        }
        return JNI.callPI(command_queue, __functionAddress);
    }

    public static long nclGetExtensionFunctionAddress(long funcname) {
        long __functionAddress = CL.getICD().clGetExtensionFunctionAddress;
        return JNI.callPP(funcname, __functionAddress);
    }

    @NativeType(value="void *")
    public static long clGetExtensionFunctionAddress(@NativeType(value="cl_char const *") ByteBuffer funcname) {
        if (Checks.CHECKS) {
            Checks.checkNT1(funcname);
        }
        return CL10.nclGetExtensionFunctionAddress(MemoryUtil.memAddress(funcname));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="void *")
    public static long clGetExtensionFunctionAddress(@NativeType(value="cl_char const *") CharSequence funcname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(funcname, true);
            long funcnameEncoded = stack.getPointerAddress();
            long l = CL10.nclGetExtensionFunctionAddress(funcnameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="cl_int")
    public static int clGetPlatformIDs(@Nullable @NativeType(value="cl_platform_id *") PointerBuffer platforms, @Nullable @NativeType(value="cl_uint *") int[] num_platforms) {
        long __functionAddress = CL.getICD().clGetPlatformIDs;
        if (Checks.CHECKS) {
            Checks.checkSafe(num_platforms, 1);
        }
        return JNI.callPPI(Checks.remainingSafe(platforms), MemoryUtil.memAddressSafe(platforms), num_platforms, __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clGetPlatformInfo(@NativeType(value="cl_platform_id") long platform, @NativeType(value="cl_platform_info") int param_name, @Nullable @NativeType(value="void *") long[] param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        long __functionAddress = CL.getICD().clGetPlatformInfo;
        if (Checks.CHECKS) {
            Checks.check(platform);
            Checks.checkSafe(param_value_size_ret, 1);
        }
        return JNI.callPPPPI(platform, param_name, Integer.toUnsignedLong(Checks.lengthSafe(param_value)) << 3, param_value, MemoryUtil.memAddressSafe(param_value_size_ret), __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clGetDeviceIDs(@NativeType(value="cl_platform_id") long platform, @NativeType(value="cl_device_type") long device_type, @Nullable @NativeType(value="cl_device_id *") PointerBuffer devices, @Nullable @NativeType(value="cl_uint *") int[] num_devices) {
        long __functionAddress = CL.getICD().clGetDeviceIDs;
        if (Checks.CHECKS) {
            Checks.checkSafe(num_devices, 1);
        }
        return JNI.callPJPPI(platform, device_type, Checks.remainingSafe(devices), MemoryUtil.memAddressSafe(devices), num_devices, __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clGetDeviceInfo(@NativeType(value="cl_device_id") long device2, @NativeType(value="cl_device_info") int param_name, @Nullable @NativeType(value="void *") int[] param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        long __functionAddress = CL.getICD().clGetDeviceInfo;
        if (Checks.CHECKS) {
            Checks.check(device2);
            Checks.checkSafe(param_value_size_ret, 1);
        }
        return JNI.callPPPPI(device2, param_name, Integer.toUnsignedLong(Checks.lengthSafe(param_value)) << 2, param_value, MemoryUtil.memAddressSafe(param_value_size_ret), __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clGetDeviceInfo(@NativeType(value="cl_device_id") long device2, @NativeType(value="cl_device_info") int param_name, @Nullable @NativeType(value="void *") long[] param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        long __functionAddress = CL.getICD().clGetDeviceInfo;
        if (Checks.CHECKS) {
            Checks.check(device2);
            Checks.checkSafe(param_value_size_ret, 1);
        }
        return JNI.callPPPPI(device2, param_name, Integer.toUnsignedLong(Checks.lengthSafe(param_value)) << 3, param_value, MemoryUtil.memAddressSafe(param_value_size_ret), __functionAddress);
    }

    @NativeType(value="cl_context")
    public static long clCreateContext(@Nullable @NativeType(value="cl_context_properties const *") PointerBuffer properties2, @NativeType(value="cl_device_id const *") PointerBuffer devices, @Nullable @NativeType(value="void (*) (cl_char const *, void const *, size_t, void *)") CLContextCallbackI pfn_notify, @NativeType(value="void *") long user_data, @Nullable @NativeType(value="cl_int *") int[] errcode_ret) {
        long __functionAddress = CL.getICD().clCreateContext;
        if (Checks.CHECKS) {
            Checks.checkNTSafe(properties2);
            Checks.checkSafe(errcode_ret, 1);
        }
        return JNI.callPPPPPP(MemoryUtil.memAddressSafe(properties2), devices.remaining(), MemoryUtil.memAddress(devices), MemoryUtil.memAddressSafe(pfn_notify), user_data, errcode_ret, __functionAddress);
    }

    @NativeType(value="cl_context")
    public static long clCreateContextFromType(@Nullable @NativeType(value="cl_context_properties const *") PointerBuffer properties2, @NativeType(value="cl_device_type") long device_type, @Nullable @NativeType(value="void (*) (cl_char const *, void const *, size_t, void *)") CLContextCallbackI pfn_notify, @NativeType(value="void *") long user_data, @Nullable @NativeType(value="cl_int *") int[] errcode_ret) {
        long __functionAddress = CL.getICD().clCreateContextFromType;
        if (Checks.CHECKS) {
            Checks.checkNTSafe(properties2);
            Checks.checkSafe(errcode_ret, 1);
        }
        return JNI.callPJPPPP(MemoryUtil.memAddressSafe(properties2), device_type, MemoryUtil.memAddressSafe(pfn_notify), user_data, errcode_ret, __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clGetContextInfo(@NativeType(value="cl_context") long context2, @NativeType(value="cl_context_info") int param_name, @Nullable @NativeType(value="void *") int[] param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        long __functionAddress = CL.getICD().clGetContextInfo;
        if (Checks.CHECKS) {
            Checks.check(context2);
            Checks.checkSafe(param_value_size_ret, 1);
        }
        return JNI.callPPPPI(context2, param_name, Integer.toUnsignedLong(Checks.lengthSafe(param_value)) << 2, param_value, MemoryUtil.memAddressSafe(param_value_size_ret), __functionAddress);
    }

    @NativeType(value="cl_command_queue")
    public static long clCreateCommandQueue(@NativeType(value="cl_context") long context2, @NativeType(value="cl_device_id") long device2, @NativeType(value="cl_command_queue_properties") long properties2, @Nullable @NativeType(value="cl_int *") int[] errcode_ret) {
        long __functionAddress = CL.getICD().clCreateCommandQueue;
        if (Checks.CHECKS) {
            Checks.check(context2);
            Checks.check(device2);
            Checks.checkSafe(errcode_ret, 1);
        }
        return JNI.callPPJPP(context2, device2, properties2, errcode_ret, __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clGetCommandQueueInfo(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_command_queue_info") int param_name, @Nullable @NativeType(value="void *") int[] param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        long __functionAddress = CL.getICD().clGetCommandQueueInfo;
        if (Checks.CHECKS) {
            Checks.check(command_queue);
            Checks.checkSafe(param_value_size_ret, 1);
        }
        return JNI.callPPPPI(command_queue, param_name, Integer.toUnsignedLong(Checks.lengthSafe(param_value)) << 2, param_value, MemoryUtil.memAddressSafe(param_value_size_ret), __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clGetCommandQueueInfo(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_command_queue_info") int param_name, @Nullable @NativeType(value="void *") long[] param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        long __functionAddress = CL.getICD().clGetCommandQueueInfo;
        if (Checks.CHECKS) {
            Checks.check(command_queue);
            Checks.checkSafe(param_value_size_ret, 1);
        }
        return JNI.callPPPPI(command_queue, param_name, Integer.toUnsignedLong(Checks.lengthSafe(param_value)) << 3, param_value, MemoryUtil.memAddressSafe(param_value_size_ret), __functionAddress);
    }

    @NativeType(value="cl_mem")
    public static long clCreateBuffer(@NativeType(value="cl_context") long context2, @NativeType(value="cl_mem_flags") long flags, @NativeType(value="void *") ByteBuffer host_ptr, @Nullable @NativeType(value="cl_int *") int[] errcode_ret) {
        long __functionAddress = CL.getICD().clCreateBuffer;
        if (Checks.CHECKS) {
            Checks.check(context2);
            Checks.checkSafe(errcode_ret, 1);
        }
        return JNI.callPJPPPP(context2, flags, (long)host_ptr.remaining(), MemoryUtil.memAddress(host_ptr), errcode_ret, __functionAddress);
    }

    @NativeType(value="cl_mem")
    public static long clCreateBuffer(@NativeType(value="cl_context") long context2, @NativeType(value="cl_mem_flags") long flags, @NativeType(value="void *") short[] host_ptr, @Nullable @NativeType(value="cl_int *") int[] errcode_ret) {
        long __functionAddress = CL.getICD().clCreateBuffer;
        if (Checks.CHECKS) {
            Checks.check(context2);
            Checks.checkSafe(errcode_ret, 1);
        }
        return JNI.callPJPPPP(context2, flags, Integer.toUnsignedLong(host_ptr.length) << 1, host_ptr, errcode_ret, __functionAddress);
    }

    @NativeType(value="cl_mem")
    public static long clCreateBuffer(@NativeType(value="cl_context") long context2, @NativeType(value="cl_mem_flags") long flags, @NativeType(value="void *") int[] host_ptr, @Nullable @NativeType(value="cl_int *") int[] errcode_ret) {
        long __functionAddress = CL.getICD().clCreateBuffer;
        if (Checks.CHECKS) {
            Checks.check(context2);
            Checks.checkSafe(errcode_ret, 1);
        }
        return JNI.callPJPPPP(context2, flags, Integer.toUnsignedLong(host_ptr.length) << 2, host_ptr, errcode_ret, __functionAddress);
    }

    @NativeType(value="cl_mem")
    public static long clCreateBuffer(@NativeType(value="cl_context") long context2, @NativeType(value="cl_mem_flags") long flags, @NativeType(value="void *") float[] host_ptr, @Nullable @NativeType(value="cl_int *") int[] errcode_ret) {
        long __functionAddress = CL.getICD().clCreateBuffer;
        if (Checks.CHECKS) {
            Checks.check(context2);
            Checks.checkSafe(errcode_ret, 1);
        }
        return JNI.callPJPPPP(context2, flags, Integer.toUnsignedLong(host_ptr.length) << 2, host_ptr, errcode_ret, __functionAddress);
    }

    @NativeType(value="cl_mem")
    public static long clCreateBuffer(@NativeType(value="cl_context") long context2, @NativeType(value="cl_mem_flags") long flags, @NativeType(value="void *") double[] host_ptr, @Nullable @NativeType(value="cl_int *") int[] errcode_ret) {
        long __functionAddress = CL.getICD().clCreateBuffer;
        if (Checks.CHECKS) {
            Checks.check(context2);
            Checks.checkSafe(errcode_ret, 1);
        }
        return JNI.callPJPPPP(context2, flags, Integer.toUnsignedLong(host_ptr.length) << 3, host_ptr, errcode_ret, __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clEnqueueReadBuffer(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long buffer, @NativeType(value="cl_bool") boolean blocking_read, @NativeType(value="size_t") long offset2, @NativeType(value="void *") short[] ptr, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        long __functionAddress = CL.getICD().clEnqueueReadBuffer;
        if (!blocking_read) {
            throw new IllegalArgumentException("Non blocking reads cannot be used when the ptr parameter is a Java array.");
        }
        if (Checks.CHECKS) {
            Checks.check(command_queue);
            Checks.check(buffer);
            Checks.checkSafe(event, 1);
        }
        return JNI.callPPPPPPPI(command_queue, buffer, blocking_read ? 1 : 0, offset2, Integer.toUnsignedLong(ptr.length) << 1, ptr, Checks.remainingSafe(event_wait_list), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event), __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clEnqueueReadBuffer(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long buffer, @NativeType(value="cl_bool") boolean blocking_read, @NativeType(value="size_t") long offset2, @NativeType(value="void *") int[] ptr, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        long __functionAddress = CL.getICD().clEnqueueReadBuffer;
        if (!blocking_read) {
            throw new IllegalArgumentException("Non blocking reads cannot be used when the ptr parameter is a Java array.");
        }
        if (Checks.CHECKS) {
            Checks.check(command_queue);
            Checks.check(buffer);
            Checks.checkSafe(event, 1);
        }
        return JNI.callPPPPPPPI(command_queue, buffer, blocking_read ? 1 : 0, offset2, Integer.toUnsignedLong(ptr.length) << 2, ptr, Checks.remainingSafe(event_wait_list), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event), __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clEnqueueReadBuffer(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long buffer, @NativeType(value="cl_bool") boolean blocking_read, @NativeType(value="size_t") long offset2, @NativeType(value="void *") float[] ptr, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        long __functionAddress = CL.getICD().clEnqueueReadBuffer;
        if (!blocking_read) {
            throw new IllegalArgumentException("Non blocking reads cannot be used when the ptr parameter is a Java array.");
        }
        if (Checks.CHECKS) {
            Checks.check(command_queue);
            Checks.check(buffer);
            Checks.checkSafe(event, 1);
        }
        return JNI.callPPPPPPPI(command_queue, buffer, blocking_read ? 1 : 0, offset2, Integer.toUnsignedLong(ptr.length) << 2, ptr, Checks.remainingSafe(event_wait_list), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event), __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clEnqueueReadBuffer(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long buffer, @NativeType(value="cl_bool") boolean blocking_read, @NativeType(value="size_t") long offset2, @NativeType(value="void *") double[] ptr, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        long __functionAddress = CL.getICD().clEnqueueReadBuffer;
        if (!blocking_read) {
            throw new IllegalArgumentException("Non blocking reads cannot be used when the ptr parameter is a Java array.");
        }
        if (Checks.CHECKS) {
            Checks.check(command_queue);
            Checks.check(buffer);
            Checks.checkSafe(event, 1);
        }
        return JNI.callPPPPPPPI(command_queue, buffer, blocking_read ? 1 : 0, offset2, Integer.toUnsignedLong(ptr.length) << 3, ptr, Checks.remainingSafe(event_wait_list), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event), __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clEnqueueWriteBuffer(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long buffer, @NativeType(value="cl_bool") boolean blocking_write, @NativeType(value="size_t") long offset2, @NativeType(value="void const *") short[] ptr, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        long __functionAddress = CL.getICD().clEnqueueWriteBuffer;
        if (!blocking_write) {
            throw new IllegalArgumentException("Non blocking writes cannot be used when the ptr parameter is a Java array.");
        }
        if (Checks.CHECKS) {
            Checks.check(command_queue);
            Checks.check(buffer);
            Checks.checkSafe(event, 1);
        }
        return JNI.callPPPPPPPI(command_queue, buffer, blocking_write ? 1 : 0, offset2, Integer.toUnsignedLong(ptr.length) << 1, ptr, Checks.remainingSafe(event_wait_list), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event), __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clEnqueueWriteBuffer(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long buffer, @NativeType(value="cl_bool") boolean blocking_write, @NativeType(value="size_t") long offset2, @NativeType(value="void const *") int[] ptr, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        long __functionAddress = CL.getICD().clEnqueueWriteBuffer;
        if (!blocking_write) {
            throw new IllegalArgumentException("Non blocking writes cannot be used when the ptr parameter is a Java array.");
        }
        if (Checks.CHECKS) {
            Checks.check(command_queue);
            Checks.check(buffer);
            Checks.checkSafe(event, 1);
        }
        return JNI.callPPPPPPPI(command_queue, buffer, blocking_write ? 1 : 0, offset2, Integer.toUnsignedLong(ptr.length) << 2, ptr, Checks.remainingSafe(event_wait_list), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event), __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clEnqueueWriteBuffer(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long buffer, @NativeType(value="cl_bool") boolean blocking_write, @NativeType(value="size_t") long offset2, @NativeType(value="void const *") float[] ptr, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        long __functionAddress = CL.getICD().clEnqueueWriteBuffer;
        if (!blocking_write) {
            throw new IllegalArgumentException("Non blocking writes cannot be used when the ptr parameter is a Java array.");
        }
        if (Checks.CHECKS) {
            Checks.check(command_queue);
            Checks.check(buffer);
            Checks.checkSafe(event, 1);
        }
        return JNI.callPPPPPPPI(command_queue, buffer, blocking_write ? 1 : 0, offset2, Integer.toUnsignedLong(ptr.length) << 2, ptr, Checks.remainingSafe(event_wait_list), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event), __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clEnqueueWriteBuffer(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long buffer, @NativeType(value="cl_bool") boolean blocking_write, @NativeType(value="size_t") long offset2, @NativeType(value="void const *") double[] ptr, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        long __functionAddress = CL.getICD().clEnqueueWriteBuffer;
        if (!blocking_write) {
            throw new IllegalArgumentException("Non blocking writes cannot be used when the ptr parameter is a Java array.");
        }
        if (Checks.CHECKS) {
            Checks.check(command_queue);
            Checks.check(buffer);
            Checks.checkSafe(event, 1);
        }
        return JNI.callPPPPPPPI(command_queue, buffer, blocking_write ? 1 : 0, offset2, Integer.toUnsignedLong(ptr.length) << 3, ptr, Checks.remainingSafe(event_wait_list), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event), __functionAddress);
    }

    @Nullable
    @NativeType(value="void *")
    public static ByteBuffer clEnqueueMapBuffer(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long buffer, @NativeType(value="cl_bool") boolean blocking_map, @NativeType(value="cl_map_flags") long map_flags, @NativeType(value="size_t") long offset2, @NativeType(value="size_t") long size2, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event, @Nullable @NativeType(value="cl_int *") int[] errcode_ret, @Nullable ByteBuffer old_buffer) {
        long __functionAddress = CL.getICD().clEnqueueMapBuffer;
        if (Checks.CHECKS) {
            Checks.check(command_queue);
            Checks.check(buffer);
            Checks.checkSafe(event, 1);
            Checks.checkSafe(errcode_ret, 1);
        }
        long __result = JNI.callPPJPPPPPP(command_queue, buffer, blocking_map ? 1 : 0, map_flags, offset2, size2, Checks.remainingSafe(event_wait_list), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event), errcode_ret, __functionAddress);
        return APIUtil.apiGetMappedBuffer(old_buffer, __result, (int)size2);
    }

    @NativeType(value="cl_mem")
    public static long clCreateImage2D(@NativeType(value="cl_context") long context2, @NativeType(value="cl_mem_flags") long flags, @NativeType(value="cl_image_format const *") CLImageFormat image_format, @NativeType(value="size_t") long image_width, @NativeType(value="size_t") long image_height, @NativeType(value="size_t") long image_row_pitch, @Nullable @NativeType(value="void *") ByteBuffer host_ptr, @Nullable @NativeType(value="cl_int *") int[] errcode_ret) {
        long __functionAddress = CL.getICD().clCreateImage2D;
        if (Checks.CHECKS) {
            Checks.check(context2);
            Checks.checkSafe(errcode_ret, 1);
        }
        return JNI.callPJPPPPPPP(context2, flags, image_format.address(), image_width, image_height, image_row_pitch, MemoryUtil.memAddressSafe(host_ptr), errcode_ret, __functionAddress);
    }

    @NativeType(value="cl_mem")
    public static long clCreateImage2D(@NativeType(value="cl_context") long context2, @NativeType(value="cl_mem_flags") long flags, @NativeType(value="cl_image_format const *") CLImageFormat image_format, @NativeType(value="size_t") long image_width, @NativeType(value="size_t") long image_height, @NativeType(value="size_t") long image_row_pitch, @Nullable @NativeType(value="void *") short[] host_ptr, @Nullable @NativeType(value="cl_int *") int[] errcode_ret) {
        long __functionAddress = CL.getICD().clCreateImage2D;
        if (Checks.CHECKS) {
            Checks.check(context2);
            Checks.checkSafe(errcode_ret, 1);
        }
        return JNI.callPJPPPPPPP(context2, flags, image_format.address(), image_width, image_height, image_row_pitch, host_ptr, errcode_ret, __functionAddress);
    }

    @NativeType(value="cl_mem")
    public static long clCreateImage2D(@NativeType(value="cl_context") long context2, @NativeType(value="cl_mem_flags") long flags, @NativeType(value="cl_image_format const *") CLImageFormat image_format, @NativeType(value="size_t") long image_width, @NativeType(value="size_t") long image_height, @NativeType(value="size_t") long image_row_pitch, @Nullable @NativeType(value="void *") int[] host_ptr, @Nullable @NativeType(value="cl_int *") int[] errcode_ret) {
        long __functionAddress = CL.getICD().clCreateImage2D;
        if (Checks.CHECKS) {
            Checks.check(context2);
            Checks.checkSafe(errcode_ret, 1);
        }
        return JNI.callPJPPPPPPP(context2, flags, image_format.address(), image_width, image_height, image_row_pitch, host_ptr, errcode_ret, __functionAddress);
    }

    @NativeType(value="cl_mem")
    public static long clCreateImage2D(@NativeType(value="cl_context") long context2, @NativeType(value="cl_mem_flags") long flags, @NativeType(value="cl_image_format const *") CLImageFormat image_format, @NativeType(value="size_t") long image_width, @NativeType(value="size_t") long image_height, @NativeType(value="size_t") long image_row_pitch, @Nullable @NativeType(value="void *") float[] host_ptr, @Nullable @NativeType(value="cl_int *") int[] errcode_ret) {
        long __functionAddress = CL.getICD().clCreateImage2D;
        if (Checks.CHECKS) {
            Checks.check(context2);
            Checks.checkSafe(errcode_ret, 1);
        }
        return JNI.callPJPPPPPPP(context2, flags, image_format.address(), image_width, image_height, image_row_pitch, host_ptr, errcode_ret, __functionAddress);
    }

    @NativeType(value="cl_mem")
    public static long clCreateImage3D(@NativeType(value="cl_context") long context2, @NativeType(value="cl_mem_flags") long flags, @NativeType(value="cl_image_format const *") CLImageFormat image_format, @NativeType(value="size_t") long image_width, @NativeType(value="size_t") long image_height, @NativeType(value="size_t") long image_depth, @NativeType(value="size_t") long image_row_pitch, @NativeType(value="size_t") long image_slice_pitch, @Nullable @NativeType(value="void *") ByteBuffer host_ptr, @Nullable @NativeType(value="cl_int *") int[] errcode_ret) {
        long __functionAddress = CL.getICD().clCreateImage3D;
        if (Checks.CHECKS) {
            Checks.check(context2);
            Checks.checkSafe(errcode_ret, 1);
        }
        return JNI.callPJPPPPPPPPP(context2, flags, image_format.address(), image_width, image_height, image_depth, image_row_pitch, image_slice_pitch, MemoryUtil.memAddressSafe(host_ptr), errcode_ret, __functionAddress);
    }

    @NativeType(value="cl_mem")
    public static long clCreateImage3D(@NativeType(value="cl_context") long context2, @NativeType(value="cl_mem_flags") long flags, @NativeType(value="cl_image_format const *") CLImageFormat image_format, @NativeType(value="size_t") long image_width, @NativeType(value="size_t") long image_height, @NativeType(value="size_t") long image_depth, @NativeType(value="size_t") long image_row_pitch, @NativeType(value="size_t") long image_slice_pitch, @Nullable @NativeType(value="void *") short[] host_ptr, @Nullable @NativeType(value="cl_int *") int[] errcode_ret) {
        long __functionAddress = CL.getICD().clCreateImage3D;
        if (Checks.CHECKS) {
            Checks.check(context2);
            Checks.checkSafe(errcode_ret, 1);
        }
        return JNI.callPJPPPPPPPPP(context2, flags, image_format.address(), image_width, image_height, image_depth, image_row_pitch, image_slice_pitch, host_ptr, errcode_ret, __functionAddress);
    }

    @NativeType(value="cl_mem")
    public static long clCreateImage3D(@NativeType(value="cl_context") long context2, @NativeType(value="cl_mem_flags") long flags, @NativeType(value="cl_image_format const *") CLImageFormat image_format, @NativeType(value="size_t") long image_width, @NativeType(value="size_t") long image_height, @NativeType(value="size_t") long image_depth, @NativeType(value="size_t") long image_row_pitch, @NativeType(value="size_t") long image_slice_pitch, @Nullable @NativeType(value="void *") int[] host_ptr, @Nullable @NativeType(value="cl_int *") int[] errcode_ret) {
        long __functionAddress = CL.getICD().clCreateImage3D;
        if (Checks.CHECKS) {
            Checks.check(context2);
            Checks.checkSafe(errcode_ret, 1);
        }
        return JNI.callPJPPPPPPPPP(context2, flags, image_format.address(), image_width, image_height, image_depth, image_row_pitch, image_slice_pitch, host_ptr, errcode_ret, __functionAddress);
    }

    @NativeType(value="cl_mem")
    public static long clCreateImage3D(@NativeType(value="cl_context") long context2, @NativeType(value="cl_mem_flags") long flags, @NativeType(value="cl_image_format const *") CLImageFormat image_format, @NativeType(value="size_t") long image_width, @NativeType(value="size_t") long image_height, @NativeType(value="size_t") long image_depth, @NativeType(value="size_t") long image_row_pitch, @NativeType(value="size_t") long image_slice_pitch, @Nullable @NativeType(value="void *") float[] host_ptr, @Nullable @NativeType(value="cl_int *") int[] errcode_ret) {
        long __functionAddress = CL.getICD().clCreateImage3D;
        if (Checks.CHECKS) {
            Checks.check(context2);
            Checks.checkSafe(errcode_ret, 1);
        }
        return JNI.callPJPPPPPPPPP(context2, flags, image_format.address(), image_width, image_height, image_depth, image_row_pitch, image_slice_pitch, host_ptr, errcode_ret, __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clGetSupportedImageFormats(@NativeType(value="cl_context") long context2, @NativeType(value="cl_mem_flags") long flags, @NativeType(value="cl_mem_object_type") int image_type, @Nullable @NativeType(value="cl_image_format *") CLImageFormat.Buffer image_formats, @Nullable @NativeType(value="cl_uint *") int[] num_image_formats) {
        long __functionAddress = CL.getICD().clGetSupportedImageFormats;
        if (Checks.CHECKS) {
            Checks.check(context2);
            Checks.checkSafe(num_image_formats, 1);
        }
        return JNI.callPJPPI(context2, flags, image_type, Checks.remainingSafe(image_formats), MemoryUtil.memAddressSafe(image_formats), num_image_formats, __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clEnqueueReadImage(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long image, @NativeType(value="cl_bool") boolean blocking_read, @NativeType(value="size_t const *") PointerBuffer origin2, @NativeType(value="size_t const *") PointerBuffer region, @NativeType(value="size_t") long row_pitch, @NativeType(value="size_t") long slice_pitch, @NativeType(value="void *") short[] ptr, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        long __functionAddress = CL.getICD().clEnqueueReadImage;
        if (!blocking_read) {
            throw new IllegalArgumentException("Non blocking reads cannot be used when the ptr parameter is a Java array.");
        }
        if (Checks.CHECKS) {
            Checks.check(command_queue);
            Checks.check(image);
            Checks.check(origin2, 3);
            Checks.check(region, 3);
            Checks.checkSafe(event, 1);
        }
        return JNI.callPPPPPPPPPI(command_queue, image, blocking_read ? 1 : 0, MemoryUtil.memAddress(origin2), MemoryUtil.memAddress(region), row_pitch, slice_pitch, ptr, Checks.remainingSafe(event_wait_list), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event), __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clEnqueueReadImage(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long image, @NativeType(value="cl_bool") boolean blocking_read, @NativeType(value="size_t const *") PointerBuffer origin2, @NativeType(value="size_t const *") PointerBuffer region, @NativeType(value="size_t") long row_pitch, @NativeType(value="size_t") long slice_pitch, @NativeType(value="void *") int[] ptr, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        long __functionAddress = CL.getICD().clEnqueueReadImage;
        if (!blocking_read) {
            throw new IllegalArgumentException("Non blocking reads cannot be used when the ptr parameter is a Java array.");
        }
        if (Checks.CHECKS) {
            Checks.check(command_queue);
            Checks.check(image);
            Checks.check(origin2, 3);
            Checks.check(region, 3);
            Checks.checkSafe(event, 1);
        }
        return JNI.callPPPPPPPPPI(command_queue, image, blocking_read ? 1 : 0, MemoryUtil.memAddress(origin2), MemoryUtil.memAddress(region), row_pitch, slice_pitch, ptr, Checks.remainingSafe(event_wait_list), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event), __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clEnqueueReadImage(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long image, @NativeType(value="cl_bool") boolean blocking_read, @NativeType(value="size_t const *") PointerBuffer origin2, @NativeType(value="size_t const *") PointerBuffer region, @NativeType(value="size_t") long row_pitch, @NativeType(value="size_t") long slice_pitch, @NativeType(value="void *") float[] ptr, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        long __functionAddress = CL.getICD().clEnqueueReadImage;
        if (!blocking_read) {
            throw new IllegalArgumentException("Non blocking reads cannot be used when the ptr parameter is a Java array.");
        }
        if (Checks.CHECKS) {
            Checks.check(command_queue);
            Checks.check(image);
            Checks.check(origin2, 3);
            Checks.check(region, 3);
            Checks.checkSafe(event, 1);
        }
        return JNI.callPPPPPPPPPI(command_queue, image, blocking_read ? 1 : 0, MemoryUtil.memAddress(origin2), MemoryUtil.memAddress(region), row_pitch, slice_pitch, ptr, Checks.remainingSafe(event_wait_list), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event), __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clEnqueueReadImage(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long image, @NativeType(value="cl_bool") boolean blocking_read, @NativeType(value="size_t const *") PointerBuffer origin2, @NativeType(value="size_t const *") PointerBuffer region, @NativeType(value="size_t") long row_pitch, @NativeType(value="size_t") long slice_pitch, @NativeType(value="void *") double[] ptr, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        long __functionAddress = CL.getICD().clEnqueueReadImage;
        if (!blocking_read) {
            throw new IllegalArgumentException("Non blocking reads cannot be used when the ptr parameter is a Java array.");
        }
        if (Checks.CHECKS) {
            Checks.check(command_queue);
            Checks.check(image);
            Checks.check(origin2, 3);
            Checks.check(region, 3);
            Checks.checkSafe(event, 1);
        }
        return JNI.callPPPPPPPPPI(command_queue, image, blocking_read ? 1 : 0, MemoryUtil.memAddress(origin2), MemoryUtil.memAddress(region), row_pitch, slice_pitch, ptr, Checks.remainingSafe(event_wait_list), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event), __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clEnqueueWriteImage(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long image, @NativeType(value="cl_bool") boolean blocking_write, @NativeType(value="size_t const *") PointerBuffer origin2, @NativeType(value="size_t const *") PointerBuffer region, @NativeType(value="size_t") long input_row_pitch, @NativeType(value="size_t") long input_slice_pitch, @NativeType(value="void const *") short[] ptr, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        long __functionAddress = CL.getICD().clEnqueueWriteImage;
        if (!blocking_write) {
            throw new IllegalArgumentException("Non blocking writes cannot be used when the ptr parameter is a Java array.");
        }
        if (Checks.CHECKS) {
            Checks.check(command_queue);
            Checks.check(image);
            Checks.check(origin2, 3);
            Checks.check(region, 3);
            Checks.checkSafe(event, 1);
        }
        return JNI.callPPPPPPPPPI(command_queue, image, blocking_write ? 1 : 0, MemoryUtil.memAddress(origin2), MemoryUtil.memAddress(region), input_row_pitch, input_slice_pitch, ptr, Checks.remainingSafe(event_wait_list), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event), __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clEnqueueWriteImage(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long image, @NativeType(value="cl_bool") boolean blocking_write, @NativeType(value="size_t const *") PointerBuffer origin2, @NativeType(value="size_t const *") PointerBuffer region, @NativeType(value="size_t") long input_row_pitch, @NativeType(value="size_t") long input_slice_pitch, @NativeType(value="void const *") int[] ptr, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        long __functionAddress = CL.getICD().clEnqueueWriteImage;
        if (!blocking_write) {
            throw new IllegalArgumentException("Non blocking writes cannot be used when the ptr parameter is a Java array.");
        }
        if (Checks.CHECKS) {
            Checks.check(command_queue);
            Checks.check(image);
            Checks.check(origin2, 3);
            Checks.check(region, 3);
            Checks.checkSafe(event, 1);
        }
        return JNI.callPPPPPPPPPI(command_queue, image, blocking_write ? 1 : 0, MemoryUtil.memAddress(origin2), MemoryUtil.memAddress(region), input_row_pitch, input_slice_pitch, ptr, Checks.remainingSafe(event_wait_list), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event), __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clEnqueueWriteImage(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long image, @NativeType(value="cl_bool") boolean blocking_write, @NativeType(value="size_t const *") PointerBuffer origin2, @NativeType(value="size_t const *") PointerBuffer region, @NativeType(value="size_t") long input_row_pitch, @NativeType(value="size_t") long input_slice_pitch, @NativeType(value="void const *") float[] ptr, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        long __functionAddress = CL.getICD().clEnqueueWriteImage;
        if (!blocking_write) {
            throw new IllegalArgumentException("Non blocking writes cannot be used when the ptr parameter is a Java array.");
        }
        if (Checks.CHECKS) {
            Checks.check(command_queue);
            Checks.check(image);
            Checks.check(origin2, 3);
            Checks.check(region, 3);
            Checks.checkSafe(event, 1);
        }
        return JNI.callPPPPPPPPPI(command_queue, image, blocking_write ? 1 : 0, MemoryUtil.memAddress(origin2), MemoryUtil.memAddress(region), input_row_pitch, input_slice_pitch, ptr, Checks.remainingSafe(event_wait_list), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event), __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clEnqueueWriteImage(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long image, @NativeType(value="cl_bool") boolean blocking_write, @NativeType(value="size_t const *") PointerBuffer origin2, @NativeType(value="size_t const *") PointerBuffer region, @NativeType(value="size_t") long input_row_pitch, @NativeType(value="size_t") long input_slice_pitch, @NativeType(value="void const *") double[] ptr, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        long __functionAddress = CL.getICD().clEnqueueWriteImage;
        if (!blocking_write) {
            throw new IllegalArgumentException("Non blocking writes cannot be used when the ptr parameter is a Java array.");
        }
        if (Checks.CHECKS) {
            Checks.check(command_queue);
            Checks.check(image);
            Checks.check(origin2, 3);
            Checks.check(region, 3);
            Checks.checkSafe(event, 1);
        }
        return JNI.callPPPPPPPPPI(command_queue, image, blocking_write ? 1 : 0, MemoryUtil.memAddress(origin2), MemoryUtil.memAddress(region), input_row_pitch, input_slice_pitch, ptr, Checks.remainingSafe(event_wait_list), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event), __functionAddress);
    }

    @Nullable
    @NativeType(value="void *")
    public static ByteBuffer clEnqueueMapImage(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long image, @NativeType(value="cl_bool") boolean blocking_map, @NativeType(value="cl_map_flags") long map_flags, @NativeType(value="size_t const *") PointerBuffer origin2, @NativeType(value="size_t const *") PointerBuffer region, @NativeType(value="size_t *") PointerBuffer image_row_pitch, @Nullable @NativeType(value="size_t *") PointerBuffer image_slice_pitch, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event, @Nullable @NativeType(value="cl_int *") int[] errcode_ret, @Nullable ByteBuffer old_buffer) {
        long __functionAddress = CL.getICD().clEnqueueMapImage;
        if (Checks.CHECKS) {
            Checks.check(command_queue);
            Checks.check(image);
            Checks.check(origin2, 3);
            Checks.check(region, 3);
            Checks.check(image_row_pitch, 1);
            Checks.checkSafe(image_slice_pitch, 1);
            Checks.checkSafe(event, 1);
            Checks.checkSafe(errcode_ret, 1);
        }
        long __result = JNI.callPPJPPPPPPPP(command_queue, image, blocking_map ? 1 : 0, map_flags, MemoryUtil.memAddress(origin2), MemoryUtil.memAddress(region), MemoryUtil.memAddress(image_row_pitch), MemoryUtil.memAddressSafe(image_slice_pitch), Checks.remainingSafe(event_wait_list), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event), errcode_ret, __functionAddress);
        int length = (int)CL10.getMemObjectInfoPointer(image, 4354);
        return APIUtil.apiGetMappedBuffer(old_buffer, __result, length);
    }

    @Nullable
    @NativeType(value="void *")
    public static ByteBuffer clEnqueueMapImage(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="cl_mem") long image, @NativeType(value="cl_bool") boolean blocking_map, @NativeType(value="cl_map_flags") long map_flags, @NativeType(value="size_t const *") PointerBuffer origin2, @NativeType(value="size_t const *") PointerBuffer region, @NativeType(value="size_t *") PointerBuffer image_row_pitch, @Nullable @NativeType(value="size_t *") PointerBuffer image_slice_pitch, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event, @Nullable @NativeType(value="cl_int *") int[] errcode_ret, long length, @Nullable ByteBuffer old_buffer) {
        long __functionAddress = CL.getICD().clEnqueueMapImage;
        if (Checks.CHECKS) {
            Checks.check(command_queue);
            Checks.check(image);
            Checks.check(origin2, 3);
            Checks.check(region, 3);
            Checks.check(image_row_pitch, 1);
            Checks.checkSafe(image_slice_pitch, 1);
            Checks.checkSafe(event, 1);
            Checks.checkSafe(errcode_ret, 1);
        }
        long __result = JNI.callPPJPPPPPPPP(command_queue, image, blocking_map ? 1 : 0, map_flags, MemoryUtil.memAddress(origin2), MemoryUtil.memAddress(region), MemoryUtil.memAddress(image_row_pitch), MemoryUtil.memAddressSafe(image_slice_pitch), Checks.remainingSafe(event_wait_list), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event), errcode_ret, __functionAddress);
        return APIUtil.apiGetMappedBuffer(old_buffer, __result, (int)length);
    }

    @NativeType(value="cl_int")
    public static int clGetImageInfo(@NativeType(value="cl_mem") long image, @NativeType(value="cl_image_info") int param_name, @Nullable @NativeType(value="void *") int[] param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        long __functionAddress = CL.getICD().clGetImageInfo;
        if (Checks.CHECKS) {
            Checks.check(image);
            Checks.checkSafe(param_value_size_ret, 1);
        }
        return JNI.callPPPPI(image, param_name, Integer.toUnsignedLong(Checks.lengthSafe(param_value)) << 2, param_value, MemoryUtil.memAddressSafe(param_value_size_ret), __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clGetMemObjectInfo(@NativeType(value="cl_mem") long memobj, @NativeType(value="cl_mem_info") int param_name, @Nullable @NativeType(value="void *") int[] param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        long __functionAddress = CL.getICD().clGetMemObjectInfo;
        if (Checks.CHECKS) {
            Checks.check(memobj);
            Checks.checkSafe(param_value_size_ret, 1);
        }
        return JNI.callPPPPI(memobj, param_name, Integer.toUnsignedLong(Checks.lengthSafe(param_value)) << 2, param_value, MemoryUtil.memAddressSafe(param_value_size_ret), __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clGetMemObjectInfo(@NativeType(value="cl_mem") long memobj, @NativeType(value="cl_mem_info") int param_name, @Nullable @NativeType(value="void *") long[] param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        long __functionAddress = CL.getICD().clGetMemObjectInfo;
        if (Checks.CHECKS) {
            Checks.check(memobj);
            Checks.checkSafe(param_value_size_ret, 1);
        }
        return JNI.callPPPPI(memobj, param_name, Integer.toUnsignedLong(Checks.lengthSafe(param_value)) << 3, param_value, MemoryUtil.memAddressSafe(param_value_size_ret), __functionAddress);
    }

    @NativeType(value="cl_sampler")
    public static long clCreateSampler(@NativeType(value="cl_context") long context2, @NativeType(value="cl_bool") boolean normalized_coords, @NativeType(value="cl_addressing_mode") int addressing_mode, @NativeType(value="cl_filter_mode") int filter_mode, @Nullable @NativeType(value="cl_int *") int[] errcode_ret) {
        long __functionAddress = CL.getICD().clCreateSampler;
        if (Checks.CHECKS) {
            Checks.check(context2);
            Checks.checkSafe(errcode_ret, 1);
        }
        return JNI.callPPP(context2, normalized_coords ? 1 : 0, addressing_mode, filter_mode, errcode_ret, __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clGetSamplerInfo(@NativeType(value="cl_sampler") long sampler, @NativeType(value="cl_sampler_info") int param_name, @Nullable @NativeType(value="void *") int[] param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        long __functionAddress = CL.getICD().clGetSamplerInfo;
        if (Checks.CHECKS) {
            Checks.check(sampler);
            Checks.checkSafe(param_value_size_ret, 1);
        }
        return JNI.callPPPPI(sampler, param_name, Integer.toUnsignedLong(Checks.lengthSafe(param_value)) << 2, param_value, MemoryUtil.memAddressSafe(param_value_size_ret), __functionAddress);
    }

    @NativeType(value="cl_program")
    public static long clCreateProgramWithSource(@NativeType(value="cl_context") long context2, @NativeType(value="cl_char const **") PointerBuffer strings, @Nullable @NativeType(value="size_t const *") PointerBuffer lengths, @Nullable @NativeType(value="cl_int *") int[] errcode_ret) {
        long __functionAddress = CL.getICD().clCreateProgramWithSource;
        if (Checks.CHECKS) {
            Checks.check(context2);
            Checks.checkSafe(lengths, strings.remaining());
            Checks.checkSafe(errcode_ret, 1);
        }
        return JNI.callPPPPP(context2, strings.remaining(), MemoryUtil.memAddress(strings), MemoryUtil.memAddressSafe(lengths), errcode_ret, __functionAddress);
    }

    @NativeType(value="cl_program")
    public static long clCreateProgramWithBinary(@NativeType(value="cl_context") long context2, @NativeType(value="cl_device_id const *") PointerBuffer device_list, @NativeType(value="size_t const *") PointerBuffer lengths, @NativeType(value="cl_uchar const **") PointerBuffer binaries, @Nullable @NativeType(value="cl_int *") int[] binary_status, @Nullable @NativeType(value="cl_int *") int[] errcode_ret) {
        long __functionAddress = CL.getICD().clCreateProgramWithBinary;
        if (Checks.CHECKS) {
            Checks.check(context2);
            Checks.check(device_list, binaries.remaining());
            Checks.check(lengths, binaries.remaining());
            Checks.checkSafe(binary_status, binaries.remaining());
            Checks.checkSafe(errcode_ret, 1);
        }
        return JNI.callPPPPPPP(context2, binaries.remaining(), MemoryUtil.memAddress(device_list), MemoryUtil.memAddress(lengths), MemoryUtil.memAddress(binaries), binary_status, errcode_ret, __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clGetProgramInfo(@NativeType(value="cl_program") long program, @NativeType(value="cl_program_info") int param_name, @Nullable @NativeType(value="void *") int[] param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        long __functionAddress = CL.getICD().clGetProgramInfo;
        if (Checks.CHECKS) {
            Checks.check(program);
            Checks.checkSafe(param_value_size_ret, 1);
        }
        return JNI.callPPPPI(program, param_name, Integer.toUnsignedLong(Checks.lengthSafe(param_value)) << 2, param_value, MemoryUtil.memAddressSafe(param_value_size_ret), __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clGetProgramBuildInfo(@NativeType(value="cl_program") long program, @NativeType(value="cl_device_id") long device2, @NativeType(value="cl_program_info") int param_name, @Nullable @NativeType(value="void *") int[] param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        long __functionAddress = CL.getICD().clGetProgramBuildInfo;
        if (Checks.CHECKS) {
            Checks.check(program);
            Checks.check(device2);
            Checks.checkSafe(param_value_size_ret, 1);
        }
        return JNI.callPPPPPI(program, device2, param_name, Integer.toUnsignedLong(Checks.lengthSafe(param_value)) << 2, param_value, MemoryUtil.memAddressSafe(param_value_size_ret), __functionAddress);
    }

    @NativeType(value="cl_kernel")
    public static long clCreateKernel(@NativeType(value="cl_program") long program, @NativeType(value="cl_char const *") ByteBuffer kernel_name, @Nullable @NativeType(value="cl_int *") int[] errcode_ret) {
        long __functionAddress = CL.getICD().clCreateKernel;
        if (Checks.CHECKS) {
            Checks.check(program);
            Checks.checkNT1(kernel_name);
            Checks.checkSafe(errcode_ret, 1);
        }
        return JNI.callPPPP(program, MemoryUtil.memAddress(kernel_name), errcode_ret, __functionAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="cl_kernel")
    public static long clCreateKernel(@NativeType(value="cl_program") long program, @NativeType(value="cl_char const *") CharSequence kernel_name, @Nullable @NativeType(value="cl_int *") int[] errcode_ret) {
        long __functionAddress = CL.getICD().clCreateKernel;
        if (Checks.CHECKS) {
            Checks.check(program);
            Checks.checkSafe(errcode_ret, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(kernel_name, true);
            long kernel_nameEncoded = stack.getPointerAddress();
            long l = JNI.callPPPP(program, kernel_nameEncoded, errcode_ret, __functionAddress);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="cl_int")
    public static int clCreateKernelsInProgram(@NativeType(value="cl_program") long program, @Nullable @NativeType(value="cl_kernel *") PointerBuffer kernels, @Nullable @NativeType(value="cl_uint *") int[] num_kernels_ret) {
        long __functionAddress = CL.getICD().clCreateKernelsInProgram;
        if (Checks.CHECKS) {
            Checks.check(program);
            Checks.checkSafe(num_kernels_ret, 1);
        }
        return JNI.callPPPI(program, Checks.remainingSafe(kernels), MemoryUtil.memAddressSafe(kernels), num_kernels_ret, __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clSetKernelArg(@NativeType(value="cl_kernel") long kernel, @NativeType(value="cl_uint") int arg_index, @NativeType(value="void const *") short[] arg_value) {
        long __functionAddress = CL.getICD().clSetKernelArg;
        if (Checks.CHECKS) {
            Checks.check(kernel);
        }
        return JNI.callPPPI(kernel, arg_index, Integer.toUnsignedLong(arg_value.length) << 1, arg_value, __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clSetKernelArg(@NativeType(value="cl_kernel") long kernel, @NativeType(value="cl_uint") int arg_index, @NativeType(value="void const *") int[] arg_value) {
        long __functionAddress = CL.getICD().clSetKernelArg;
        if (Checks.CHECKS) {
            Checks.check(kernel);
        }
        return JNI.callPPPI(kernel, arg_index, Integer.toUnsignedLong(arg_value.length) << 2, arg_value, __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clSetKernelArg(@NativeType(value="cl_kernel") long kernel, @NativeType(value="cl_uint") int arg_index, @NativeType(value="void const *") long[] arg_value) {
        long __functionAddress = CL.getICD().clSetKernelArg;
        if (Checks.CHECKS) {
            Checks.check(kernel);
        }
        return JNI.callPPPI(kernel, arg_index, Integer.toUnsignedLong(arg_value.length) << 3, arg_value, __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clSetKernelArg(@NativeType(value="cl_kernel") long kernel, @NativeType(value="cl_uint") int arg_index, @NativeType(value="void const *") float[] arg_value) {
        long __functionAddress = CL.getICD().clSetKernelArg;
        if (Checks.CHECKS) {
            Checks.check(kernel);
        }
        return JNI.callPPPI(kernel, arg_index, Integer.toUnsignedLong(arg_value.length) << 2, arg_value, __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clSetKernelArg(@NativeType(value="cl_kernel") long kernel, @NativeType(value="cl_uint") int arg_index, @NativeType(value="void const *") double[] arg_value) {
        long __functionAddress = CL.getICD().clSetKernelArg;
        if (Checks.CHECKS) {
            Checks.check(kernel);
        }
        return JNI.callPPPI(kernel, arg_index, Integer.toUnsignedLong(arg_value.length) << 3, arg_value, __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clGetKernelInfo(@NativeType(value="cl_kernel") long kernel, @NativeType(value="cl_kernel_info") int param_name, @Nullable @NativeType(value="void *") int[] param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        long __functionAddress = CL.getICD().clGetKernelInfo;
        if (Checks.CHECKS) {
            Checks.check(kernel);
            Checks.checkSafe(param_value_size_ret, 1);
        }
        return JNI.callPPPPI(kernel, param_name, Integer.toUnsignedLong(Checks.lengthSafe(param_value)) << 2, param_value, MemoryUtil.memAddressSafe(param_value_size_ret), __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clGetKernelWorkGroupInfo(@NativeType(value="cl_kernel") long kernel, @NativeType(value="cl_device_id") long device2, @NativeType(value="cl_kernel_work_group_info") int param_name, @Nullable @NativeType(value="void *") int[] param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        long __functionAddress = CL.getICD().clGetKernelWorkGroupInfo;
        if (Checks.CHECKS) {
            Checks.check(kernel);
            Checks.check(device2);
            Checks.checkSafe(param_value_size_ret, 1);
        }
        return JNI.callPPPPPI(kernel, device2, param_name, Integer.toUnsignedLong(Checks.lengthSafe(param_value)) << 2, param_value, MemoryUtil.memAddressSafe(param_value_size_ret), __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clGetKernelWorkGroupInfo(@NativeType(value="cl_kernel") long kernel, @NativeType(value="cl_device_id") long device2, @NativeType(value="cl_kernel_work_group_info") int param_name, @Nullable @NativeType(value="void *") long[] param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        long __functionAddress = CL.getICD().clGetKernelWorkGroupInfo;
        if (Checks.CHECKS) {
            Checks.check(kernel);
            Checks.check(device2);
            Checks.checkSafe(param_value_size_ret, 1);
        }
        return JNI.callPPPPPI(kernel, device2, param_name, Integer.toUnsignedLong(Checks.lengthSafe(param_value)) << 3, param_value, MemoryUtil.memAddressSafe(param_value_size_ret), __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clGetEventInfo(@NativeType(value="cl_event") long event, @NativeType(value="cl_event_info") int param_name, @Nullable @NativeType(value="void *") int[] param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        long __functionAddress = CL.getICD().clGetEventInfo;
        if (Checks.CHECKS) {
            Checks.check(event);
            Checks.checkSafe(param_value_size_ret, 1);
        }
        return JNI.callPPPPI(event, param_name, Integer.toUnsignedLong(Checks.lengthSafe(param_value)) << 2, param_value, MemoryUtil.memAddressSafe(param_value_size_ret), __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clGetEventProfilingInfo(@NativeType(value="cl_event") long event, @NativeType(value="cl_profiling_info") int param_name, @Nullable @NativeType(value="void *") long[] param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        long __functionAddress = CL.getICD().clGetEventProfilingInfo;
        if (Checks.CHECKS) {
            Checks.check(event);
            Checks.checkSafe(param_value_size_ret, 1);
        }
        return JNI.callPPPPI(event, param_name, Integer.toUnsignedLong(Checks.lengthSafe(param_value)) << 3, param_value, MemoryUtil.memAddressSafe(param_value_size_ret), __functionAddress);
    }

    private static long getMemObjectInfoPointer(long cl_mem, int param_name) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            PointerBuffer pp = stack.pointers(0L);
            long l = CL10.clGetMemObjectInfo(cl_mem, param_name, pp, null) == 0 ? pp.get(0) : 0L;
            return l;
        }
    }
}

