/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.CheckIntrinsics;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Pointer;

public class PointerBuffer
extends CustomBuffer<PointerBuffer>
implements Comparable<PointerBuffer> {
    protected PointerBuffer(long address, @Nullable ByteBuffer container2, int mark, int position, int limit, int capacity) {
        super(address, container2, mark, position, limit, capacity);
    }

    public static PointerBuffer allocateDirect(int capacity) {
        ByteBuffer source = BufferUtils.createByteBuffer(BufferUtils.getAllocationSize(capacity, POINTER_SHIFT));
        return PointerBuffer.wrap(PointerBuffer.class, MemoryUtil.memAddress(source), capacity, source);
    }

    public static PointerBuffer create(long address, int capacity) {
        return PointerBuffer.wrap(PointerBuffer.class, address, capacity);
    }

    public static PointerBuffer create(ByteBuffer source) {
        int capacity = source.remaining() >> POINTER_SHIFT;
        return PointerBuffer.wrap(PointerBuffer.class, MemoryUtil.memAddress(source), capacity, source);
    }

    @Override
    protected PointerBuffer self() {
        return this;
    }

    @Override
    public int sizeof() {
        return POINTER_SIZE;
    }

    public long get() {
        return MemoryUtil.memGetAddress(this.address + Integer.toUnsignedLong(this.nextGetIndex()) * (long)POINTER_SIZE);
    }

    public static long get(ByteBuffer source) {
        if (source.remaining() < POINTER_SIZE) {
            throw new BufferUnderflowException();
        }
        try {
            long l = MemoryUtil.memGetAddress(MemoryUtil.memAddress(source));
            return l;
        }
        finally {
            source.position(source.position() + POINTER_SIZE);
        }
    }

    @Override
    public PointerBuffer put(long p) {
        MemoryUtil.memPutAddress(this.address + Integer.toUnsignedLong(this.nextPutIndex()) * (long)POINTER_SIZE, p);
        return this;
    }

    public static void put(ByteBuffer target, long p) {
        if (target.remaining() < POINTER_SIZE) {
            throw new BufferOverflowException();
        }
        try {
            MemoryUtil.memPutAddress(MemoryUtil.memAddress(target), p);
        }
        finally {
            target.position(target.position() + POINTER_SIZE);
        }
    }

    public long get(int index2) {
        return MemoryUtil.memGetAddress(this.address + Checks.check(index2, this.limit) * (long)POINTER_SIZE);
    }

    public static long get(ByteBuffer source, int index2) {
        CheckIntrinsics.checkFromIndexSize(index2, POINTER_SIZE, source.limit());
        return MemoryUtil.memGetAddress(MemoryUtil.memAddress0(source) + (long)index2);
    }

    public PointerBuffer put(int index2, long p) {
        MemoryUtil.memPutAddress(this.address + Checks.check(index2, this.limit) * (long)POINTER_SIZE, p);
        return this;
    }

    public static void put(ByteBuffer target, int index2, long p) {
        CheckIntrinsics.checkFromIndexSize(index2, POINTER_SIZE, target.limit());
        MemoryUtil.memPutAddress(MemoryUtil.memAddress0(target) + (long)index2, p);
    }

    @Override
    public PointerBuffer put(Pointer pointer) {
        this.put(pointer.address());
        return this;
    }

    public PointerBuffer put(int index2, Pointer pointer) {
        this.put(index2, pointer.address());
        return this;
    }

    @Override
    public PointerBuffer put(ByteBuffer buffer) {
        this.put(MemoryUtil.memAddress(buffer));
        return this;
    }

    @Override
    public PointerBuffer put(ShortBuffer buffer) {
        this.put(MemoryUtil.memAddress(buffer));
        return this;
    }

    @Override
    public PointerBuffer put(IntBuffer buffer) {
        this.put(MemoryUtil.memAddress(buffer));
        return this;
    }

    @Override
    public PointerBuffer put(LongBuffer buffer) {
        this.put(MemoryUtil.memAddress(buffer));
        return this;
    }

    @Override
    public PointerBuffer put(FloatBuffer buffer) {
        this.put(MemoryUtil.memAddress(buffer));
        return this;
    }

    @Override
    public PointerBuffer put(DoubleBuffer buffer) {
        this.put(MemoryUtil.memAddress(buffer));
        return this;
    }

    public PointerBuffer putAddressOf(CustomBuffer<?> buffer) {
        this.put(MemoryUtil.memAddress(buffer));
        return this;
    }

    public PointerBuffer put(int index2, ByteBuffer buffer) {
        this.put(index2, MemoryUtil.memAddress(buffer));
        return this;
    }

    public PointerBuffer put(int index2, ShortBuffer buffer) {
        this.put(index2, MemoryUtil.memAddress(buffer));
        return this;
    }

    public PointerBuffer put(int index2, IntBuffer buffer) {
        this.put(index2, MemoryUtil.memAddress(buffer));
        return this;
    }

    public PointerBuffer put(int index2, LongBuffer buffer) {
        this.put(index2, MemoryUtil.memAddress(buffer));
        return this;
    }

    public PointerBuffer put(int index2, FloatBuffer buffer) {
        this.put(index2, MemoryUtil.memAddress(buffer));
        return this;
    }

    public PointerBuffer put(int index2, DoubleBuffer buffer) {
        this.put(index2, MemoryUtil.memAddress(buffer));
        return this;
    }

    public PointerBuffer putAddressOf(int index2, CustomBuffer<?> buffer) {
        this.put(index2, MemoryUtil.memAddress(buffer));
        return this;
    }

    public ByteBuffer getByteBuffer(int size2) {
        return MemoryUtil.memByteBuffer(this.get(), size2);
    }

    public ShortBuffer getShortBuffer(int size2) {
        return MemoryUtil.memShortBuffer(this.get(), size2);
    }

    public IntBuffer getIntBuffer(int size2) {
        return MemoryUtil.memIntBuffer(this.get(), size2);
    }

    public LongBuffer getLongBuffer(int size2) {
        return MemoryUtil.memLongBuffer(this.get(), size2);
    }

    public FloatBuffer getFloatBuffer(int size2) {
        return MemoryUtil.memFloatBuffer(this.get(), size2);
    }

    public DoubleBuffer getDoubleBuffer(int size2) {
        return MemoryUtil.memDoubleBuffer(this.get(), size2);
    }

    public PointerBuffer getPointerBuffer(int size2) {
        return MemoryUtil.memPointerBuffer(this.get(), size2);
    }

    public String getStringASCII() {
        return MemoryUtil.memASCII(this.get());
    }

    public String getStringUTF8() {
        return MemoryUtil.memUTF8(this.get());
    }

    public String getStringUTF16() {
        return MemoryUtil.memUTF16(this.get());
    }

    public ByteBuffer getByteBuffer(int index2, int size2) {
        return MemoryUtil.memByteBuffer(this.get(index2), size2);
    }

    public ShortBuffer getShortBuffer(int index2, int size2) {
        return MemoryUtil.memShortBuffer(this.get(index2), size2);
    }

    public IntBuffer getIntBuffer(int index2, int size2) {
        return MemoryUtil.memIntBuffer(this.get(index2), size2);
    }

    public LongBuffer getLongBuffer(int index2, int size2) {
        return MemoryUtil.memLongBuffer(this.get(index2), size2);
    }

    public FloatBuffer getFloatBuffer(int index2, int size2) {
        return MemoryUtil.memFloatBuffer(this.get(index2), size2);
    }

    public DoubleBuffer getDoubleBuffer(int index2, int size2) {
        return MemoryUtil.memDoubleBuffer(this.get(index2), size2);
    }

    public PointerBuffer getPointerBuffer(int index2, int size2) {
        return MemoryUtil.memPointerBuffer(this.get(index2), size2);
    }

    public String getStringASCII(int index2) {
        return MemoryUtil.memASCII(this.get(index2));
    }

    public String getStringUTF8(int index2) {
        return MemoryUtil.memUTF8(this.get(index2));
    }

    public String getStringUTF16(int index2) {
        return MemoryUtil.memUTF16(this.get(index2));
    }

    public PointerBuffer get(long[] dst) {
        return this.get(dst, 0, dst.length);
    }

    public PointerBuffer get(long[] dst, int offset2, int length) {
        if (BITS64) {
            MemoryUtil.memLongBuffer(this.address(), this.remaining()).get(dst, offset2, length);
            this.position(this.position() + length);
        } else {
            this.get32(dst, offset2, length);
        }
        return this;
    }

    private void get32(long[] dst, int offset2, int length) {
        CheckIntrinsics.checkFromIndexSize(offset2, length, dst.length);
        if (this.remaining() < length) {
            throw new BufferUnderflowException();
        }
        int end2 = offset2 + length;
        for (int i = offset2; i < end2; ++i) {
            dst[i] = this.get();
        }
    }

    @Override
    public PointerBuffer put(long[] src) {
        return this.put(src, 0, src.length);
    }

    public PointerBuffer put(long[] src, int offset2, int length) {
        if (BITS64) {
            MemoryUtil.memLongBuffer(this.address(), this.remaining()).put(src, offset2, length);
            this.position(this.position() + length);
        } else {
            this.put32(src, offset2, length);
        }
        return this;
    }

    private void put32(long[] src, int offset2, int length) {
        CheckIntrinsics.checkFromIndexSize(offset2, length, src.length);
        if (this.remaining() < length) {
            throw new BufferOverflowException();
        }
        int end2 = offset2 + length;
        for (int i = offset2; i < end2; ++i) {
            this.put(src[i]);
        }
    }

    @Override
    public int hashCode() {
        int h = 1;
        int p = this.position();
        for (int i = this.limit() - 1; i >= p; --i) {
            h = 31 * h + (int)this.get(i);
        }
        return h;
    }

    @Override
    public boolean equals(Object ob) {
        if (!(ob instanceof PointerBuffer)) {
            return false;
        }
        PointerBuffer that = (PointerBuffer)ob;
        if (this.remaining() != that.remaining()) {
            return false;
        }
        int p = this.position();
        int i = this.limit() - 1;
        int j = that.limit() - 1;
        while (i >= p) {
            long v2;
            long v1 = this.get(i);
            if (v1 != (v2 = that.get(j))) {
                return false;
            }
            --i;
            --j;
        }
        return true;
    }

    @Override
    public int compareTo(PointerBuffer that) {
        int n = this.position() + Math.min(this.remaining(), that.remaining());
        int i = this.position();
        int j = that.position();
        while (i < n) {
            long v2;
            long v1 = this.get(i);
            if (v1 != (v2 = that.get(j))) {
                if (v1 < v2) {
                    return -1;
                }
                return 1;
            }
            ++i;
            ++j;
        }
        return this.remaining() - that.remaining();
    }
}

