/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko.swing;

import java.awt.Graphics2D;
import java.util.concurrent.CancellationException;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.skiko.GraphicsApi;
import org.jetbrains.skiko.Logger;
import org.jetbrains.skiko.OsArch_jvmKt;
import org.jetbrains.skiko.SkiaLayerAnalytics;
import org.jetbrains.skiko.SkikoLoggerInterface;
import org.jetbrains.skiko.Version;
import org.jetbrains.skiko.swing.SwingLayerProperties;
import org.jetbrains.skiko.swing.SwingLayerPropertiesKt;
import org.jetbrains.skiko.swing.SwingRedrawer;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\b \u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0017\u0010\u0012\u001a\u00020\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00110\u0014H\u0082\bJ\b\u0010\u0015\u001a\u00020\u0011H\u0004J\u0012\u0010\u0016\u001a\u00020\u00112\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0004J(\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020 H$J\u000e\u0010!\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u001bJ\b\u0010\"\u001a\u00020\u0018H\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/jetbrains/skiko/swing/SwingRedrawerBase;", "Lorg/jetbrains/skiko/swing/SwingRedrawer;", "swingLayerProperties", "Lorg/jetbrains/skiko/swing/SwingLayerProperties;", "analytics", "Lorg/jetbrains/skiko/SkiaLayerAnalytics;", "graphicsApi", "Lorg/jetbrains/skiko/GraphicsApi;", "(Lorg/jetbrains/skiko/swing/SwingLayerProperties;Lorg/jetbrains/skiko/SkiaLayerAnalytics;Lorg/jetbrains/skiko/GraphicsApi;)V", "deviceAnalytics", "Lorg/jetbrains/skiko/SkiaLayerAnalytics$DeviceAnalytics;", "isDisposed", "", "isFirstFrameRendered", "rendererAnalytics", "Lorg/jetbrains/skiko/SkiaLayerAnalytics$RendererAnalytics;", "dispose", "", "inDrawScope", "body", "Lkotlin/Function0;", "onContextInit", "onDeviceChosen", "deviceName", "", "onRender", "g", "Ljava/awt/Graphics2D;", "width", "", "height", "nanoTime", "", "redraw", "rendererInfo", "skiko"})
@SourceDebugExtension(value={"SMAP\nSwingRedrawerBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SwingRedrawerBase.kt\norg/jetbrains/skiko/swing/SwingRedrawerBase\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Logging.kt\norg/jetbrains/skiko/Logger\n*L\n1#1,98:1\n81#1:100\n82#1,16:102\n1#2:99\n1#2:101\n124#3,4:118\n*S KotlinDebug\n*F\n+ 1 SwingRedrawerBase.kt\norg/jetbrains/skiko/swing/SwingRedrawerBase\n*L\n47#1:100\n47#1:102,16\n47#1:101\n75#1:118,4\n*E\n"})
public abstract class SwingRedrawerBase
implements SwingRedrawer {
    @NotNull
    private final SwingLayerProperties swingLayerProperties;
    @NotNull
    private final SkiaLayerAnalytics analytics;
    @NotNull
    private final GraphicsApi graphicsApi;
    private boolean isFirstFrameRendered;
    @NotNull
    private final SkiaLayerAnalytics.RendererAnalytics rendererAnalytics;
    @Nullable
    private SkiaLayerAnalytics.DeviceAnalytics deviceAnalytics;
    private boolean isDisposed;

    public SwingRedrawerBase(@NotNull SwingLayerProperties swingLayerProperties2, @NotNull SkiaLayerAnalytics analytics, @NotNull GraphicsApi graphicsApi) {
        Intrinsics.checkNotNullParameter(swingLayerProperties2, "swingLayerProperties");
        Intrinsics.checkNotNullParameter(analytics, "analytics");
        Intrinsics.checkNotNullParameter((Object)graphicsApi, "graphicsApi");
        this.swingLayerProperties = swingLayerProperties2;
        this.analytics = analytics;
        this.graphicsApi = graphicsApi;
        this.rendererAnalytics = this.analytics.renderer(Version.INSTANCE.getSkiko(), OsArch_jvmKt.getHostOs(), this.graphicsApi);
        this.rendererAnalytics.init();
    }

    protected abstract void onRender(@NotNull Graphics2D var1, int var2, int var3, long var4);

    @Override
    public void dispose() {
        if (!(!this.isDisposed)) {
            boolean bl = false;
            String string = this.getClass() + " is disposed";
            throw new IllegalArgumentException(string.toString());
        }
        this.isDisposed = true;
    }

    @Override
    public final void redraw(@NotNull Graphics2D g) {
        Intrinsics.checkNotNullParameter(g, "g");
        if (!(!this.isDisposed)) {
            boolean $i$a$-require-SwingRedrawerBase$redraw$22 = false;
            String $i$a$-require-SwingRedrawerBase$redraw$22 = this.getClass() + " is disposed";
            throw new IllegalArgumentException($i$a$-require-SwingRedrawerBase$redraw$22.toString());
        }
        SwingRedrawerBase this_$iv = this;
        boolean $i$f$inDrawScope = false;
        if (!SwingUtilities.isEventDispatchThread()) {
            boolean $i$a$-check-SwingRedrawerBase$inDrawScope$1$iv22 = false;
            String $i$a$-check-SwingRedrawerBase$inDrawScope$1$iv22 = "Method should be called from AWT event dispatch thread";
            throw new IllegalStateException($i$a$-check-SwingRedrawerBase$inDrawScope$1$iv22.toString());
        }
        SkiaLayerAnalytics.DeviceAnalytics deviceAnalytics = this_$iv.deviceAnalytics;
        if (deviceAnalytics == null) {
            boolean bl = false;
            String string = "deviceAnalytics is not null. Call onDeviceChosen after choosing the drawing device";
            throw new IllegalArgumentException(string.toString());
        }
        if (!this_$iv.isDisposed) {
            if (!this_$iv.isFirstFrameRendered) {
                SkiaLayerAnalytics.DeviceAnalytics deviceAnalytics2 = deviceAnalytics = this_$iv.deviceAnalytics;
                if (deviceAnalytics2 != null) {
                    deviceAnalytics2.beforeFirstFrameRender();
                }
            }
            try {
                boolean bl = false;
                float scale2 = SwingLayerPropertiesKt.getScale(this.swingLayerProperties);
                int width2 = RangesKt.coerceAtLeast((int)((float)this.swingLayerProperties.getWidth() * scale2), 0);
                int height2 = RangesKt.coerceAtLeast((int)((float)this.swingLayerProperties.getHeight() * scale2), 0);
                this.onRender(g, width2, height2, System.nanoTime());
            }
            catch (CancellationException cancellationException) {
                // empty catch block
            }
            if (!this_$iv.isFirstFrameRendered && !this_$iv.isDisposed) {
                SkiaLayerAnalytics.DeviceAnalytics deviceAnalytics3 = this_$iv.deviceAnalytics;
                if (deviceAnalytics3 != null) {
                    deviceAnalytics3.afterFirstFrameRender();
                }
            }
            this_$iv.isFirstFrameRendered = true;
        }
    }

    protected final void onDeviceChosen(@Nullable String deviceName) {
        block2: {
            if (!(!this.isDisposed)) {
                boolean $i$a$-require-SwingRedrawerBase$onDeviceChosen$32 = false;
                String $i$a$-require-SwingRedrawerBase$onDeviceChosen$32 = this.getClass() + " is disposed";
                throw new IllegalArgumentException($i$a$-require-SwingRedrawerBase$onDeviceChosen$32.toString());
            }
            if (!(this.deviceAnalytics == null)) {
                boolean bl = false;
                String string = "deviceAnalytics is not null";
                throw new IllegalArgumentException(string.toString());
            }
            this.rendererAnalytics.deviceChosen();
            SkiaLayerAnalytics.DeviceAnalytics deviceAnalytics = this.deviceAnalytics = this.analytics.device(Version.INSTANCE.getSkiko(), OsArch_jvmKt.getHostOs(), this.graphicsApi, deviceName);
            if (deviceAnalytics == null) break block2;
            deviceAnalytics.init();
        }
    }

    @NotNull
    protected String rendererInfo() {
        return "GraphicsApi: " + (Object)((Object)this.graphicsApi) + "\nOS: " + OsArch_jvmKt.getHostOs().getId() + ' ' + OsArch_jvmKt.getHostArch().getId() + '\n';
    }

    protected final void onContextInit() {
        block4: {
            if (!(!this.isDisposed)) {
                boolean $i$a$-require-SwingRedrawerBase$onContextInit$22 = false;
                String $i$a$-require-SwingRedrawerBase$onContextInit$22 = this.getClass() + " is disposed";
                throw new IllegalArgumentException($i$a$-require-SwingRedrawerBase$onContextInit$22.toString());
            }
            if (this.deviceAnalytics == null) {
                boolean $i$a$-requireNotNull-SwingRedrawerBase$onContextInit$32 = false;
                String $i$a$-requireNotNull-SwingRedrawerBase$onContextInit$32 = "deviceAnalytics is not null. Call onDeviceChosen after choosing the drawing device";
                throw new IllegalArgumentException($i$a$-requireNotNull-SwingRedrawerBase$onContextInit$32.toString());
            }
            if (Intrinsics.areEqual(System.getProperty("skiko.hardwareInfo.enabled"), "true")) {
                Logger this_$iv = Logger.INSTANCE;
                boolean $i$f$info = false;
                if (this_$iv.getLoggerImpl().isInfoEnabled()) {
                    SkikoLoggerInterface skikoLoggerInterface = this_$iv.getLoggerImpl();
                    boolean bl = false;
                    skikoLoggerInterface.info("Renderer info:\n " + this.rendererInfo());
                }
            }
            SkiaLayerAnalytics.DeviceAnalytics deviceAnalytics = this.deviceAnalytics;
            if (deviceAnalytics == null) break block4;
            deviceAnalytics.contextInit();
        }
    }

    private final void inDrawScope(Function0<Unit> body) {
        boolean $i$f$inDrawScope = false;
        if (!SwingUtilities.isEventDispatchThread()) {
            boolean $i$a$-check-SwingRedrawerBase$inDrawScope$22 = false;
            String $i$a$-check-SwingRedrawerBase$inDrawScope$22 = "Method should be called from AWT event dispatch thread";
            throw new IllegalStateException($i$a$-check-SwingRedrawerBase$inDrawScope$22.toString());
        }
        SkiaLayerAnalytics.DeviceAnalytics deviceAnalytics = this.deviceAnalytics;
        if (deviceAnalytics == null) {
            boolean bl = false;
            String string = "deviceAnalytics is not null. Call onDeviceChosen after choosing the drawing device";
            throw new IllegalArgumentException(string.toString());
        }
        if (!this.isDisposed) {
            if (!this.isFirstFrameRendered) {
                SkiaLayerAnalytics.DeviceAnalytics deviceAnalytics2 = deviceAnalytics = this.deviceAnalytics;
                if (deviceAnalytics2 != null) {
                    deviceAnalytics2.beforeFirstFrameRender();
                }
            }
            try {
                body.invoke();
            }
            catch (CancellationException cancellationException) {
                // empty catch block
            }
            if (!this.isFirstFrameRendered && !this.isDisposed) {
                SkiaLayerAnalytics.DeviceAnalytics deviceAnalytics3 = this.deviceAnalytics;
                if (deviceAnalytics3 != null) {
                    deviceAnalytics3.afterFirstFrameRender();
                }
            }
            this.isFirstFrameRendered = true;
        }
    }
}

