/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skia;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.skia.Canvas;
import org.jetbrains.skia.Path;
import org.jetbrains.skia.Point3;
import org.jetbrains.skia.ShadowUtilsKt;
import org.jetbrains.skia.impl.Library;
import org.jetbrains.skia.impl.NativeKt;
import org.jetbrains.skia.impl.Native_jvmKt;
import org.jetbrains.skia.impl.Stats;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004J\u0016\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004JN\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/skia/ShadowUtils;", "", "()V", "computeTonalAmbientColor", "", "ambientColor", "spotColor", "computeTonalSpotColor", "drawShadow", "", "canvas", "Lorg/jetbrains/skia/Canvas;", "path", "Lorg/jetbrains/skia/Path;", "zPlaneParams", "Lorg/jetbrains/skia/Point3;", "lightPos", "lightRadius", "", "transparentOccluder", "", "geometricOnly", "skiko"})
public final class ShadowUtils {
    @NotNull
    public static final ShadowUtils INSTANCE = new ShadowUtils();

    private ShadowUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void drawShadow(@NotNull Canvas canvas, @NotNull Path path, @NotNull Point3 zPlaneParams, @NotNull Point3 lightPos, float lightRadius, int ambientColor, int spotColor, boolean transparentOccluder, boolean geometricOnly) {
        Intrinsics.checkNotNullParameter(canvas, "canvas");
        Intrinsics.checkNotNullParameter(path, "path");
        Intrinsics.checkNotNullParameter(zPlaneParams, "zPlaneParams");
        Intrinsics.checkNotNullParameter(lightPos, "lightPos");
        Stats.INSTANCE.onNativeCall();
        int flags = 0;
        if (transparentOccluder) {
            flags |= 1;
        }
        if (geometricOnly) {
            flags |= 2;
        }
        try {
            ShadowUtilsKt.access$_nDrawShadow(NativeKt.getPtr(canvas), NativeKt.getPtr(path), zPlaneParams.getX(), zPlaneParams.getY(), zPlaneParams.getZ(), lightPos.getX(), lightPos.getY(), lightPos.getZ(), lightRadius, ambientColor, spotColor, flags);
        }
        finally {
            Native_jvmKt.reachabilityBarrier(canvas);
            Native_jvmKt.reachabilityBarrier(path);
        }
    }

    public final int computeTonalAmbientColor(int ambientColor, int spotColor) {
        Stats.INSTANCE.onNativeCall();
        return ShadowUtilsKt.access$_nComputeTonalAmbientColor(ambientColor, spotColor);
    }

    public final int computeTonalSpotColor(int ambientColor, int spotColor) {
        Stats.INSTANCE.onNativeCall();
        return ShadowUtilsKt.access$_nComputeTonalSpotColor(ambientColor, spotColor);
    }

    static {
        Library.Companion.staticLoad();
    }
}

