/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.datetime.internal.format.parser;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import kotlinx.datetime.internal.DecimalFraction;
import kotlinx.datetime.internal.format.parser.AssignableField;
import kotlinx.datetime.internal.format.parser.NumberConsumer;
import kotlinx.datetime.internal.format.parser.NumberConsumerKt;
import kotlinx.datetime.internal.format.parser.NumberConsumptionError;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000*\u0006\b\u0000\u0010\u0001 \u00002\b\u0012\u0004\u0012\u0002H\u00010\u0002B5\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u001f\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00028\u00002\u0006\u0010\u0010\u001a\u00020\nH\u0016\u00a2\u0006\u0002\u0010\u0011R\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lkotlinx/datetime/internal/format/parser/FractionPartConsumer;", "Receiver", "Lkotlinx/datetime/internal/format/parser/NumberConsumer;", "minLength", "", "maxLength", "setter", "Lkotlinx/datetime/internal/format/parser/AssignableField;", "Lkotlinx/datetime/internal/DecimalFraction;", "name", "", "(Ljava/lang/Integer;Ljava/lang/Integer;Lkotlinx/datetime/internal/format/parser/AssignableField;Ljava/lang/String;)V", "Ljava/lang/Integer;", "consume", "Lkotlinx/datetime/internal/format/parser/NumberConsumptionError;", "storage", "input", "(Ljava/lang/Object;Ljava/lang/String;)Lkotlinx/datetime/internal/format/parser/NumberConsumptionError;", "kotlinx-datetime"})
@SourceDebugExtension(value={"SMAP\nNumberConsumer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NumberConsumer.kt\nkotlinx/datetime/internal/format/parser/FractionPartConsumer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,138:1\n1#2:139\n*E\n"})
public final class FractionPartConsumer<Receiver>
extends NumberConsumer<Receiver> {
    @Nullable
    private final Integer minLength;
    @Nullable
    private final Integer maxLength;
    @NotNull
    private final AssignableField<Receiver, DecimalFraction> setter;

    public FractionPartConsumer(@Nullable Integer minLength, @Nullable Integer maxLength, @NotNull AssignableField<? super Receiver, DecimalFraction> setter, @NotNull String name) {
        Intrinsics.checkNotNullParameter(setter, "setter");
        Intrinsics.checkNotNullParameter(name, "name");
        super(Intrinsics.areEqual(minLength, maxLength) ? minLength : null, name, null);
        this.minLength = minLength;
        this.maxLength = maxLength;
        this.setter = setter;
        if (!(this.minLength == null || new IntRange(1, 9).contains(this.minLength))) {
            boolean bl = false;
            String string = "Invalid length for field " + this.getWhatThisExpects() + ": " + this.getLength();
            throw new IllegalArgumentException(string.toString());
        }
    }

    @Override
    @Nullable
    public NumberConsumptionError consume(Receiver storage2, @NotNull String input) {
        Integer numerator;
        Intrinsics.checkNotNullParameter(input, "input");
        return this.minLength != null && input.length() < this.minLength ? (NumberConsumptionError)new NumberConsumptionError.TooFewDigits(this.minLength) : (this.maxLength != null && input.length() > this.maxLength ? (NumberConsumptionError)new NumberConsumptionError.TooManyDigits(this.maxLength) : ((numerator = StringsKt.toIntOrNull(input)) == null ? (NumberConsumptionError)new NumberConsumptionError.TooManyDigits(9) : NumberConsumerKt.access$setWithoutReassigning(this.setter, storage2, new DecimalFraction(numerator, input.length()))));
    }
}

