/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.coroutines.debug.internal;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.AbstractMutableMap;
import kotlin.collections.AbstractMutableSet;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMutableIterator;
import kotlin.jvm.internal.markers.KMutableMap;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.debug.internal.ConcurrentWeakMap;
import kotlinx.coroutines.debug.internal.ConcurrentWeakMapKt;
import kotlinx.coroutines.debug.internal.HashedWeakRef;
import kotlinx.coroutines.debug.internal.Marked;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0010'\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u0004:\u0003()*B\u000f\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0014\u0010\u0019\u001a\u00020\u001a2\n\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u001cH\u0002J\b\u0010\u001d\u001a\u00020\u001aH\u0016J\b\u0010\u001e\u001a\u00020\u001aH\u0002J\u0018\u0010\u001f\u001a\u0004\u0018\u00018\u00012\u0006\u0010 \u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010!J\u001f\u0010\"\u001a\u0004\u0018\u00018\u00012\u0006\u0010 \u001a\u00028\u00002\u0006\u0010#\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010$J!\u0010%\u001a\u0004\u0018\u00018\u00012\u0006\u0010 \u001a\u00028\u00002\b\u0010#\u001a\u0004\u0018\u00018\u0001H\u0002\u00a2\u0006\u0002\u0010$J\u0017\u0010&\u001a\u0004\u0018\u00018\u00012\u0006\u0010 \u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010!J\u0006\u0010'\u001a\u00020\u001aR\t\u0010\b\u001a\u00020\tX\u0082\u0004R\u001f\u0010\n\u001a\u0018\u0012\u0014\u0012\u00120\fR\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00000\u000bX\u0082\u0004R&\u0010\r\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000f0\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0011R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0016\u0010\u0005\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lkotlinx/coroutines/debug/internal/ConcurrentWeakMap;", "K", "", "V", "Lkotlin/collections/AbstractMutableMap;", "weakRefQueue", "", "(Z)V", "_size", "Lkotlinx/atomicfu/AtomicInt;", "core", "Lkotlinx/atomicfu/AtomicRef;", "Lkotlinx/coroutines/debug/internal/ConcurrentWeakMap$Core;", "entries", "", "", "getEntries", "()Ljava/util/Set;", "keys", "getKeys", "size", "", "getSize", "()I", "Ljava/lang/ref/ReferenceQueue;", "cleanWeakRef", "", "w", "Lkotlinx/coroutines/debug/internal/HashedWeakRef;", "clear", "decrementSize", "get", "key", "(Ljava/lang/Object;)Ljava/lang/Object;", "put", "value", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "putSynchronized", "remove", "runWeakRefQueueCleaningLoopUntilInterrupted", "Core", "Entry", "KeyValueSet", "kotlinx-coroutines-core"})
@SourceDebugExtension(value={"SMAP\nConcurrentWeakMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConcurrentWeakMap.kt\nkotlinx/coroutines/debug/internal/ConcurrentWeakMap\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,280:1\n1#2:281\n*E\n"})
public final class ConcurrentWeakMap<K, V>
extends AbstractMutableMap<K, V> {
    private volatile /* synthetic */ int _size$volatile;
    private volatile /* synthetic */ Object core$volatile;
    @Nullable
    private final ReferenceQueue<K> weakRefQueue;
    private static final /* synthetic */ AtomicIntegerFieldUpdater _size$volatile$FU;
    private static final /* synthetic */ AtomicReferenceFieldUpdater core$volatile$FU;

    public ConcurrentWeakMap(boolean weakRefQueue) {
        this.core$volatile = new Core(16);
        this.weakRefQueue = weakRefQueue ? new ReferenceQueue() : null;
    }

    public /* synthetic */ ConcurrentWeakMap(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        this(bl);
    }

    private final /* synthetic */ int get_size$volatile() {
        return this._size$volatile;
    }

    private final /* synthetic */ void set_size$volatile(int value) {
        this._size$volatile = value;
    }

    private final /* synthetic */ Object getCore$volatile() {
        return this.core$volatile;
    }

    private final /* synthetic */ void setCore$volatile(Object value) {
        this.core$volatile = value;
    }

    @Override
    public int getSize() {
        return ConcurrentWeakMap._size$volatile$FU.get(this);
    }

    private final void decrementSize() {
        ConcurrentWeakMap._size$volatile$FU.decrementAndGet(this);
    }

    @Override
    @Nullable
    public V get(@Nullable Object key) {
        if (key == null) {
            return null;
        }
        return ((Core)ConcurrentWeakMap.core$volatile$FU.get(this)).getImpl(key);
    }

    @Override
    @Nullable
    public V put(@NotNull K key, @NotNull V value) {
        Object oldValue = Core.putImpl$default((Core)ConcurrentWeakMap.core$volatile$FU.get(this), key, value, null, 4, null);
        if (oldValue == ConcurrentWeakMapKt.access$getREHASH$p()) {
            oldValue = this.putSynchronized(key, value);
        }
        if (oldValue == null) {
            ConcurrentWeakMap._size$volatile$FU.incrementAndGet(this);
        }
        return (V)oldValue;
    }

    @Override
    @Nullable
    public V remove(@Nullable Object key) {
        if (key == null) {
            return null;
        }
        Object oldValue = Core.putImpl$default((Core)ConcurrentWeakMap.core$volatile$FU.get(this), key, null, null, 4, null);
        if (oldValue == ConcurrentWeakMapKt.access$getREHASH$p()) {
            oldValue = this.putSynchronized(key, null);
        }
        if (oldValue != null) {
            ConcurrentWeakMap._size$volatile$FU.decrementAndGet(this);
        }
        return (V)oldValue;
    }

    private final synchronized V putSynchronized(K key, V value) {
        Core curCore = (Core)ConcurrentWeakMap.core$volatile$FU.get(this);
        Object oldValue;
        while ((oldValue = Core.putImpl$default(curCore, key, value, null, 4, null)) == ConcurrentWeakMapKt.access$getREHASH$p()) {
            curCore = curCore.rehash();
            ConcurrentWeakMap.core$volatile$FU.set(this, curCore);
        }
        return (V)oldValue;
    }

    @Override
    @NotNull
    public Set<K> getKeys() {
        return new KeyValueSet(keys.1.INSTANCE);
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, V>> getEntries() {
        return new KeyValueSet(entries.1.INSTANCE);
    }

    @Override
    public void clear() {
        for (Object k : this.keySet()) {
            this.remove(k);
        }
    }

    public final void runWeakRefQueueCleaningLoopUntilInterrupted() {
        if (!(this.weakRefQueue != null)) {
            boolean bl = false;
            String string = "Must be created with weakRefQueue = true";
            throw new IllegalStateException(string.toString());
        }
        try {
            while (true) {
                Reference<K> reference = this.weakRefQueue.remove();
                Intrinsics.checkNotNull(reference, "null cannot be cast to non-null type kotlinx.coroutines.debug.internal.HashedWeakRef<*>");
                this.cleanWeakRef((HashedWeakRef)reference);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return;
        }
    }

    private final void cleanWeakRef(HashedWeakRef<?> w) {
        ((Core)ConcurrentWeakMap.core$volatile$FU.get(this)).cleanWeakRef(w);
    }

    public ConcurrentWeakMap() {
        this(false, 1, null);
    }

    static {
        _size$volatile$FU = AtomicIntegerFieldUpdater.newUpdater(ConcurrentWeakMap.class, "_size$volatile");
        core$volatile$FU = AtomicReferenceFieldUpdater.newUpdater(ConcurrentWeakMap.class, Object.class, "core$volatile");
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010)\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001:\u0001!B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\r\u001a\u00020\u000e2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0007J\u0015\u0010\u0010\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0011\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0003H\u0002J,\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00170\u0016\"\u0004\b\u0002\u0010\u00172\u0018\u0010\u0018\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u0002H\u00170\u0019J1\u0010\u001a\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0011\u001a\u00028\u00002\b\u0010\u001b\u001a\u0004\u0018\u00018\u00012\u0010\b\u0002\u0010\u001c\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\u001dJ\u0016\u0010\u001e\u001a\u00120\u0000R\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u001fJ\u0010\u0010 \u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0005\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00070\u0006X\u0082\u0004R\t\u0010\b\u001a\u00020\tX\u0082\u0004R\u000e\u0010\n\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0006X\u0082\u0004\u00a8\u0006\""}, d2={"Lkotlinx/coroutines/debug/internal/ConcurrentWeakMap$Core;", "", "allocated", "", "(Lkotlinx/coroutines/debug/internal/ConcurrentWeakMap;I)V", "keys", "Lkotlinx/atomicfu/AtomicArray;", "Lkotlinx/coroutines/debug/internal/HashedWeakRef;", "load", "Lkotlinx/atomicfu/AtomicInt;", "shift", "threshold", "values", "cleanWeakRef", "", "weakRef", "getImpl", "key", "(Ljava/lang/Object;)Ljava/lang/Object;", "index", "hash", "keyValueIterator", "", "E", "factory", "Lkotlin/Function2;", "putImpl", "value", "weakKey0", "(Ljava/lang/Object;Ljava/lang/Object;Lkotlinx/coroutines/debug/internal/HashedWeakRef;)Ljava/lang/Object;", "rehash", "Lkotlinx/coroutines/debug/internal/ConcurrentWeakMap;", "removeCleanedAt", "KeyValueIterator", "kotlinx-coroutines-core"})
    private final class Core {
        private final int allocated;
        private final int shift;
        private final int threshold;
        private volatile /* synthetic */ int load$volatile;
        private final /* synthetic */ AtomicReferenceArray keys;
        private final /* synthetic */ AtomicReferenceArray values;
        private static final /* synthetic */ AtomicIntegerFieldUpdater load$volatile$FU;

        public Core(int allocated) {
            this.allocated = allocated;
            this.shift = Integer.numberOfLeadingZeros(this.allocated) + 1;
            this.threshold = 2 * this.allocated / 3;
            this.keys = new AtomicReferenceArray(this.allocated);
            this.values = new AtomicReferenceArray(this.allocated);
        }

        private final /* synthetic */ int getLoad$volatile() {
            return this.load$volatile;
        }

        private final /* synthetic */ void setLoad$volatile(int value) {
            this.load$volatile = value;
        }

        private final /* synthetic */ AtomicReferenceArray getKeys() {
            return this.keys;
        }

        private final /* synthetic */ AtomicReferenceArray getValues() {
            return this.values;
        }

        private final int index(int hash) {
            return hash * -1640531527 >>> this.shift;
        }

        @Nullable
        public final V getImpl(@NotNull K key) {
            int index2 = this.index(key.hashCode());
            while ((HashedWeakRef)this.getKeys().get(index2) != null) {
                HashedWeakRef w;
                Object k = w.get();
                if (Intrinsics.areEqual(key, k)) {
                    Object value = this.getValues().get(index2);
                    return value instanceof Marked ? ((Marked)value).ref : value;
                }
                if (k == null) {
                    this.removeCleanedAt(index2);
                }
                if (index2 == 0) {
                    index2 = this.allocated;
                }
                --index2;
            }
            return null;
        }

        private final void removeCleanedAt(int index2) {
            Object oldValue;
            do {
                if (this.getValues().get(index2) == null) {
                    return;
                }
                if (!(oldValue instanceof Marked)) continue;
                return;
            } while (!this.getValues().compareAndSet(index2, oldValue, null));
            ConcurrentWeakMap.this.decrementSize();
        }

        @Nullable
        public final Object putImpl(@NotNull K key, @Nullable V value, @Nullable HashedWeakRef<K> weakKey0) {
            int index2 = this.index(key.hashCode());
            boolean loadIncremented = false;
            HashedWeakRef weakKey = weakKey0;
            while (true) {
                HashedWeakRef w;
                if ((w = (HashedWeakRef)this.getKeys().get(index2)) == null) {
                    if (value == null) {
                        return null;
                    }
                    if (!loadIncremented) {
                        int n;
                        int n2;
                        int n3;
                        Core core = this;
                        AtomicIntegerFieldUpdater handler$atomicfu$iv = Core.load$volatile$FU;
                        do {
                            n = n3 = handler$atomicfu$iv.get(this);
                            boolean bl = false;
                            if (n < this.threshold) continue;
                            return ConcurrentWeakMapKt.access$getREHASH$p();
                        } while (!handler$atomicfu$iv.compareAndSet(this, n3, n2 = n + 1));
                        loadIncremented = true;
                    }
                    if (weakKey == null) {
                        weakKey = new HashedWeakRef(key, ConcurrentWeakMap.this.weakRefQueue);
                    }
                    if (this.getKeys().compareAndSet(index2, null, weakKey)) break;
                    continue;
                }
                Object k = w.get();
                if (Intrinsics.areEqual(key, k)) {
                    if (!loadIncremented) break;
                    Core.load$volatile$FU.decrementAndGet(this);
                    break;
                }
                if (k == null) {
                    this.removeCleanedAt(index2);
                }
                if (index2 == 0) {
                    index2 = this.allocated;
                }
                --index2;
            }
            Object oldValue = null;
            do {
                if (!((oldValue = (Object)this.getValues().get(index2)) instanceof Marked)) continue;
                return ConcurrentWeakMapKt.access$getREHASH$p();
            } while (!this.getValues().compareAndSet(index2, oldValue, value));
            return oldValue;
        }

        public static /* synthetic */ Object putImpl$default(Core core, Object object, Object object2, HashedWeakRef hashedWeakRef, int n, Object object3) {
            if ((n & 4) != 0) {
                hashedWeakRef = null;
            }
            return core.putImpl(object, object2, hashedWeakRef);
        }

        @NotNull
        public final Core rehash() {
            Core newCore;
            block0: while (true) {
                int newCapacity = Integer.highestOneBit(RangesKt.coerceAtLeast(ConcurrentWeakMap.this.size(), 4)) * 4;
                newCore = new Core(newCapacity);
                int n = this.allocated;
                for (int index2 = 0; index2 < n; ++index2) {
                    boolean bl;
                    Object k;
                    HashedWeakRef w;
                    HashedWeakRef hashedWeakRef = w = (HashedWeakRef)this.getKeys().get(index2);
                    Object object = k = hashedWeakRef != null ? hashedWeakRef.get() : null;
                    if (w != null && k == null) {
                        this.removeCleanedAt(index2);
                    }
                    Object value = null;
                    do {
                        if (!((value = (Object)this.getValues().get(index2)) instanceof Marked)) continue;
                        value = ((Marked)value).ref;
                        break;
                    } while (!this.getValues().compareAndSet(index2, value, ConcurrentWeakMapKt.access$mark(value)));
                    if (k == null || value == null) continue;
                    Object oldValue = newCore.putImpl(k, value, w);
                    if (oldValue == ConcurrentWeakMapKt.access$getREHASH$p()) continue block0;
                    boolean bl2 = bl = oldValue == null;
                    if (!_Assertions.ENABLED || bl) continue;
                    String string = "Assertion failed";
                    throw new AssertionError((Object)string);
                }
                break;
            }
            return newCore;
        }

        public final void cleanWeakRef(@NotNull HashedWeakRef<?> weakRef) {
            int index2 = this.index(weakRef.hash);
            while ((HashedWeakRef)this.getKeys().get(index2) != null) {
                HashedWeakRef w;
                if (w == weakRef) {
                    this.removeCleanedAt(index2);
                    return;
                }
                if (index2 == 0) {
                    index2 = this.allocated;
                }
                --index2;
            }
            return;
        }

        @NotNull
        public final <E> Iterator<E> keyValueIterator(@NotNull Function2<? super K, ? super V, ? extends E> factory) {
            return new KeyValueIterator<E>(factory);
        }

        private final /* synthetic */ void update$atomicfu(Object dispatchReceiver$atomicfu, AtomicIntegerFieldUpdater handler$atomicfu, Function1<? super Integer, Integer> action$atomicfu) {
            Integer n;
            int n2;
            while (!handler$atomicfu.compareAndSet(dispatchReceiver$atomicfu, n2 = handler$atomicfu.get(dispatchReceiver$atomicfu), ((Number)(n = action$atomicfu.invoke((Integer)n2))).intValue())) {
            }
        }

        static {
            load$volatile$FU = AtomicIntegerFieldUpdater.newUpdater(Core.class, "load$volatile");
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010)\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0000\b\u0082\u0004\u0018\u0000*\u0004\b\u0002\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u001f\u0012\u0018\u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u000b\u001a\u00020\fH\u0002J\t\u0010\r\u001a\u00020\u000eH\u0096\u0002J\u000e\u0010\u000f\u001a\u00028\u0002H\u0096\u0002\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u0011\u001a\u00020\u0012H\u0016R \u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00028\u0000X\u0082.\u00a2\u0006\u0004\n\u0002\u0010\tR\u0010\u0010\n\u001a\u00028\u0001X\u0082.\u00a2\u0006\u0004\n\u0002\u0010\t\u00a8\u0006\u0013"}, d2={"Lkotlinx/coroutines/debug/internal/ConcurrentWeakMap$Core$KeyValueIterator;", "E", "", "factory", "Lkotlin/Function2;", "(Lkotlinx/coroutines/debug/internal/ConcurrentWeakMap$Core;Lkotlin/jvm/functions/Function2;)V", "index", "", "key", "Ljava/lang/Object;", "value", "findNext", "", "hasNext", "", "next", "()Ljava/lang/Object;", "remove", "", "kotlinx-coroutines-core"})
        @SourceDebugExtension(value={"SMAP\nConcurrentWeakMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConcurrentWeakMap.kt\nkotlinx/coroutines/debug/internal/ConcurrentWeakMap$Core$KeyValueIterator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,280:1\n1#2:281\n*E\n"})
        private final class KeyValueIterator<E>
        implements Iterator<E>,
        KMutableIterator {
            @NotNull
            private final Function2<K, V, E> factory;
            private int index;
            private K key;
            private V value;

            public KeyValueIterator(Function2<? super K, ? super V, ? extends E> factory) {
                this.factory = factory;
                this.index = -1;
                this.findNext();
            }

            private final void findNext() {
                block2: {
                    Object value;
                    while (true) {
                        ++this.index;
                        if (this.index >= Core.this.allocated) break block2;
                        HashedWeakRef hashedWeakRef = (HashedWeakRef)Core.this.getKeys().get(this.index);
                        if (hashedWeakRef == null || (hashedWeakRef = hashedWeakRef.get()) == null) continue;
                        this.key = hashedWeakRef;
                        value = Core.this.getValues().get(this.index);
                        if (value instanceof Marked) {
                            value = ((Marked)value).ref;
                        }
                        if (value != null) break;
                    }
                    this.value = value;
                    return;
                }
            }

            @Override
            public boolean hasNext() {
                return this.index < Core.this.allocated;
            }

            @Override
            public E next() {
                E e;
                Object object;
                if (this.index >= Core.this.allocated) {
                    throw new NoSuchElementException();
                }
                Object object2 = this.key;
                if (object2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("key");
                    object2 = Unit.INSTANCE;
                }
                if ((object = this.value) == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("value");
                    object = Unit.INSTANCE;
                }
                E it = e = this.factory.invoke(object2, object);
                boolean bl = false;
                this.findNext();
                return e;
            }

            @NotNull
            public Void remove() {
                ConcurrentWeakMapKt.access$noImpl();
                throw new KotlinNothingValueException();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010'\n\u0002\b\u000b\b\u0002\u0018\u0000*\u0004\b\u0002\u0010\u0001*\u0004\b\u0003\u0010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0003B\u0015\u0012\u0006\u0010\u0004\u001a\u00028\u0002\u0012\u0006\u0010\u0005\u001a\u00028\u0003\u00a2\u0006\u0002\u0010\u0006J\u0015\u0010\u000b\u001a\u00028\u00032\u0006\u0010\f\u001a\u00028\u0003H\u0016\u00a2\u0006\u0002\u0010\rR\u0016\u0010\u0004\u001a\u00028\u0002X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\u0005\u001a\u00028\u0003X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\n\u0010\b\u00a8\u0006\u000e"}, d2={"Lkotlinx/coroutines/debug/internal/ConcurrentWeakMap$Entry;", "K", "V", "", "key", "value", "(Ljava/lang/Object;Ljava/lang/Object;)V", "getKey", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getValue", "setValue", "newValue", "(Ljava/lang/Object;)Ljava/lang/Object;", "kotlinx-coroutines-core"})
    private static final class Entry<K, V>
    implements Map.Entry<K, V>,
    KMutableMap.Entry {
        private final K key;
        private final V value;

        public Entry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V newValue) {
            ConcurrentWeakMapKt.access$noImpl();
            throw new KotlinNothingValueException();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010)\n\u0000\b\u0082\u0004\u0018\u0000*\u0004\b\u0002\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u001f\u0012\u0018\u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0015\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00028\u0002H\u0016\u00a2\u0006\u0002\u0010\rJ\u000f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00020\u000fH\u0096\u0002R \u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0010"}, d2={"Lkotlinx/coroutines/debug/internal/ConcurrentWeakMap$KeyValueSet;", "E", "Lkotlin/collections/AbstractMutableSet;", "factory", "Lkotlin/Function2;", "(Lkotlinx/coroutines/debug/internal/ConcurrentWeakMap;Lkotlin/jvm/functions/Function2;)V", "size", "", "getSize", "()I", "add", "", "element", "(Ljava/lang/Object;)Z", "iterator", "", "kotlinx-coroutines-core"})
    private final class KeyValueSet<E>
    extends AbstractMutableSet<E> {
        @NotNull
        private final Function2<K, V, E> factory;

        public KeyValueSet(Function2<? super K, ? super V, ? extends E> factory) {
            this.factory = factory;
        }

        @Override
        public int getSize() {
            return ConcurrentWeakMap.this.size();
        }

        @Override
        public boolean add(E element) {
            ConcurrentWeakMapKt.access$noImpl();
            throw new KotlinNothingValueException();
        }

        @Override
        @NotNull
        public Iterator<E> iterator() {
            return ((Core)ConcurrentWeakMap.core$volatile$FU.get(ConcurrentWeakMap.this)).keyValueIterator(this.factory);
        }
    }
}

