/*
 * Decompiled with CFR 0.152.
 */
package jme3tools.shader;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Preprocessor {
    private static final Pattern FOR_REGEX = Pattern.compile("([^=]+)=\\s*([0-9]+)\\s*\\.\\.\\s*([0-9]+)\\s*\\((.+)\\)");

    public static InputStream apply(InputStream in) throws IOException {
        int read;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] chunk = new byte[1024];
        while ((read = in.read(chunk)) != -1) {
            bos.write(chunk, 0, read);
        }
        bos.close();
        in.close();
        String code = bos.toString("UTF-8");
        code = Preprocessor.forMacro(code);
        return new ByteArrayInputStream(code.getBytes("UTF-8"));
    }

    public static String forMacro(String code) {
        StringBuilder expandedCode = new StringBuilder();
        StringBuilder currentFor = null;
        String forDec = null;
        int skip = 0;
        String[] codel = code.split("\n");
        boolean captured = false;
        for (String l : codel) {
            if (!captured) {
                Matcher matcher;
                String ln = l.trim();
                if (ln.startsWith("#for")) {
                    if (skip == 0) {
                        forDec = ln;
                        currentFor = new StringBuilder();
                        ++skip;
                        continue;
                    }
                    ++skip;
                } else if (ln.startsWith("#endfor") && --skip == 0 && (matcher = FOR_REGEX.matcher(forDec = forDec.substring("#for ".length()).trim())).matches()) {
                    String varN = "$" + matcher.group(1);
                    int start2 = Integer.parseInt(matcher.group(2));
                    int end2 = Integer.parseInt(matcher.group(3));
                    String inj = matcher.group(4);
                    if (inj.trim().isEmpty()) {
                        inj = "$0";
                    }
                    String inCode = currentFor.toString();
                    currentFor = null;
                    for (int i = start2; i < end2; ++i) {
                        expandedCode.append("\n").append(inj.replace("$0", "\n" + inCode).replace(varN, "" + i)).append("\n");
                    }
                    captured = true;
                    continue;
                }
            }
            if (currentFor != null) {
                currentFor.append(l).append("\n");
                continue;
            }
            expandedCode.append(l).append("\n");
        }
        code = expandedCode.toString();
        if (captured) {
            code = Preprocessor.forMacro(code);
        }
        return code;
    }
}

