/*
 * Decompiled with CFR 0.152.
 */
package jme3tools.optimize;

import com.jme3.material.Material;
import com.jme3.math.Matrix4f;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.mesh.IndexBuffer;
import com.jme3.util.BufferUtils;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GeometryBatchFactory {
    private static final Logger logger = Logger.getLogger(GeometryBatchFactory.class.getName());

    private static void doTransformVerts(FloatBuffer inBuf, int offset2, FloatBuffer outBuf, Matrix4f transform2) {
        Vector3f pos = new Vector3f();
        offset2 *= 3;
        for (int i = 0; i < inBuf.limit() / 3; ++i) {
            pos.x = inBuf.get(i * 3 + 0);
            pos.y = inBuf.get(i * 3 + 1);
            pos.z = inBuf.get(i * 3 + 2);
            transform2.mult(pos, pos);
            outBuf.put(offset2 + i * 3 + 0, pos.x);
            outBuf.put(offset2 + i * 3 + 1, pos.y);
            outBuf.put(offset2 + i * 3 + 2, pos.z);
        }
    }

    private static void doTransformNorms(FloatBuffer inBuf, int offset2, FloatBuffer outBuf, Matrix4f transform2) {
        Vector3f norm = new Vector3f();
        offset2 *= 3;
        for (int i = 0; i < inBuf.limit() / 3; ++i) {
            norm.x = inBuf.get(i * 3 + 0);
            norm.y = inBuf.get(i * 3 + 1);
            norm.z = inBuf.get(i * 3 + 2);
            transform2.multNormal(norm, norm);
            outBuf.put(offset2 + i * 3 + 0, norm.x);
            outBuf.put(offset2 + i * 3 + 1, norm.y);
            outBuf.put(offset2 + i * 3 + 2, norm.z);
        }
    }

    private static void doTransformTangents(FloatBuffer inBuf, int offset2, int components, FloatBuffer outBuf, Matrix4f transform2) {
        Vector3f tan = new Vector3f();
        offset2 *= components;
        for (int i = 0; i < inBuf.limit() / components; ++i) {
            tan.x = inBuf.get(i * components + 0);
            tan.y = inBuf.get(i * components + 1);
            tan.z = inBuf.get(i * components + 2);
            transform2.multNormal(tan, tan);
            outBuf.put(offset2 + i * components + 0, tan.x);
            outBuf.put(offset2 + i * components + 1, tan.y);
            outBuf.put(offset2 + i * components + 2, tan.z);
            if (components != 4) continue;
            outBuf.put(offset2 + i * components + 3, inBuf.get(i * components + 3));
        }
    }

    public static void mergeGeometries(Collection<Geometry> geometries, Mesh outMesh) {
        int[] compsForBuf = new int[VertexBuffer.Type.values().length];
        VertexBuffer.Format[] formatForBuf = new VertexBuffer.Format[compsForBuf.length];
        boolean[] normForBuf = new boolean[VertexBuffer.Type.values().length];
        int totalVerts = 0;
        int totalTris = 0;
        int totalLodLevels = 0;
        int maxWeights = -1;
        Mesh.Mode mode = null;
        for (Geometry geom : geometries) {
            int components;
            Mesh.Mode listMode;
            totalVerts += geom.getVertexCount();
            totalTris += geom.getTriangleCount();
            totalLodLevels = Math.min(totalLodLevels, geom.getMesh().getNumLodLevels());
            switch (geom.getMesh().getMode()) {
                case Points: {
                    listMode = Mesh.Mode.Points;
                    components = 0;
                    break;
                }
                case LineLoop: 
                case LineStrip: 
                case Lines: {
                    listMode = Mesh.Mode.Lines;
                    components = 2;
                    break;
                }
                case TriangleFan: 
                case TriangleStrip: 
                case Triangles: {
                    listMode = Mesh.Mode.Triangles;
                    components = 3;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
            for (VertexBuffer vb : geom.getMesh().getBufferList().getArray()) {
                int currentCompsForBuf = compsForBuf[vb.getBufferType().ordinal()];
                if (vb.getBufferType() != VertexBuffer.Type.Index && currentCompsForBuf != 0 && currentCompsForBuf != vb.getNumComponents()) {
                    throw new UnsupportedOperationException("The geometry " + geom + " buffer " + (Object)((Object)vb.getBufferType()) + " has different number of components than the rest of the meshes (this: " + vb.getNumComponents() + ", expected: " + currentCompsForBuf + ")");
                }
                compsForBuf[vb.getBufferType().ordinal()] = vb.getNumComponents();
                formatForBuf[vb.getBufferType().ordinal()] = vb.getFormat();
                normForBuf[vb.getBufferType().ordinal()] = vb.isNormalized();
            }
            maxWeights = Math.max(maxWeights, geom.getMesh().getMaxNumWeights());
            if (mode != null && mode != listMode) {
                throw new UnsupportedOperationException("Cannot combine different primitive types: " + (Object)((Object)mode) + " != " + (Object)((Object)listMode));
            }
            mode = listMode;
            compsForBuf[VertexBuffer.Type.Index.ordinal()] = components;
        }
        outMesh.setMaxNumWeights(maxWeights);
        outMesh.setMode(mode);
        formatForBuf[VertexBuffer.Type.Index.ordinal()] = totalVerts >= 65536 ? VertexBuffer.Format.UnsignedInt : VertexBuffer.Format.UnsignedShort;
        for (int i = 0; i < compsForBuf.length; ++i) {
            if (compsForBuf[i] == 0) continue;
            Buffer data2 = i == VertexBuffer.Type.Index.ordinal() ? VertexBuffer.createBuffer(formatForBuf[i], compsForBuf[i], totalTris) : VertexBuffer.createBuffer(formatForBuf[i], compsForBuf[i], totalVerts);
            VertexBuffer vb = new VertexBuffer(VertexBuffer.Type.values()[i]);
            vb.setupData(VertexBuffer.Usage.Static, compsForBuf[i], formatForBuf[i], data2);
            vb.setNormalized(normForBuf[i]);
            outMesh.setBuffer(vb);
        }
        int globalVertIndex = 0;
        int globalTriIndex = 0;
        for (Geometry geom : geometries) {
            Mesh inMesh = geom.getMesh();
            geom.computeWorldMatrix();
            Matrix4f worldMatrix = geom.getWorldMatrix();
            int geomVertCount = inMesh.getVertexCount();
            int geomTriCount = inMesh.getTriangleCount();
            for (int bufType = 0; bufType < compsForBuf.length; ++bufType) {
                FloatBuffer outPos;
                VertexBuffer inBuf = inMesh.getBuffer(VertexBuffer.Type.values()[bufType]);
                VertexBuffer outBuf = outMesh.getBuffer(VertexBuffer.Type.values()[bufType]);
                if (inBuf == null || outBuf == null) continue;
                if (VertexBuffer.Type.Index.ordinal() == bufType) {
                    int components = compsForBuf[bufType];
                    IndexBuffer inIdx = inMesh.getIndicesAsList();
                    IndexBuffer outIdx = outMesh.getIndexBuffer();
                    for (int tri = 0; tri < geomTriCount; ++tri) {
                        for (int comp = 0; comp < components; ++comp) {
                            int idx = inIdx.get(tri * components + comp) + globalVertIndex;
                            outIdx.put((globalTriIndex + tri) * components + comp, idx);
                        }
                    }
                    continue;
                }
                if (VertexBuffer.Type.Position.ordinal() == bufType) {
                    FloatBuffer inPos = (FloatBuffer)inBuf.getDataReadOnly();
                    outPos = (FloatBuffer)outBuf.getData();
                    GeometryBatchFactory.doTransformVerts(inPos, globalVertIndex, outPos, worldMatrix);
                    continue;
                }
                if (VertexBuffer.Type.Normal.ordinal() == bufType) {
                    FloatBuffer inPos = (FloatBuffer)inBuf.getDataReadOnly();
                    outPos = (FloatBuffer)outBuf.getData();
                    GeometryBatchFactory.doTransformNorms(inPos, globalVertIndex, outPos, worldMatrix);
                    continue;
                }
                if (VertexBuffer.Type.Tangent.ordinal() == bufType) {
                    FloatBuffer inPos = (FloatBuffer)inBuf.getDataReadOnly();
                    outPos = (FloatBuffer)outBuf.getData();
                    int components = inBuf.getNumComponents();
                    GeometryBatchFactory.doTransformTangents(inPos, globalVertIndex, components, outPos, worldMatrix);
                    continue;
                }
                inBuf.copyElements(0, outBuf, globalVertIndex, geomVertCount);
            }
            globalVertIndex += geomVertCount;
            globalTriIndex += geomTriCount;
        }
    }

    public static void makeLods(Collection<Geometry> geometries, Mesh outMesh) {
        int lodLevels = Integer.MAX_VALUE;
        for (Geometry geometry : geometries) {
            lodLevels = Math.min(lodLevels, geometry.getMesh().getNumLodLevels());
        }
        if (lodLevels == Integer.MAX_VALUE || lodLevels == 0) {
            return;
        }
        int[] lodSize = null;
        for (Geometry g : geometries) {
            if (lodLevels == 0) {
                lodLevels = g.getMesh().getNumLodLevels();
            }
            if (lodSize == null) {
                lodSize = new int[lodLevels];
            }
            for (int i = 0; i < lodLevels; ++i) {
                int n = i;
                lodSize[n] = lodSize[n] + g.getMesh().getLodLevel(i).getData().limit();
            }
        }
        int[][] nArrayArray = new int[lodLevels][];
        for (int i = 0; i < lodLevels; ++i) {
            nArrayArray[i] = new int[lodSize[i]];
        }
        VertexBuffer[] lods = new VertexBuffer[lodLevels];
        int[] bufferPos = new int[lodLevels];
        int numOfVertices = 0;
        int[] indexPos = new int[lodLevels];
        for (Geometry g : geometries) {
            numOfVertices = g.getVertexCount();
            int i = 0;
            while (i < lodLevels) {
                int j;
                Buffer buffer;
                boolean isShortBuffer;
                boolean bl = isShortBuffer = g.getMesh().getLodLevel(i).getFormat() == VertexBuffer.Format.UnsignedShort;
                if (isShortBuffer) {
                    buffer = (ShortBuffer)g.getMesh().getLodLevel(i).getDataReadOnly();
                    for (j = 0; j < buffer.limit(); ++j) {
                        nArrayArray[i][bufferPos[i]] = (((ShortBuffer)buffer).get() & 0xFFFF) + indexPos[i];
                        int n = i;
                        bufferPos[n] = bufferPos[n] + 1;
                    }
                } else {
                    buffer = (IntBuffer)g.getMesh().getLodLevel(i).getDataReadOnly();
                    for (j = 0; j < buffer.limit(); ++j) {
                        nArrayArray[i][bufferPos[i]] = ((IntBuffer)buffer).get() + indexPos[i];
                        int n = i;
                        bufferPos[n] = bufferPos[n] + 1;
                    }
                }
                int n = i++;
                indexPos[n] = indexPos[n] + numOfVertices;
            }
        }
        for (int i = 0; i < lodLevels; ++i) {
            lods[i] = new VertexBuffer(VertexBuffer.Type.Index);
            lods[i].setupData(VertexBuffer.Usage.Dynamic, 1, VertexBuffer.Format.UnsignedInt, BufferUtils.createIntBuffer(nArrayArray[i]));
        }
        outMesh.setLodLevels(lods);
    }

    public static List<Geometry> makeBatches(Collection<Geometry> geometries) {
        return GeometryBatchFactory.makeBatches(geometries, false);
    }

    public static List<Geometry> makeBatches(Collection<Geometry> geometries, boolean useLods) {
        ArrayList<Geometry> retVal = new ArrayList<Geometry>();
        HashMap<Material, ArrayList<Geometry>> matToGeom = new HashMap<Material, ArrayList<Geometry>>();
        for (Geometry geom : geometries) {
            List<Geometry> outList = (ArrayList<Geometry>)matToGeom.get(geom.getMaterial());
            if (outList == null) {
                for (Material mat : matToGeom.keySet()) {
                    if (!geom.getMaterial().contentEquals(mat)) continue;
                    outList = (List)matToGeom.get(mat);
                }
            }
            if (outList == null) {
                outList = new ArrayList<Geometry>();
                matToGeom.put(geom.getMaterial(), (ArrayList<Geometry>)outList);
            }
            outList.add(geom);
        }
        int batchNum = 0;
        for (Map.Entry entry : matToGeom.entrySet()) {
            Material mat = (Material)entry.getKey();
            List geomsForMat = (List)entry.getValue();
            Mesh mesh = new Mesh();
            GeometryBatchFactory.mergeGeometries(geomsForMat, mesh);
            if (useLods) {
                GeometryBatchFactory.makeLods(geomsForMat, mesh);
            }
            mesh.updateCounts();
            Geometry out = new Geometry("batch[" + batchNum++ + "]", mesh);
            out.setMaterial(mat);
            out.updateModelBound();
            retVal.add(out);
        }
        return retVal;
    }

    public static void gatherGeoms(Spatial scene2, List<Geometry> geoms) {
        if (scene2 instanceof Node) {
            Node node2 = (Node)scene2;
            for (Spatial child2 : node2.getChildren()) {
                GeometryBatchFactory.gatherGeoms(child2, geoms);
            }
        } else if (scene2 instanceof Geometry) {
            geoms.add((Geometry)scene2);
        }
    }

    public static Spatial optimize(Node scene2) {
        return GeometryBatchFactory.optimize(scene2, false);
    }

    public static Node optimize(Node scene2, boolean useLods) {
        ArrayList<Geometry> geoms = new ArrayList<Geometry>();
        GeometryBatchFactory.gatherGeoms(scene2, geoms);
        List<Geometry> batchedGeoms = GeometryBatchFactory.makeBatches(geoms, useLods);
        for (Geometry geom : batchedGeoms) {
            scene2.attachChild(geom);
        }
        for (Geometry geometry : geoms) {
            geometry.removeFromParent();
        }
        scene2.setLocalTransform(Transform.IDENTITY);
        return scene2;
    }

    public static void printMesh(Mesh mesh) {
        for (int bufType = 0; bufType < VertexBuffer.Type.values().length; ++bufType) {
            VertexBuffer outBuf = mesh.getBuffer(VertexBuffer.Type.values()[bufType]);
            if (outBuf == null) continue;
            System.out.println((Object)((Object)outBuf.getBufferType()) + ": ");
            for (int vert = 0; vert < outBuf.getNumElements(); ++vert) {
                String str = "[";
                for (int comp = 0; comp < outBuf.getNumComponents(); ++comp) {
                    Object val = outBuf.getElementComponent(vert, comp);
                    outBuf.setElementComponent(vert, comp, val);
                    val = outBuf.getElementComponent(vert, comp);
                    str = str + val;
                    if (comp == outBuf.getNumComponents() - 1) continue;
                    str = str + ", ";
                }
                str = str + "]";
                System.out.println(str);
            }
            System.out.println("------");
        }
    }

    public static void main(String[] args2) {
        Mesh mesh = new Mesh();
        mesh.setBuffer(VertexBuffer.Type.Position, 3, new float[]{0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f});
        mesh.setBuffer(VertexBuffer.Type.Index, 2, new short[]{0, 1, 1, 2, 2, 3, 3, 0});
        Geometry g1 = new Geometry("g1", mesh);
        ArrayList<Geometry> geoms = new ArrayList<Geometry>();
        geoms.add(g1);
        Mesh outMesh = new Mesh();
        GeometryBatchFactory.mergeGeometries(geoms, outMesh);
        GeometryBatchFactory.printMesh(outMesh);
    }

    public static void alignBuffers(Node n, AlignOption option) {
        Integer count2;
        ArrayList<Geometry> geoms = new ArrayList<Geometry>();
        GeometryBatchFactory.gatherGeoms(n, geoms);
        EnumMap<VertexBuffer.Type, VertexBuffer> types = new EnumMap<VertexBuffer.Type, VertexBuffer>(VertexBuffer.Type.class);
        EnumMap<VertexBuffer.Type, Integer> typesCount = new EnumMap<VertexBuffer.Type, Integer>(VertexBuffer.Type.class);
        for (Geometry geom : geoms) {
            for (VertexBuffer buffer : geom.getMesh().getBufferList()) {
                if (types.get((Object)buffer.getBufferType()) == null) {
                    types.put(buffer.getBufferType(), buffer);
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, buffer.getBufferType().toString());
                    }
                }
                if ((count2 = (Integer)typesCount.get((Object)buffer.getBufferType())) == null) {
                    count2 = 0;
                }
                Integer n2 = count2;
                count2 = count2 + 1;
                typesCount.put(buffer.getBufferType(), count2);
            }
        }
        switch (option) {
            case RemoveUnalignedBuffers: {
                for (Geometry geom : geoms) {
                    for (VertexBuffer buffer : geom.getMesh().getBufferList()) {
                        count2 = (Integer)typesCount.get((Object)buffer.getBufferType());
                        if (count2 == null || count2 >= geoms.size()) continue;
                        geom.getMesh().clearBuffer(buffer.getBufferType());
                        if (!logger.isLoggable(Level.FINE)) continue;
                        logger.log(Level.FINE, "removing {0} from {1}", new Object[]{buffer.getBufferType(), geom.getName()});
                    }
                }
                break;
            }
            case CreateMissingBuffers: {
                for (Geometry geom : geoms) {
                    for (VertexBuffer.Type type2 : types.keySet()) {
                        Buffer b;
                        if (geom.getMesh().getBuffer(type2) != null) continue;
                        VertexBuffer vb = new VertexBuffer(type2);
                        switch (type2) {
                            case Index: 
                            case BoneIndex: 
                            case HWBoneIndex: {
                                b = BufferUtils.createIntBuffer(geom.getMesh().getVertexCount() * ((VertexBuffer)types.get((Object)type2)).getNumComponents());
                                break;
                            }
                            case InterleavedData: {
                                b = BufferUtils.createByteBuffer(geom.getMesh().getVertexCount() * ((VertexBuffer)types.get((Object)type2)).getNumComponents());
                                break;
                            }
                            default: {
                                b = BufferUtils.createFloatBuffer(geom.getMesh().getVertexCount() * ((VertexBuffer)types.get((Object)type2)).getNumComponents());
                            }
                        }
                        vb.setupData(((VertexBuffer)types.get((Object)type2)).getUsage(), ((VertexBuffer)types.get((Object)type2)).getNumComponents(), ((VertexBuffer)types.get((Object)type2)).getFormat(), b);
                        geom.getMesh().setBuffer(vb);
                        if (!logger.isLoggable(Level.FINE)) continue;
                        logger.log(Level.FINE, "geom {0} misses buffer {1}. Creating", new Object[]{geom.getName(), type2});
                    }
                }
                break;
            }
        }
    }

    public static enum AlignOption {
        RemoveUnalignedBuffers,
        CreateMissingBuffers;

    }
}

