/*
 * Decompiled with CFR 0.152.
 */
package jme3tools.converters;

import com.jme3.texture.Image;
import com.jme3.texture.plugins.AWTLoader;
import com.jme3.util.BufferUtils;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.EnumMap;

public class ImageToAwt {
    private static final EnumMap<Image.Format, DecodeParams> params = new EnumMap(Image.Format.class);
    private static final double LOG2;

    private ImageToAwt() {
    }

    private static int Ix(int x2, int y2, int w) {
        return y2 * w + x2;
    }

    private static int readPixel(ByteBuffer buf, int idx, int bpp) {
        buf.position(idx);
        int original = buf.get() & 0xFF;
        while (--bpp > 0) {
            original = original << 8 | buf.get() & 0xFF;
        }
        return original;
    }

    private static void writePixel(ByteBuffer buf, int idx, int pixel, int bpp) {
        buf.position(idx);
        while (--bpp >= 0) {
            byte bt = (byte)(pixel >> bpp * 8 & 0xFF);
            buf.put(bt);
        }
    }

    public static void convert(BufferedImage image, Image.Format format2, ByteBuffer buf) {
        DecodeParams p = params.get((Object)format2);
        if (p == null) {
            throw new UnsupportedOperationException("Image format " + (Object)((Object)format2) + " is not supported");
        }
        int width2 = image.getWidth();
        int height2 = image.getHeight();
        boolean alpha2 = true;
        boolean luminance = false;
        int reductionA = 8 - Integer.bitCount(p.am);
        int reductionR = 8 - Integer.bitCount(p.rm);
        int reductionG = 8 - Integer.bitCount(p.gm);
        int reductionB = 8 - Integer.bitCount(p.bm);
        int initialPos = buf.position();
        for (int y2 = 0; y2 < height2; ++y2) {
            for (int x2 = 0; x2 < width2; ++x2) {
                int argb = image.getRGB(x2, y2);
                int a = (argb & 0xFF000000) >> 24;
                int r = (argb & 0xFF0000) >> 16;
                int g = (argb & 0xFF00) >> 8;
                int b = argb & 0xFF;
                a &= 0xFF;
                r &= 0xFF;
                g &= 0xFF;
                b &= 0xFF;
                if (!alpha2) {
                    a = 255;
                }
                if (luminance) {
                    // empty if block
                }
                a >>= reductionA;
                r >>= reductionR;
                g >>= reductionG;
                b >>= reductionB;
                a = a << p.as & p.am;
                r = r << p.rs & p.rm;
                g = g << p.gs & p.gm;
                b = b << p.bs & p.bm;
                int outputPixel = (a | r | g | b) << p.is & p.im;
                int i = initialPos + ImageToAwt.Ix(x2, y2, width2) * p.bpp;
                ImageToAwt.writePixel(buf, i, outputPixel, p.bpp);
            }
        }
    }

    public static void createData(Image image, boolean mipmaps) {
        int bpp = image.getFormat().getBitsPerPixel();
        int w = image.getWidth();
        int h = image.getHeight();
        if (!mipmaps) {
            image.setData(BufferUtils.createByteBuffer(w * h * bpp / 8));
            return;
        }
        int expectedMipmaps = 1 + (int)Math.ceil(Math.log(Math.max(h, w)) / LOG2);
        int[] mipMapSizes = new int[expectedMipmaps];
        int total = 0;
        for (int i = 0; i < mipMapSizes.length; ++i) {
            int size2 = w * h * bpp / 8;
            total += size2;
            mipMapSizes[i] = size2;
            w /= 2;
            h /= 2;
        }
        image.setMipMapSizes(mipMapSizes);
        image.setData(BufferUtils.createByteBuffer(total));
    }

    public static void convert(Image input, Image output) {
        DecodeParams inParams = params.get((Object)input.getFormat());
        DecodeParams outParams = params.get((Object)output.getFormat());
        if (inParams == null || outParams == null) {
            throw new UnsupportedOperationException();
        }
        int width2 = input.getWidth();
        int height2 = input.getHeight();
        if (width2 != output.getWidth() || height2 != output.getHeight()) {
            throw new IllegalArgumentException();
        }
        ByteBuffer inData = input.getData(0);
        boolean inAlpha = false;
        boolean inLum = false;
        boolean inRGB = false;
        if (inParams.am != 0) {
            inAlpha = true;
        }
        if (inParams.rm != 0 && inParams.gm == 0 && inParams.bm == 0) {
            inLum = true;
        } else if (inParams.rm != 0 && inParams.gm != 0 && inParams.bm != 0) {
            inRGB = true;
        }
        int expansionA = 8 - Integer.bitCount(inParams.am);
        int expansionR = 8 - Integer.bitCount(inParams.rm);
        int expansionG = 8 - Integer.bitCount(inParams.gm);
        int expansionB = 8 - Integer.bitCount(inParams.bm);
        for (int y2 = 0; y2 < height2; ++y2) {
            for (int x2 = 0; x2 < width2; ++x2) {
                int i = ImageToAwt.Ix(x2, y2, width2) * inParams.bpp;
                int inputPixel = (ImageToAwt.readPixel(inData, i, inParams.bpp) & inParams.im) >> inParams.is;
                int a = (inputPixel & inParams.am) >> inParams.as;
                int r = (inputPixel & inParams.rm) >> inParams.rs;
                int g = (inputPixel & inParams.gm) >> inParams.gs;
                int b = (inputPixel & inParams.bm) >> inParams.bs;
                r &= 0xFF;
                g &= 0xFF;
                b &= 0xFF;
                a &= 0xFF;
                a <<= expansionA;
                r <<= expansionR;
                g <<= expansionG;
                b <<= expansionB;
                if (inLum) {
                    b = g = r;
                }
                if (inAlpha) continue;
                a = 255;
            }
        }
    }

    public static BufferedImage convert(Image image, boolean do16bit, boolean fullAlpha, int mipLevel) {
        BufferedImage out;
        Image.Format format2 = image.getFormat();
        DecodeParams p = params.get((Object)image.getFormat());
        if (p == null) {
            throw new UnsupportedOperationException();
        }
        int width2 = image.getWidth();
        int height2 = image.getHeight();
        int level = mipLevel;
        while (--level >= 0) {
            width2 /= 2;
            height2 /= 2;
        }
        ByteBuffer buf = image.getData(0);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        boolean alpha2 = false;
        boolean luminance = false;
        boolean rgb = false;
        if (p.am != 0) {
            alpha2 = true;
        }
        if (p.rm != 0 && p.gm == 0 && p.bm == 0) {
            luminance = true;
        } else if (p.rm != 0 && p.gm != 0 && p.bm != 0) {
            rgb = true;
        }
        if (alpha2 && !rgb && !luminance || luminance && !alpha2 && !rgb) {
            out = new BufferedImage(width2, height2, 10);
        } else if (rgb && alpha2 || luminance && alpha2) {
            if (do16bit) {
                if (fullAlpha) {
                    ColorModel model = AWTLoader.AWT_RGBA4444;
                    WritableRaster raster = model.createCompatibleWritableRaster(width2, width2);
                    out = new BufferedImage(model, raster, false, null);
                } else {
                    ColorSpace cs = ColorSpace.getInstance(1000);
                    int[] nBits = new int[]{5, 5, 5, 1};
                    int[] bOffs = new int[]{0, 1, 2, 3};
                    ComponentColorModel colorModel = new ComponentColorModel(cs, nBits, true, false, 2, 0);
                    WritableRaster raster = Raster.createInterleavedRaster(0, width2, height2, width2 * 2, 2, bOffs, null);
                    out = new BufferedImage(colorModel, raster, false, null);
                }
            } else {
                out = new BufferedImage(width2, height2, 2);
            }
        } else {
            out = do16bit ? new BufferedImage(width2, height2, 8) : new BufferedImage(width2, height2, 1);
        }
        int expansionA = 8 - Integer.bitCount(p.am);
        int expansionR = 8 - Integer.bitCount(p.rm);
        int expansionG = 8 - Integer.bitCount(p.gm);
        int expansionB = 8 - Integer.bitCount(p.bm);
        if (expansionR < 0) {
            expansionR = 0;
        }
        int mipPos = 0;
        for (int i = 0; i < mipLevel; ++i) {
            mipPos += image.getMipMapSizes()[i];
        }
        for (int y2 = 0; y2 < height2; ++y2) {
            for (int x2 = 0; x2 < width2; ++x2) {
                int i = mipPos + ImageToAwt.Ix(x2, y2, width2) * p.bpp;
                int inputPixel = (ImageToAwt.readPixel(buf, i, p.bpp) & p.im) >> p.is;
                int a = (inputPixel & p.am) >> p.as;
                int r = (inputPixel & p.rm) >> p.rs;
                int g = (inputPixel & p.gm) >> p.gs;
                int b = (inputPixel & p.bm) >> p.bs;
                r &= 0xFF;
                g &= 0xFF;
                b &= 0xFF;
                a &= 0xFF;
                a <<= expansionA;
                r <<= expansionR;
                g <<= expansionG;
                b <<= expansionB;
                if (luminance) {
                    b = g = r;
                }
                if (!alpha2) {
                    a = 255;
                }
                int argb = a << 24 | r << 16 | g << 8 | b;
                out.setRGB(x2, y2, argb);
            }
        }
        return out;
    }

    static {
        int mx___ = -16777216;
        int m_x__ = 0xFF0000;
        int m__x_ = 65280;
        int m___x = 255;
        int sx___ = 24;
        int s_x__ = 16;
        int s__x_ = 8;
        boolean s___x = false;
        int mxxxx = -1;
        boolean sxxxx = false;
        int m4x___ = 61440;
        int m4_x__ = 3840;
        int m4__x_ = 240;
        int m4___x = 15;
        int s4x___ = 12;
        int s4_x__ = 8;
        int s4__x_ = 4;
        boolean s4___x = false;
        int m5___ = 63488;
        int m_5__ = 1984;
        int m__5_ = 62;
        boolean m___1 = true;
        int s5___ = 11;
        int s_5__ = 6;
        boolean s__5_ = true;
        boolean s___1 = false;
        int m5__ = 63488;
        int m_6_ = 2016;
        int m__5 = 31;
        int s5__ = 11;
        int s_6_ = 5;
        boolean s__5 = false;
        int mxx__ = -65536;
        int sxx__ = 32;
        int m__xx = 65535;
        boolean s__xx = false;
        params.put(Image.Format.ABGR8, new DecodeParams(4, -16777216, 255, 65280, 0xFF0000, 24, 0, 8, 16, -1, 0));
        params.put(Image.Format.Alpha8, new DecodeParams(1, -1, 0, -1, 0, true));
        params.put(Image.Format.BGR8, new DecodeParams(3, 0, 255, 65280, 0xFF0000, 0, 0, 8, 16, -1, 0));
        params.put(Image.Format.Luminance8, new DecodeParams(1, -1, 0, -1, 0, false));
        params.put(Image.Format.Luminance16F, new DecodeParams(2, -1, 0, -1, 0, false));
        params.put(Image.Format.Luminance16FAlpha16F, new DecodeParams(4, 65535, -65536, 0, 0, 0, 32, 0, 0, -1, 0));
        params.put(Image.Format.Luminance32F, new DecodeParams(4, -1, 0, -1, 0, false));
        params.put(Image.Format.Luminance8, new DecodeParams(1, -1, 0, -1, 0, false));
        params.put(Image.Format.RGB5A1, new DecodeParams(2, 1, 63488, 1984, 62, 0, 11, 6, 1, -1, 0));
        params.put(Image.Format.RGB565, new DecodeParams(2, 0, 63488, 2016, 31, 0, 11, 5, 0, -1, 0));
        params.put(Image.Format.RGB8, new DecodeParams(3, 0, 0xFF0000, 65280, 255, 0, 16, 8, 0, -1, 0));
        params.put(Image.Format.RGBA8, new DecodeParams(4, 255, -16777216, 0xFF0000, 65280, 0, 24, 16, 8, -1, 0));
        params.put(Image.Format.BGRA8, new DecodeParams(4, 255, 65280, 0xFF0000, -16777216, 0, 8, 16, 24, -1, 0));
        params.put(Image.Format.ARGB8, new DecodeParams(4, -16777216, 0xFF0000, 65280, 255, 24, 16, 8, 0, -1, 0));
        LOG2 = Math.log(2.0);
    }

    private static class DecodeParams {
        final int bpp;
        final int am;
        final int rm;
        final int gm;
        final int bm;
        final int as;
        final int rs;
        final int gs;
        final int bs;
        final int im;
        final int is;

        public DecodeParams(int bpp, int am, int rm, int gm, int bm, int as, int rs, int gs, int bs, int im, int is) {
            this.bpp = bpp;
            this.am = am;
            this.rm = rm;
            this.gm = gm;
            this.bm = bm;
            this.as = as;
            this.rs = rs;
            this.gs = gs;
            this.bs = bs;
            this.im = im;
            this.is = is;
        }

        public DecodeParams(int bpp, int rm, int rs, int im, int is, boolean alpha2) {
            this.bpp = bpp;
            if (alpha2) {
                this.am = rm;
                this.as = rs;
                this.rm = 0;
                this.rs = 0;
            } else {
                this.rm = rm;
                this.rs = rs;
                this.am = 0;
                this.as = 0;
            }
            this.gm = 0;
            this.bm = 0;
            this.gs = 0;
            this.bs = 0;
            this.im = im;
            this.is = is;
        }

        public DecodeParams(int bpp, int rm, int rs, int im, int is) {
            this(bpp, rm, rs, im, is, false);
        }
    }
}

