/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.jmescher;

import edu.berkeley.jmescher.Point;

public class HalfEdge {
    public static final int AUXILARY = 0;
    public static final int BOUNDARY = 1;
    public static final int CONSTRAINT = 2;
    public static final int FLAGS = 5;
    public static final int FLAG_ALGORITHM = 0;
    public static final int FLAG_DRAW = 1;
    public static final int FLAG_READ = 2;
    public static final int FLAG_BEZIER = 3;
    public static final int FLAG_CONTOUR = 4;
    public Point origin = null;
    public HalfEdge next = null;
    public HalfEdge sibling = null;
    int type = 0;
    private boolean[] flagged = new boolean[5];

    public HalfEdge() {
    }

    public HalfEdge(Point p) {
        this.origin = p;
    }

    public HalfEdge(Point p, int t) {
        this(p);
        this.type = t;
    }

    public HalfEdge(HalfEdge he) {
        this.origin = he.origin;
        this.next = he.next;
        this.sibling = he.sibling;
        this.type = he.type;
        this.flagged = he.flagged;
    }

    public HalfEdge getNext() {
        return this.next;
    }

    public HalfEdge getPrev() {
        HalfEdge hePrev = this.next;
        while (hePrev.next != this) {
            hePrev = hePrev.next;
        }
        return hePrev;
    }

    public int getType() {
        return this.type;
    }

    public void setNext(HalfEdge he) {
        this.next = he;
        if (this.type == 1 || this.next.origin != this.sibling.origin) {
            // empty if block
        }
    }

    public void setSibling(HalfEdge he) {
        this.sibling = he;
    }

    public void setType(int type2) {
        this.type = type2;
        if (this.sibling != null) {
            this.sibling.type = type2;
        }
    }

    public boolean isType(int type2) {
        return this.type == type2;
    }

    public boolean isFlagged(int flag) {
        return this.flagged[flag];
    }

    public void constrain() {
        this.type = 2;
    }

    public void flag(int flag) {
        this.flagged[flag] = true;
    }

    public void flagEdge(int flag) {
        this.flagged[flag] = true;
        if (this.sibling != null) {
            this.sibling.flagged[flag] = true;
        }
    }

    public void unflag(int flag) {
        this.flagged[flag] = false;
    }
}

