/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.water;

import com.jme3.math.Plane;
import com.jme3.post.SceneProcessor;
import com.jme3.profile.AppProfiler;
import com.jme3.renderer.Camera;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.texture.FrameBuffer;

public class ReflectionProcessor
implements SceneProcessor {
    private RenderManager rm;
    private ViewPort vp;
    private Camera reflectionCam;
    private FrameBuffer reflectionBuffer;
    private Plane reflectionClipPlane;

    public ReflectionProcessor(Camera reflectionCam, FrameBuffer reflectionBuffer, Plane reflectionClipPlane) {
        this.reflectionCam = reflectionCam;
        this.reflectionBuffer = reflectionBuffer;
        this.reflectionClipPlane = reflectionClipPlane;
    }

    @Override
    public void initialize(RenderManager rm, ViewPort vp) {
        this.rm = rm;
        this.vp = vp;
    }

    @Override
    public void reshape(ViewPort vp, int w, int h) {
    }

    @Override
    public boolean isInitialized() {
        return this.rm != null;
    }

    @Override
    public void preFrame(float tpf) {
    }

    @Override
    public void postQueue(RenderQueue rq) {
        this.rm.getRenderer().setFrameBuffer(this.reflectionBuffer);
        this.reflectionCam.setProjectionMatrix(null);
        this.rm.setCamera(this.reflectionCam, false);
        this.rm.getRenderer().clearBuffers(true, true, true);
        this.rm.getRenderer().setDepthRange(1.0f, 1.0f);
        this.vp.getQueue().renderQueue(RenderQueue.Bucket.Sky, this.rm, this.reflectionCam, true);
        this.rm.getRenderer().setDepthRange(0.0f, 1.0f);
        this.reflectionCam.setClipPlane(this.reflectionClipPlane, Plane.Side.Positive);
        this.rm.setCamera(this.reflectionCam, false);
    }

    @Override
    public void postFrame(FrameBuffer out) {
    }

    @Override
    public void cleanup() {
    }

    @Override
    public void setProfiler(AppProfiler profiler) {
    }

    public FrameBuffer getReflectionBuffer() {
        return this.reflectionBuffer;
    }

    public void setReflectionBuffer(FrameBuffer reflectionBuffer) {
        this.reflectionBuffer = reflectionBuffer;
    }

    public Camera getReflectionCam() {
        return this.reflectionCam;
    }

    public void setReflectionCam(Camera reflectionCam) {
        this.reflectionCam = reflectionCam;
    }

    public Plane getReflectionClipPlane() {
        return this.reflectionClipPlane;
    }

    public void setReflectionClipPlane(Plane reflectionClipPlane) {
        this.reflectionClipPlane = reflectionClipPlane;
    }
}

