/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.util.xml;

import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public final class SAXUtil {
    private SAXUtil() {
    }

    public static int parseInt(String i, int def) throws SAXException {
        if (i == null) {
            return def;
        }
        try {
            return Integer.parseInt(i);
        }
        catch (NumberFormatException ex) {
            throw new SAXException("Expected an integer, got '" + i + "'");
        }
    }

    public static int parseInt(String i) throws SAXException {
        if (i == null) {
            throw new SAXException("Expected an integer");
        }
        try {
            return Integer.parseInt(i);
        }
        catch (NumberFormatException ex) {
            throw new SAXException("Expected an integer, got '" + i + "'");
        }
    }

    public static float parseFloat(String f, float def) throws SAXException {
        if (f == null) {
            return def;
        }
        try {
            return Float.parseFloat(f);
        }
        catch (NumberFormatException ex) {
            throw new SAXException("Expected a decimal, got '" + f + "'");
        }
    }

    public static float parseFloat(String f) throws SAXException {
        if (f == null) {
            throw new SAXException("Expected a decimal");
        }
        try {
            return Float.parseFloat(f);
        }
        catch (NumberFormatException ex) {
            throw new SAXException("Expected a decimal, got '" + f + "'");
        }
    }

    public static boolean parseBool(String bool, boolean def) throws SAXException {
        if (bool == null || bool.equals("")) {
            return def;
        }
        return Boolean.valueOf(bool);
    }

    public static String parseString(String str, String def) {
        if (str == null) {
            return def;
        }
        return str;
    }

    public static String parseString(String str) throws SAXException {
        if (str == null) {
            throw new SAXException("Expected a string");
        }
        return str;
    }

    public static Vector3f parseVector3(Attributes attribs) throws SAXException {
        float x2 = SAXUtil.parseFloat(attribs.getValue("x"));
        float y2 = SAXUtil.parseFloat(attribs.getValue("y"));
        float z = SAXUtil.parseFloat(attribs.getValue("z"));
        return new Vector3f(x2, y2, z);
    }

    public static ColorRGBA parseColor(Attributes attribs) throws SAXException {
        float r = SAXUtil.parseFloat(attribs.getValue("r"));
        float g = SAXUtil.parseFloat(attribs.getValue("g"));
        float b = SAXUtil.parseFloat(attribs.getValue("b"));
        return new ColorRGBA(r, g, b, 1.0f);
    }
}

