/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.util.clone;

import com.jme3.util.SafeArrayList;
import com.jme3.util.clone.CloneFunction;
import com.jme3.util.clone.JmeCloneable;
import com.jme3.util.clone.ListCloneFunction;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Cloner {
    private static final Logger log = Logger.getLogger(Cloner.class.getName());
    private final IdentityHashMap<Object, Object> index = new IdentityHashMap();
    private final Map<Class, CloneFunction> functions = new HashMap<Class, CloneFunction>();
    private static final Map<Class, Method> methodCache = new ConcurrentHashMap<Class, Method>();

    public Cloner() {
        ListCloneFunction listFunction = new ListCloneFunction();
        this.functions.put(ArrayList.class, listFunction);
        this.functions.put(LinkedList.class, listFunction);
        this.functions.put(CopyOnWriteArrayList.class, listFunction);
        this.functions.put(Vector.class, listFunction);
        this.functions.put(Stack.class, listFunction);
        this.functions.put(SafeArrayList.class, listFunction);
    }

    public static <T> T deepClone(T object) {
        return new Cloner().clone(object);
    }

    public <T> T clone(T object) {
        return this.clone(object, true);
    }

    private <T> Class<T> objectClass(T object) {
        return object.getClass();
    }

    public <T> T clone(T object, boolean useFunctions) {
        if (object == null) {
            return null;
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("cloning:" + object.getClass() + "@" + System.identityHashCode(object));
        }
        Class<T> type2 = this.objectClass(object);
        Object clone2 = this.index.get(object);
        if (clone2 != null || this.index.containsKey(object)) {
            if (log.isLoggable(Level.FINER)) {
                log.finer("cloned:" + object.getClass() + "@" + System.identityHashCode(object) + " as cached:" + (clone2 == null ? "null" : clone2.getClass() + "@" + System.identityHashCode(clone2)));
            }
            return type2.cast(clone2);
        }
        CloneFunction<T> f = this.getCloneFunction(type2);
        if (f != null) {
            T result2 = f.cloneObject(this, object);
            this.index.put(object, result2);
            f.cloneFields(this, result2, object);
            if (log.isLoggable(Level.FINER)) {
                if (result2 == null) {
                    log.finer("cloned:" + object.getClass() + "@" + System.identityHashCode(object) + " as transformed:null");
                } else {
                    log.finer("clone:" + object.getClass() + "@" + System.identityHashCode(object) + " as transformed:" + result2.getClass() + "@" + System.identityHashCode(result2));
                }
            }
            return result2;
        }
        if (object.getClass().isArray()) {
            clone2 = this.arrayClone(object);
        } else if (object instanceof JmeCloneable) {
            clone2 = ((JmeCloneable)object).jmeClone();
            this.index.put(object, clone2);
            ((JmeCloneable)clone2).cloneFields(this, object);
        } else if (object instanceof Cloneable) {
            try {
                clone2 = this.javaClone(object);
            }
            catch (CloneNotSupportedException e) {
                throw new IllegalArgumentException("Object is not cloneable, type:" + type2, e);
            }
            this.index.put(object, clone2);
        } else {
            throw new IllegalArgumentException("Object is not cloneable, type:" + type2);
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("cloned:" + object.getClass() + "@" + System.identityHashCode(object) + " as " + clone2.getClass() + "@" + System.identityHashCode(clone2));
        }
        return type2.cast(clone2);
    }

    public <T> void setCloneFunction(Class<T> type2, CloneFunction<T> function) {
        if (function == null) {
            this.functions.remove(type2);
        } else {
            this.functions.put(type2, function);
        }
    }

    public <T> CloneFunction<T> getCloneFunction(Class<T> type2) {
        CloneFunction result2 = this.functions.get(type2);
        if (result2 == null) {
            for (Map.Entry<Class, CloneFunction> e : this.functions.entrySet()) {
                if (!e.getKey().isAssignableFrom(type2)) continue;
                result2 = e.getValue();
                break;
            }
            if (result2 != null) {
                this.functions.put(type2, result2);
            }
        }
        return result2;
    }

    public <T> void setClonedValue(T original, T clone2) {
        this.index.put(original, clone2);
    }

    public boolean isCloned(Object o) {
        return this.index.containsKey(o);
    }

    public void clearIndex() {
        this.index.clear();
    }

    public <T> T javaClone(T object) throws CloneNotSupportedException {
        if (object == null) {
            return null;
        }
        Method m = methodCache.get(object.getClass());
        if (m == null) {
            try {
                m = object.getClass().getMethod("clone", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new CloneNotSupportedException("No public clone method found for:" + object.getClass());
            }
            methodCache.put(object.getClass(), m);
        }
        try {
            Class<T> type2 = this.objectClass(object);
            return type2.cast(m.invoke(object, new Object[0]));
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException("Error cloning object of type:" + object.getClass(), e);
        }
    }

    protected <T> T arrayClone(T object) {
        Class<T> type2 = this.objectClass(object);
        Class<?> elementType = type2.getComponentType();
        int size2 = Array.getLength(object);
        Object clone2 = Array.newInstance(elementType, size2);
        this.index.put(object, clone2);
        if (elementType.isPrimitive()) {
            System.arraycopy(object, 0, clone2, 0, size2);
        } else {
            for (int i = 0; i < size2; ++i) {
                Object element = this.clone(Array.get(object, i));
                Array.set(clone2, i, element);
            }
        }
        return type2.cast(clone2);
    }
}

