/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.util.blockparser;

import com.jme3.util.blockparser.Statement;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

public class BlockLanguageParser {
    private Reader reader;
    private final ArrayList<Statement> statementStack = new ArrayList();
    private Statement lastStatement;
    private int lineNumber = 1;

    private BlockLanguageParser() {
    }

    private void reset() {
        this.statementStack.clear();
        this.statementStack.add(new Statement(0, "<root>"));
        this.lastStatement = null;
        this.lineNumber = 1;
    }

    private void pushStatement(StringBuilder buffer) {
        String content = buffer.toString().trim();
        if (content.length() > 0) {
            this.lastStatement = new Statement(this.lineNumber, content);
            Statement parent2 = this.statementStack.get(this.statementStack.size() - 1);
            parent2.addStatement(this.lastStatement);
            buffer.setLength(0);
        }
    }

    private void load(InputStream in) throws IOException {
        this.reset();
        this.reader = new InputStreamReader(in, "UTF-8");
        StringBuilder buffer = new StringBuilder();
        boolean insideComment = false;
        int lastChar = 0;
        while (true) {
            int ci;
            char c;
            if ((c = (char)(ci = this.reader.read())) == '\r') {
                continue;
            }
            if (insideComment && c == '\n') {
                insideComment = false;
                continue;
            }
            if (c == '/' && lastChar == 47) {
                buffer.deleteCharAt(buffer.length() - 1);
                insideComment = true;
                this.pushStatement(buffer);
                lastChar = 0;
                ++this.lineNumber;
                continue;
            }
            if (insideComment) continue;
            if (ci == -1 || c == '{' || c == '}' || c == '\n' || c == ';') {
                this.pushStatement(buffer);
                lastChar = 0;
                if (c == '{') {
                    this.statementStack.add(this.lastStatement);
                    continue;
                }
                if (c == '}') {
                    this.statementStack.remove(this.statementStack.size() - 1);
                    continue;
                }
                if (c == '\n') {
                    ++this.lineNumber;
                    continue;
                }
                if (ci != -1) continue;
                break;
            }
            buffer.append(c);
            lastChar = c;
        }
    }

    public static List<Statement> parse(InputStream in) throws IOException {
        BlockLanguageParser parser2 = new BlockLanguageParser();
        parser2.load(in);
        return parser2.statementStack.get(0).getContents();
    }
}

