/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.util;

import com.jme3.math.ColorRGBA;
import com.jme3.math.FastMath;
import com.jme3.texture.Image;
import com.jme3.texture.image.ImageRaster;
import com.jme3.util.BufferUtils;
import java.nio.ByteBuffer;
import java.util.ArrayList;

public class MipMapGenerator {
    private MipMapGenerator() {
    }

    public static Image scaleImage(Image inputImage, int outputWidth, int outputHeight) {
        int size2 = outputWidth * outputHeight * inputImage.getFormat().getBitsPerPixel() / 8;
        ByteBuffer buffer = BufferUtils.createByteBuffer(size2);
        Image outputImage = new Image(inputImage.getFormat(), outputWidth, outputHeight, buffer, inputImage.getColorSpace());
        ImageRaster input = ImageRaster.create(inputImage, 0, 0, false);
        ImageRaster output = ImageRaster.create(outputImage, 0, 0, false);
        float xRatio = (float)(input.getWidth() - 1) / (float)output.getWidth();
        float yRatio = (float)(input.getHeight() - 1) / (float)output.getHeight();
        ColorRGBA outputColor = new ColorRGBA(0.0f, 0.0f, 0.0f, 0.0f);
        ColorRGBA bottomLeft = new ColorRGBA();
        ColorRGBA bottomRight = new ColorRGBA();
        ColorRGBA topLeft = new ColorRGBA();
        ColorRGBA topRight = new ColorRGBA();
        for (int y2 = 0; y2 < outputHeight; ++y2) {
            for (int x2 = 0; x2 < outputWidth; ++x2) {
                float x2f = (float)x2 * xRatio;
                float y2f = (float)y2 * yRatio;
                int x22 = (int)x2f;
                int y22 = (int)y2f;
                input.getPixel(x22, y22, bottomLeft);
                input.getPixel(x22 + 1, y22, bottomRight);
                input.getPixel(x22, y22 + 1, topLeft);
                input.getPixel(x22 + 1, y22 + 1, topRight);
                outputColor.set(bottomLeft).addLocal(bottomRight).addLocal(topLeft).addLocal(topRight);
                outputColor.multLocal(0.25f);
                output.setPixel(x2, y2, outputColor);
            }
        }
        return outputImage;
    }

    public static Image resizeToPowerOf2(Image original) {
        int potWidth = FastMath.nearestPowerOfTwo(original.getWidth());
        int potHeight = FastMath.nearestPowerOfTwo(original.getHeight());
        return MipMapGenerator.scaleImage(original, potWidth, potHeight);
    }

    public static void generateMipMaps(Image image) {
        int width2 = image.getWidth();
        int height2 = image.getHeight();
        Image current = image;
        ArrayList<ByteBuffer> output = new ArrayList<ByteBuffer>();
        int totalSize = 0;
        while (height2 >= 1 || width2 >= 1) {
            output.add(current.getData(0));
            totalSize += current.getData(0).capacity();
            if (height2 == 1 || width2 == 1) break;
            current = MipMapGenerator.scaleImage(current, width2 /= 2, height2 /= 2);
        }
        ByteBuffer combinedData = BufferUtils.createByteBuffer(totalSize);
        int[] mipSizes = new int[output.size()];
        for (int i = 0; i < output.size(); ++i) {
            ByteBuffer data2 = (ByteBuffer)output.get(i);
            data2.clear();
            combinedData.put(data2);
            mipSizes[i] = data2.capacity();
        }
        combinedData.flip();
        image.setData(0, combinedData);
        image.setMipMapSizes(mipSizes);
    }
}

